/*
 * Decompiled with CFR 0.152.
 */
package smartsettlers;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import smartsettlers.boardlayout.BoardLayout;
import smartsettlers.boardlayout.GameStateConstants;
import smartsettlers.display.SettlersPanel;

public class AppFrame
extends JFrame
implements GameStateConstants {
    BoardLayout boardlayout;
    DefaultListModel listModel;
    private JButton jButton1;
    private JButton jButton2;
    private JButton jButton3;
    private JButton jButton4;
    private JButton jButton5;
    private JButton jButton6;
    private JButton jButton7;
    private JList jList1;
    private JMenu jMenu1;
    private JMenu jMenu2;
    private JMenuBar jMenuBar1;
    private JScrollPane jScrollPane1;
    private JTextField jTextField1;
    private JTextField jTextField2;
    private JProgressBar progressBar;
    private SettlersPanel settlersPanel1;
    private JLabel statusAnimationLabel;
    private JLabel statusMessageLabel;
    private JPanel statusPanel;

    public AppFrame() {
        this.initComponents();
        this.listModel = new DefaultListModel();
        this.jList1.setModel(this.listModel);
        this.boardlayout = new BoardLayout(this.settlersPanel1.getWidth(), this.settlersPanel1.getHeight());
        this.settlersPanel1.SetBoardLayout(this.boardlayout);
        this.boardlayout.InitBoard();
    }

    private void initComponents() {
        this.settlersPanel1 = new SettlersPanel();
        this.statusPanel = new JPanel();
        JSeparator statusPanelSeparator = new JSeparator();
        this.statusMessageLabel = new JLabel();
        this.statusAnimationLabel = new JLabel();
        this.progressBar = new JProgressBar();
        this.jTextField1 = new JTextField();
        this.jButton1 = new JButton();
        this.jButton2 = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.jList1 = new JList();
        this.jButton3 = new JButton();
        this.jButton4 = new JButton();
        this.jButton5 = new JButton();
        this.jTextField2 = new JTextField();
        this.jButton6 = new JButton();
        this.jButton7 = new JButton();
        this.jMenuBar1 = new JMenuBar();
        this.jMenu1 = new JMenu();
        this.jMenu2 = new JMenu();
        this.setDefaultCloseOperation(3);
        this.settlersPanel1.setBorder(BorderFactory.createEtchedBorder());
        this.statusAnimationLabel.setHorizontalAlignment(2);
        this.jTextField1.setEditable(false);
        this.jTextField1.setText("state");
        GroupLayout statusPanelLayout = new GroupLayout(this.statusPanel);
        this.statusPanel.setLayout(statusPanelLayout);
        statusPanelLayout.setHorizontalGroup(statusPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(statusPanelSeparator, -1, 1198, Short.MAX_VALUE).addGroup(statusPanelLayout.createSequentialGroup().addGroup(statusPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(statusPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.statusMessageLabel)).addGroup(statusPanelLayout.createSequentialGroup().addGap(158, 158, 158).addComponent(this.jTextField1, -2, 413, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 467, Short.MAX_VALUE).addComponent(this.progressBar, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.statusAnimationLabel).addContainerGap()));
        statusPanelLayout.setVerticalGroup(statusPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(statusPanelLayout.createSequentialGroup().addComponent(statusPanelSeparator, -2, 2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(statusPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(statusPanelLayout.createSequentialGroup().addGroup(statusPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.statusMessageLabel).addComponent(this.statusAnimationLabel).addComponent(this.progressBar, -2, -1, -2)).addGap(3, 3, 3)).addComponent(this.jTextField1, -2, -1, -2))));
        this.jButton1.setText(">");
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AppFrame.this.jButton1ActionPerformed(evt);
            }
        });
        this.jButton2.setText("New");
        this.jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AppFrame.this.jButton2ActionPerformed(evt);
            }
        });
        this.jList1.setModel(new AbstractListModel(){
            String[] strings = new String[]{"Item 1", "Item 2", "Item 3", "Item 4", "Item 5"};

            @Override
            public int getSize() {
                return this.strings.length;
            }

            @Override
            public Object getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.jList1.setSelectionMode(0);
        this.jList1.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                AppFrame.this.jList1ValueChanged(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jList1);
        this.jButton3.setText(">> 10");
        this.jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AppFrame.this.jButton3ActionPerformed(evt);
            }
        });
        this.jButton4.setText(">|");
        this.jButton4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AppFrame.this.jButton4ActionPerformed(evt);
            }
        });
        this.jButton5.setText("1000 games");
        this.jButton5.setEnabled(false);
        this.jButton5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AppFrame.this.jButton5ActionPerformed(evt);
            }
        });
        this.jTextField2.setText("0");
        this.jButton6.setText("UCT");
        this.jButton6.setEnabled(false);
        this.jButton6.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AppFrame.this.jButton6ActionPerformed(evt);
            }
        });
        this.jButton7.setText("Experiment");
        this.jButton7.setEnabled(false);
        this.jButton7.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AppFrame.this.jButton7ActionPerformed(evt);
            }
        });
        this.jMenu1.setText("File");
        this.jMenuBar1.add(this.jMenu1);
        this.jMenu2.setText("Edit");
        this.jMenuBar1.add(this.jMenu2);
        this.setJMenuBar(this.jMenuBar1);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.statusPanel, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.settlersPanel1, -2, 831, -2).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(27, 27, 27).addComponent(this.jButton2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton6)).addComponent(this.jScrollPane1, -2, 319, -2)).addContainerGap(20, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.jButton5).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextField2, -2, 93, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 37, Short.MAX_VALUE).addComponent(this.jButton7).addGap(25, 25, 25)))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButton2).addComponent(this.jButton1).addComponent(this.jButton3).addComponent(this.jButton4).addComponent(this.jButton6)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -2, 383, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButton5).addComponent(this.jTextField2, -2, -1, -2).addComponent(this.jButton7))).addComponent(this.settlersPanel1, -2, 462, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.statusPanel, -2, -1, -2).addContainerGap(17, Short.MAX_VALUE)));
        this.pack();
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        this.boardlayout.NewGame(this.boardlayout.state, true);
        this.jTextField1.setText(this.boardlayout.gamelog.toString());
        this.listModel.clear();
        this.settlersPanel1.repaint();
    }

    private void makeOneStep() {
        JScrollBar scrollbar = this.jScrollPane1.getVerticalScrollBar();
        int ind = this.jList1.getSelectedIndex();
        if (ind == -1 || ind == this.listModel.getSize() - 1) {
            this.boardlayout.GameTick(this.boardlayout.state, this.boardlayout.action);
            this.jTextField1.setText(this.boardlayout.gamelog.toString());
            this.listModel.addElement(this.boardlayout.gamelog.toString());
            this.jList1.validate();
            this.jScrollPane1.validate();
            this.jList1.setSelectedIndex(this.listModel.getSize() - 1);
            scrollbar.setValue(scrollbar.getMaximum());
        } else {
            this.jList1.setSelectedIndex(ind + 1);
            scrollbar.setValue(scrollbar.getValue() + scrollbar.getUnitIncrement(1));
        }
        this.settlersPanel1.paintAll(this.settlersPanel1.getGraphics());
        this.jList1.paintAll(this.jList1.getGraphics());
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.makeOneStep();
    }

    private void jButton3ActionPerformed(ActionEvent evt) {
        for (int i = 0; i < 10; ++i) {
            this.makeOneStep();
        }
    }

    private void jList1ValueChanged(ListSelectionEvent evt) {
        int ind = this.jList1.getSelectedIndex();
        if (ind == -1) {
            return;
        }
        this.boardlayout.setState((int[])this.boardlayout.gamelog.states.get(ind + 1));
        this.jTextField1.setText(this.boardlayout.gamelog.toString(ind));
        this.settlersPanel1.repaint();
    }

    public void playOneGame() {
        JScrollBar scrollbar = this.jScrollPane1.getVerticalScrollBar();
        do {
            this.boardlayout.GameTick(this.boardlayout.state, this.boardlayout.action);
            this.listModel.addElement(this.boardlayout.gamelog.toString());
            this.jList1.validate();
            this.jScrollPane1.validate();
            this.jList1.setSelectedIndex(this.listModel.getSize() - 1);
            scrollbar.setValue(scrollbar.getMaximum());
            this.settlersPanel1.paintAll(this.settlersPanel1.getGraphics());
            this.jList1.paintAll(this.jList1.getGraphics());
        } while (this.boardlayout.getWinner(this.boardlayout.state) == -1);
        this.boardlayout.GameTick(this.boardlayout.state, this.boardlayout.action);
        this.listModel.addElement(this.boardlayout.gamelog.toString());
    }

    private void jButton4ActionPerformed(ActionEvent evt) {
        JScrollBar scrollbar = this.jScrollPane1.getVerticalScrollBar();
        this.playOneGame();
        this.jList1.validate();
        this.jScrollPane1.validate();
        this.jList1.setSelectedIndex(this.listModel.getSize() - 1);
        scrollbar.setValue(scrollbar.getMaximum());
        this.settlersPanel1.repaint();
    }

    private void jButton5ActionPerformed(ActionEvent evt) {
        JScrollBar scrollbar = this.jScrollPane1.getVerticalScrollBar();
        long starttime = System.currentTimeMillis();
        for (int i = 0; i < 10000; ++i) {
            this.boardlayout = new BoardLayout(this.settlersPanel1.getWidth(), this.settlersPanel1.getHeight());
            this.boardlayout.InitBoard();
            this.boardlayout.NewGame(this.boardlayout.state, false);
            do {
                this.boardlayout.GameTick(this.boardlayout.state, this.boardlayout.action);
            } while (this.boardlayout.getWinner(this.boardlayout.state) == -1);
            this.boardlayout.GameTick(this.boardlayout.state, this.boardlayout.action);
        }
        long totaltime = System.currentTimeMillis() - starttime;
        this.jList1.validate();
        this.jScrollPane1.validate();
        this.jList1.setSelectedIndex(this.listModel.getSize() - 1);
        scrollbar.setValue(scrollbar.getMaximum());
        this.settlersPanel1.repaint();
        this.jTextField2.setText("" + (double)totaltime / 1000.0);
        this.jTextField2.validate();
    }

    private void jButton6ActionPerformed(ActionEvent evt) {
        this.boardlayout.UCTsimulateGame(this.boardlayout.state);
    }

    private void jButton7ActionPerformed(ActionEvent evt) {
        int[] winlist = new int[4];
        int[][] scorelist = new int[4][13];
        String fname = "winstats.txt";
        this.listModel.clear();
        for (int i = 0; i < 1000; ++i) {
            int winner;
            long starttime = System.currentTimeMillis();
            this.boardlayout.NewGame(this.boardlayout.state, false);
            do {
                this.boardlayout.GameTick(this.boardlayout.state, this.boardlayout.action);
            } while ((winner = this.boardlayout.getWinner(this.boardlayout.state)) == -1);
            this.boardlayout.GameTick(this.boardlayout.state, this.boardlayout.action);
            long totaltime = System.currentTimeMillis() - starttime;
            int n = winner;
            winlist[n] = winlist[n] + 1;
            String s = String.format("N=%d \t %d/%d/%d/%d \t time: %d s \t @ ", i, winlist[0], winlist[1], winlist[2], winlist[3], totaltime / 1000L);
            for (int j = 0; j < 4; ++j) {
                int score = this.boardlayout.state[OFS_PLAYERDATA[j] + 0];
                int[] nArray = scorelist[j];
                int n2 = score;
                nArray[n2] = nArray[n2] + 1;
                for (int k = 1; k <= 12; ++k) {
                    s = s + scorelist[j][k] + " ";
                }
                s = s + "| ";
            }
            try {
                PrintStream f = new PrintStream(new FileOutputStream(fname, true));
                f.println(s);
                f.close();
                continue;
            }
            catch (FileNotFoundException ex1) {
                Logger.getLogger(AppFrame.class.getName()).log(Level.SEVERE, null, ex1);
            }
        }
        this.settlersPanel1.repaint();
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new AppFrame().setVisible(true);
            }
        });
    }
}

