/*
 * Decompiled with CFR 0.152.
 */
package smartsettlers.boardlayout;

import java.awt.Point;
import java.awt.Polygon;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import smartsettlers.boardlayout.ActionList;
import smartsettlers.boardlayout.Edge;
import smartsettlers.boardlayout.GameStateConstants;
import smartsettlers.boardlayout.HexTile;
import smartsettlers.boardlayout.HexTypeConstants;
import smartsettlers.boardlayout.Vertex;
import smartsettlers.player.Player;
import smartsettlers.player.UctPlayer;
import smartsettlers.util.GameLog;
import smartsettlers.util.Vector2d;
import smartsettlers.util.VectorConstants;
import uct.TreeNode;
import uct.UCT;

public class BoardLayout
implements HexTypeConstants,
VectorConstants,
GameStateConstants {
    public static final int[][] LAND_COORD = new int[][]{{3, 1, -1}, {4, 1, -1}, {5, 1, -1}, {2, 2, -1}, {3, 2, -1}, {4, 2, -1}, {5, 2, -1}, {1, 3, -1}, {2, 3, -1}, {3, 3, -1}, {4, 3, -1}, {5, 3, -1}, {1, 4, -1}, {2, 4, -1}, {3, 4, -1}, {4, 4, -1}, {1, 5, -1}, {2, 5, -1}, {3, 5, -1}};
    public static final int[][] PORT_COORD = new int[][]{{3, 0, 1}, {5, 0, 2}, {6, 1, 2}, {6, 3, 3}, {4, 5, 4}, {2, 6, 4}, {0, 6, 5}, {0, 4, 0}, {1, 2, 0}};
    public static final int[][] SEA_COORD = new int[][]{{4, 0, -1}, {6, 0, -1}, {6, 2, -1}, {5, 4, -1}, {3, 6, -1}, {1, 6, -1}, {0, 5, -1}, {0, 3, -1}, {2, 1, -1}};
    public static final int N_LAND_TILES = LAND_COORD.length;
    public static final int N_SEA_TILES = SEA_COORD.length;
    public static final int N_PORT_TILES = PORT_COORD.length;
    public static final int N_TILES = N_LAND_TILES + N_SEA_TILES + N_PORT_TILES;
    public static final int LAND_START_INDEX = 0;
    public static final int SEA_START_INDEX = 0 + N_LAND_TILES;
    public static final int PORT_START_INDEX = SEA_START_INDEX + N_SEA_TILES;
    public static final int MAXX = 7;
    public static final int MAXY = 7;
    public int[] landSequence = new int[]{7, 7, 7, 7, 10, 10, 10, 10, 9, 9, 9, 8, 8, 8, 8, 11, 11, 11, 12};
    public int[] portSequence = new int[]{6, 6, 6, 6, 1, 2, 3, 4, 5};
    public int[] cardSequence = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 4, 4, 3, 3, 2, 2};
    public int[] hexnumberSequence = new int[]{2, 3, 3, 4, 4, 5, 5, 6, 6, 8, 8, 9, 9, 10, 10, 11, 11, 12};
    public HexTile[] hextiles;
    public Edge[] edges;
    public Vertex[] vertices;
    public int[][] hexatcoord;
    public int[][] neighborHexHex;
    public int[][] neighborVertexVertex;
    public int[][] neighborHexVertex;
    public int[][] neighborHexEdge;
    public int[][] neighborVertexHex;
    public int[][] neighborVertexEdge;
    public int[][] neighborEdgeEdge;
    public Random rnd = new Random();
    public int screenWidth;
    public int screenHeight;
    double[][] A = new double[][]{{1.0, 0.0}, {0.5, -0.8660254037844386}};
    double[] offset = new double[]{-0.5, 6.5};
    public double scale = 20.0;
    public int[] state;
    public int[] action;
    public Player[] player;
    public GameLog gamelog;
    public boolean isLoggingOn;
    public ActionList possibilities = new ActionList();
    public static final int MODE_RANDOM = 0;
    public static final int MODE_UCT = 1;
    public int mode = 1;
    public UCT uctTree;
    private int uctTime = 0;
    int[] auxScoreArray = new int[4];
    private static final int LR_EMPTY = 0;
    private static final int LR_UNCHECKED = 1;
    private static final int LR_CHECKED1 = 2;
    private static final int LR_CHECKED2 = 3;
    private static final int LR_CHECKED3 = 4;
    private static final int LR_MAXROUTE = 5;
    FileWriter logfile = null;

    public void setState(int[] s) {
        for (int i = 0; i < 269; ++i) {
            this.state[i] = s[i];
        }
    }

    public static int[] cloneOfState(int[] s) {
        int[] s2 = new int[269];
        for (int i = 0; i < 269; ++i) {
            s2[i] = s[i];
        }
        return s2;
    }

    public void setBoardSize(int screenWidth, int screenHeight, double scale) {
        this.screenWidth = screenWidth;
        this.screenHeight = screenHeight;
        this.scale = scale;
    }

    public BoardLayout(int screenWidth, int screenHeight) {
    }

    public void ShuffleIntArray(int[] a) {
        int pos2 = 0;
        int nSteps = 1000;
        int N = a.length;
        int pos1 = this.rnd.nextInt(N);
        int firstvalue = a[pos1];
        for (int i = 0; i < nSteps; ++i) {
            pos2 = this.rnd.nextInt(N);
            a[pos1] = a[pos2];
            pos1 = pos2;
        }
        a[pos2] = firstvalue;
    }

    public void InitBoard() {
        int v1;
        HexTile t2;
        HexTile t1;
        int ind1;
        int ind2;
        int j;
        int i;
        this.hextiles = new HexTile[N_TILES];
        this.edges = new Edge[72];
        this.vertices = new Vertex[54];
        this.hexatcoord = new int[7][7];
        this.neighborHexHex = new int[N_TILES][6];
        this.neighborHexVertex = new int[N_TILES][6];
        this.neighborHexEdge = new int[N_TILES][6];
        this.neighborVertexHex = new int[54][6];
        this.neighborVertexVertex = new int[54][6];
        this.neighborVertexEdge = new int[54][6];
        this.neighborEdgeEdge = new int[72][6];
        this.gamelog = new GameLog();
        this.state = new int[269];
        this.action = new int[5];
        for (i = 0; i < 7; ++i) {
            for (j = 0; j < 7; ++j) {
                this.hexatcoord[i][j] = -1;
            }
        }
        for (i = 0; i < N_TILES; ++i) {
            for (j = 0; j < 6; ++j) {
                this.neighborHexHex[i][j] = -1;
                this.neighborHexVertex[i][j] = -1;
                this.neighborHexEdge[i][j] = -1;
            }
        }
        for (i = 0; i < 54; ++i) {
            for (j = 0; j < 6; ++j) {
                this.neighborVertexVertex[i][j] = -1;
                this.neighborVertexEdge[i][j] = -1;
                this.neighborVertexHex[i][j] = -1;
            }
        }
        for (i = 0; i < 72; ++i) {
            for (j = 0; j < 6; ++j) {
                this.neighborEdgeEdge[i][j] = -1;
            }
        }
        this.ShuffleIntArray(this.landSequence);
        this.ShuffleIntArray(this.portSequence);
        this.ShuffleIntArray(this.cardSequence);
        for (i = 0; i < N_LAND_TILES; ++i) {
            this.hextiles[0 + i] = new HexTile(LAND_COORD[i][0], LAND_COORD[i][1], this.landSequence[i], -1);
            this.hexatcoord[BoardLayout.LAND_COORD[i][0]][BoardLayout.LAND_COORD[i][1]] = 0 + i;
        }
        for (i = 0; i < N_SEA_TILES; ++i) {
            this.hextiles[BoardLayout.SEA_START_INDEX + i] = new HexTile(SEA_COORD[i][0], SEA_COORD[i][1], 0, -1);
            this.hexatcoord[BoardLayout.SEA_COORD[i][0]][BoardLayout.SEA_COORD[i][1]] = SEA_START_INDEX + i;
        }
        for (i = 0; i < N_PORT_TILES; ++i) {
            this.hextiles[BoardLayout.PORT_START_INDEX + i] = new HexTile(PORT_COORD[i][0], PORT_COORD[i][1], this.portSequence[i], PORT_COORD[i][2]);
            this.hexatcoord[BoardLayout.PORT_COORD[i][0]][BoardLayout.PORT_COORD[i][1]] = PORT_START_INDEX + i;
        }
        int[][] delta = new int[][]{{1, 0}, {0, 1}, {-1, 1}, {-1, 0}, {0, -1}, {1, -1}};
        for (i = 0; i < N_TILES; ++i) {
            int x1 = (int)this.hextiles[i].pos.x;
            int y1 = (int)this.hextiles[i].pos.y;
            for (j = 0; j < 6; ++j) {
                int x2 = x1 + delta[j][0];
                int y2 = y1 + delta[j][1];
                ind2 = x2 >= 0 && x2 < 7 && y2 >= 0 && y2 < 7 ? this.hexatcoord[x2][y2] : -1;
                ind1 = i;
                if (ind1 == -1 || ind2 == -1) continue;
                this.neighborHexHex[i][j] = ind2;
            }
        }
        for (j = 0; j < N_TILES; ++j) {
            Polygon hexagon = new Polygon();
            for (i = 0; i < 6; ++i) {
                Point p = this.VectorToScreenCoord(this.hextiles[j].pos.Add(HEX_EDGES[i]));
                hexagon.addPoint(p.x, p.y);
            }
            this.hextiles[j].screenCoord = hexagon;
            this.hextiles[j].centerScreenCord = this.VectorToScreenCoord(this.hextiles[j].pos);
        }
        int nvertices = 0;
        for (i = 0; i < 7; ++i) {
            for (j = 0; j < 7; ++j) {
                HexTile t3;
                int ind3;
                ind1 = this.hexatcoord[i][j];
                if (i < 6 && j < 6) {
                    ind2 = this.hexatcoord[i + 1][j];
                    ind3 = this.hexatcoord[i][j + 1];
                    if (ind1 != -1 && ind2 != -1 && ind3 != -1) {
                        t1 = this.hextiles[ind1];
                        t2 = this.hextiles[ind2];
                        t3 = this.hextiles[ind3];
                        if (t1.type == 2 || t2.type == 2 || t3.type == 2) {
                            this.vertices[nvertices] = new Vertex(t1.pos.Add(HEX_EDGES[5]));
                            this.vertices[nvertices].screenCoord = this.VectorToScreenCoord(t1.pos.Add(HEX_EDGES[0]));
                            this.neighborHexVertex[ind1][0] = nvertices;
                            this.neighborHexVertex[ind2][2] = nvertices;
                            this.neighborHexVertex[ind3][4] = nvertices;
                            this.neighborVertexHex[nvertices][3] = ind1;
                            this.neighborVertexHex[nvertices][5] = ind2;
                            this.neighborVertexHex[nvertices][1] = ind3;
                            ++nvertices;
                        }
                    }
                }
                if (i >= 6 || j <= 0) continue;
                ind2 = this.hexatcoord[i + 1][j];
                ind3 = this.hexatcoord[i + 1][j - 1];
                if (ind1 == -1 || ind2 == -1 || ind3 == -1) continue;
                t1 = this.hextiles[ind1];
                t2 = this.hextiles[ind2];
                t3 = this.hextiles[ind3];
                if (t1.type != 2 && t2.type != 2 && t3.type != 2) continue;
                this.vertices[nvertices] = new Vertex(t1.pos.Add(HEX_EDGES[5]));
                this.vertices[nvertices].screenCoord = this.VectorToScreenCoord(t1.pos.Add(HEX_EDGES[5]));
                this.neighborHexVertex[ind1][5] = nvertices;
                this.neighborHexVertex[ind2][3] = nvertices;
                this.neighborHexVertex[ind3][1] = nvertices;
                this.neighborVertexHex[nvertices][2] = ind1;
                this.neighborVertexHex[nvertices][0] = ind2;
                this.neighborVertexHex[nvertices][4] = ind3;
                ++nvertices;
            }
        }
        for (ind1 = 0; ind1 < N_TILES; ++ind1) {
            v1 = this.neighborHexVertex[ind1][0];
            int v2 = this.neighborHexVertex[ind1][1];
            if (v1 != -1 && v2 != -1) {
                this.neighborVertexVertex[v1][2] = v2;
                this.neighborVertexVertex[v2][5] = v1;
            }
            v1 = this.neighborHexVertex[ind1][1];
            v2 = this.neighborHexVertex[ind1][2];
            if (v1 != -1 && v2 != -1) {
                this.neighborVertexVertex[v1][3] = v2;
                this.neighborVertexVertex[v2][0] = v1;
            }
            v1 = this.neighborHexVertex[ind1][2];
            v2 = this.neighborHexVertex[ind1][3];
            if (v1 != -1 && v2 != -1) {
                this.neighborVertexVertex[v1][4] = v2;
                this.neighborVertexVertex[v2][1] = v1;
            }
            v1 = this.neighborHexVertex[ind1][3];
            v2 = this.neighborHexVertex[ind1][4];
            if (v1 != -1 && v2 != -1) {
                this.neighborVertexVertex[v1][5] = v2;
                this.neighborVertexVertex[v2][2] = v1;
            }
            v1 = this.neighborHexVertex[ind1][4];
            v2 = this.neighborHexVertex[ind1][5];
            if (v1 != -1 && v2 != -1) {
                this.neighborVertexVertex[v1][0] = v2;
                this.neighborVertexVertex[v2][3] = v1;
            }
            v1 = this.neighborHexVertex[ind1][5];
            v2 = this.neighborHexVertex[ind1][0];
            if (v1 == -1 || v2 == -1) continue;
            this.neighborVertexVertex[v1][1] = v2;
            this.neighborVertexVertex[v2][4] = v1;
        }
        int nedges = 0;
        for (i = 0; i < 7; ++i) {
            for (j = 0; j < 7; ++j) {
                ind1 = this.hexatcoord[i][j];
                if (i < 6) {
                    ind2 = this.hexatcoord[i + 1][j];
                    if (ind1 != -1 && ind2 != -1) {
                        t1 = this.hextiles[ind1];
                        t2 = this.hextiles[ind2];
                        if (t1.type == 2 || t2.type == 2) {
                            this.edges[nedges] = new Edge(t1.pos.Add(HEX_EDGES[5]), t1.pos.Add(HEX_EDGES[0]));
                            this.edges[nedges].screenCoord[0] = this.VectorToScreenCoord(t1.pos.Add(HEX_EDGES[5]));
                            this.edges[nedges].screenCoord[1] = this.VectorToScreenCoord(t1.pos.Add(HEX_EDGES[0]));
                            v1 = this.neighborHexVertex[ind1][5];
                            this.neighborVertexEdge[v1][1] = nedges;
                            v1 = this.neighborHexVertex[ind1][0];
                            this.neighborVertexEdge[v1][4] = nedges;
                            this.neighborHexEdge[ind1][0] = nedges;
                            this.neighborHexEdge[ind2][3] = nedges++;
                        }
                    }
                }
                if (j < 6) {
                    ind2 = this.hexatcoord[i][j + 1];
                    if (ind1 != -1 && ind2 != -1) {
                        t1 = this.hextiles[ind1];
                        t2 = this.hextiles[ind2];
                        if (t1.type == 2 || t2.type == 2) {
                            this.edges[nedges] = new Edge(t1.pos.Add(HEX_EDGES[0]), t1.pos.Add(HEX_EDGES[1]));
                            this.edges[nedges].screenCoord[0] = this.VectorToScreenCoord(t1.pos.Add(HEX_EDGES[0]));
                            this.edges[nedges].screenCoord[1] = this.VectorToScreenCoord(t1.pos.Add(HEX_EDGES[1]));
                            v1 = this.neighborHexVertex[ind1][0];
                            this.neighborVertexEdge[v1][2] = nedges;
                            v1 = this.neighborHexVertex[ind1][1];
                            this.neighborVertexEdge[v1][5] = nedges;
                            this.neighborHexEdge[ind1][1] = nedges;
                            this.neighborHexEdge[ind2][4] = nedges++;
                        }
                    }
                }
                if (i <= 0 || j >= 6) continue;
                ind2 = this.hexatcoord[i - 1][j + 1];
                if (ind1 == -1 || ind2 == -1) continue;
                t1 = this.hextiles[ind1];
                t2 = this.hextiles[ind2];
                if (t1.type != 2 && t2.type != 2) continue;
                this.edges[nedges] = new Edge(t1.pos.Add(HEX_EDGES[1]), t1.pos.Add(HEX_EDGES[2]));
                this.edges[nedges].screenCoord[0] = this.VectorToScreenCoord(t1.pos.Add(HEX_EDGES[1]));
                this.edges[nedges].screenCoord[1] = this.VectorToScreenCoord(t1.pos.Add(HEX_EDGES[2]));
                v1 = this.neighborHexVertex[ind1][1];
                this.neighborVertexEdge[v1][3] = nedges;
                v1 = this.neighborHexVertex[ind1][2];
                this.neighborVertexEdge[v1][0] = nedges;
                this.neighborHexEdge[ind1][2] = nedges;
                this.neighborHexEdge[ind2][5] = nedges++;
            }
        }
        for (i = 0; i < 54; ++i) {
            for (j = 0; j < 6; ++j) {
                for (int k = 0; k < 6; ++k) {
                    ind1 = this.neighborVertexEdge[i][j];
                    ind2 = this.neighborVertexEdge[i][k];
                    if (ind1 == -1 || ind2 == -1) continue;
                    this.neighborEdgeEdge[ind1][k] = ind2;
                    this.neighborEdgeEdge[ind2][j] = ind1;
                }
            }
        }
        this.InitProductionNumbers();
        this.NewGame(this.state, true);
        this.uctTree = new UCT();
    }

    void InitProductionNumbers() {
        boolean goodarrangement = false;
        block0: while (!goodarrangement) {
            int ind;
            int y;
            int x;
            this.ShuffleIntArray(this.hexnumberSequence);
            int seqind = 0;
            for (x = 0; x < 7; ++x) {
                for (y = 0; y < 7; ++y) {
                    ind = this.hexatcoord[x][y];
                    if (ind == -1 || this.hextiles[ind].type != 2 || this.hextiles[ind].subtype == 12) continue;
                    this.hextiles[ind].productionNumber = this.hexnumberSequence[seqind];
                    ++seqind;
                }
            }
            goodarrangement = true;
            for (x = 0; x < 7; ++x) {
                for (y = 0; y < 7; ++y) {
                    ind = this.hexatcoord[x][y];
                    for (int k = 0; k < 6; ++k) {
                        int ind2;
                        if (ind == -1 || (ind2 = this.neighborHexHex[ind][k]) == -1 || this.hextiles[ind].productionNumber != 6 && this.hextiles[ind].productionNumber != 8 || this.hextiles[ind2].productionNumber != 6 && this.hextiles[ind2].productionNumber != 8) continue;
                        goodarrangement = false;
                        continue block0;
                    }
                }
            }
        }
    }

    public Point VectorToScreenCoord(Vector2d v) {
        Point p = new Point();
        p.setLocation(this.scale * (this.A[0][0] * v.x + this.A[1][0] * v.y + this.offset[0]), this.scale * (this.A[0][1] * v.x + this.A[1][1] * v.y + this.offset[1]));
        return p;
    }

    public void NewGame(int[] s, boolean isLoggingOn) {
        this.player = new Player[4];
        for (int pl = 0; pl < 4; ++pl) {
            this.player[pl] = new UctPlayer(this, pl);
        }
        s = new int[269];
        s[1] = 0;
        s[2] = 0;
        s[5] = 0;
        s[13] = -1;
        s[12] = -1;
        for (int i = 0; i < 19; ++i) {
            if (this.hextiles[i].subtype != 12) continue;
            s[11] = i;
            break;
        }
        int[] a = new int[5];
        this.GameTick(s, a);
        this.setState(s);
        this.isLoggingOn = isLoggingOn;
        if (isLoggingOn) {
            this.gamelog.clear();
            this.gamelog.addState(s);
        }
    }

    public void GameTick(int[] s, int[] a) {
        int fsmlevel = s[1];
        int pl = s[5 + fsmlevel];
        this.player[pl].listPossibilities(s);
        this.player[pl].selectAction(s, a);
        if (this.isLoggingOn) {
            this.gamelog.addAction(a);
        }
        this.player[pl].performAction(s, a);
        this.stateTransition(s, a);
    }

    public static void printArray(int[] s) {
        for (int i = 0; i < s.length; ++i) {
            System.out.print(s[i] + " ");
        }
        System.out.println();
    }

    public void GameTickUCT(int[] s, int[] a) {
        int fsmlevel = s[1];
        int pl = s[5 + fsmlevel];
        if (pl == 0) {
            int[] s2 = BoardLayout.cloneOfState(s);
            this.UCTsimulateGame(s2);
            s2 = null;
            this.player[pl].listPossibilities(s);
            int aind = this.uctTree.selectAction(s, pl, true);
            for (int i = 0; i < a.length; ++i) {
                a[i] = this.possibilities.action[aind][i];
            }
        } else {
            this.player[pl].listPossibilities(s);
            this.player[pl].selectAction(s, a);
        }
        if (this.isLoggingOn) {
            this.gamelog.addAction(a);
        }
        this.player[pl].performAction(s, a);
        this.stateTransition(s, a);
    }

    public void stateTransition(int[] s, int[] a) {
        int fsmlevel = s[1];
        int fsmstate = s[2 + fsmlevel];
        int pl = s[5 + fsmlevel];
        if (fsmlevel > 0) {
            int motherstate = s[2 + fsmlevel - 1];
        } else {
            int motherstate = -1;
        }
        switch (fsmstate) {
            case 0: {
                s[1] = ++fsmlevel;
                s[2 + fsmlevel] = 2;
                break;
            }
            case 2: {
                s[2 + fsmlevel] = 3;
                break;
            }
            case 3: {
                if (pl == 3) {
                    pl = 3;
                    s[2 + fsmlevel] = 4;
                    break;
                }
                s[5 + fsmlevel] = ++pl;
                s[2 + fsmlevel] = 2;
                break;
            }
            case 4: {
                s[2 + fsmlevel] = 5;
                break;
            }
            case 5: {
                if (pl == 0) {
                    pl = 0;
                    s[2 + fsmlevel] = 6;
                    break;
                }
                s[5 + fsmlevel] = --pl;
                s[2 + fsmlevel] = 4;
                break;
            }
            case 6: {
                if (a[0] == 4 && s[9] + s[10] != 7) {
                    s[2 + fsmlevel] = 100;
                    break;
                }
                if (a[0] != 4 || s[9] + s[10] != 7) break;
                s[1] = ++fsmlevel;
                s[2 + fsmlevel] = 11;
                s[5 + fsmlevel] = 0;
                break;
            }
            case 11: {
                if (++pl < 4) {
                    s[5 + fsmlevel] = pl;
                    s[2 + fsmlevel] = 11;
                    break;
                }
                s[5 + fsmlevel] = s[5 + fsmlevel - 1];
                s[2 + fsmlevel] = 15;
                break;
            }
            case 15: {
                s[1] = --fsmlevel;
                s[2 + fsmlevel] = 100;
                break;
            }
            case 100: {
                switch (a[0]) {
                    case 5: {
                        if (++pl >= 4) {
                            pl = 0;
                        }
                        s[5 + fsmlevel] = pl;
                        s[2 + fsmlevel] = 6;
                        break;
                    }
                    case 9: {
                        s[2 + fsmlevel] = 13;
                    }
                }
                break;
            }
            case 13: {
                s[2 + fsmlevel] = 14;
                break;
            }
            case 14: {
                s[2 + fsmlevel] = 100;
            }
        }
        this.recalcScores(s);
        if (this.getWinner(s) != -1) {
            s[2 + fsmlevel] = 101;
        }
        if (this.isLoggingOn) {
            this.gamelog.addState(s);
        }
    }

    public void UCTsimulateGame(int[] s2) {
        int[] s = null;
        int[] a = new int[5];
        boolean isKnownState = true;
        boolean oldIsLoggingOn = this.isLoggingOn;
        this.isLoggingOn = false;
        ++this.uctTime;
        if (this.uctTree.tree.size() > 10000) {
            this.uctTree.tree.clear();
        }
        int fsmlevel = s2[1];
        int pl = s2[5 + fsmlevel];
        this.player[pl].listPossibilities(s2);
        int N_IT = 1000;
        if (this.possibilities.n == 1) {
            N_IT = 1;
        }
        for (int it = 0; it < N_IT; ++it) {
            int winner;
            isKnownState = true;
            s = BoardLayout.cloneOfState(s2);
            this.uctTree.clearTraces();
            do {
                int aind;
                int hc = UCT.getHashCode(s);
                TreeNode node = this.uctTree.getNode(hc);
                fsmlevel = s[1];
                pl = s[5 + fsmlevel];
                this.player[pl].listPossibilities(s);
                int nactions = this.possibilities.n;
                if (isKnownState && node != null) {
                    aind = this.uctTree.selectAction(hc, pl, false);
                    this.uctTree.addTrace(hc, pl, aind);
                } else if (isKnownState && node == null) {
                    isKnownState = false;
                    aind = this.possibilities.randomInd();
                    this.uctTree.addState(s, hc, this.possibilities);
                    this.uctTree.addTrace(hc, pl, aind);
                } else {
                    aind = this.possibilities.randomInd();
                }
                a = this.possibilities.action[aind];
                this.player[pl].performAction(s, a);
                this.stateTransition(s, a);
            } while ((winner = this.getWinner(s)) == -1);
            this.uctTree.update(winner, this.uctTime);
        }
        this.isLoggingOn = oldIsLoggingOn;
        s = null;
        a = null;
    }

    public int getWinner(int[] s) {
        int retval = -1;
        for (int pl = 0; pl < 4; ++pl) {
            if (s[OFS_PLAYERDATA[pl] + 0] < 10) continue;
            retval = pl;
        }
        return retval;
    }

    public void recalcScores(int[] s) {
        int pl;
        for (pl = 0; pl < 4; ++pl) {
            this.auxScoreArray[pl] = 0;
            int n = pl;
            this.auxScoreArray[n] = this.auxScoreArray[n] + s[OFS_PLAYERDATA[pl] + 1];
            int n2 = pl;
            this.auxScoreArray[n2] = this.auxScoreArray[n2] + s[OFS_PLAYERDATA[pl] + 2] * 2;
            int n3 = pl;
            this.auxScoreArray[n3] = this.auxScoreArray[n3] + s[OFS_PLAYERDATA[pl] + 22 + 1];
        }
        for (pl = 0; pl < 4; ++pl) {
            s[BoardLayout.OFS_PLAYERDATA[pl] + 0] = this.auxScoreArray[pl];
        }
        pl = s[13];
        if (pl != -1) {
            int n = OFS_PLAYERDATA[pl] + 0;
            s[n] = s[n] + 2;
        }
        if ((pl = s[12]) != -1) {
            int n = OFS_PLAYERDATA[pl] + 0;
            s[n] = s[n] + 2;
        }
    }

    public void recalcScores() {
        this.recalcScores(this.state);
    }

    boolean isOpponentPresentAtVertex(int[] s, int pl, int ind) {
        int val = s[87 + ind];
        boolean returnval = val != 0 && val != 1 && val != 2 + pl && val != 6 + pl;
        for (int j = 0; j < 6; ++j) {
            val = this.neighborVertexEdge[ind][j];
            if (val == -1 || s[15 + val] == 0) continue;
            returnval = true;
        }
        return returnval;
    }

    void lrDepthFirstSearch(int[] s, int pl, int ind, int[] lrVertices, boolean[] lrOpponentPresent, boolean[] lrPlayerPresent, int UNCHECKEDVALUE, int CHECKEDVALUE, int[] returnvalues) {
        int[] lrStack = new int[54];
        int[] lrStackPos = new int[54];
        int maxlen = 0;
        int maxStartInd = 0;
        int nextind = 0;
        int lrStacklen = 0;
        int cind = ind;
        int cpos = 0;
        boolean isstartind = true;
        do {
            boolean foundnext = false;
            isstartind = false;
            lrVertices[cind] = CHECKEDVALUE;
            this.vertices[cind].debugLRstatus = CHECKEDVALUE;
            if (cind == ind || lrPlayerPresent[cind] || !lrOpponentPresent[cind]) {
                for (int j = cpos; j < 6; ++j) {
                    nextind = this.neighborVertexVertex[cind][j];
                    int nextedge = this.neighborVertexEdge[cind][j];
                    if (nextind == -1 || s[15 + nextedge] != 1 + pl || lrVertices[nextind] != UNCHECKEDVALUE) continue;
                    foundnext = true;
                    lrStack[lrStacklen] = cind;
                    lrStackPos[lrStacklen] = j + 1;
                    if (++lrStacklen > maxlen) {
                        maxlen = lrStacklen;
                        maxStartInd = nextind;
                    }
                    if (CHECKEDVALUE != 4 || maxlen != returnvalues[0]) break;
                    for (int i = 0; i < lrStacklen; ++i) {
                        this.vertices[lrStack[i]].debugLRstatus = CHECKEDVALUE;
                    }
                    this.vertices[nextind].debugLRstatus = CHECKEDVALUE;
                    break;
                }
            }
            if (foundnext) {
                cind = nextind;
                cpos = 0;
                continue;
            }
            if (lrStacklen == 0) break;
            cind = lrStack[--lrStacklen];
            cpos = lrStackPos[lrStacklen];
        } while (lrStacklen >= 0);
        returnvalues[0] = maxlen;
        returnvalues[1] = maxStartInd;
        lrStack = null;
        lrStackPos = null;
    }

    public void recalcLongestRoad(int[] s, int pl) {
        int ind;
        int[] lrVertices = new int[54];
        boolean[] lrOpponentPresent = new boolean[54];
        boolean[] lrPlayerPresent = new boolean[54];
        int[] returnvalues = new int[2];
        int maxStartInd = 0;
        for (ind = 0; ind < 54; ++ind) {
            this.vertices[ind].debugLRstatus = 0;
        }
        for (ind = 0; ind < 72; ++ind) {
            this.edges[ind].isPartOfLongestRoad = false;
        }
        for (ind = 0; ind < 54; ++ind) {
            lrVertices[ind] = 0;
            lrOpponentPresent[ind] = false;
            int val = s[87 + ind];
            if (val != 0 && val != 1) {
                if (val == 2 + pl || val == 6 + pl) {
                    lrPlayerPresent[ind] = true;
                } else {
                    lrOpponentPresent[ind] = true;
                }
            }
            for (int j = 0; j < 6; ++j) {
                val = this.neighborVertexEdge[ind][j];
                if (val == -1 || s[15 + val] != 1 + pl) continue;
                lrVertices[ind] = 1;
            }
        }
        int maxlen = 0;
        for (ind = 0; ind < 54; ++ind) {
            if (lrVertices[ind] != 1) continue;
            this.lrDepthFirstSearch(s, pl, ind, lrVertices, lrOpponentPresent, lrPlayerPresent, 1, 2, returnvalues);
            this.lrDepthFirstSearch(s, pl, returnvalues[1], lrVertices, lrOpponentPresent, lrPlayerPresent, 2, 3, returnvalues);
            if (maxlen >= returnvalues[0]) continue;
            maxlen = returnvalues[0];
            maxStartInd = returnvalues[1];
        }
        this.lrDepthFirstSearch(s, pl, maxStartInd, lrVertices, lrOpponentPresent, lrPlayerPresent, 3, 4, returnvalues);
        s[BoardLayout.OFS_PLAYERDATA[pl] + 4] = maxlen;
        int maxpl = s[12];
        maxlen = maxpl != -1 ? s[OFS_PLAYERDATA[maxpl] + 4] : 0;
        for (pl = 0; pl < 4; ++pl) {
            if (s[OFS_PLAYERDATA[pl] + 4] <= maxlen) continue;
            maxlen = s[OFS_PLAYERDATA[pl] + 4];
            maxpl = pl;
        }
        if (maxlen >= 5) {
            s[12] = maxpl;
        }
        lrVertices = null;
        lrOpponentPresent = null;
        lrPlayerPresent = null;
        returnvalues = null;
    }

    public void recalcLargestArmy(int[] s) {
        int largestpl = s[13];
        for (int pl = 0; pl < 4; ++pl) {
            int current = s[OFS_PLAYERDATA[pl] + 17 + 0];
            if (largestpl == -1 && current >= 3) {
                s[13] = pl;
            }
            if (largestpl == -1 || current <= s[OFS_PLAYERDATA[largestpl] + 17 + 0]) continue;
            s[13] = pl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeLog(int[] st, int[] a, int pl, String gameName, String event) {
        String s;
        System.out.println("log:  " + event);
        if (this.logfile == null) {
            try {
                this.logfile = new FileWriter(gameName + ".txt");
                s = String.format("I %d \n", st.length);
                this.logfile.write(s);
            }
            catch (IOException ex) {
                Logger.getLogger(BoardLayout.class.getName()).log(Level.SEVERE, null, ex);
            }
            finally {
                try {
                    this.logfile.close();
                }
                catch (IOException ex) {
                    Logger.getLogger(BoardLayout.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
        if (this.logfile != null) {
            try {
                int i;
                this.logfile = new FileWriter(gameName + ".txt", true);
                this.logfile.append("C " + event + "\n");
                System.out.println("C " + event);
                s = "A " + pl;
                for (i = 0; i < a.length; ++i) {
                    s = s + " " + a[i];
                }
                this.logfile.append(s + "\n");
                System.out.println(s);
                s = "S";
                for (i = 0; i < st.length; ++i) {
                    s = s + " " + st[i];
                }
                this.logfile.append(s + "\n");
                System.out.println(s);
                this.logfile.close();
            }
            catch (Exception e) {
                System.out.println("log: ERROR " + e);
            }
        }
    }
}

