/*
 * Decompiled with CFR 0.152.
 */
package smartsettlers.display;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JPanel;
import smartsettlers.boardlayout.BoardLayout;
import smartsettlers.boardlayout.Edge;
import smartsettlers.boardlayout.GameStateConstants;
import smartsettlers.boardlayout.HexTile;
import smartsettlers.boardlayout.HexTypeConstants;
import smartsettlers.boardlayout.Vertex;
import smartsettlers.util.VectorConstants;

public class SettlersPanel
extends JPanel
implements VectorConstants,
HexTypeConstants,
GameStateConstants {
    BoardLayout boardlayout;
    double[][] A = new double[][]{{1.0, 0.0}, {0.5, -0.8660254037844386}};
    double[] offset = new double[]{-0.5, 6.5};
    double scale = 20.0;
    static int pxPlayerPanelWidth;
    static int pxPlayerPanelHeight;
    static int pxOnePlayerPanelHeight;
    static int pxPlayerPanelXOfs;
    static int pxPlayerPanelYOfs;
    static int pxBoardPanelWidth;
    static int pxBoardPanelHeight;
    static final int OBJ_NONE = -1;
    static final int OBJ_HEX = 0;
    static final int OBJ_EDGE = 1;
    static final int OBJ_VERTEX = 2;
    int objUnderMouse = -1;
    int objIndUnderMouse = -1;
    int prevObjUnderMouse = -1;
    int prevObjIndUnderMouse = -1;
    String[] portStrings = new String[]{"Sh", "Wd", "Cl", "Wh", "St", "??"};

    public SettlersPanel() {
        this.initComponents();
    }

    public void SetBoardLayout(BoardLayout boardlayout) {
        this.boardlayout = boardlayout;
        int h = this.getHeight();
        int w = this.getWidth();
        pxPlayerPanelWidth = 300;
        pxOnePlayerPanelHeight = 120;
        pxPlayerPanelHeight = 4 * pxOnePlayerPanelHeight;
        pxPlayerPanelXOfs = w - pxPlayerPanelWidth;
        pxPlayerPanelYOfs = 0;
        pxBoardPanelWidth = w - pxPlayerPanelWidth;
        pxBoardPanelHeight = h;
        this.scale = Math.min((double)pxBoardPanelWidth / 8.0, (double)pxBoardPanelHeight / 8.0);
        boardlayout.setBoardSize(w, h, this.scale);
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.boardlayout == null) {
            g.drawString("Board not initialized!", 10, 20);
        } else {
            this.DrawBoard(g);
        }
    }

    void HighlightHex(Graphics2D g, boolean on) {
    }

    void DrawHexTile(Graphics g, HexTile h) {
        Polygon hexagon = h.screenCoord;
        if (h.type == 0) {
            g.setColor(Color.BLUE);
            g.fillPolygon(hexagon);
        } else if (h.type == 1) {
            g.setColor(Color.BLUE);
            g.fillPolygon(hexagon);
            g.setColor(Color.CYAN);
            int i = h.orientation;
            g.drawLine(h.centerScreenCord.x, h.centerScreenCord.y, hexagon.xpoints[i], hexagon.ypoints[i]);
            if (--i < 0) {
                i = 5;
            }
            g.drawLine(h.centerScreenCord.x, h.centerScreenCord.y, hexagon.xpoints[i], hexagon.ypoints[i]);
            int x = 2 * h.centerScreenCord.x;
            int y = 2 * h.centerScreenCord.y;
            i = h.orientation - 3;
            if (i < 0) {
                i += 6;
            }
            x += hexagon.xpoints[i];
            y += hexagon.ypoints[i];
            i = h.orientation - 4;
            if (i < 0) {
                i += 6;
            }
            x += hexagon.xpoints[i];
            y += hexagon.ypoints[i];
            g.setColor(Color.WHITE);
            g.drawString(this.portStrings[h.subtype - 1], (x /= 4) - 5, (y /= 4) + 5);
        } else if (h.type == 2) {
            switch (h.subtype) {
                case 7: {
                    g.setColor(Color.GREEN);
                    break;
                }
                case 10: {
                    g.setColor(Color.YELLOW);
                    break;
                }
                case 9: {
                    g.setColor(Color.ORANGE);
                    break;
                }
                case 8: {
                    g.setColor(new Color(0, 150, 0));
                    break;
                }
                case 11: {
                    g.setColor(Color.GRAY);
                    break;
                }
                case 12: {
                    g.setColor(Color.LIGHT_GRAY);
                }
            }
            g.fillPolygon(hexagon);
            if (h.productionNumber != 0) {
                g.setColor(Color.BLACK);
                g.drawString("" + h.productionNumber, h.centerScreenCord.x - 10, h.centerScreenCord.y + 5);
            }
        }
    }

    void DrawVertex(Graphics2D g2, int i) {
        Vertex v = this.boardlayout.vertices[i];
        Stroke oldstroke = g2.getStroke();
        if (v == null) {
            return;
        }
        int vstate = this.boardlayout.state[87 + i];
        if (vstate == 0) {
            g2.setColor(Color.RED);
            int W = 5;
            g2.fillOval(v.screenCoord.x - W, v.screenCoord.y - W, 2 * W, 2 * W);
        } else if (vstate >= 2 && vstate < 6) {
            int W = 8;
            g2.setColor(Color.WHITE);
            g2.fillRect(v.screenCoord.x - W - 1, v.screenCoord.y - W - 1, 2 * W + 2, 2 * W + 2);
            g2.setColor(playerColor[vstate - 2]);
            g2.fillRect(v.screenCoord.x - W, v.screenCoord.y - W, 2 * W, 2 * W);
        } else if (vstate >= 6 && vstate < 10) {
            int W = 5;
            g2.setColor(Color.WHITE);
            g2.fillRect(v.screenCoord.x - 2 * W - 1, v.screenCoord.y - 1, 4 * W + 2, 2 * W + 2);
            g2.fillRect(v.screenCoord.x - 1, v.screenCoord.y - 2 * W - 1, 2 * W + 2, 4 * W + 2);
            g2.setColor(playerColor[vstate - 6]);
            g2.fillRect(v.screenCoord.x - 2 * W, v.screenCoord.y, 4 * W, 2 * W);
            g2.fillRect(v.screenCoord.x, v.screenCoord.y - 2 * W, 2 * W, 4 * W);
        }
        g2.setStroke(oldstroke);
    }

    void DrawEdge(Graphics2D g2, int i) {
        Edge e = this.boardlayout.edges[i];
        Stroke oldstroke = g2.getStroke();
        if (e == null) {
            return;
        }
        int estate = this.boardlayout.state[15 + i];
        if (estate >= 1 && estate < 5) {
            int W = 4;
            if (e.isPartOfLongestRoad) {
                g2.setColor(Color.BLACK);
            } else {
                g2.setColor(Color.WHITE);
            }
            g2.setStroke(new BasicStroke(W + 2, 1, 1));
            g2.drawLine(e.screenCoord[0].x, e.screenCoord[0].y, e.screenCoord[1].x, e.screenCoord[1].y);
            g2.setColor(playerColor[estate - 1]);
            g2.setStroke(new BasicStroke(W, 1, 1));
            g2.drawLine(e.screenCoord[0].x, e.screenCoord[0].y, e.screenCoord[1].x, e.screenCoord[1].y);
        }
        g2.setStroke(oldstroke);
    }

    void DrawBoard(Graphics g) {
        int i;
        Graphics2D g2 = (Graphics2D)g;
        for (i = 0; i < this.boardlayout.hextiles.length; ++i) {
            this.DrawHexTile(g2, this.boardlayout.hextiles[i]);
        }
        for (i = 0; i < this.boardlayout.edges.length; ++i) {
            this.DrawEdge(g2, i);
        }
        for (i = 0; i < this.boardlayout.vertices.length; ++i) {
            this.DrawVertex(g2, i);
        }
        for (i = 0; i < 4; ++i) {
            this.DrawPlayerInfo(g2, i);
        }
        Font font1 = g2.getFont();
        Font font2 = new Font("SansSerif", 1, 16);
        g2.setFont(font2);
        int val = this.boardlayout.state[9];
        g2.drawRect(5, 5, 25, 25);
        String s = val == 0 ? "?" : "" + val;
        g2.drawString(s, 15, 25);
        val = this.boardlayout.state[10];
        g2.drawRect(35, 5, 25, 25);
        s = val == 0 ? "?" : "" + val;
        g2.drawString(s, 45, 25);
        g2.setFont(font1);
        if (this.boardlayout.state[11] != -1) {
            g2.setColor(Color.BLACK);
            HexTile h = this.boardlayout.hextiles[this.boardlayout.state[11]];
            g2.fillOval(h.centerScreenCord.x, h.centerScreenCord.y, 15, 15);
        }
    }

    void DrawPlayerInfo(Graphics2D g2, int pl) {
        int i;
        Font font1 = g2.getFont();
        Font font2 = new Font("SansSerif", 1, 16);
        Font font3 = new Font("SansSerif", 0, 10);
        Stroke oldstroke = g2.getStroke();
        int x0 = pxPlayerPanelXOfs;
        int y0 = pxPlayerPanelYOfs + pl * pxOnePlayerPanelHeight;
        int W = 2;
        g2.setColor(new Color(236, 233, 216));
        g2.fillRect(x0 + W, y0 + W, pxPlayerPanelWidth - 3 * W, pxOnePlayerPanelHeight - 2 * W);
        g2.setColor(Color.LIGHT_GRAY);
        g2.drawRect(x0 + W, y0 + W, pxPlayerPanelWidth - 3 * W, pxOnePlayerPanelHeight - 2 * W);
        g2.setColor(Color.BLACK);
        int col1ofs = 10;
        int rowheight = 14;
        g2.drawString("Player " + pl, x0 + col1ofs, y0 + 2 * rowheight);
        g2.setColor(playerColor[pl]);
        g2.fillRect(x0 + col1ofs, y0 + 3 * rowheight, 50, rowheight);
        g2.setColor(Color.BLACK);
        g2.setFont(font2);
        int val = this.boardlayout.state[OFS_PLAYERDATA[pl] + 0];
        g2.drawString("" + val, x0 + col1ofs + 10, y0 + 5 * rowheight + 10);
        g2.setColor(Color.BLACK);
        g2.setFont(font3);
        val = this.boardlayout.state[12];
        if (val == pl) {
            g2.setColor(Color.BLACK);
        } else {
            g2.setColor(Color.LIGHT_GRAY);
        }
        g2.drawString("Longest road: " + this.boardlayout.state[OFS_PLAYERDATA[pl] + 4], x0 + col1ofs, y0 + 7 * rowheight);
        val = this.boardlayout.state[13];
        if (val == pl) {
            g2.setColor(Color.BLACK);
            g2.drawString("Largest army: " + this.boardlayout.state[OFS_PLAYERDATA[pl] + 17 + 0], x0 + col1ofs, y0 + 8 * rowheight);
        } else {
            g2.setColor(Color.LIGHT_GRAY);
            g2.drawString("Army size: " + this.boardlayout.state[OFS_PLAYERDATA[pl] + 17 + 0], x0 + col1ofs, y0 + 8 * rowheight);
        }
        g2.setFont(font1);
        g2.setColor(Color.BLACK);
        int col2ofs = 80;
        for (i = 0; i < 5; ++i) {
            val = this.boardlayout.state[OFS_PLAYERDATA[pl] + 6 + i];
            g2.drawString(resourceNames[i] + ": ", x0 + col2ofs, y0 + (i + 2) * rowheight);
            g2.drawString("" + val, x0 + col2ofs + 50, y0 + (i + 2) * rowheight);
        }
        for (i = 0; i < 6; ++i) {
            val = this.boardlayout.state[OFS_PLAYERDATA[pl] + 11 + i];
            g2.drawString(val > 0 ? "+" : " ", x0 + col2ofs + 60, y0 + (i + 2) * rowheight);
        }
        int col3ofs = 170;
        for (i = 0; i < 5; ++i) {
            String str = "";
            val = this.boardlayout.state[OFS_PLAYERDATA[pl] + 22 + i];
            str = str + val;
            val = this.boardlayout.state[OFS_PLAYERDATA[pl] + 27 + i];
            str = str + " (+" + val + ")";
            val = this.boardlayout.state[OFS_PLAYERDATA[pl] + 17 + i];
            str = str + " u:" + val;
            g2.drawString(cardNames[i] + ": ", x0 + col3ofs, y0 + (i + 2) * rowheight);
            g2.drawString(str, x0 + col3ofs + 60, y0 + (i + 2) * rowheight);
        }
    }

    boolean findObjectAtPoint(Point p) {
        this.prevObjUnderMouse = this.objUnderMouse;
        this.prevObjIndUnderMouse = this.objIndUnderMouse;
        int ind = this.findHexAtPoint(p);
        if (ind > -1) {
            this.objUnderMouse = 0;
            this.objIndUnderMouse = ind;
        } else {
            this.objUnderMouse = -1;
        }
        if (this.prevObjUnderMouse == this.objUnderMouse && this.prevObjIndUnderMouse == this.objIndUnderMouse) {
            return false;
        }
        return this.prevObjUnderMouse != this.objUnderMouse || this.prevObjUnderMouse != -1;
    }

    int findHexAtPoint(Point p) {
        for (int i = 0; i < this.boardlayout.hextiles.length; ++i) {
            if (!this.boardlayout.hextiles[i].screenCoord.contains(p)) continue;
            return i;
        }
        return -1;
    }

    void UpdateMouseHighlight() {
        Graphics g = this.getGraphics();
        if (this.prevObjUnderMouse == 0) {
            this.DrawBoard(g);
            this.DrawHexTile(g, this.boardlayout.hextiles[this.prevObjIndUnderMouse]);
        }
        if (this.objUnderMouse == 0) {
            Color c = new Color(255, 255, 255, 100);
            g.setColor(c);
            g.fillPolygon(this.boardlayout.hextiles[this.objIndUnderMouse].screenCoord);
            g.setColor(Color.RED);
            g.drawPolygon(this.boardlayout.hextiles[this.objIndUnderMouse].screenCoord);
        }
    }

    private void initComponents() {
        this.setBorder(BorderFactory.createEtchedBorder());
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent evt) {
                SettlersPanel.this.formMouseMoved(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 394, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 408, Short.MAX_VALUE));
    }

    private void formMouseMoved(MouseEvent evt) {
        Point p = evt.getPoint();
    }
}

