/*
 * Decompiled with CFR 0.152.
 */
package smartsettlers.player;

import smartsettlers.boardlayout.BoardLayout;
import smartsettlers.boardlayout.GameStateConstants;
import smartsettlers.player.Player;
import smartsettlers.player.Resource;

public class HeuristicPlayer
extends Player
implements GameStateConstants {
    Resource[] stock = new Resource[4];
    Resource[] prodPerTurn = new Resource[4];
    int[][] exchRatio = new int[4][5];
    int[] totalVP = new int[4];
    int[] tempVP = new int[4];
    int[] regularVP = new int[4];
    int[] cardVP = new int[4];
    double[] internalScore = new double[4];
    int strongestOpponentPl;
    double[] totalProdPerTurn = new double[4];
    double[] etbRoad;
    double[] etbStlmt;
    double[] etbCity;
    double[] etbCard;
    double[] etbLongestRoad;
    double[] etbLargestArmy;

    public HeuristicPlayer(BoardLayout bl, int position) {
        super(bl, position);
    }

    @Override
    public void selectAction(int[] s, int[] a) {
        int[] a2;
        for (int j = 0; j < this.bl.possibilities.n; ++j) {
            a2 = this.bl.possibilities.action[j];
            System.out.printf("%2d: [%d %d %d %d %d]  w:%f\n", j, a2[0], a2[1], a2[2], a2[3], a2[4], this.bl.possibilities.weight[j]);
        }
        System.out.print("\n==========\n");
        a2 = this.bl.possibilities.randomAction();
        for (int i = 0; i < a2.length; ++i) {
            a[i] = a2[i];
        }
    }

    @Override
    public int selectMostUselessResourceInHand(int pl, int[] s) {
        return this.selectRandomResourceInHand(pl, s);
    }

    private double calcETB(int pl, Resource what) {
        Resource st0 = new Resource(this.stock[pl].res);
        if (Resource.Contains(st0, what)) {
            return 0.0;
        }
        int low = 0;
        int up = 1000;
        int njokers = 0;
        int nmissing = 0;
        while (up - low > 1) {
            int mid = (up + low) / 2;
            Resource st = new Resource(Resource.Add((Resource)st0, (Resource)Resource.Mult((Resource)this.prodPerTurn[pl], (double)((double)mid))).res);
            njokers = 0;
            nmissing = 0;
            for (int i = 0; i < 5; ++i) {
                double val = Math.max(0.0, (st.res[i] - what.res[i]) / (double)this.exchRatio[pl][i]);
                njokers += (int)val;
                nmissing += (int)Math.max(0.0, what.res[i] - st.res[i]);
            }
            if (njokers >= nmissing) {
                up = mid;
                continue;
            }
            low = mid;
        }
        return (int)((double)up + 0.5 * (double)njokers);
    }

    public void analyzeState(int pl0, int[] s, BoardLayout bl) {
        int pl;
        for (int ind = 0; ind < 19; ++ind) {
            if (s[11] == ind) continue;
            int val = bl.hextiles[ind].productionNumber;
            if (val > 7) {
                val = 14 - val;
            }
            double rate = (val - 1) / 36;
            for (int j = 0; j < 6; ++j) {
                int ind2 = bl.neighborHexVertex[ind][j];
                if (ind2 == -1) continue;
                int k = s[87 + ind2];
                if (k >= 2 && k < 6) {
                    pl = k - 2;
                    int n = bl.hextiles[ind].yields();
                    this.prodPerTurn[pl].res[n] = this.prodPerTurn[pl].res[n] + rate;
                }
                if (k < 6 || k >= 10) continue;
                pl = k - 6;
                int n = bl.hextiles[ind].yields();
                this.prodPerTurn[pl].res[n] = this.prodPerTurn[pl].res[n] + 2.0 * rate;
            }
        }
        for (pl = 0; pl < 4; ++pl) {
            this.stock[pl] = new Resource();
            this.totalProdPerTurn[pl] = 0.0;
            for (int i = 0; i < 5; ++i) {
                this.stock[pl].res[i] = s[OFS_PLAYERDATA[pl] + 6 + i];
                this.exchRatio[pl][i] = 4;
                if (s[OFS_PLAYERDATA[pl] + 11 + 6] != 0) {
                    this.exchRatio[pl][i] = 3;
                }
                if (s[OFS_PLAYERDATA[pl] + 11 + i] != 0) {
                    this.exchRatio[pl][i] = 2;
                }
                int n = pl;
                this.totalProdPerTurn[n] = this.totalProdPerTurn[n] + this.prodPerTurn[pl].res[i];
            }
        }
    }
}

