/*
 * Decompiled with CFR 0.152.
 */
package smartsettlers.player;

import java.util.Random;
import smartsettlers.boardlayout.BoardLayout;
import smartsettlers.boardlayout.GameStateConstants;

public abstract class Player
implements GameStateConstants {
    int position;
    int type;
    BoardLayout bl;
    Random rnd;

    public Player(BoardLayout bl, int position) {
        this.bl = bl;
        this.position = position;
        this.rnd = new Random();
    }

    public void listMonopolyPossibilities(int[] s) {
        int fsmlevel = s[1];
        int pl = s[5 + fsmlevel];
        if (s[OFS_PLAYERDATA[pl] + 5] != 0) {
            return;
        }
        if (s[OFS_PLAYERDATA[pl] + 22 + 4] >= 1) {
            for (int i = 0; i < 5; ++i) {
                this.bl.possibilities.addAction(1.0, 11, i);
            }
        }
    }

    public void listInitSettlementPossibilities(int[] s) {
        for (int i = 0; i < 54; ++i) {
            if (s[87 + i] != 0) continue;
            this.bl.possibilities.addAction(1.0, 1, i);
        }
    }

    public void listInitRoadPossibilities(int[] s) {
        int lastvertex = s[14];
        for (int i = 0; i < 6; ++i) {
            int ind = this.bl.neighborVertexEdge[lastvertex][i];
            if (ind == -1 || s[15 + ind] != 0) continue;
            this.bl.possibilities.addAction(1.0, 2, ind);
        }
    }

    public void listNormalPossibilities(int[] s) {
        int j;
        int i;
        int fsmlevel = s[1];
        int fsmstate = s[2 + fsmlevel];
        int pl = s[5 + fsmlevel];
        this.bl.possibilities.addAction(1.0, 5);
        if (s[OFS_PLAYERDATA[pl] + 6 + 1] >= 1 && s[OFS_PLAYERDATA[pl] + 6 + 2] >= 1 && s[OFS_PLAYERDATA[pl] + 3] < 15) {
            this.listRoadPossibilities(s);
        }
        if (s[OFS_PLAYERDATA[pl] + 6 + 1] >= 1 && s[OFS_PLAYERDATA[pl] + 6 + 2] >= 1 && s[OFS_PLAYERDATA[pl] + 6 + 3] >= 1 && s[OFS_PLAYERDATA[pl] + 6 + 0] >= 1 && s[OFS_PLAYERDATA[pl] + 1] <= 5) {
            for (i = 0; i < 54; ++i) {
                if (s[87 + i] != 0) continue;
                boolean hasneighbor = false;
                for (j = 0; j < 6; ++j) {
                    int ind = this.bl.neighborVertexEdge[i][j];
                    if (ind == -1 || s[15 + ind] != 1 + pl) continue;
                    hasneighbor = true;
                }
                if (!hasneighbor) continue;
                this.bl.possibilities.addAction(1.0, 1, i);
            }
        }
        if (s[OFS_PLAYERDATA[pl] + 6 + 4] >= 3 && s[OFS_PLAYERDATA[pl] + 6 + 3] >= 2 && s[OFS_PLAYERDATA[pl] + 2] <= 4) {
            for (i = 0; i < 54; ++i) {
                if (s[87 + i] != 2 + pl) continue;
                this.bl.possibilities.addAction(1.0, 3, i);
            }
        }
        if (s[OFS_PLAYERDATA[pl] + 6 + 4] >= 1 && s[OFS_PLAYERDATA[pl] + 6 + 3] >= 1 && s[OFS_PLAYERDATA[pl] + 6 + 0] >= 1 && s[8] < 25) {
            this.bl.possibilities.addAction(1.0, 7, this.bl.cardSequence[s[8]]);
        }
        this.listDevCardPossibilities(s);
        double w = 10.0;
        for (i = 0; i < 5; ++i) {
            for (j = 0; j < 5; ++j) {
                if (i == j) continue;
                w = 1.0;
                if (s[OFS_PLAYERDATA[pl] + 6 + i] >= 2 && s[OFS_PLAYERDATA[pl] + 11 + i] == 1) {
                    this.bl.possibilities.addAction(w, 6, 2, i, 1, j);
                    continue;
                }
                if (s[OFS_PLAYERDATA[pl] + 6 + i] >= 3 && s[OFS_PLAYERDATA[pl] + 11 + 5] == 1) {
                    this.bl.possibilities.addAction(w, 6, 3, i, 1, j);
                    continue;
                }
                if (s[OFS_PLAYERDATA[pl] + 6 + i] < 4) continue;
                this.bl.possibilities.addAction(w, 6, 4, i, 1, j);
            }
        }
    }

    public void listDevCardPossibilities(int[] s) {
        int fsmlevel = s[1];
        int pl = s[5 + fsmlevel];
        if (s[OFS_PLAYERDATA[pl] + 5] != 0) {
            return;
        }
        if (s[OFS_PLAYERDATA[pl] + 22 + 3] >= 1) {
            for (int i = 0; i < 5; ++i) {
                for (int j = i; j < 5; ++j) {
                    this.bl.possibilities.addAction(1.0, 10, i, j);
                }
            }
        }
        this.listMonopolyPossibilities(s);
        if (s[OFS_PLAYERDATA[pl] + 22 + 2] >= 1 && s[OFS_PLAYERDATA[pl] + 3] < 14) {
            this.bl.possibilities.addAction(1.0, 9);
        }
        if (s[OFS_PLAYERDATA[pl] + 22 + 0] >= 1) {
            this.listRobberPossibilities(s, 8);
        }
    }

    public void listRoadPossibilities(int[] s) {
        int fsmlevel = s[1];
        int fsmstate = s[2 + fsmlevel];
        int pl = s[5 + fsmlevel];
        double ratio = (double)s[OFS_PLAYERDATA[pl] + 3] / (double)(s[OFS_PLAYERDATA[pl] + 1] + s[OFS_PLAYERDATA[pl] + 2]);
        double weight = Math.pow(10.0, -ratio + 1.0);
        weight = 1.0;
        for (int i = 0; i < 54; ++i) {
            int ind;
            int j;
            if (s[87 + i] != 0 && s[87 + i] != 1 && s[87 + i] != 2 + pl && s[87 + i] != 6 + pl) continue;
            boolean hasneighbor = false;
            for (j = 0; j < 6; ++j) {
                ind = this.bl.neighborVertexEdge[i][j];
                if (ind == -1 || s[15 + ind] != 1 + pl) continue;
                hasneighbor = true;
            }
            if (!hasneighbor) continue;
            for (j = 0; j < 6; ++j) {
                ind = this.bl.neighborVertexEdge[i][j];
                if (ind == -1 || s[15 + ind] != 0) continue;
                this.bl.possibilities.addAction(weight, 2, ind);
            }
        }
    }

    public void listRobberPossibilities(int[] s, int action) {
        int fsmlevel = s[1];
        int fsmstate = s[2 + fsmlevel];
        int pl = s[5 + fsmlevel];
        for (int i = 0; i < 19; ++i) {
            if (this.bl.hextiles[i].type != 2 || i == s[11]) continue;
            for (int j = 0; j < 6; ++j) {
                int val;
                int pl2;
                int ind = this.bl.neighborHexVertex[i][j];
                if (ind == -1 || (pl2 = (val = s[87 + ind]) >= 2 && val < 6 ? val - 2 : (val >= 6 && val < 10 ? val - 6 : -1)) == -1 || pl2 == pl) continue;
                this.bl.possibilities.addAction(1.0, action, i, pl2, this.selectRandomResourceInHand(pl2, s));
            }
        }
    }

    public void listPossibilities(int[] s) {
        int fsmlevel = s[1];
        int fsmstate = s[2 + fsmlevel];
        int pl = s[5 + fsmlevel];
        this.bl.possibilities.Clear();
        switch (fsmstate) {
            case 2: 
            case 4: {
                this.listInitSettlementPossibilities(s);
                break;
            }
            case 3: 
            case 5: {
                this.listInitRoadPossibilities(s);
                break;
            }
            case 6: {
                this.bl.possibilities.addAction(1.0, 4);
                if (s[OFS_PLAYERDATA[pl] + 22 + 0] < 1 || s[OFS_PLAYERDATA[pl] + 5] != 0) break;
                this.listRobberPossibilities(s, 8);
                break;
            }
            case 13: 
            case 14: {
                this.listRoadPossibilities(s);
                break;
            }
            case 11: {
                int val = 0;
                for (int i = 0; i < 5; ++i) {
                    val += s[OFS_PLAYERDATA[pl] + 6 + i];
                }
                val = val > 7 ? (val /= 2) : 0;
                this.bl.possibilities.addAction(1.0, 12, val);
                break;
            }
            case 15: {
                this.listRobberPossibilities(s, 13);
                break;
            }
            case 100: {
                this.listNormalPossibilities(s);
            }
        }
        if (this.bl.possibilities.n == 0) {
            this.bl.possibilities.addAction(1.0, 0);
        }
    }

    public abstract void selectAction(int[] var1, int[] var2);

    public int selectRandomResourceInHand(int pl, int[] s) {
        int i;
        int ncards = 0;
        for (i = 0; i < 5; ++i) {
            ncards += s[OFS_PLAYERDATA[pl] + 6 + i];
        }
        if (ncards == 0) {
            return -1;
        }
        if (ncards <= 0) {
            String str = "";
            System.out.printf("Player %d has %d cards\n", pl, ncards);
            for (i = 0; i < s.length; ++i) {
                str = str + " " + s[i];
            }
            System.out.flush();
        }
        int ind = this.rnd.nextInt(ncards) + 1;
        int j = 0;
        for (i = 0; i < 5 && (j += s[OFS_PLAYERDATA[pl] + 6 + i]) < ind; ++i) {
        }
        return Math.min(i, 4);
    }

    public abstract int selectMostUselessResourceInHand(int var1, int[] var2);

    public void performAction(int[] s, int[] a) {
        int fsmlevel = s[1];
        int fsmstate = s[2 + fsmlevel];
        int pl = s[5 + fsmlevel];
        switch (a[0]) {
            case 1: {
                int ind;
                int j;
                s[87 + a[1]] = 2 + pl;
                int n = OFS_PLAYERDATA[pl] + 1;
                s[n] = s[n] + 1;
                s[14] = a[1];
                boolean[] hasOpponentRoad = new boolean[4];
                for (j = 0; j < 6; ++j) {
                    ind = this.bl.neighborVertexVertex[a[1]][j];
                    if (ind != -1) {
                        s[87 + ind] = 1;
                    }
                    if ((ind = this.bl.neighborVertexEdge[a[1]][j]) == -1 || s[15 + ind] == 0) continue;
                    hasOpponentRoad[s[15 + ind] - 1] = true;
                }
                hasOpponentRoad[pl] = false;
                for (j = 0; j < 6; ++j) {
                    ind = this.bl.neighborVertexHex[a[1]][j];
                    if (ind == -1 || this.bl.hextiles[ind].type != 1) continue;
                    int val = this.bl.hextiles[ind].subtype - 1;
                    int k = j - 2;
                    if (k < 0) {
                        k += 6;
                    }
                    if (k == this.bl.hextiles[ind].orientation) {
                        s[Player.OFS_PLAYERDATA[pl] + 11 + val] = 1;
                    }
                    if ((k = j - 3) < 0) {
                        k += 6;
                    }
                    if (k != this.bl.hextiles[ind].orientation) continue;
                    s[Player.OFS_PLAYERDATA[pl] + 11 + val] = 1;
                }
                for (int pl2 = 0; pl2 < 4; ++pl2) {
                    if (!hasOpponentRoad[pl2]) continue;
                    this.bl.recalcLongestRoad(s, pl2);
                }
                if (fsmstate == 4) {
                    for (j = 0; j < 6; ++j) {
                        int resource;
                        ind = this.bl.neighborVertexHex[a[1]][j];
                        if (ind == -1 || (resource = this.bl.hextiles[ind].yields()) == -1) continue;
                        int n2 = OFS_PLAYERDATA[pl] + 6 + resource;
                        s[n2] = s[n2] + 1;
                    }
                    break;
                }
                if (fsmstate != 100) break;
                int n3 = OFS_PLAYERDATA[pl] + 6 + 1;
                s[n3] = s[n3] - 1;
                int n4 = OFS_PLAYERDATA[pl] + 6 + 2;
                s[n4] = s[n4] - 1;
                int n5 = OFS_PLAYERDATA[pl] + 6 + 3;
                s[n5] = s[n5] - 1;
                int n6 = OFS_PLAYERDATA[pl] + 6 + 0;
                s[n6] = s[n6] - 1;
                break;
            }
            case 3: {
                s[87 + a[1]] = 6 + pl;
                int n = OFS_PLAYERDATA[pl] + 1;
                s[n] = s[n] - 1;
                int n7 = OFS_PLAYERDATA[pl] + 2;
                s[n7] = s[n7] + 1;
                int n8 = OFS_PLAYERDATA[pl] + 6 + 4;
                s[n8] = s[n8] - 3;
                int n9 = OFS_PLAYERDATA[pl] + 6 + 3;
                s[n9] = s[n9] - 2;
                break;
            }
            case 2: {
                s[15 + a[1]] = 1 + pl;
                int n = OFS_PLAYERDATA[pl] + 3;
                s[n] = s[n] + 1;
                if (fsmstate == 100) {
                    int n10 = OFS_PLAYERDATA[pl] + 6 + 1;
                    s[n10] = s[n10] - 1;
                    int n11 = OFS_PLAYERDATA[pl] + 6 + 2;
                    s[n11] = s[n11] - 1;
                }
                this.bl.recalcLongestRoad(s, pl);
                break;
            }
            case 4: {
                s[9] = this.rnd.nextInt(6) + 1;
                s[10] = this.rnd.nextInt(6) + 1;
                int val = s[9] + s[10];
                for (int ind = 0; ind < 19; ++ind) {
                    if (val != this.bl.hextiles[ind].productionNumber || s[11] == ind) continue;
                    for (int j = 0; j < 6; ++j) {
                        int ind2 = this.bl.neighborHexVertex[ind][j];
                        if (ind2 == -1) continue;
                        int k = s[87 + ind2];
                        if (k >= 2 && k < 6) {
                            pl = k - 2;
                            int n = OFS_PLAYERDATA[pl] + 6 + this.bl.hextiles[ind].yields();
                            s[n] = s[n] + 1;
                        }
                        if (k < 6 || k >= 10) continue;
                        pl = k - 6;
                        int n = OFS_PLAYERDATA[pl] + 6 + this.bl.hextiles[ind].yields();
                        s[n] = s[n] + 2;
                    }
                }
                break;
            }
            case 6: {
                int n = OFS_PLAYERDATA[pl] + 6 + a[2];
                s[n] = s[n] - a[1];
                int n12 = OFS_PLAYERDATA[pl] + 6 + a[4];
                s[n12] = s[n12] + a[3];
                break;
            }
            case 7: {
                int n = OFS_PLAYERDATA[pl] + 6 + 3;
                s[n] = s[n] - 1;
                int n13 = OFS_PLAYERDATA[pl] + 6 + 0;
                s[n13] = s[n13] - 1;
                int n14 = OFS_PLAYERDATA[pl] + 6 + 4;
                s[n14] = s[n14] - 1;
                int val = this.bl.cardSequence[s[8]];
                if (val == 1) {
                    int n15 = OFS_PLAYERDATA[pl] + 22 + val;
                    s[n15] = s[n15] + 1;
                } else {
                    int n16 = OFS_PLAYERDATA[pl] + 27 + val;
                    s[n16] = s[n16] + 1;
                }
                s[8] = s[8] + 1;
                break;
            }
            case 10: {
                s[Player.OFS_PLAYERDATA[pl] + 5] = 1;
                int n = OFS_PLAYERDATA[pl] + 22 + 3;
                s[n] = s[n] - 1;
                int n17 = OFS_PLAYERDATA[pl] + 17 + 3;
                s[n17] = s[n17] + 1;
                int n18 = OFS_PLAYERDATA[pl] + 6 + a[1];
                s[n18] = s[n18] + 1;
                int n19 = OFS_PLAYERDATA[pl] + 6 + a[2];
                s[n19] = s[n19] + 1;
                break;
            }
            case 11: {
                s[Player.OFS_PLAYERDATA[pl] + 5] = 1;
                int n = OFS_PLAYERDATA[pl] + 22 + 4;
                s[n] = s[n] - 1;
                int n20 = OFS_PLAYERDATA[pl] + 17 + 4;
                s[n20] = s[n20] + 1;
                for (int ind = 0; ind < 4; ++ind) {
                    if (ind == pl) continue;
                    int n21 = OFS_PLAYERDATA[pl] + 6 + a[1];
                    s[n21] = s[n21] + s[OFS_PLAYERDATA[ind] + 6 + a[1]];
                    s[Player.OFS_PLAYERDATA[ind] + 6 + a[1]] = 0;
                }
                break;
            }
            case 9: {
                s[Player.OFS_PLAYERDATA[pl] + 5] = 1;
                int n = OFS_PLAYERDATA[pl] + 22 + 2;
                s[n] = s[n] - 1;
                int n22 = OFS_PLAYERDATA[pl] + 17 + 2;
                s[n22] = s[n22] + 1;
                break;
            }
            case 8: {
                s[Player.OFS_PLAYERDATA[pl] + 5] = 1;
                int n = OFS_PLAYERDATA[pl] + 22 + 0;
                s[n] = s[n] - 1;
                int n23 = OFS_PLAYERDATA[pl] + 17 + 0;
                s[n23] = s[n23] + 1;
                this.bl.recalcLargestArmy(s);
            }
            case 13: {
                s[11] = a[1];
                if (a[2] == -1 || a[3] == -1) break;
                int n = OFS_PLAYERDATA[a[2]] + 6 + a[3];
                s[n] = s[n] - 1;
                int n24 = OFS_PLAYERDATA[pl] + 6 + a[3];
                s[n24] = s[n24] + 1;
                break;
            }
            case 12: {
                for (int i = 0; i < a[1]; ++i) {
                    int ind = this.selectMostUselessResourceInHand(pl, s);
                    int n = OFS_PLAYERDATA[pl] + 6 + ind;
                    s[n] = s[n] - 1;
                }
                break;
            }
            case 5: {
                for (int ind = 0; ind < 5; ++ind) {
                    int n = OFS_PLAYERDATA[pl] + 22 + ind;
                    s[n] = s[n] + s[OFS_PLAYERDATA[pl] + 27 + ind];
                    s[Player.OFS_PLAYERDATA[pl] + 27 + ind] = 0;
                }
                s[Player.OFS_PLAYERDATA[pl] + 5] = 0;
            }
        }
    }
}

