/*
 * Decompiled with CFR 0.152.
 */
package smartsettlers.player;

import smartsettlers.boardlayout.HexTypeConstants;

class Resource
implements HexTypeConstants {
    double[] res = new double[5];
    static final Resource ResRoad = new Resource(0.0, 1.0, 1.0, 0.0, 0.0);
    static final Resource ResStlmt = new Resource(1.0, 1.0, 1.0, 1.0, 0.0);
    static final Resource ResCity = new Resource(0.0, 0.0, 0.0, 2.0, 3.0);
    static final Resource ResCard = new Resource(1.0, 0.0, 0.0, 1.0, 1.0);

    public Resource(double sh, double wd, double cl, double wh, double st) {
        this.res[0] = sh;
        this.res[1] = wd;
        this.res[2] = cl;
        this.res[3] = wh;
        this.res[4] = st;
    }

    public Resource(double[] res) {
        for (int i = 0; i < 5; ++i) {
            this.res[i] = res[i];
        }
    }

    public Resource() {
        for (int i = 0; i < 5; ++i) {
            this.res[i] = 0.0;
        }
    }

    static Resource Mult(Resource r, double factor) {
        Resource rr = new Resource(r.res);
        int i = 0;
        while (i < 5) {
            int n = i++;
            rr.res[n] = rr.res[n] * factor;
        }
        return rr;
    }

    static Resource Add(Resource r1, Resource r2) {
        Resource rr = new Resource(r1.res);
        for (int i = 0; i < 5; ++i) {
            int n = i;
            rr.res[n] = rr.res[n] + r2.res[i];
        }
        return rr;
    }

    static boolean Contains(Resource r1, Resource r2) {
        for (int i = 0; i < 5; ++i) {
            if (!(r1.res[i] < r2.res[i])) continue;
            return false;
        }
        return true;
    }

    static boolean IsEmpty(Resource r1) {
        for (int i = 0; i < 5; ++i) {
            if (!(r1.res[i] > 0.0)) continue;
            return false;
        }
        return true;
    }
}

