/*
 * Decompiled with CFR 0.152.
 */
package smartsettlers.util;

import java.util.Random;

public final class FastRandom {
    private int mt_index;
    private int[] mt_buffer = new int[624];

    public FastRandom() {
        Random r = new Random();
        for (int i = 0; i < 624; ++i) {
            this.mt_buffer[i] = r.nextInt();
        }
        this.mt_index = 0;
    }

    public int random() {
        if (this.mt_index == 624) {
            int s;
            int i;
            this.mt_index = 0;
            for (i = 0; i < 227; ++i) {
                s = this.mt_buffer[i] & Integer.MIN_VALUE | this.mt_buffer[i + 1] & Integer.MAX_VALUE;
                this.mt_buffer[i] = this.mt_buffer[i + 397] ^ s >> 1 ^ (s & 1) * -1727483681;
            }
            while (i < 623) {
                s = this.mt_buffer[i] & Integer.MIN_VALUE | this.mt_buffer[i + 1] & Integer.MAX_VALUE;
                this.mt_buffer[i] = this.mt_buffer[i - 227] ^ s >> 1 ^ (s & 1) * -1727483681;
                ++i;
            }
            s = this.mt_buffer[623] & Integer.MIN_VALUE | this.mt_buffer[0] & Integer.MAX_VALUE;
            this.mt_buffer[623] = this.mt_buffer[396] ^ s >> 1 ^ (s & 1) * -1727483681;
        }
        return this.mt_buffer[this.mt_index++];
    }

    public int nextInt(int n) {
        int val;
        int bits;
        if (n == 0) {
            return 0;
        }
        if (n <= 0) {
            throw new IllegalArgumentException("n must be positive");
        }
        if ((n & -n) == n) {
            return (int)((long)n * (long)this.random() >> 31);
        }
        while ((bits = this.random()) - (val = bits % n) + (n - 1) < 0) {
        }
        return val;
    }
}

