/*
 * Decompiled with CFR 0.152.
 */
package smartsettlers.util;

import java.util.ArrayList;
import smartsettlers.boardlayout.GameStateConstants;
import smartsettlers.boardlayout.HexTypeConstants;

public class GameLog
implements GameStateConstants,
HexTypeConstants {
    public int size = 0;
    public ArrayList states = new ArrayList();
    public ArrayList actions = new ArrayList();

    public void clear() {
        this.size = 0;
        this.states.clear();
        this.actions.clear();
    }

    public void addState(int[] state) {
        int[] s = (int[])state.clone();
        this.states.add(s);
    }

    public void addAction(int[] action) {
        int[] a = (int[])action.clone();
        this.actions.add(a);
        ++this.size;
    }

    public String toString(int index) {
        if (this.size == 0 || index < 0) {
            return "Empty log";
        }
        String str = null;
        String str2 = null;
        int[] s = (int[])this.states.get(index);
        int[] s2 = (int[])this.states.get(index + 1);
        int[] a = (int[])this.actions.get(index);
        int fsmlevel = s[1];
        int fsmstate = s[2 + fsmlevel];
        int pl = s[5 + fsmlevel];
        str = "" + index + ". Player " + pl + ": ";
        switch (fsmstate) {
            case 0: {
                str = "Game start";
                break;
            }
            case 2: {
                str = str + "Place settlement 1 at pos#" + a[1];
                break;
            }
            case 4: {
                str = str + "Place settlement 2 at pos#" + a[1];
                break;
            }
            case 3: {
                str = str + "Place road 1";
                break;
            }
            case 5: {
                str = str + "Place road 2";
                break;
            }
            case 6: {
                if (a[0] == 4) {
                    str = str + "Throw dice: " + s2[9] + "+" + s2[10] + " = " + (s2[9] + s2[10]);
                    break;
                }
                str = str + "S_BEFOREDICE";
                break;
            }
            case 13: {
                str = str + "Build free road 1 at pos#" + a[1];
                break;
            }
            case 14: {
                str = str + "Build free road 2 at pos#" + a[1];
                break;
            }
            case 11: {
                if (a[1] == 0) {
                    str = str + "Do not need to pay tax";
                    break;
                }
                boolean val2 = true;
                str = str + "pay " + a[1] + " tax:";
                for (int i = 0; i < 5; ++i) {
                    int val1 = s[OFS_PLAYERDATA[pl] + 6 + i] - s2[OFS_PLAYERDATA[pl] + 6 + i];
                    if (val1 == 0) continue;
                    if (val2) {
                        val2 = false;
                        str = str + " ";
                    } else {
                        str = str + ", ";
                    }
                    str = str + val1 + " " + resourceNames[i];
                }
                break;
            }
            case 15: {
                str = str + "Robber to hex #" + a[1] + ", ";
                if (a[2] == -1) {
                    str = str + "do not steal";
                    break;
                }
                if (a[3] == -1) {
                    str = str + "steal from Pl." + a[2] + ", who has no cards";
                    break;
                }
                str = str + "steal a " + resourceNames[a[3]] + " from Pl." + a[2];
                break;
            }
            case 100: {
                switch (a[0]) {
                    case 2: {
                        str = str + "Build road at pos#" + a[1];
                        break;
                    }
                    case 1: {
                        str = str + "Build settlement at pos#" + a[1];
                        break;
                    }
                    case 3: {
                        str = str + "Build city at pos#" + a[1];
                        break;
                    }
                    case 5: {
                        str = str + "End turn";
                        break;
                    }
                    case 6: {
                        if (a[1] == 2) {
                            str2 = " at special port";
                        } else if (a[1] == 3) {
                            str2 = " at general port";
                        } else if (a[1] == 4) {
                            str2 = " at bank";
                        }
                        str = str + "Trade " + a[1] + " " + resourceNames[a[2]] + " to " + a[3] + " " + resourceNames[a[4]] + str2;
                        break;
                    }
                    case 7: {
                        str = str + "Buy development card: " + cardNames[a[1]];
                        break;
                    }
                    case 10: {
                        if (a[1] == a[2]) {
                            str = str + "Take free res.: 2 " + resourceNames[a[1]];
                            break;
                        }
                        str = str + "Take free res.: 1 " + resourceNames[a[1]] + " and 1" + resourceNames[a[2]];
                        break;
                    }
                    case 11: {
                        str = str + "Declare monopoly on " + resourceNames[a[1]];
                        break;
                    }
                    case 9: {
                        str = str + "2 free roads";
                        break;
                    }
                    case 8: {
                        str = str + "Robber to hex #" + a[1] + ", ";
                        str = a[2] == -1 ? str + "do not steal" : (a[3] == -1 ? str + "steal from Pl." + a[2] + ", who has no cards" : str + "steal a " + resourceNames[a[3]] + " from Pl." + a[2]);
                    }
                }
                break;
            }
            case 101: {
                int val1 = -1;
                for (pl = 0; pl < 4; ++pl) {
                    if (s[OFS_PLAYERDATA[pl] + 0] < 10) continue;
                    val1 = pl;
                }
                str = str + "Finished, Player " + val1 + " wins.";
            }
        }
        return str;
    }

    public String toString() {
        return this.toString(this.size - 1);
    }
}

