/*
 * Decompiled with CFR 0.152.
 */
package soc.client;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.List;
import java.awt.Point;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.StringTokenizer;
import java.util.Vector;
import soc.client.SOCPlayerClient;
import soc.client.SnippingTextArea;

public class ChannelFrame
extends Frame {
    public SnippingTextArea ta;
    public TextField tf;
    public List lst;
    public Canvas cnvs;
    public int ncols;
    public int npix = 1;
    SOCPlayerClient cc;
    String cname;
    Vector history = new Vector();
    int historyCounter = 1;
    boolean down = false;

    public ChannelFrame(String t, SOCPlayerClient ccp) {
        super("Channel: " + t);
        this.setBackground(ccp.getBackground());
        this.setForeground(ccp.getForeground());
        this.ta = new SnippingTextArea("", 100);
        this.tf = new TextField("Please wait...");
        this.lst = new List(0, false);
        this.cc = ccp;
        this.cname = t;
        this.ta.setEditable(false);
        this.tf.setEditable(false);
        this.cnvs = new Canvas();
        this.cnvs.setBackground(Color.lightGray);
        this.cnvs.setSize(5, 200);
        this.lst.setSize(180, 200);
        this.setFont(new Font("Helvetica", 0, 12));
        this.add(this.ta);
        this.add(this.cnvs);
        this.add(this.lst);
        this.add(this.tf);
        this.setLayout(null);
        this.setSize(640, 480);
        this.setLocation(200, 200);
        this.history.addElement("");
        this.tf.addActionListener(new InputActionListener());
        this.tf.addKeyListener(new InputKeyListener());
        this.cnvs.addMouseListener(new DividerMouseListener());
        this.addWindowListener(new MyWindowListener());
    }

    public void print(String s) {
        StringTokenizer st = new StringTokenizer(s, " \n", true);
        String row = "";
        while (st.hasMoreElements()) {
            String tk = st.nextToken();
            if (tk.equals("\n")) continue;
            if (row.length() + tk.length() > this.ncols) {
                this.ta.append(row + "\n");
                row = tk;
                continue;
            }
            row = row + tk;
        }
        if (row.trim().length() > 0) {
            this.ta.append(row + "\n");
        }
    }

    public void over(String s) {
        this.tf.setEditable(false);
        this.tf.setText(s);
    }

    public void began() {
        this.tf.setEditable(true);
        this.tf.setText("");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMember(String s) {
        Object object = this.lst.getTreeLock();
        synchronized (object) {
            int i;
            for (i = this.lst.getItemCount() - 1; i >= 0 && this.lst.getItem(i).compareTo(s) >= 0; --i) {
            }
            this.lst.add(s, i + 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteMember(String s) {
        Object object = this.lst.getTreeLock();
        synchronized (object) {
            for (int i = this.lst.getItemCount() - 1; i >= 0; --i) {
                if (!this.lst.getItem(i).equals(s)) continue;
                this.lst.remove(i);
                break;
            }
        }
    }

    @Override
    public void doLayout() {
        Insets i = this.getInsets();
        Dimension dim = this.getSize();
        dim.width -= i.left + i.right;
        dim.height -= i.top + i.bottom;
        int tfheight = this.tf.getPreferredSize().height;
        int h = dim.height - tfheight;
        int lw = this.lst.getSize().width;
        int cw = this.cnvs.getSize().width;
        int w = dim.width - lw - cw;
        this.tf.setSize(dim.width, tfheight);
        this.tf.setLocation(i.left, i.top + h);
        this.ta.setSize(w, h);
        this.ta.setLocation(i.left, i.top);
        this.cnvs.setSize(cw, h);
        this.cnvs.setLocation(i.left + w, i.top);
        this.lst.setSize(lw, h);
        this.lst.setLocation(w + cw + i.left, i.top);
        this.npix = this.ta.getPreferredSize((int)100, (int)100).width;
        this.ncols = (int)((double)w * 100.0 / (double)this.npix) - 2;
    }

    private class MyWindowListener
    extends WindowAdapter {
        private MyWindowListener() {
        }

        @Override
        public void windowClosing(WindowEvent e) {
            ChannelFrame.this.cc.leaveChannel(ChannelFrame.this.cname);
            ChannelFrame.this.dispose();
        }

        @Override
        public void windowOpened(WindowEvent e) {
            ChannelFrame.this.tf.requestFocus();
        }
    }

    private class InputKeyListener
    extends KeyAdapter {
        private InputKeyListener() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            int hs = ChannelFrame.this.history.size();
            int key = e.getKeyCode();
            if (key == 38 && hs > ChannelFrame.this.historyCounter) {
                if (ChannelFrame.this.historyCounter == 1) {
                    ChannelFrame.this.history.setElementAt(ChannelFrame.this.tf.getText(), hs - 1);
                }
                ++ChannelFrame.this.historyCounter;
                ChannelFrame.this.tf.setText((String)ChannelFrame.this.history.elementAt(hs - ChannelFrame.this.historyCounter));
            } else if (key == 40 && ChannelFrame.this.historyCounter > 1) {
                --ChannelFrame.this.historyCounter;
                ChannelFrame.this.tf.setText((String)ChannelFrame.this.history.elementAt(hs - ChannelFrame.this.historyCounter));
            }
        }
    }

    private class DividerMouseListener
    extends MouseAdapter {
        private DividerMouseListener() {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            if (!ChannelFrame.this.down) {
                ChannelFrame.this.setCursor(Cursor.getPredefinedCursor(10));
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            if (!ChannelFrame.this.down) {
                ChannelFrame.this.setCursor(Cursor.getDefaultCursor());
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            ChannelFrame.this.down = true;
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (!ChannelFrame.this.cnvs.contains(e.getPoint())) {
                ChannelFrame.this.setCursor(Cursor.getDefaultCursor());
            }
            Dimension d = ChannelFrame.this.ta.getSize();
            Point p = ChannelFrame.this.cnvs.getLocation();
            int diff = p.x + e.getX() - 7 - d.width;
            diff = Math.max(diff, 30 - d.width);
            diff = Math.min(diff, ChannelFrame.this.getSize().width - 30 - d.width);
            d.width += diff;
            ChannelFrame.this.ta.setSize(d);
            ChannelFrame.this.ncols = (int)((double)d.width * 100.0 / (double)ChannelFrame.this.npix) - 2;
            d = ChannelFrame.this.lst.getSize();
            d.width -= diff;
            ChannelFrame.this.lst.setSize(d);
            p.x += diff;
            ChannelFrame.this.cnvs.setLocation(p);
            p = ChannelFrame.this.lst.getLocation();
            p.x += diff;
            ChannelFrame.this.lst.setLocation(p);
            ChannelFrame.this.down = false;
        }
    }

    private class InputActionListener
    implements ActionListener {
        private InputActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String s = ChannelFrame.this.tf.getText().trim();
            if (s.length() > 0) {
                ChannelFrame.this.tf.setText("");
                ChannelFrame.this.cc.chSend(ChannelFrame.this.cname, s + "\n");
                ChannelFrame.this.history.setElementAt(s, ChannelFrame.this.history.size() - 1);
                ChannelFrame.this.history.addElement("");
                ChannelFrame.this.historyCounter = 1;
            }
        }
    }
}

