/*
 * Decompiled with CFR 0.152.
 */
package soc.client;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

public class ColorSquare
extends Canvas
implements MouseListener {
    public static final Color CLAY = new Color(204, 102, 102);
    public static final Color ORE = new Color(153, 153, 153);
    public static final Color SHEEP = new Color(51, 204, 51);
    public static final Color WHEAT = new Color(204, 204, 51);
    public static final Color WOOD = new Color(204, 153, 102);
    public static final Color GREY = new Color(204, 204, 204);
    public static final int NUMBER = 0;
    public static final int YES_NO = 1;
    public static final int CHECKBOX = 2;
    public static final int BOUNDED_INC = 3;
    public static final int BOUNDED_DEC = 4;
    public static final int WIDTH = 16;
    public static final int HEIGHT = 16;
    int intValue;
    boolean boolValue;
    boolean valueVis;
    int kind;
    int upperBound;
    int lowerBound;
    boolean interactive;

    public ColorSquare() {
        this(0, false, GREY, 0, 0);
        this.valueVis = false;
    }

    public ColorSquare(Color c) {
        this(0, false, c, 99, 0);
    }

    public ColorSquare(Color c, int v) {
        this(0, false, c, 99, 0);
        this.intValue = v;
    }

    public ColorSquare(int k, boolean in, Color c) {
        this(k, in, c, 99, 0);
    }

    public ColorSquare(int k, boolean in, Color c, int upper, int lower) {
        this.setFont(new Font("Geneva", 0, 10));
        this.setBackground(c);
        this.kind = k;
        this.interactive = in;
        switch (k) {
            case 0: {
                this.valueVis = true;
                this.intValue = 0;
                break;
            }
            case 1: {
                this.valueVis = true;
                this.boolValue = false;
                break;
            }
            case 2: {
                this.valueVis = true;
                this.boolValue = false;
                break;
            }
            case 3: {
                this.valueVis = true;
                this.boolValue = false;
                this.upperBound = upper;
                this.lowerBound = lower;
                break;
            }
            case 4: {
                this.valueVis = true;
                this.boolValue = false;
                this.upperBound = upper;
                this.lowerBound = lower;
            }
        }
        this.addMouseListener(this);
    }

    public void setColor(Color c) {
        this.setBackground(c);
    }

    public Dimension getPreferedSize() {
        return new Dimension(16, 16);
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(16, 16);
    }

    @Override
    public void paint(Graphics g) {
        g.setPaintMode();
        g.clearRect(0, 0, 16, 16);
        g.setColor(Color.black);
        g.drawRect(0, 0, 15, 15);
        if (this.valueVis) {
            FontMetrics fm = this.getFontMetrics(this.getFont());
            switch (this.kind) {
                case 0: 
                case 3: 
                case 4: {
                    int numW = fm.stringWidth(Integer.toString(this.intValue));
                    int x = (16 - numW) / 2;
                    int y = 12;
                    g.drawString(Integer.toString(this.intValue), x, y);
                    break;
                }
                case 1: {
                    String value = this.boolValue ? "Y" : "N";
                    int numW = fm.stringWidth(value);
                    int x = (16 - numW) / 2;
                    int y = 12;
                    g.drawString(value, x, y);
                    break;
                }
                case 2: {
                    if (!this.boolValue) break;
                    int checkX = 3;
                    int checkY = 4;
                    g.drawLine(checkX, 2 * checkY, 2 * checkX, 3 * checkY);
                    g.drawLine(2 * checkX, 3 * checkY, 4 * checkX, checkY);
                }
            }
        }
    }

    public void addValue(int v) {
        this.intValue += v;
        this.repaint();
    }

    public void subtractValue(int v) {
        this.intValue -= v;
        this.repaint();
    }

    public void setIntValue(int v) {
        this.intValue = v;
        this.repaint();
    }

    public int getIntValue() {
        return this.intValue;
    }

    public void setBoolValue(boolean v) {
        this.boolValue = v;
        this.repaint();
    }

    public boolean getBoolValue() {
        return this.boolValue;
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent evt) {
        if (this.interactive) {
            switch (this.kind) {
                case 1: 
                case 2: {
                    this.boolValue = !this.boolValue;
                    break;
                }
                case 0: {
                    ++this.intValue;
                    break;
                }
                case 3: {
                    if (this.intValue >= this.upperBound) break;
                    ++this.intValue;
                    break;
                }
                case 4: {
                    if (this.intValue <= this.lowerBound) break;
                    --this.intValue;
                }
            }
            this.repaint();
        }
    }
}

