/*
 * Decompiled with CFR 0.152.
 */
package soc.client;

import java.applet.Applet;
import java.applet.AppletContext;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import soc.disableDebug.D;
import soc.message.SOCChannels;
import soc.message.SOCCreateAccount;
import soc.message.SOCMessage;
import soc.message.SOCRejectConnection;
import soc.message.SOCStatusMessage;
import soc.util.Version;

public class SOCAccountClient
extends Applet
implements Runnable,
ActionListener {
    private static final String MAIN_PANEL = "main";
    private static final String MESSAGE_PANEL = "message";
    protected TextField nick;
    protected TextField pass;
    protected TextField pass2;
    protected TextField email;
    protected TextField status;
    protected Button submit;
    protected Label messageLabel;
    protected AppletContext ac;
    protected boolean submitLock;
    protected CardLayout cardLayout;
    protected String host;
    protected int port;
    protected Socket s;
    protected DataInputStream in;
    protected DataOutputStream out;
    protected Thread reader = null;
    protected Exception ex = null;
    protected boolean connected = false;
    protected String nickname = null;
    protected String password = null;
    protected String password2 = null;
    protected String emailAddress = null;

    public SOCAccountClient() {
        this(null, 8880);
    }

    public SOCAccountClient(String h, int p) {
        this.host = h;
        this.port = p;
    }

    protected void initVisualElements() {
        this.setFont(new Font("Monaco", 0, 12));
        this.nick = new TextField(20);
        this.pass = new TextField(10);
        this.pass.setEchoChar('*');
        this.pass2 = new TextField(10);
        this.pass2.setEchoChar('*');
        this.email = new TextField(50);
        this.status = new TextField(50);
        this.status.setEditable(false);
        this.submit = new Button("Create Account");
        this.submitLock = false;
        this.submit.addActionListener(this);
        this.ac = null;
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        Panel mainPane = new Panel(gbl);
        c.fill = 1;
        Label l = new Label("Your Nickname:");
        c.gridwidth = 1;
        gbl.setConstraints(l, c);
        mainPane.add(l);
        c.gridwidth = 0;
        gbl.setConstraints(this.nick, c);
        mainPane.add(this.nick);
        l = new Label();
        c.gridwidth = 0;
        gbl.setConstraints(l, c);
        mainPane.add(l);
        l = new Label("Password:");
        c.gridwidth = 1;
        gbl.setConstraints(l, c);
        mainPane.add(l);
        c.gridwidth = 0;
        gbl.setConstraints(this.pass, c);
        mainPane.add(this.pass);
        l = new Label();
        c.gridwidth = 0;
        gbl.setConstraints(l, c);
        mainPane.add(l);
        l = new Label("Password (again):");
        c.gridwidth = 1;
        gbl.setConstraints(l, c);
        mainPane.add(l);
        c.gridwidth = 0;
        gbl.setConstraints(this.pass2, c);
        mainPane.add(this.pass2);
        l = new Label();
        c.gridwidth = 0;
        gbl.setConstraints(l, c);
        mainPane.add(l);
        l = new Label("Email (optional):");
        c.gridwidth = 1;
        gbl.setConstraints(l, c);
        mainPane.add(l);
        c.gridwidth = 0;
        gbl.setConstraints(this.email, c);
        mainPane.add(this.email);
        l = new Label();
        c.gridwidth = 0;
        gbl.setConstraints(l, c);
        mainPane.add(l);
        l = new Label();
        c.gridwidth = 1;
        gbl.setConstraints(l, c);
        mainPane.add(l);
        c.gridwidth = 0;
        gbl.setConstraints(this.submit, c);
        mainPane.add(this.submit);
        l = new Label();
        c.gridwidth = 0;
        gbl.setConstraints(l, c);
        mainPane.add(l);
        c.gridwidth = 0;
        gbl.setConstraints(this.status, c);
        mainPane.add(this.status);
        this.messageLabel = new Label("", 1);
        Panel messagePane = new Panel(new BorderLayout());
        messagePane.add((Component)this.messageLabel, "Center");
        this.cardLayout = new CardLayout();
        this.setLayout(this.cardLayout);
        this.add((Component)messagePane, MESSAGE_PANEL);
        this.add((Component)mainPane, MAIN_PANEL);
    }

    public int getHexParameter(String name) {
        String value = null;
        int iValue = -1;
        try {
            value = this.getParameter(name);
            if (value != null) {
                iValue = Integer.parseInt(value, 16);
            }
        }
        catch (Exception e) {
            System.err.println("Invalid " + name + ": " + value);
        }
        return iValue;
    }

    @Override
    public synchronized void init() {
        System.out.println("Java Settlers Account Client " + Version.version() + ", " + Version.copyright());
        System.out.println("Network layer based on code by Cristian Bogdan.");
        String param = null;
        int intValue = this.getHexParameter("background");
        if (intValue != -1) {
            this.setBackground(new Color(intValue));
        }
        if ((intValue = this.getHexParameter("foreground")) != -1) {
            this.setForeground(new Color(intValue));
        }
        this.initVisualElements();
        System.out.println("Getting host...");
        this.host = this.getCodeBase().getHost();
        if (this.host.equals("")) {
            this.host = null;
        }
        try {
            param = this.getParameter("PORT");
            if (param != null) {
                this.port = Integer.parseInt(param);
            }
        }
        catch (Exception e) {
            System.err.println("Invalid port: " + param);
        }
        this.connect();
    }

    public synchronized void connect() {
        String hostString = (this.host != null ? this.host : "localhost") + ":" + this.port;
        if (this.connected) {
            throw new IllegalStateException("Already connected to " + hostString);
        }
        System.out.println("Connecting to " + hostString);
        this.messageLabel.setText("Connecting to server...");
        try {
            this.s = new Socket(this.host, this.port);
            this.in = new DataInputStream(this.s.getInputStream());
            this.out = new DataOutputStream(this.s.getOutputStream());
            this.connected = true;
            this.reader = new Thread(this);
            this.reader.start();
        }
        catch (Exception e) {
            this.ex = e;
            String msg = "Could not connect to the server: " + this.ex;
            System.err.println(msg);
            this.messageLabel.setText(msg);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object target = e.getSource();
        if (target == this.submit) {
            String n = this.nick.getText().trim();
            this.nickname = n.length() > 20 ? n.substring(1, 20) : n;
            String p1 = this.pass.getText().trim();
            this.password = p1.length() > 20 ? p1.substring(1, 20) : p1;
            String p2 = this.pass2.getText().trim();
            this.password2 = p2.length() > 20 ? p2.substring(1, 20) : p2;
            this.emailAddress = this.email.getText().trim();
            if (this.nickname.length() == 0) {
                this.status.setText("You must enter a nickname.");
                this.nick.requestFocus();
            } else if (this.password.length() == 0) {
                this.status.setText("You must enter a password.");
                this.pass.requestFocus();
            } else if (!this.password.equals(this.password2)) {
                this.pass.requestFocus();
                this.status.setText("Your passwords don't match.");
            } else if (!this.submitLock) {
                this.submitLock = true;
                this.status.setText("Creating account ...");
                this.put(SOCCreateAccount.toCmd(this.nickname, this.password, this.host, this.emailAddress));
            }
        }
    }

    @Override
    public void run() {
        block3: {
            try {
                while (this.connected) {
                    String s = this.in.readUTF();
                    this.treat(SOCMessage.toMsg(s));
                }
            }
            catch (IOException e) {
                if (!this.connected) break block3;
                this.ex = e;
                System.out.println("could not read from the net: " + this.ex);
                this.destroy();
            }
        }
    }

    public synchronized boolean put(String s) {
        D.ebugPrintln("OUT - " + s);
        if (this.ex != null || !this.connected) {
            return false;
        }
        try {
            this.out.writeUTF(s);
        }
        catch (IOException e) {
            this.ex = e;
            System.err.println("could not write to the net: " + this.ex);
            this.destroy();
            return false;
        }
        return true;
    }

    public void treat(SOCMessage mes) {
        D.ebugPrintln(mes.toString());
        try {
            switch (mes.getType()) {
                case 1003: {
                    this.handleCHANNELS((SOCChannels)mes);
                    break;
                }
                case 1069: {
                    this.handleSTATUSMESSAGE((SOCStatusMessage)mes);
                    break;
                }
                case 1059: {
                    this.handleREJECTCONNECTION((SOCRejectConnection)mes);
                }
            }
        }
        catch (Exception e) {
            System.out.println("SOCAccountClient treat ERROR - " + e.getMessage());
            e.printStackTrace();
        }
    }

    protected void handleCHANNELS(SOCChannels mes) {
        this.cardLayout.show(this, MAIN_PANEL);
        this.validate();
    }

    protected void handleREJECTCONNECTION(SOCRejectConnection mes) {
        this.disconnect();
        this.messageLabel.setText(mes.getText());
        this.cardLayout.show(this, MESSAGE_PANEL);
        this.validate();
    }

    protected void handleSTATUSMESSAGE(SOCStatusMessage mes) {
        this.status.setText(mes.getStatus());
        this.submitLock = false;
    }

    protected synchronized void disconnect() {
        this.connected = false;
        try {
            this.s.close();
        }
        catch (Exception e) {
            this.ex = e;
        }
    }

    @Override
    public String getAppletInfo() {
        return "SOCAccountClient 0.1 by Robert S. Thomas.";
    }

    @Override
    public void destroy() {
        String err = "Sorry, the applet has been destroyed. " + (this.ex == null ? "Load the page again." : this.ex.toString());
        this.disconnect();
        this.messageLabel.setText(err);
        this.cardLayout.show(this, MESSAGE_PANEL);
        this.validate();
    }

    public static void usage() {
        System.err.println("usage: java soc.client.SOCAccountClient <host> <port>");
    }

    public static void main(String[] args) {
        SOCAccountClient client = new SOCAccountClient();
        if (args.length != 2) {
            SOCAccountClient.usage();
            System.exit(1);
        }
        try {
            client.host = args[0];
            client.port = Integer.parseInt(args[1]);
        }
        catch (NumberFormatException x) {
            SOCAccountClient.usage();
            System.err.println("Invalid port: " + args[1]);
            System.exit(1);
        }
        Frame frame = new Frame("SOCAccountClient");
        frame.setBackground(new Color(Integer.parseInt("61AF71", 16)));
        frame.setForeground(Color.black);
        frame.addWindowListener(client.createWindowAdapter());
        client.initVisualElements();
        frame.add((Component)client, "Center");
        frame.setSize(600, 350);
        frame.setVisible(true);
        client.connect();
    }

    private WindowAdapter createWindowAdapter() {
        return new MyWindowAdapter();
    }

    private class MyWindowAdapter
    extends WindowAdapter {
        private MyWindowAdapter() {
        }

        @Override
        public void windowClosing(WindowEvent evt) {
            System.exit(0);
        }

        @Override
        public void windowOpened(WindowEvent evt) {
            SOCAccountClient.this.nick.requestFocus();
        }
    }
}

