/*
 * Decompiled with CFR 0.152.
 */
package soc.client;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Enumeration;
import soc.client.SOCPlayerClient;
import soc.client.SOCPlayerInterface;
import soc.game.SOCBoard;
import soc.game.SOCCity;
import soc.game.SOCGame;
import soc.game.SOCPlayer;
import soc.game.SOCRoad;
import soc.game.SOCSettlement;

public class SOCBoardPanel
extends Canvas
implements MouseListener,
MouseMotionListener {
    private static String IMAGEDIR = "/soc/client/images";
    public static final int panelx = 253;
    public static final int panely = 222;
    private static final int[] hexX = new int[]{54, 90, 126, 162, 36, 72, 108, 144, 180, 18, 54, 90, 126, 162, 198, 0, 36, 72, 108, 144, 180, 216, 18, 54, 90, 126, 162, 198, 36, 72, 108, 144, 180, 54, 90, 126, 162};
    private static final int[] hexY = new int[]{0, 0, 0, 0, 30, 30, 30, 30, 30, 60, 60, 60, 60, 60, 60, 90, 90, 90, 90, 90, 90, 90, 120, 120, 120, 120, 120, 120, 150, 150, 150, 150, 150, 180, 180, 180, 180};
    private static final int[] vertRoadX = new int[]{-2, 3, 3, -2, -2};
    private static final int[] vertRoadY = new int[]{11, 11, 31, 31, 11};
    private static final int[] upRoadX = new int[]{-1, 17, 20, 2, -1};
    private static final int[] upRoadY = new int[]{9, -2, 2, 13, 9};
    private static final int[] downRoadX = new int[]{-1, 2, 20, 17, -1};
    private static final int[] downRoadY = new int[]{33, 29, 40, 44, 33};
    private static final int[] settlementX = new int[]{-6, 0, 6, 6, -6, -6, 6};
    private static final int[] settlementY = new int[]{-6, -12, -6, 4, 4, -6, -6};
    private static final int[] cityX = new int[]{-8, -4, 0, 4, 8, 8, -8, -8, 0, 0, 8, 4, -8};
    private static final int[] cityY = new int[]{-6, -12, -6, -6, -2, 4, 4, -6, -6, -2, -2, -6, -6};
    private static final int[] robberX = new int[]{6, 4, 4, 6, 10, 12, 12, 10, 12, 12, 4, 4, 6, 10};
    private static final int[] robberY = new int[]{6, 4, 2, 0, 0, 2, 4, 6, 8, 16, 16, 8, 6, 6};
    public static final int NONE = 0;
    public static final int PLACE_ROAD = 1;
    public static final int PLACE_SETTLEMENT = 2;
    public static final int PLACE_CITY = 3;
    public static final int PLACE_ROBBER = 4;
    public static final int PLACE_INIT_SETTLEMENT = 5;
    public static final int PLACE_INIT_ROAD = 6;
    public static final int CONSIDER_LM_SETTLEMENT = 7;
    public static final int CONSIDER_LM_ROAD = 8;
    public static final int CONSIDER_LM_CITY = 9;
    public static final int CONSIDER_LT_SETTLEMENT = 10;
    public static final int CONSIDER_LT_ROAD = 11;
    public static final int CONSIDER_LT_CITY = 12;
    private int HEXWIDTH = 37;
    private int HEXHEIGHT = 42;
    private int[] hexIDtoNum;
    private static Image[] hexes;
    private static Image[] ports;
    private static Image[] numbers;
    private static Image arrowR;
    private static Image arrowL;
    private static Image[] dice;
    private int ptrOldX;
    private int ptrOldY;
    private int hilight;
    private int[] edgeMap;
    private int[] nodeMap;
    private int[] hexMap;
    private SOCGame game;
    private SOCBoard board;
    private SOCPlayer player;
    private SOCPlayer otherPlayer;
    private Image buffer;
    private int mode;
    private int initstlmt;
    private SOCPlayerInterface playerInterface;

    public SOCBoardPanel(SOCPlayerInterface pi) {
        int i;
        this.game = pi.getGame();
        this.playerInterface = pi;
        this.player = null;
        this.board = this.game.getBoard();
        this.ptrOldX = 0;
        this.ptrOldY = 0;
        this.hilight = 0;
        this.edgeMap = new int[345];
        for (i = 0; i < 345; ++i) {
            this.edgeMap[i] = 0;
        }
        this.initEdgeMapAux(4, 3, 9, 6, 55);
        this.initEdgeMapAux(3, 6, 10, 9, 53);
        this.initEdgeMapAux(2, 9, 11, 12, 51);
        this.initEdgeMapAux(3, 12, 10, 15, 83);
        this.initEdgeMapAux(4, 15, 9, 18, 115);
        this.nodeMap = new int[345];
        for (i = 0; i < 345; ++i) {
            this.nodeMap[i] = 0;
        }
        this.initNodeMapAux(4, 3, 10, 7, 55);
        this.initNodeMapAux(3, 6, 11, 10, 53);
        this.initNodeMapAux(2, 9, 12, 13, 51);
        this.initNodeMapAux(3, 12, 11, 16, 83);
        this.initNodeMapAux(4, 15, 10, 19, 115);
        this.hexMap = new int[345];
        for (i = 0; i < 345; ++i) {
            this.hexMap[i] = 0;
        }
        this.initHexMapAux(4, 4, 9, 5, 55);
        this.initHexMapAux(3, 7, 10, 8, 53);
        this.initHexMapAux(2, 10, 11, 11, 51);
        this.initHexMapAux(3, 13, 10, 14, 83);
        this.initHexMapAux(4, 16, 9, 17, 115);
        this.hexIDtoNum = new int[222];
        for (i = 0; i < 222; ++i) {
            this.hexIDtoNum[i] = 0;
        }
        this.initHexIDtoNumAux(23, 125, 0);
        this.initHexIDtoNumAux(21, 157, 4);
        this.initHexIDtoNumAux(19, 189, 9);
        this.initHexIDtoNumAux(17, 221, 15);
        this.initHexIDtoNumAux(49, 219, 22);
        this.initHexIDtoNumAux(81, 217, 28);
        this.initHexIDtoNumAux(113, 215, 33);
        this.mode = 0;
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        SOCBoardPanel.loadImages(this);
    }

    private final void initEdgeMapAux(int x1, int y1, int x2, int y2, int startHex) {
        int facing = 0;
        int count = 0;
        int edgeNum = 0;
        for (int y = y1; y <= y2; ++y) {
            int hexNum = startHex;
            switch (count) {
                case 0: {
                    facing = 6;
                    edgeNum = hexNum - 16;
                    break;
                }
                case 1: {
                    facing = 5;
                    edgeNum = hexNum - 17;
                    break;
                }
                case 2: {
                    facing = 5;
                    edgeNum = hexNum - 17;
                    break;
                }
                case 3: {
                    facing = 4;
                    edgeNum = hexNum - 1;
                    break;
                }
                default: {
                    System.out.println("initEdgeMap error");
                    return;
                }
            }
            block15: for (int x = x1; x <= x2; ++x) {
                this.edgeMap[x + y * 15] = edgeNum;
                switch (facing) {
                    case 1: {
                        facing = 6;
                        edgeNum = (hexNum += 34) - 16;
                        continue block15;
                    }
                    case 2: {
                        facing = 5;
                        edgeNum = (hexNum += 34) - 17;
                        continue block15;
                    }
                    case 3: {
                        facing = 4;
                        edgeNum = (hexNum += 34) - 1;
                        continue block15;
                    }
                    case 4: {
                        facing = 3;
                        edgeNum = hexNum + 16;
                        continue block15;
                    }
                    case 5: {
                        facing = 2;
                        edgeNum = hexNum + 17;
                        continue block15;
                    }
                    case 6: {
                        facing = 1;
                        edgeNum = hexNum + 1;
                        continue block15;
                    }
                    default: {
                        System.out.println("initEdgeMap error");
                        return;
                    }
                }
            }
            ++count;
        }
    }

    private final void initHexMapAux(int x1, int y1, int x2, int y2, int startHex) {
        int count = 0;
        for (int y = y1; y <= y2; ++y) {
            int hexNum = startHex;
            for (int x = x1; x <= x2; ++x) {
                this.hexMap[x + y * 15] = hexNum;
                if (count % 2 != 0) {
                    hexNum += 34;
                }
                ++count;
            }
        }
    }

    private final void initNodeMapAux(int x1, int y1, int x2, int y2, int startHex) {
        int facing = 0;
        int count = 0;
        int edgeNum = 0;
        for (int y = y1; y <= y2; ++y) {
            int hexNum = startHex;
            switch (count) {
                case 0: {
                    facing = -1;
                    edgeNum = 0;
                    break;
                }
                case 1: {
                    facing = 6;
                    edgeNum = hexNum - 16;
                    break;
                }
                case 2: {
                    facing = -7;
                    edgeNum = 0;
                    break;
                }
                case 3: {
                    facing = 5;
                    edgeNum = hexNum - 1;
                    break;
                }
                case 4: {
                    facing = -4;
                    edgeNum = 0;
                    break;
                }
                default: {
                    System.out.println("initNodeMap error");
                    return;
                }
            }
            block21: for (int x = x1; x <= x2; ++x) {
                this.nodeMap[x + y * 15] = edgeNum;
                switch (facing) {
                    case 1: {
                        facing = -1;
                        hexNum += 34;
                        edgeNum = 0;
                        continue block21;
                    }
                    case -1: {
                        facing = 1;
                        edgeNum = hexNum + 1;
                        continue block21;
                    }
                    case 2: {
                        facing = -2;
                        hexNum += 34;
                        edgeNum = 0;
                        continue block21;
                    }
                    case -2: {
                        facing = 2;
                        edgeNum = hexNum + 18;
                        continue block21;
                    }
                    case 6: {
                        facing = -2;
                        edgeNum = 0;
                        continue block21;
                    }
                    case -7: {
                        edgeNum = 0;
                        continue block21;
                    }
                    case 5: {
                        facing = -3;
                        edgeNum = 0;
                        continue block21;
                    }
                    case 3: {
                        facing = -3;
                        hexNum += 34;
                        edgeNum = 0;
                        continue block21;
                    }
                    case -3: {
                        facing = 3;
                        edgeNum = hexNum + 33;
                        continue block21;
                    }
                    case 4: {
                        facing = -4;
                        hexNum += 34;
                        edgeNum = 0;
                        continue block21;
                    }
                    case -4: {
                        facing = 4;
                        edgeNum = hexNum + 16;
                        continue block21;
                    }
                    default: {
                        System.out.println("initNodeMap error");
                        return;
                    }
                }
            }
            ++count;
        }
    }

    private final void initHexIDtoNumAux(int begin, int end, int num) {
        for (int i = begin; i <= end; i += 34) {
            this.hexIDtoNum[i] = num++;
        }
    }

    public Dimension getPreferedSize() {
        return new Dimension(253, 222);
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(253, 222);
    }

    @Override
    public void paint(Graphics g) {
        if (this.buffer == null) {
            this.buffer = this.createImage(253, 222);
        }
        this.drawBoard(this.buffer.getGraphics());
        this.buffer.flush();
        g.drawImage(this.buffer, 0, 0, this);
    }

    @Override
    public void update(Graphics g) {
        this.paint(g);
    }

    private final void drawHex(Graphics g, int hexNum) {
        int[] hexLayout = this.board.getHexLayout();
        int[] numberLayout = this.board.getNumberLayout();
        int hexType = hexLayout[hexNum];
        int tmp = hexType & 0xF;
        g.drawImage(hexes[tmp], hexX[hexNum], hexY[hexNum], this);
        tmp = hexType >> 4;
        if (tmp > 0) {
            g.drawImage(ports[tmp], hexX[hexNum], hexY[hexNum], this);
        }
        if (numberLayout[hexNum] >= 0) {
            g.drawImage(numbers[numberLayout[hexNum]], hexX[hexNum] + 9, hexY[hexNum] + 12, this);
        }
    }

    private final void drawRobber(Graphics g, int hexID) {
        int[] tmpX = new int[14];
        int[] tmpY = new int[14];
        int hexNum = this.hexIDtoNum[hexID];
        for (int i = 0; i < 14; ++i) {
            tmpX[i] = robberX[i] + hexX[hexNum] + 18;
            tmpY[i] = robberY[i] + hexY[hexNum] + 12;
        }
        g.setColor(Color.lightGray);
        g.fillPolygon(tmpX, tmpY, 13);
        g.setColor(Color.black);
        g.drawPolygon(tmpX, tmpY, 14);
    }

    private final void drawRoad(Graphics g, int edgeNum, int pn) {
        int[] tmpX = new int[5];
        int[] tmpY = new int[5];
        if (((edgeNum & 0xF) + (edgeNum >> 4)) % 2 == 0) {
            int hexNum = this.hexIDtoNum[edgeNum + 17];
            for (int i = 0; i < 5; ++i) {
                tmpX[i] = vertRoadX[i] + hexX[hexNum];
                tmpY[i] = vertRoadY[i] + hexY[hexNum];
            }
        } else if ((edgeNum >> 4) % 2 == 0) {
            int hexNum = this.hexIDtoNum[edgeNum + 16];
            hexNum = this.hexIDtoNum[edgeNum + 16];
            for (int i = 0; i < 5; ++i) {
                tmpX[i] = upRoadX[i] + hexX[hexNum];
                tmpY[i] = upRoadY[i] + hexY[hexNum];
            }
        } else {
            int hexNum = this.hexIDtoNum[edgeNum + 1];
            for (int i = 0; i < 5; ++i) {
                tmpX[i] = downRoadX[i] + hexX[hexNum];
                tmpY[i] = downRoadY[i] + hexY[hexNum];
            }
        }
        g.setColor(this.playerInterface.getPlayerColor(pn));
        g.fillPolygon(tmpX, tmpY, 5);
        g.setColor(Color.black);
        g.drawPolygon(tmpX, tmpY, 5);
    }

    private final void drawSettlement(Graphics g, int nodeNum, int pn) {
        int[] tmpX = new int[7];
        int[] tmpY = new int[7];
        if ((nodeNum >> 4) % 2 == 0) {
            int hexNum = this.hexIDtoNum[nodeNum + 16];
            for (int i = 0; i < 7; ++i) {
                tmpX[i] = settlementX[i] + hexX[hexNum];
                tmpY[i] = settlementY[i] + hexY[hexNum] + 11;
            }
        } else {
            int hexNum = this.hexIDtoNum[nodeNum - 1];
            for (int i = 0; i < 7; ++i) {
                tmpX[i] = settlementX[i] + hexX[hexNum] + 18;
                tmpY[i] = settlementY[i] + hexY[hexNum] + 2;
            }
        }
        g.setColor(this.playerInterface.getPlayerColor(pn));
        g.fillPolygon(tmpX, tmpY, 6);
        g.setColor(Color.black);
        g.drawPolygon(tmpX, tmpY, 7);
    }

    private final void drawCity(Graphics g, int nodeNum, int pn) {
        int[] tmpX = new int[13];
        int[] tmpY = new int[13];
        if ((nodeNum >> 4) % 2 == 0) {
            int hexNum = this.hexIDtoNum[nodeNum + 16];
            for (int i = 0; i < 13; ++i) {
                tmpX[i] = cityX[i] + hexX[hexNum];
                tmpY[i] = cityY[i] + hexY[hexNum] + 11;
            }
        } else {
            int hexNum = this.hexIDtoNum[nodeNum - 1];
            for (int i = 0; i < 13; ++i) {
                tmpX[i] = cityX[i] + hexX[hexNum] + 18;
                tmpY[i] = cityY[i] + hexY[hexNum] + 2;
            }
        }
        g.setColor(this.playerInterface.getPlayerColor(pn));
        g.fillPolygon(tmpX, tmpY, 8);
        g.setColor(Color.black);
        g.drawPolygon(tmpX, tmpY, 13);
    }

    private final void drawArrow(Graphics g, int pnum, int diceResult) {
        switch (pnum) {
            case 0: {
                g.drawImage(arrowL, 3, 5, this);
                if (diceResult < 2 || this.game.getGameState() == 15) break;
                g.drawImage(dice[diceResult], 13, 10, this);
                break;
            }
            case 1: {
                g.drawImage(arrowR, 213, 5, this);
                if (diceResult < 2 || this.game.getGameState() == 15) break;
                g.drawImage(dice[diceResult], 213, 10, this);
                break;
            }
            case 2: {
                g.drawImage(arrowR, 213, 180, this);
                if (diceResult < 2 || this.game.getGameState() == 15) break;
                g.drawImage(dice[diceResult], 213, 185, this);
                break;
            }
            case 3: {
                g.drawImage(arrowL, 3, 180, this);
                if (diceResult < 2 || this.game.getGameState() == 15) break;
                g.drawImage(dice[diceResult], 13, 185, this);
            }
        }
    }

    private void drawBoard(Graphics g) {
        int gameState;
        g.setPaintMode();
        g.setColor(this.getBackground());
        g.fillRect(0, 0, 253, 222);
        for (int i = 0; i < 37; ++i) {
            this.drawHex(g, i);
        }
        if (this.mode != 4 && this.board.getRobberHex() != -1) {
            this.drawRobber(g, this.board.getRobberHex());
        }
        if ((gameState = this.game.getGameState()) != 0) {
            this.drawArrow(g, this.game.getCurrentPlayerNumber(), this.game.getCurrentDice());
        }
        Enumeration roads = this.board.getRoads().elements();
        while (roads.hasMoreElements()) {
            SOCRoad r = (SOCRoad)roads.nextElement();
            this.drawRoad(g, r.getCoordinates(), r.getPlayer().getPlayerNumber());
        }
        Enumeration settlements = this.board.getSettlements().elements();
        while (settlements.hasMoreElements()) {
            SOCSettlement s = (SOCSettlement)settlements.nextElement();
            this.drawSettlement(g, s.getCoordinates(), s.getPlayer().getPlayerNumber());
        }
        Enumeration cities = this.board.getCities().elements();
        while (cities.hasMoreElements()) {
            SOCCity c = (SOCCity)cities.nextElement();
            this.drawCity(g, c.getCoordinates(), c.getPlayer().getPlayerNumber());
        }
        switch (this.mode) {
            case 1: 
            case 6: {
                if (this.hilight <= 0) break;
                this.drawRoad(g, this.hilight, this.player.getPlayerNumber());
                break;
            }
            case 2: 
            case 5: {
                if (this.hilight <= 0) break;
                this.drawSettlement(g, this.hilight, this.player.getPlayerNumber());
                break;
            }
            case 3: {
                if (this.hilight <= 0) break;
                this.drawCity(g, this.hilight, this.player.getPlayerNumber());
                break;
            }
            case 7: 
            case 10: {
                if (this.hilight <= 0) break;
                this.drawSettlement(g, this.hilight, this.otherPlayer.getPlayerNumber());
                break;
            }
            case 8: 
            case 11: {
                if (this.hilight <= 0) break;
                this.drawRoad(g, this.hilight, this.otherPlayer.getPlayerNumber());
                break;
            }
            case 9: 
            case 12: {
                if (this.hilight <= 0) break;
                this.drawCity(g, this.hilight, this.otherPlayer.getPlayerNumber());
                break;
            }
            case 4: {
                if (this.hilight <= 0) break;
                this.drawRobber(g, this.hilight);
            }
        }
    }

    public void updateMode() {
        if (this.player != null) {
            if (this.game.getCurrentPlayerNumber() == this.player.getPlayerNumber()) {
                switch (this.game.getGameState()) {
                    case 5: 
                    case 10: {
                        this.mode = 5;
                        break;
                    }
                    case 6: 
                    case 11: {
                        this.mode = 6;
                        break;
                    }
                    case 30: 
                    case 40: 
                    case 41: {
                        this.mode = 1;
                        break;
                    }
                    case 31: {
                        this.mode = 2;
                        break;
                    }
                    case 32: {
                        this.mode = 3;
                        break;
                    }
                    case 33: {
                        this.mode = 4;
                        break;
                    }
                    default: {
                        this.mode = 0;
                        break;
                    }
                }
            } else {
                this.mode = 0;
            }
        } else {
            this.mode = 0;
        }
    }

    public void setPlayer() {
        this.player = this.game.getPlayer(this.playerInterface.getClient().getNickname());
    }

    public void setOtherPlayer(SOCPlayer op) {
        this.otherPlayer = op;
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
        if (this.mode != 0) {
            this.hilight = 0;
            this.repaint();
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        switch (this.mode) {
            case 0: {
                break;
            }
            case 6: {
                int edgeNum = 0;
                if (this.ptrOldX == x && this.ptrOldY == y) break;
                this.ptrOldX = x;
                this.ptrOldY = y;
                edgeNum = this.findEdge(x, y);
                if (!this.player.isPotentialRoad(edgeNum) || edgeNum != this.initstlmt && edgeNum != this.initstlmt - 17 && edgeNum != this.initstlmt - 1 && edgeNum != this.initstlmt - 16) {
                    edgeNum = 0;
                }
                if (this.hilight == edgeNum) break;
                this.hilight = edgeNum;
                this.repaint();
                break;
            }
            case 1: {
                int edgeNum = 0;
                if (this.ptrOldX == x && this.ptrOldY == y) break;
                this.ptrOldX = x;
                this.ptrOldY = y;
                edgeNum = this.findEdge(x, y);
                if (!this.player.isPotentialRoad(edgeNum)) {
                    edgeNum = 0;
                }
                if (this.hilight == edgeNum) break;
                this.hilight = edgeNum;
                this.repaint();
                break;
            }
            case 2: 
            case 5: {
                int nodeNum = 0;
                if (this.ptrOldX == x && this.ptrOldY == y) break;
                this.ptrOldX = x;
                this.ptrOldY = y;
                nodeNum = this.findNode(x, y);
                if (!this.player.isPotentialSettlement(nodeNum)) {
                    nodeNum = 0;
                }
                if (this.hilight == nodeNum) break;
                this.hilight = nodeNum;
                this.repaint();
                break;
            }
            case 3: {
                int nodeNum = 0;
                if (this.ptrOldX == x && this.ptrOldY == y) break;
                this.ptrOldX = x;
                this.ptrOldY = y;
                nodeNum = this.findNode(x, y);
                if (!this.player.isPotentialCity(nodeNum)) {
                    nodeNum = 0;
                }
                if (this.hilight == nodeNum) break;
                this.hilight = nodeNum;
                this.repaint();
                break;
            }
            case 4: {
                int hexNum = 0;
                if (this.ptrOldX == x && this.ptrOldY == y) break;
                this.ptrOldX = x;
                this.ptrOldY = y;
                hexNum = this.findHex(x, y);
                if (hexNum == this.board.getRobberHex()) {
                    hexNum = 0;
                }
                if (this.hilight == hexNum) break;
                this.hilight = hexNum;
                this.repaint();
                break;
            }
            case 7: 
            case 10: {
                int nodeNum = 0;
                if (this.ptrOldX == x && this.ptrOldY == y) break;
                this.ptrOldX = x;
                this.ptrOldY = y;
                nodeNum = this.findNode(x, y);
                if (this.hilight == nodeNum) break;
                this.hilight = nodeNum;
                this.repaint();
                break;
            }
            case 8: 
            case 11: {
                int edgeNum = 0;
                if (this.ptrOldX == x && this.ptrOldY == y) break;
                this.ptrOldX = x;
                this.ptrOldY = y;
                edgeNum = this.findEdge(x, y);
                if (!this.otherPlayer.isPotentialRoad(edgeNum)) {
                    edgeNum = 0;
                }
                if (this.hilight == edgeNum) break;
                this.hilight = edgeNum;
                this.repaint();
                break;
            }
            case 9: 
            case 12: {
                int nodeNum = 0;
                if (this.ptrOldX == x && this.ptrOldY == y) break;
                this.ptrOldX = x;
                this.ptrOldY = y;
                nodeNum = this.findNode(x, y);
                if (!this.otherPlayer.isPotentialCity(nodeNum)) {
                    nodeNum = 0;
                }
                if (this.hilight == nodeNum) break;
                this.hilight = nodeNum;
                this.repaint();
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent evt) {
        int x = evt.getX();
        int y = evt.getY();
        if (this.hilight > 0) {
            SOCPlayerClient client = this.playerInterface.getClient();
            switch (this.mode) {
                case 0: {
                    break;
                }
                case 1: 
                case 6: {
                    if (!this.player.isPotentialRoad(this.hilight)) break;
                    client.putPiece(this.game, new SOCRoad(this.player, this.hilight));
                    break;
                }
                case 5: {
                    this.initstlmt = this.hilight;
                    if (!this.player.isPotentialSettlement(this.hilight)) break;
                    client.putPiece(this.game, new SOCSettlement(this.player, this.hilight));
                    break;
                }
                case 2: {
                    if (!this.player.isPotentialSettlement(this.hilight)) break;
                    client.putPiece(this.game, new SOCSettlement(this.player, this.hilight));
                    break;
                }
                case 3: {
                    if (!this.player.isPotentialCity(this.hilight)) break;
                    client.putPiece(this.game, new SOCCity(this.player, this.hilight));
                    break;
                }
                case 4: {
                    if (this.hilight == this.board.getRobberHex()) break;
                    client.moveRobber(this.game, this.player, this.hilight);
                    break;
                }
                case 7: {
                    if (!this.otherPlayer.isPotentialSettlement(this.hilight)) break;
                    client.considerMove(this.game, this.otherPlayer.getName(), new SOCSettlement(this.otherPlayer, this.hilight));
                    break;
                }
                case 8: {
                    if (!this.otherPlayer.isPotentialRoad(this.hilight)) break;
                    client.considerMove(this.game, this.otherPlayer.getName(), new SOCRoad(this.otherPlayer, this.hilight));
                    break;
                }
                case 9: {
                    if (!this.otherPlayer.isPotentialCity(this.hilight)) break;
                    client.considerMove(this.game, this.otherPlayer.getName(), new SOCCity(this.otherPlayer, this.hilight));
                    break;
                }
                case 10: {
                    if (!this.otherPlayer.isPotentialSettlement(this.hilight)) break;
                    client.considerTarget(this.game, this.otherPlayer.getName(), new SOCSettlement(this.otherPlayer, this.hilight));
                    break;
                }
                case 11: {
                    if (!this.otherPlayer.isPotentialRoad(this.hilight)) break;
                    client.considerTarget(this.game, this.otherPlayer.getName(), new SOCRoad(this.otherPlayer, this.hilight));
                    break;
                }
                case 12: {
                    if (!this.otherPlayer.isPotentialCity(this.hilight)) break;
                    client.considerTarget(this.game, this.otherPlayer.getName(), new SOCCity(this.otherPlayer, this.hilight));
                }
            }
            this.mode = 0;
            this.hilight = 0;
        }
    }

    private final int findEdge(int x, int y) {
        int sector = x / 18 + y / 10 * 15;
        return this.edgeMap[sector];
    }

    private final int findNode(int x, int y) {
        int sector = (x + 9) / 18 + (y + 5) / 10 * 15;
        return this.nodeMap[sector];
    }

    private final int findHex(int x, int y) {
        int sector = x / 18 + y / 10 * 15;
        return this.hexMap[sector];
    }

    public void setMode(int m) {
        this.mode = m;
    }

    public int getMode() {
        return this.mode;
    }

    private static synchronized void loadImages(Component c) {
        if (hexes == null) {
            int i;
            MediaTracker tracker = new MediaTracker(c);
            Toolkit tk = c.getToolkit();
            Class<?> clazz = c.getClass();
            hexes = new Image[13];
            numbers = new Image[10];
            ports = new Image[7];
            dice = new Image[14];
            SOCBoardPanel.hexes[0] = tk.getImage(clazz.getResource(IMAGEDIR + "/desertHex.gif"));
            SOCBoardPanel.hexes[1] = tk.getImage(clazz.getResource(IMAGEDIR + "/clayHex.gif"));
            SOCBoardPanel.hexes[2] = tk.getImage(clazz.getResource(IMAGEDIR + "/oreHex.gif"));
            SOCBoardPanel.hexes[3] = tk.getImage(clazz.getResource(IMAGEDIR + "/sheepHex.gif"));
            SOCBoardPanel.hexes[4] = tk.getImage(clazz.getResource(IMAGEDIR + "/wheatHex.gif"));
            SOCBoardPanel.hexes[5] = tk.getImage(clazz.getResource(IMAGEDIR + "/woodHex.gif"));
            SOCBoardPanel.hexes[6] = tk.getImage(clazz.getResource(IMAGEDIR + "/waterHex.gif"));
            for (i = 0; i < 7; ++i) {
                tracker.addImage(hexes[i], 0);
            }
            for (i = 0; i < 6; ++i) {
                SOCBoardPanel.hexes[i + 7] = tk.getImage(clazz.getResource(IMAGEDIR + "/miscPort" + i + ".gif"));
                tracker.addImage(hexes[i + 7], 0);
            }
            for (i = 0; i < 6; ++i) {
                SOCBoardPanel.ports[i + 1] = tk.getImage(clazz.getResource(IMAGEDIR + "/port" + i + ".gif"));
                tracker.addImage(ports[i + 1], 0);
            }
            SOCBoardPanel.numbers[0] = tk.getImage(clazz.getResource(IMAGEDIR + "/two.gif"));
            SOCBoardPanel.numbers[1] = tk.getImage(clazz.getResource(IMAGEDIR + "/three.gif"));
            SOCBoardPanel.numbers[2] = tk.getImage(clazz.getResource(IMAGEDIR + "/four.gif"));
            SOCBoardPanel.numbers[3] = tk.getImage(clazz.getResource(IMAGEDIR + "/five.gif"));
            SOCBoardPanel.numbers[4] = tk.getImage(clazz.getResource(IMAGEDIR + "/six.gif"));
            SOCBoardPanel.numbers[5] = tk.getImage(clazz.getResource(IMAGEDIR + "/eight.gif"));
            SOCBoardPanel.numbers[6] = tk.getImage(clazz.getResource(IMAGEDIR + "/nine.gif"));
            SOCBoardPanel.numbers[7] = tk.getImage(clazz.getResource(IMAGEDIR + "/ten.gif"));
            SOCBoardPanel.numbers[8] = tk.getImage(clazz.getResource(IMAGEDIR + "/eleven.gif"));
            SOCBoardPanel.numbers[9] = tk.getImage(clazz.getResource(IMAGEDIR + "/twelve.gif"));
            for (i = 0; i < 10; ++i) {
                tracker.addImage(numbers[i], 0);
            }
            arrowL = tk.getImage(clazz.getResource(IMAGEDIR + "/arrowL.gif"));
            arrowR = tk.getImage(clazz.getResource(IMAGEDIR + "/arrowR.gif"));
            tracker.addImage(arrowL, 0);
            tracker.addImage(arrowR, 0);
            for (i = 2; i < 13; ++i) {
                SOCBoardPanel.dice[i] = tk.getImage(clazz.getResource(IMAGEDIR + "/dice" + i + ".gif"));
                tracker.addImage(dice[i], 0);
            }
            try {
                tracker.waitForID(0);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            if (tracker.isErrorID(0)) {
                System.out.println("Error loading board images");
            }
        }
    }

    public static int getPanelX() {
        return 253;
    }

    public static int getPanelY() {
        return 222;
    }
}

