/*
 * Decompiled with CFR 0.152.
 */
package soc.client;

import java.awt.Button;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import soc.client.ColorSquare;
import soc.client.SOCPlayerClient;
import soc.client.SOCPlayerInterface;
import soc.game.SOCGame;
import soc.game.SOCPlayer;

public class SOCBuildingPanel
extends Panel
implements ActionListener {
    static final String ROAD = "road";
    static final String STLMT = "stlmt";
    static final String CITY = "city";
    static final String CARD = "card";
    Label title;
    Button roadBut;
    Button settlementBut;
    Button cityBut;
    Button cardBut;
    Label roadT;
    Label roadV;
    Label roadC;
    ColorSquare roadWood;
    ColorSquare roadClay;
    Label settlementT;
    Label settlementV;
    Label settlementC;
    ColorSquare settlementWood;
    ColorSquare settlementClay;
    ColorSquare settlementWheat;
    ColorSquare settlementSheep;
    Label cityT;
    Label cityV;
    Label cityC;
    ColorSquare cityWheat;
    ColorSquare cityOre;
    Label cardT;
    Label cardV;
    Label cardC;
    ColorSquare cardWheat;
    ColorSquare cardSheep;
    ColorSquare cardOre;
    SOCPlayerInterface pi;

    public SOCBuildingPanel(SOCPlayerInterface pi) {
        this.setLayout(null);
        this.pi = pi;
        this.setBackground(new Color(156, 179, 94));
        this.setForeground(Color.black);
        this.setFont(new Font("Helvetica", 0, 10));
        this.roadT = new Label("Road: ");
        this.add(this.roadT);
        this.roadV = new Label("0 VP  (longest road = 2 VP) ");
        this.roadV.setAlignment(0);
        this.add(this.roadV);
        this.roadC = new Label("Cost: ");
        this.add(this.roadC);
        this.roadWood = new ColorSquare(ColorSquare.WOOD, 1);
        this.add(this.roadWood);
        this.roadClay = new ColorSquare(ColorSquare.CLAY, 1);
        this.add(this.roadClay);
        this.roadBut = new Button("---");
        this.add(this.roadBut);
        this.roadBut.setActionCommand(ROAD);
        this.roadBut.addActionListener(this);
        this.settlementT = new Label("Settlement: ");
        this.add(this.settlementT);
        this.settlementV = new Label("1 VP ");
        this.settlementV.setAlignment(0);
        this.add(this.settlementV);
        this.settlementC = new Label("Cost: ");
        this.add(this.settlementC);
        this.settlementWood = new ColorSquare(ColorSquare.WOOD, 1);
        this.add(this.settlementWood);
        this.settlementClay = new ColorSquare(ColorSquare.CLAY, 1);
        this.add(this.settlementClay);
        this.settlementWheat = new ColorSquare(ColorSquare.WHEAT, 1);
        this.add(this.settlementWheat);
        this.settlementSheep = new ColorSquare(ColorSquare.SHEEP, 1);
        this.add(this.settlementSheep);
        this.settlementBut = new Button("---");
        this.add(this.settlementBut);
        this.settlementBut.setActionCommand(STLMT);
        this.settlementBut.addActionListener(this);
        this.cityT = new Label("City Upgrade: ");
        this.add(this.cityT);
        this.cityV = new Label("2 VP  (receives 2x rsrc.) ");
        this.cityV.setAlignment(0);
        this.add(this.cityV);
        this.cityC = new Label("Cost: ");
        this.add(this.cityC);
        this.cityWheat = new ColorSquare(ColorSquare.WHEAT, 2);
        this.add(this.cityWheat);
        this.cityOre = new ColorSquare(ColorSquare.ORE, 3);
        this.add(this.cityOre);
        this.cityBut = new Button("---");
        this.add(this.cityBut);
        this.cityBut.setActionCommand(CITY);
        this.cityBut.addActionListener(this);
        this.cardT = new Label("Card: ");
        this.add(this.cardT);
        this.cardV = new Label("? VP  (largest army = 2 VP) ");
        this.cardV.setAlignment(0);
        this.add(this.cardV);
        this.cardC = new Label("Cost: ");
        this.add(this.cardC);
        this.cardWheat = new ColorSquare(ColorSquare.WHEAT, 1);
        this.add(this.cardWheat);
        this.cardSheep = new ColorSquare(ColorSquare.SHEEP, 1);
        this.add(this.cardSheep);
        this.cardOre = new ColorSquare(ColorSquare.ORE, 1);
        this.add(this.cardOre);
        this.cardBut = new Button("---");
        this.add(this.cardBut);
        this.cardBut.setActionCommand(CARD);
        this.cardBut.addActionListener(this);
    }

    @Override
    public void doLayout() {
        Dimension dim = this.getSize();
        int curY = 0;
        FontMetrics fm = this.getFontMetrics(this.getFont());
        int lineH = 16;
        int rowSpaceH = (dim.height - 8 * lineH) / 3;
        int halfLineH = lineH / 2;
        int costW = fm.stringWidth(new String("Cost: "));
        int butW = 50;
        int margin = 2;
        this.roadT.setSize(fm.stringWidth(this.roadT.getText()), lineH);
        this.roadT.setLocation(margin, curY);
        int roadVW = fm.stringWidth(this.roadV.getText());
        this.roadV.setSize(roadVW, lineH);
        this.roadV.setLocation(dim.width - (roadVW + margin), curY);
        this.roadC.setSize(costW, lineH);
        this.roadC.setLocation(margin, curY += lineH);
        int curX = 1 + costW + 3;
        this.roadWood.setSize(16, 16);
        this.roadWood.setLocation(curX, curY);
        this.roadClay.setSize(16, 16);
        this.roadClay.setLocation(curX += 19, curY);
        this.roadBut.setSize(butW, lineH);
        this.roadBut.setLocation(dim.width - (butW + margin), curY);
        this.settlementT.setSize(fm.stringWidth(this.settlementT.getText()), lineH);
        this.settlementT.setLocation(margin, curY += rowSpaceH + lineH);
        int settlementVW = fm.stringWidth(this.settlementV.getText());
        this.settlementV.setSize(settlementVW, lineH);
        this.settlementV.setLocation(dim.width - (settlementVW + margin), curY);
        this.settlementC.setSize(costW, lineH);
        this.settlementC.setLocation(margin, curY += lineH);
        curX = 1 + costW + 3;
        this.settlementWood.setSize(16, 16);
        this.settlementWood.setLocation(curX, curY);
        this.settlementClay.setSize(16, 16);
        this.settlementClay.setLocation(curX += 19, curY);
        this.settlementWheat.setSize(16, 16);
        this.settlementWheat.setLocation(curX += 19, curY);
        this.settlementSheep.setSize(16, 16);
        this.settlementSheep.setLocation(curX += 19, curY);
        this.settlementBut.setSize(butW, lineH);
        this.settlementBut.setLocation(dim.width - (butW + margin), curY);
        this.cityT.setSize(fm.stringWidth(this.cityT.getText()), lineH);
        this.cityT.setLocation(margin, curY += rowSpaceH + lineH);
        int cityVW = fm.stringWidth(this.cityV.getText());
        this.cityV.setSize(cityVW, lineH);
        this.cityV.setLocation(dim.width - (cityVW + margin), curY);
        this.cityC.setSize(costW, lineH);
        this.cityC.setLocation(margin, curY += lineH);
        curX = 1 + costW + 3;
        this.cityWheat.setSize(16, 16);
        this.cityWheat.setLocation(curX, curY);
        this.cityOre.setSize(16, 16);
        this.cityOre.setLocation(curX += 19, curY);
        this.cityBut.setSize(butW, lineH);
        this.cityBut.setLocation(dim.width - (butW + margin), curY);
        this.cardT.setSize(fm.stringWidth(this.cardT.getText()), lineH);
        this.cardT.setLocation(margin, curY += rowSpaceH + lineH);
        int cardVW = fm.stringWidth(this.cardV.getText());
        this.cardV.setSize(cardVW, lineH);
        this.cardV.setLocation(dim.width - (cardVW + margin), curY);
        this.cardC.setSize(costW, lineH);
        this.cardC.setLocation(margin, curY += lineH);
        curX = 1 + costW + 3;
        this.cardWheat.setSize(16, 16);
        this.cardWheat.setLocation(curX, curY);
        this.cardSheep.setSize(16, 16);
        this.cardSheep.setLocation(curX += 19, curY);
        this.cardOre.setSize(16, 16);
        this.cardOre.setLocation(curX += 19, curY);
        this.cardBut.setSize(butW, lineH);
        this.cardBut.setLocation(dim.width - (butW + margin), curY);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        SOCPlayerClient client;
        String target = e.getActionCommand();
        SOCGame game = this.pi.getGame();
        SOCPlayer ourPlayerData = game.getPlayer((client = this.pi.getClient()).getNickname());
        if (ourPlayerData != null && game.getCurrentPlayerNumber() == ourPlayerData.getPlayerNumber()) {
            if (target == ROAD) {
                if (game.getGameState() == 20 && this.roadBut.getLabel().equals("Buy")) {
                    client.buildRequest(game, 0);
                } else if (this.roadBut.getLabel().equals("Cancel")) {
                    client.cancelBuildRequest(game, 0);
                }
            } else if (target == STLMT) {
                if (game.getGameState() == 20 && this.settlementBut.getLabel().equals("Buy")) {
                    client.buildRequest(game, 1);
                } else if (this.settlementBut.getLabel().equals("Cancel")) {
                    client.cancelBuildRequest(game, 1);
                }
            } else if (target == CITY) {
                if (game.getGameState() == 20 && this.cityBut.getLabel().equals("Buy")) {
                    client.buildRequest(game, 2);
                } else if (this.cityBut.getLabel().equals("Cancel")) {
                    client.cancelBuildRequest(game, 2);
                }
            } else if (target == CARD && game.getGameState() == 20 && this.cardBut.getLabel().equals("Buy")) {
                client.buyDevCard(game);
            }
        }
    }

    public void updateButtonStatus() {
        SOCGame game = this.pi.getGame();
        SOCPlayer player = game.getPlayer(this.pi.getClient().getNickname());
        if (player != null) {
            if (game.getCurrentPlayerNumber() == player.getPlayerNumber() && game.getGameState() == 30) {
                this.roadBut.setLabel("Cancel");
            } else if (game.couldBuildRoad(player.getPlayerNumber())) {
                this.roadBut.setLabel("Buy");
            } else {
                this.roadBut.setLabel("---");
            }
            if (game.getCurrentPlayerNumber() == player.getPlayerNumber() && game.getGameState() == 31) {
                this.settlementBut.setLabel("Cancel");
            } else if (game.couldBuildSettlement(player.getPlayerNumber())) {
                this.settlementBut.setLabel("Buy");
            } else {
                this.settlementBut.setLabel("---");
            }
            if (game.getCurrentPlayerNumber() == player.getPlayerNumber() && game.getGameState() == 32) {
                this.cityBut.setLabel("Cancel");
            } else if (game.couldBuildCity(player.getPlayerNumber())) {
                this.cityBut.setLabel("Buy");
            } else {
                this.cityBut.setLabel("---");
            }
            if (game.couldBuyDevCard(player.getPlayerNumber())) {
                this.cardBut.setLabel("Buy");
            } else {
                this.cardBut.setLabel("---");
            }
        }
    }
}

