/*
 * Decompiled with CFR 0.152.
 */
package soc.client;

import java.awt.Button;
import java.awt.Color;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.Label;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import soc.client.SOCPlayerInterface;
import soc.game.SOCGame;

class SOCChoosePlayerDialog
extends Dialog
implements ActionListener {
    Button[] buttons;
    int[] players;
    int number;
    Label msg;
    SOCPlayerInterface pi;

    public SOCChoosePlayerDialog(SOCPlayerInterface plInt, int num, int[] p) {
        super(plInt, "Choose Player", true);
        this.pi = plInt;
        this.number = num;
        this.players = p;
        this.setBackground(new Color(255, 230, 162));
        this.setForeground(Color.black);
        this.setFont(new Font("Geneva", 0, 12));
        this.setLayout(null);
        this.setSize(350, 100);
        this.msg = new Label("Please choose a player to steal from:", 1);
        this.add(this.msg);
        this.buttons = new Button[this.number];
        SOCGame ga = this.pi.getGame();
        for (int i = 0; i < this.number; ++i) {
            this.buttons[i] = new Button(ga.getPlayer(this.players[i]).getName());
            this.add(this.buttons[i]);
            this.buttons[i].addActionListener(this);
        }
    }

    @Override
    public void setVisible(boolean b) {
        super.setVisible(b);
        if (b) {
            this.buttons[0].requestFocus();
        }
    }

    @Override
    public void doLayout() {
        int x = this.getInsets().left;
        int y = this.getInsets().top;
        int width = this.getSize().width - this.getInsets().left - this.getInsets().right;
        int height = this.getSize().height - this.getInsets().top - this.getInsets().bottom;
        int space = 10;
        int piX = this.pi.getInsets().left;
        int piY = this.pi.getInsets().top;
        int piWidth = this.pi.getSize().width - this.pi.getInsets().left - this.pi.getInsets().right;
        int piHeight = this.pi.getSize().height - this.pi.getInsets().top - this.pi.getInsets().bottom;
        int bwidth = (width - (this.number - 1 + 2) * space) / this.number;
        this.setLocation(piX + (piWidth - width) / 2, piY + (piHeight - height) / 2);
        try {
            this.msg.setBounds(x, y, width, 20);
            for (int i = 0; i < this.number; ++i) {
                this.buttons[i].setBounds(x + space + i * (bwidth + space), this.getInsets().bottom + height - (20 + space), bwidth, 20);
            }
        }
        catch (NullPointerException e) {
            // empty catch block
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object target = e.getSource();
        for (int i = 0; i < this.number; ++i) {
            if (target != this.buttons[i]) continue;
            this.pi.getClient().choosePlayer(this.pi.getGame(), this.players[i]);
            this.dispose();
            break;
        }
    }
}

