/*
 * Decompiled with CFR 0.152.
 */
package soc.client;

import java.awt.Button;
import java.awt.Color;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.Label;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import soc.client.ColorSquare;
import soc.client.SOCPlayerInterface;
import soc.game.SOCPlayer;
import soc.game.SOCResourceSet;

class SOCDiscardDialog
extends Dialog
implements ActionListener,
MouseListener {
    Button discardBut;
    ColorSquare[] keep;
    ColorSquare[] disc;
    Label msg;
    Label youHave;
    Label discThese;
    SOCPlayerInterface playerInterface;
    int numDiscards;

    public SOCDiscardDialog(SOCPlayerInterface pi, int rnum) {
        super(pi, "Discard", true);
        this.playerInterface = pi;
        this.numDiscards = rnum;
        this.setBackground(new Color(255, 230, 162));
        this.setForeground(Color.black);
        this.setFont(new Font("Geneva", 0, 12));
        this.discardBut = new Button("Discard");
        this.setLayout(null);
        this.setSize(280, 190);
        this.msg = new Label("Please discard " + Integer.toString(this.numDiscards) + " resources.", 1);
        this.add(this.msg);
        this.youHave = new Label("You have:", 0);
        this.add(this.youHave);
        this.discThese = new Label("Discard these:", 0);
        this.add(this.discThese);
        this.add(this.discardBut);
        this.discardBut.addActionListener(this);
        this.keep = new ColorSquare[5];
        this.keep[0] = new ColorSquare(4, false, ColorSquare.CLAY);
        this.keep[1] = new ColorSquare(4, false, ColorSquare.ORE);
        this.keep[2] = new ColorSquare(4, false, ColorSquare.SHEEP);
        this.keep[3] = new ColorSquare(4, false, ColorSquare.WHEAT);
        this.keep[4] = new ColorSquare(4, false, ColorSquare.WOOD);
        this.disc = new ColorSquare[5];
        this.disc[0] = new ColorSquare(3, false, ColorSquare.CLAY);
        this.disc[1] = new ColorSquare(3, false, ColorSquare.ORE);
        this.disc[2] = new ColorSquare(3, false, ColorSquare.SHEEP);
        this.disc[3] = new ColorSquare(3, false, ColorSquare.WHEAT);
        this.disc[4] = new ColorSquare(3, false, ColorSquare.WOOD);
        for (int i = 0; i < 5; ++i) {
            this.add(this.keep[i]);
            this.add(this.disc[i]);
            this.keep[i].addMouseListener(this);
            this.disc[i].addMouseListener(this);
        }
    }

    @Override
    public void setVisible(boolean b) {
        if (b) {
            SOCPlayer player = this.playerInterface.getGame().getPlayer(this.playerInterface.getClient().getNickname());
            SOCResourceSet resources = player.getResources();
            this.keep[0].setIntValue(resources.getAmount(1));
            this.keep[1].setIntValue(resources.getAmount(2));
            this.keep[2].setIntValue(resources.getAmount(3));
            this.keep[3].setIntValue(resources.getAmount(4));
            this.keep[4].setIntValue(resources.getAmount(5));
            this.discardBut.requestFocus();
        }
        super.setVisible(b);
    }

    @Override
    public void doLayout() {
        int x = this.getInsets().left;
        int y = this.getInsets().top;
        int width = this.getSize().width - this.getInsets().left - this.getInsets().right;
        int height = this.getSize().height - this.getInsets().top - this.getInsets().bottom;
        int space = 5;
        int cfx = this.playerInterface.getInsets().left;
        int cfy = this.playerInterface.getInsets().top;
        int cfwidth = this.playerInterface.getSize().width - this.playerInterface.getInsets().left - this.playerInterface.getInsets().right;
        int cfheight = this.playerInterface.getSize().height - this.playerInterface.getInsets().top - this.playerInterface.getInsets().bottom;
        int sqwidth = 16;
        int sqspace = (width - 5 * sqwidth) / 5;
        this.setLocation(cfx + (cfwidth - width) / 2, cfy + (cfheight - height) / 2);
        try {
            this.msg.setBounds((width - 188) / 2, this.getInsets().top, 180, 20);
            this.discardBut.setBounds((width - 88) / 2, this.getInsets().bottom + height - 25, 80, 25);
            this.youHave.setBounds(this.getInsets().left, this.getInsets().top + 20 + space, 70, 20);
            this.discThese.setBounds(this.getInsets().left, this.getInsets().top + 20 + space + 20 + space + sqwidth + space, 100, 20);
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        int keepY = this.getInsets().top + 20 + space + 20 + space;
        int discY = keepY + sqwidth + space + 20 + space;
        try {
            for (int i = 0; i < 5; ++i) {
                this.keep[i].setSize(sqwidth, sqwidth);
                this.keep[i].setLocation(i * sqspace + (width - (3 * sqspace + 4 * sqwidth)) / 2, keepY);
                this.disc[i].setSize(sqwidth, sqwidth);
                this.disc[i].setLocation(i * sqspace + (width - (3 * sqspace + 4 * sqwidth)) / 2, discY);
            }
        }
        catch (NullPointerException e) {
            // empty catch block
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        SOCResourceSet rsrcs;
        Object target = e.getSource();
        if (target == this.discardBut && (rsrcs = new SOCResourceSet(this.disc[0].getIntValue(), this.disc[1].getIntValue(), this.disc[2].getIntValue(), this.disc[3].getIntValue(), this.disc[4].getIntValue(), 0)).getTotal() == this.numDiscards) {
            this.playerInterface.getClient().discard(this.playerInterface.getGame(), rsrcs);
            this.dispose();
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        Object target = e.getSource();
        for (int i = 0; i < 5; ++i) {
            if (target == this.keep[i] && this.disc[i].getIntValue() > 0) {
                this.keep[i].addValue(1);
                this.disc[i].subtractValue(1);
                continue;
            }
            if (target != this.disc[i] || this.keep[i].getIntValue() <= 0) continue;
            this.keep[i].subtractValue(1);
            this.disc[i].addValue(1);
        }
    }
}

