/*
 * Decompiled with CFR 0.152.
 */
package soc.client;

import java.awt.Button;
import java.awt.Color;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.Label;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import soc.client.ColorSquare;
import soc.client.SOCPlayerInterface;
import soc.game.SOCResourceSet;

class SOCDiscoveryDialog
extends Dialog
implements ActionListener {
    Button doneBut;
    Button clearBut;
    ColorSquare[] rsrc;
    Label msg;
    SOCPlayerInterface pi;

    public SOCDiscoveryDialog(SOCPlayerInterface pi) {
        super(pi, "Discovery", true);
        this.pi = pi;
        this.setBackground(new Color(255, 230, 162));
        this.setForeground(Color.black);
        this.setFont(new Font("Geneva", 0, 12));
        this.doneBut = new Button("Done");
        this.clearBut = new Button("Clear");
        this.setLayout(null);
        this.addNotify();
        this.setSize(280, 190);
        this.msg = new Label("Please pick two resources.", 1);
        this.add(this.msg);
        this.add(this.doneBut);
        this.doneBut.addActionListener(this);
        this.add(this.clearBut);
        this.clearBut.addActionListener(this);
        this.rsrc = new ColorSquare[5];
        this.rsrc[0] = new ColorSquare(3, true, ColorSquare.CLAY, 2, 0);
        this.rsrc[1] = new ColorSquare(3, true, ColorSquare.ORE, 2, 0);
        this.rsrc[2] = new ColorSquare(3, true, ColorSquare.SHEEP, 2, 0);
        this.rsrc[3] = new ColorSquare(3, true, ColorSquare.WHEAT, 2, 0);
        this.rsrc[4] = new ColorSquare(3, true, ColorSquare.WOOD, 2, 0);
        for (int i = 0; i < 5; ++i) {
            this.add(this.rsrc[i]);
        }
    }

    @Override
    public void setVisible(boolean b) {
        super.setVisible(b);
        if (b) {
            this.doneBut.requestFocus();
        }
    }

    @Override
    public void doLayout() {
        int x = this.getInsets().left;
        int y = this.getInsets().top;
        int width = this.getSize().width - this.getInsets().left - this.getInsets().right;
        int height = this.getSize().height - this.getInsets().top - this.getInsets().bottom;
        int space = 5;
        int pix = this.pi.getInsets().left;
        int piy = this.pi.getInsets().top;
        int piwidth = this.pi.getSize().width - this.pi.getInsets().left - this.pi.getInsets().right;
        int piheight = this.pi.getSize().height - this.pi.getInsets().top - this.pi.getInsets().bottom;
        int sqwidth = 16;
        int sqspace = (width - 5 * sqwidth) / 5;
        int buttonW = 80;
        int buttonX = (width - (2 * buttonW + space)) / 2;
        this.setLocation(pix + (piwidth - width) / 2, piy + (piheight - height) / 2);
        if (this.msg != null) {
            this.msg.setBounds((width - 188) / 2, this.getInsets().top, 180, 20);
        }
        if (this.clearBut != null) {
            this.clearBut.setBounds(buttonX, this.getInsets().bottom + height - 25, buttonW, 25);
        }
        if (this.doneBut != null) {
            this.doneBut.setBounds(buttonX + buttonW + space, this.getInsets().bottom + height - 25, buttonW, 25);
        }
        try {
            int rsrcY = y + 20 + space + 20 + space;
            for (int i = 0; i < 5; ++i) {
                this.rsrc[i].setSize(sqwidth, sqwidth);
                this.rsrc[i].setLocation(i * sqspace + (width - (3 * sqspace + 4 * sqwidth)) / 2, rsrcY);
            }
        }
        catch (NullPointerException e) {
            // empty catch block
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object target = e.getSource();
        if (target == this.doneBut) {
            int[] rsrcCnt = new int[5];
            int sum = 0;
            for (int i = 0; i < 5; ++i) {
                rsrcCnt[i] = this.rsrc[i].getIntValue();
                sum += rsrcCnt[i];
            }
            if (sum == 2) {
                SOCResourceSet resources = new SOCResourceSet(rsrcCnt[0], rsrcCnt[1], rsrcCnt[2], rsrcCnt[3], rsrcCnt[4], 0);
                this.pi.getClient().discoveryPick(this.pi.getGame(), resources);
                this.dispose();
            }
        } else if (target == this.clearBut) {
            for (int i = 0; i < 5; ++i) {
                this.rsrc[i].setIntValue(0);
            }
        }
    }
}

