/*
 * Decompiled with CFR 0.152.
 */
package soc.client;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.Socket;
import java.util.Hashtable;
import soc.disableDebug.D;
import soc.game.SOCBoard;
import soc.game.SOCCity;
import soc.game.SOCGame;
import soc.game.SOCPlayer;
import soc.game.SOCPlayingPiece;
import soc.game.SOCResourceSet;
import soc.game.SOCRoad;
import soc.game.SOCSettlement;
import soc.game.SOCTradeOffer;
import soc.message.SOCAcceptOffer;
import soc.message.SOCBCastTextMsg;
import soc.message.SOCBankTrade;
import soc.message.SOCBoardLayout;
import soc.message.SOCBuildRequest;
import soc.message.SOCBuyCardRequest;
import soc.message.SOCCancelBuildRequest;
import soc.message.SOCChangeFace;
import soc.message.SOCChannels;
import soc.message.SOCChoosePlayer;
import soc.message.SOCChoosePlayerRequest;
import soc.message.SOCClearOffer;
import soc.message.SOCClearTradeMsg;
import soc.message.SOCDeleteChannel;
import soc.message.SOCDeleteGame;
import soc.message.SOCDevCard;
import soc.message.SOCDevCardCount;
import soc.message.SOCDiceResult;
import soc.message.SOCDiscard;
import soc.message.SOCDiscardRequest;
import soc.message.SOCDiscoveryPick;
import soc.message.SOCEndTurn;
import soc.message.SOCFirstPlayer;
import soc.message.SOCGameMembers;
import soc.message.SOCGameState;
import soc.message.SOCGameStats;
import soc.message.SOCGameTextMsg;
import soc.message.SOCGames;
import soc.message.SOCJoin;
import soc.message.SOCJoinAuth;
import soc.message.SOCJoinGame;
import soc.message.SOCJoinGameAuth;
import soc.message.SOCLargestArmy;
import soc.message.SOCLeave;
import soc.message.SOCLeaveAll;
import soc.message.SOCLeaveGame;
import soc.message.SOCLongestRoad;
import soc.message.SOCMakeOffer;
import soc.message.SOCMembers;
import soc.message.SOCMessage;
import soc.message.SOCMonopolyPick;
import soc.message.SOCMoveRobber;
import soc.message.SOCNewChannel;
import soc.message.SOCNewGame;
import soc.message.SOCPlayDevCardRequest;
import soc.message.SOCPlayerElement;
import soc.message.SOCPotentialSettlements;
import soc.message.SOCPutPiece;
import soc.message.SOCRejectConnection;
import soc.message.SOCRejectOffer;
import soc.message.SOCResourceCount;
import soc.message.SOCRollDice;
import soc.message.SOCSetPlayedDevCard;
import soc.message.SOCSetSeatLock;
import soc.message.SOCSetTurn;
import soc.message.SOCSitDown;
import soc.message.SOCStartGame;
import soc.message.SOCStatusMessage;
import soc.message.SOCTextMsg;
import soc.message.SOCTurn;

public class SOCDisplaylessPlayerClient
implements Runnable {
    protected static String STATSPREFEX = "  [";
    protected String doc;
    protected String lastMessage;
    protected String host;
    protected int port;
    protected Socket s;
    protected DataInputStream in;
    protected DataOutputStream out;
    protected Thread reader = null;
    protected Exception ex = null;
    protected boolean connected = false;
    protected String nickname = null;
    protected String password = null;
    protected boolean gotPassword;
    protected Hashtable channels = new Hashtable();
    protected Hashtable games = new Hashtable();

    public SOCDisplaylessPlayerClient() {
        this.host = null;
        this.port = 8889;
        this.gotPassword = false;
    }

    public SOCDisplaylessPlayerClient(String h, int p, boolean visual) {
        this.host = h;
        this.port = p;
    }

    public String getNickname() {
        return this.nickname;
    }

    @Override
    public void run() {
        try {
            while (this.connected) {
                String s = this.in.readUTF();
                this.treat(SOCMessage.toMsg(s));
            }
        }
        catch (InterruptedIOException x) {
            System.err.println("Socket timeout in run: " + x);
        }
        catch (IOException e) {
            if (!this.connected) {
                return;
            }
            this.ex = e;
            System.err.println("could not read from the net: " + this.ex);
            this.destroy();
        }
    }

    public void resend() {
        this.put(this.lastMessage);
    }

    public synchronized boolean put(String s) {
        this.lastMessage = s;
        D.ebugPrintln("OUT - " + s);
        if (this.ex != null || !this.connected) {
            return false;
        }
        try {
            this.out.writeUTF(s);
        }
        catch (InterruptedIOException x) {
            System.err.println("Socket timeout in put: " + x);
        }
        catch (IOException e) {
            this.ex = e;
            System.err.println("could not write to the net: " + this.ex);
            this.destroy();
            return false;
        }
        return true;
    }

    public void treat(SOCMessage mes) {
        D.ebugPrintln(mes.toString());
        try {
            switch (mes.getType()) {
                case 1069: {
                    this.handleSTATUSMESSAGE((SOCStatusMessage)mes);
                    break;
                }
                case 1020: {
                    this.handleJOINAUTH((SOCJoinAuth)mes);
                    break;
                }
                case 1004: {
                    this.handleJOIN((SOCJoin)mes);
                    break;
                }
                case 1002: {
                    this.handleMEMBERS((SOCMembers)mes);
                    break;
                }
                case 1001: {
                    this.handleNEWCHANNEL((SOCNewChannel)mes);
                    break;
                }
                case 1003: {
                    this.handleCHANNELS((SOCChannels)mes);
                    break;
                }
                case 1005: {
                    this.handleTEXTMSG((SOCTextMsg)mes);
                    break;
                }
                case 1006: {
                    this.handleLEAVE((SOCLeave)mes);
                    break;
                }
                case 1007: {
                    this.handleDELETECHANNEL((SOCDeleteChannel)mes);
                    break;
                }
                case 1019: {
                    this.handleGAMES((SOCGames)mes);
                    break;
                }
                case 1021: {
                    this.handleJOINGAMEAUTH((SOCJoinGameAuth)mes);
                    break;
                }
                case 1013: {
                    this.handleJOINGAME((SOCJoinGame)mes);
                    break;
                }
                case 1011: {
                    this.handleLEAVEGAME((SOCLeaveGame)mes);
                    break;
                }
                case 1016: {
                    this.handleNEWGAME((SOCNewGame)mes);
                    break;
                }
                case 1015: {
                    this.handleDELETEGAME((SOCDeleteGame)mes);
                    break;
                }
                case 1017: {
                    this.handleGAMEMEMBERS((SOCGameMembers)mes);
                    break;
                }
                case 1061: {
                    this.handleGAMESTATS((SOCGameStats)mes);
                    break;
                }
                case 1010: {
                    this.handleGAMETEXTMSG((SOCGameTextMsg)mes);
                    break;
                }
                case 1062: {
                    this.handleBCASTTEXTMSG((SOCBCastTextMsg)mes);
                    break;
                }
                case 1012: {
                    this.handleSITDOWN((SOCSitDown)mes);
                    break;
                }
                case 1014: {
                    this.handleBOARDLAYOUT((SOCBoardLayout)mes);
                    break;
                }
                case 1018: {
                    this.handleSTARTGAME((SOCStartGame)mes);
                    break;
                }
                case 1025: {
                    this.handleGAMESTATE((SOCGameState)mes);
                    break;
                }
                case 1055: {
                    this.handleSETTURN((SOCSetTurn)mes);
                    break;
                }
                case 1054: {
                    this.handleFIRSTPLAYER((SOCFirstPlayer)mes);
                    break;
                }
                case 1026: {
                    this.handleTURN((SOCTurn)mes);
                    break;
                }
                case 1024: {
                    this.handlePLAYERELEMENT((SOCPlayerElement)mes);
                    break;
                }
                case 1063: {
                    this.handleRESOURCECOUNT((SOCResourceCount)mes);
                    break;
                }
                case 1028: {
                    this.handleDICERESULT((SOCDiceResult)mes);
                    break;
                }
                case 1009: {
                    this.handlePUTPIECE((SOCPutPiece)mes);
                    break;
                }
                case 1034: {
                    this.handleMOVEROBBER((SOCMoveRobber)mes);
                    break;
                }
                case 1029: {
                    this.handleDISCARDREQUEST((SOCDiscardRequest)mes);
                    break;
                }
                case 1036: {
                    this.handleCHOOSEPLAYERREQUEST((SOCChoosePlayerRequest)mes);
                    break;
                }
                case 1041: {
                    this.handleMAKEOFFER((SOCMakeOffer)mes);
                    break;
                }
                case 1038: {
                    this.handleCLEAROFFER((SOCClearOffer)mes);
                    break;
                }
                case 1037: {
                    this.handleREJECTOFFER((SOCRejectOffer)mes);
                    break;
                }
                case 1042: {
                    this.handleCLEARTRADEMSG((SOCClearTradeMsg)mes);
                    break;
                }
                case 1047: {
                    this.handleDEVCARDCOUNT((SOCDevCardCount)mes);
                    break;
                }
                case 1046: {
                    this.handleDEVCARD((SOCDevCard)mes);
                    break;
                }
                case 1048: {
                    this.handleSETPLAYEDDEVCARD((SOCSetPlayedDevCard)mes);
                    break;
                }
                case 1057: {
                    this.handlePOTENTIALSETTLEMENTS((SOCPotentialSettlements)mes);
                    break;
                }
                case 1058: {
                    this.handleCHANGEFACE((SOCChangeFace)mes);
                    break;
                }
                case 1059: {
                    this.handleREJECTCONNECTION((SOCRejectConnection)mes);
                    break;
                }
                case 1066: {
                    this.handleLONGESTROAD((SOCLongestRoad)mes);
                    break;
                }
                case 1067: {
                    this.handleLARGESTARMY((SOCLargestArmy)mes);
                    break;
                }
                case 1068: {
                    this.handleSETSEATLOCK((SOCSetSeatLock)mes);
                }
            }
        }
        catch (Exception e) {
            System.out.println("SOCDisplaylessPlayerClient treat ERROR - " + e.getMessage());
            e.printStackTrace();
        }
    }

    protected void handleSTATUSMESSAGE(SOCStatusMessage mes) {
    }

    protected void handleJOINAUTH(SOCJoinAuth mes) {
        this.gotPassword = true;
    }

    protected void handleJOIN(SOCJoin mes) {
    }

    protected void handleMEMBERS(SOCMembers mes) {
    }

    protected void handleNEWCHANNEL(SOCNewChannel mes) {
    }

    protected void handleCHANNELS(SOCChannels mes) {
    }

    protected void handleBCASTTEXTMSG(SOCBCastTextMsg mes) {
    }

    protected void handleTEXTMSG(SOCTextMsg mes) {
    }

    protected void handleLEAVE(SOCLeave mes) {
    }

    protected void handleDELETECHANNEL(SOCDeleteChannel mes) {
    }

    protected void handleGAMES(SOCGames mes) {
    }

    protected void handleJOINGAMEAUTH(SOCJoinGameAuth mes) {
        this.gotPassword = true;
        SOCGame ga = new SOCGame(mes.getGame());
        if (ga != null) {
            this.games.put(mes.getGame(), ga);
        }
    }

    protected void handleJOINGAME(SOCJoinGame mes) {
    }

    protected void handleLEAVEGAME(SOCLeaveGame mes) {
        SOCPlayer player;
        String gn = mes.getGame();
        SOCGame ga = (SOCGame)this.games.get(gn);
        if (ga != null && (player = ga.getPlayer(mes.getNickname())) != null) {
            ga.removePlayer(mes.getNickname());
        }
    }

    protected void handleNEWGAME(SOCNewGame mes) {
    }

    protected void handleDELETEGAME(SOCDeleteGame mes) {
    }

    protected void handleGAMEMEMBERS(SOCGameMembers mes) {
    }

    protected void handleGAMESTATS(SOCGameStats mes) {
    }

    protected void handleGAMETEXTMSG(SOCGameTextMsg mes) {
    }

    protected void handleSITDOWN(SOCSitDown mes) {
        SOCGame ga = (SOCGame)this.games.get(mes.getGame());
        if (ga != null) {
            ga.takeMonitor();
            try {
                ga.addPlayer(mes.getNickname(), mes.getPlayerNumber());
                ga.getPlayer(mes.getPlayerNumber()).setRobotFlag(mes.isRobot());
            }
            catch (Exception e) {
                ga.releaseMonitor();
                System.out.println("Exception caught - " + e);
                e.printStackTrace();
            }
            ga.releaseMonitor();
        }
    }

    protected void handleBOARDLAYOUT(SOCBoardLayout mes) {
        SOCGame ga = (SOCGame)this.games.get(mes.getGame());
        if (ga != null) {
            SOCBoard bd = ga.getBoard();
            bd.setHexLayout(mes.getHexLayout());
            bd.setNumberLayout(mes.getNumberLayout());
            bd.setRobberHex(mes.getRobberHex());
        }
    }

    protected void handleSTARTGAME(SOCStartGame mes) {
    }

    protected void handleGAMESTATE(SOCGameState mes) {
        SOCGame ga = (SOCGame)this.games.get(mes.getGame());
        if (ga != null) {
            ga.setGameState(mes.getState());
        }
    }

    protected void handleSETTURN(SOCSetTurn mes) {
        SOCGame ga = (SOCGame)this.games.get(mes.getGame());
        if (ga != null) {
            ga.setCurrentPlayerNumber(mes.getPlayerNumber());
        }
    }

    protected void handleFIRSTPLAYER(SOCFirstPlayer mes) {
        SOCGame ga = (SOCGame)this.games.get(mes.getGame());
        if (ga != null) {
            ga.setFirstPlayer(mes.getPlayerNumber());
        }
    }

    protected void handleTURN(SOCTurn mes) {
        SOCGame ga = (SOCGame)this.games.get(mes.getGame());
        if (ga != null) {
            if (ga.getFirstPlayer() == -1) {
                ga.setFirstPlayer(mes.getPlayerNumber());
            }
            ga.setCurrentDice(0);
            ga.setCurrentPlayerNumber(mes.getPlayerNumber());
            ga.getPlayer(mes.getPlayerNumber()).getDevCards().newToOld();
        }
    }

    protected void handlePLAYERELEMENT(SOCPlayerElement mes) {
        SOCGame ga = (SOCGame)this.games.get(mes.getGame());
        if (ga != null) {
            SOCPlayer pl = ga.getPlayer(mes.getPlayerNumber());
            block0 : switch (mes.getElementType()) {
                case 10: {
                    switch (mes.getAction()) {
                        case 100: {
                            pl.setNumPieces(0, mes.getValue());
                            break;
                        }
                        case 101: {
                            pl.setNumPieces(0, pl.getNumPieces(0) + mes.getValue());
                            break;
                        }
                        case 102: {
                            pl.setNumPieces(0, pl.getNumPieces(0) - mes.getValue());
                        }
                    }
                    break;
                }
                case 11: {
                    switch (mes.getAction()) {
                        case 100: {
                            pl.setNumPieces(1, mes.getValue());
                            break;
                        }
                        case 101: {
                            pl.setNumPieces(1, pl.getNumPieces(1) + mes.getValue());
                            break;
                        }
                        case 102: {
                            pl.setNumPieces(1, pl.getNumPieces(1) - mes.getValue());
                        }
                    }
                    break;
                }
                case 12: {
                    switch (mes.getAction()) {
                        case 100: {
                            pl.setNumPieces(2, mes.getValue());
                            break;
                        }
                        case 101: {
                            pl.setNumPieces(2, pl.getNumPieces(2) + mes.getValue());
                            break;
                        }
                        case 102: {
                            pl.setNumPieces(2, pl.getNumPieces(2) - mes.getValue());
                        }
                    }
                    break;
                }
                case 15: {
                    switch (mes.getAction()) {
                        case 100: {
                            pl.setNumKnights(mes.getValue());
                            break;
                        }
                        case 101: {
                            pl.setNumKnights(pl.getNumKnights() + mes.getValue());
                            break;
                        }
                        case 102: {
                            pl.setNumKnights(pl.getNumKnights() - mes.getValue());
                        }
                    }
                    ga.updateLargestArmy();
                    break;
                }
                case 1: {
                    switch (mes.getAction()) {
                        case 100: {
                            pl.getResources().setAmount(mes.getValue(), 1);
                            break;
                        }
                        case 101: {
                            pl.getResources().add(mes.getValue(), 1);
                            break;
                        }
                        case 102: {
                            if (pl.getResources().getAmount(1) >= mes.getValue()) {
                                pl.getResources().subtract(mes.getValue(), 1);
                                break;
                            }
                            pl.getResources().subtract(mes.getValue() - pl.getResources().getAmount(1), 6);
                            pl.getResources().setAmount(0, 1);
                        }
                    }
                    break;
                }
                case 2: {
                    switch (mes.getAction()) {
                        case 100: {
                            pl.getResources().setAmount(mes.getValue(), 2);
                            break;
                        }
                        case 101: {
                            pl.getResources().add(mes.getValue(), 2);
                            break;
                        }
                        case 102: {
                            if (pl.getResources().getAmount(2) >= mes.getValue()) {
                                pl.getResources().subtract(mes.getValue(), 2);
                                break;
                            }
                            pl.getResources().subtract(mes.getValue() - pl.getResources().getAmount(2), 6);
                            pl.getResources().setAmount(0, 2);
                        }
                    }
                    break;
                }
                case 3: {
                    switch (mes.getAction()) {
                        case 100: {
                            pl.getResources().setAmount(mes.getValue(), 3);
                            break;
                        }
                        case 101: {
                            pl.getResources().add(mes.getValue(), 3);
                            break;
                        }
                        case 102: {
                            if (pl.getResources().getAmount(3) >= mes.getValue()) {
                                pl.getResources().subtract(mes.getValue(), 3);
                                break;
                            }
                            pl.getResources().subtract(mes.getValue() - pl.getResources().getAmount(3), 6);
                            pl.getResources().setAmount(0, 3);
                        }
                    }
                    break;
                }
                case 4: {
                    switch (mes.getAction()) {
                        case 100: {
                            pl.getResources().setAmount(mes.getValue(), 4);
                            break;
                        }
                        case 101: {
                            pl.getResources().add(mes.getValue(), 4);
                            break;
                        }
                        case 102: {
                            if (pl.getResources().getAmount(4) >= mes.getValue()) {
                                pl.getResources().subtract(mes.getValue(), 4);
                                break;
                            }
                            pl.getResources().subtract(mes.getValue() - pl.getResources().getAmount(4), 6);
                            pl.getResources().setAmount(0, 4);
                        }
                    }
                    break;
                }
                case 5: {
                    switch (mes.getAction()) {
                        case 100: {
                            pl.getResources().setAmount(mes.getValue(), 5);
                            break;
                        }
                        case 101: {
                            pl.getResources().add(mes.getValue(), 5);
                            break;
                        }
                        case 102: {
                            if (pl.getResources().getAmount(5) >= mes.getValue()) {
                                pl.getResources().subtract(mes.getValue(), 5);
                                break;
                            }
                            pl.getResources().subtract(mes.getValue() - pl.getResources().getAmount(5), 6);
                            pl.getResources().setAmount(0, 5);
                        }
                    }
                    break;
                }
                case 6: {
                    switch (mes.getAction()) {
                        case 100: {
                            pl.getResources().setAmount(mes.getValue(), 6);
                            break block0;
                        }
                        case 101: {
                            pl.getResources().add(mes.getValue(), 6);
                            break block0;
                        }
                        case 102: {
                            SOCResourceSet rs = pl.getResources();
                            rs.add(rs.getAmount(1), 6);
                            rs.setAmount(0, 1);
                            rs.add(rs.getAmount(2), 6);
                            rs.setAmount(0, 2);
                            rs.add(rs.getAmount(3), 6);
                            rs.setAmount(0, 3);
                            rs.add(rs.getAmount(4), 6);
                            rs.setAmount(0, 4);
                            rs.add(rs.getAmount(5), 6);
                            rs.setAmount(0, 5);
                            pl.getResources().subtract(mes.getValue(), 6);
                        }
                    }
                }
            }
        }
    }

    protected void handleRESOURCECOUNT(SOCResourceCount mes) {
        SOCGame ga = (SOCGame)this.games.get(mes.getGame());
        if (ga != null) {
            SOCPlayer pl = ga.getPlayer(mes.getPlayerNumber());
            if (mes.getCount() != pl.getResources().getTotal()) {
                SOCResourceSet rsrcs = pl.getResources();
                if (!pl.getName().equals(this.nickname)) {
                    rsrcs.clear();
                    rsrcs.setAmount(mes.getCount(), 6);
                }
            }
        }
    }

    protected void handleDICERESULT(SOCDiceResult mes) {
        SOCGame ga = (SOCGame)this.games.get(mes.getGame());
        if (ga != null) {
            ga.setCurrentDice(mes.getResult());
        }
    }

    protected void handlePUTPIECE(SOCPutPiece mes) {
        SOCGame ga = (SOCGame)this.games.get(mes.getGame());
        if (ga != null) {
            SOCPlayer pl = ga.getPlayer(mes.getPlayerNumber());
            switch (mes.getPieceType()) {
                case 0: {
                    SOCRoad rd = new SOCRoad(pl, mes.getCoordinates());
                    ga.putPiece(rd);
                    break;
                }
                case 1: {
                    SOCSettlement se = new SOCSettlement(pl, mes.getCoordinates());
                    ga.putPiece(se);
                    break;
                }
                case 2: {
                    SOCCity ci = new SOCCity(pl, mes.getCoordinates());
                    ga.putPiece(ci);
                }
            }
        }
    }

    protected void handleMOVEROBBER(SOCMoveRobber mes) {
        SOCGame ga = (SOCGame)this.games.get(mes.getGame());
        if (ga != null) {
            ga.getBoard().setRobberHex(mes.getCoordinates());
        }
    }

    protected void handleDISCARDREQUEST(SOCDiscardRequest mes) {
    }

    protected void handleCHOOSEPLAYERREQUEST(SOCChoosePlayerRequest mes) {
        int[] choices = new int[4];
        boolean[] ch = mes.getChoices();
        int count = 0;
        for (int i = 0; i < 4; ++i) {
            if (!ch[i]) continue;
            choices[count] = i;
            ++count;
        }
    }

    protected void handleMAKEOFFER(SOCMakeOffer mes) {
        SOCGame ga = (SOCGame)this.games.get(mes.getGame());
        if (ga != null) {
            SOCTradeOffer offer = mes.getOffer();
            ga.getPlayer(offer.getFrom()).setCurrentOffer(offer);
        }
    }

    protected void handleCLEAROFFER(SOCClearOffer mes) {
        SOCGame ga = (SOCGame)this.games.get(mes.getGame());
        if (ga != null) {
            ga.getPlayer(mes.getPlayerNumber()).setCurrentOffer(null);
        }
    }

    protected void handleREJECTOFFER(SOCRejectOffer mes) {
    }

    protected void handleCLEARTRADEMSG(SOCClearTradeMsg mes) {
    }

    protected void handleDEVCARDCOUNT(SOCDevCardCount mes) {
        SOCGame ga = (SOCGame)this.games.get(mes.getGame());
        if (ga != null) {
            ga.setNumDevCards(mes.getNumDevCards());
        }
    }

    protected void handleDEVCARD(SOCDevCard mes) {
        SOCGame ga = (SOCGame)this.games.get(mes.getGame());
        if (ga != null) {
            SOCPlayer player = ga.getPlayer(mes.getPlayerNumber());
            switch (mes.getAction()) {
                case 0: {
                    player.getDevCards().add(1, 1, mes.getCardType());
                    break;
                }
                case 1: {
                    player.getDevCards().subtract(1, 0, mes.getCardType());
                    break;
                }
                case 3: {
                    player.getDevCards().add(1, 0, mes.getCardType());
                    break;
                }
                case 2: {
                    player.getDevCards().add(1, 1, mes.getCardType());
                }
            }
        }
    }

    protected void handleSETPLAYEDDEVCARD(SOCSetPlayedDevCard mes) {
        SOCGame ga = (SOCGame)this.games.get(mes.getGame());
        if (ga != null) {
            SOCPlayer player = ga.getPlayer(mes.getPlayerNumber());
            player.setPlayedDevCard(mes.hasPlayedDevCard());
        }
    }

    protected void handlePOTENTIALSETTLEMENTS(SOCPotentialSettlements mes) {
        SOCGame ga = (SOCGame)this.games.get(mes.getGame());
        if (ga != null) {
            SOCPlayer player = ga.getPlayer(mes.getPlayerNumber());
            player.setPotentialSettlements(mes.getPotentialSettlements());
        }
    }

    protected void handleCHANGEFACE(SOCChangeFace mes) {
        SOCGame ga = (SOCGame)this.games.get(mes.getGame());
        if (ga != null) {
            SOCPlayer player = ga.getPlayer(mes.getPlayerNumber());
            player.setFaceId(mes.getFaceId());
        }
    }

    protected void handleREJECTCONNECTION(SOCRejectConnection mes) {
        this.disconnect();
    }

    protected void handleLONGESTROAD(SOCLongestRoad mes) {
        SOCGame ga = (SOCGame)this.games.get(mes.getGame());
        if (ga != null) {
            if (mes.getPlayerNumber() == -1) {
                ga.setPlayerWithLongestRoad(null);
            } else {
                ga.setPlayerWithLongestRoad(ga.getPlayer(mes.getPlayerNumber()));
            }
        }
    }

    protected void handleLARGESTARMY(SOCLargestArmy mes) {
        SOCGame ga = (SOCGame)this.games.get(mes.getGame());
        if (ga != null) {
            if (mes.getPlayerNumber() == -1) {
                ga.setPlayerWithLargestArmy(null);
            } else {
                ga.setPlayerWithLargestArmy(ga.getPlayer(mes.getPlayerNumber()));
            }
        }
    }

    protected void handleSETSEATLOCK(SOCSetSeatLock mes) {
        SOCGame ga = (SOCGame)this.games.get(mes.getGame());
        if (ga != null) {
            if (mes.getLockState()) {
                ga.lockSeat(mes.getPlayerNumber());
            } else {
                ga.unlockSeat(mes.getPlayerNumber());
            }
        }
    }

    public void chSend(String ch, String mes) {
        this.put(SOCTextMsg.toCmd(ch, this.nickname, mes));
    }

    public void leaveChannel(String ch) {
        this.channels.remove(ch);
        this.put(SOCLeave.toCmd(this.nickname, this.host, ch));
    }

    protected void disconnect() {
        this.connected = false;
        try {
            this.s.close();
        }
        catch (Exception e) {
            this.ex = e;
        }
    }

    public void buyDevCard(SOCGame ga) {
        this.put(SOCBuyCardRequest.toCmd(ga.getName()));
    }

    public void buildRequest(SOCGame ga, int piece) {
        this.put(SOCBuildRequest.toCmd(ga.getName(), piece));
    }

    public void cancelBuildRequest(SOCGame ga, int piece) {
        this.put(SOCCancelBuildRequest.toCmd(ga.getName(), piece));
    }

    public void putPiece(SOCGame ga, SOCPlayingPiece pp) {
        System.out.printf("Message Sent: %s \n", SOCPutPiece.toCmd(ga.getName(), pp.getPlayer().getPlayerNumber(), pp.getType(), pp.getCoordinates()));
        this.put(SOCPutPiece.toCmd(ga.getName(), pp.getPlayer().getPlayerNumber(), pp.getType(), pp.getCoordinates()));
    }

    public void moveRobber(SOCGame ga, SOCPlayer pl, int coord) {
        this.put(SOCMoveRobber.toCmd(ga.getName(), pl.getPlayerNumber(), coord));
    }

    public void sendText(SOCGame ga, String me) {
        this.put(SOCGameTextMsg.toCmd(ga.getName(), this.nickname, me));
    }

    public void leaveGame(SOCGame ga) {
        this.games.remove(ga.getName());
        this.put(SOCLeaveGame.toCmd(this.nickname, this.host, ga.getName()));
    }

    public void sitDown(SOCGame ga, int pn) {
        this.put(SOCSitDown.toCmd(ga.getName(), "dummy", pn, false));
    }

    public void startGame(SOCGame ga) {
        this.put(SOCStartGame.toCmd(ga.getName()));
    }

    public void rollDice(SOCGame ga) {
        this.put(SOCRollDice.toCmd(ga.getName()));
    }

    public void endTurn(SOCGame ga) {
        this.put(SOCEndTurn.toCmd(ga.getName()));
    }

    public void discard(SOCGame ga, SOCResourceSet rs) {
        this.put(SOCDiscard.toCmd(ga.getName(), rs));
    }

    public void choosePlayer(SOCGame ga, int pn) {
        this.put(SOCChoosePlayer.toCmd(ga.getName(), pn));
    }

    public void rejectOffer(SOCGame ga) {
        this.put(SOCRejectOffer.toCmd(ga.getName(), ga.getPlayer(this.nickname).getPlayerNumber()));
    }

    public void acceptOffer(SOCGame ga, int from) {
        this.put(SOCAcceptOffer.toCmd(ga.getName(), ga.getPlayer(this.nickname).getPlayerNumber(), from));
    }

    public void clearOffer(SOCGame ga) {
        this.put(SOCClearOffer.toCmd(ga.getName(), ga.getPlayer(this.nickname).getPlayerNumber()));
    }

    public void bankTrade(SOCGame ga, SOCResourceSet give, SOCResourceSet get) {
        this.put(SOCBankTrade.toCmd(ga.getName(), give, get));
    }

    public void offerTrade(SOCGame ga, SOCTradeOffer offer) {
        this.put(SOCMakeOffer.toCmd(ga.getName(), offer));
    }

    public void playDevCard(SOCGame ga, int dc) {
        this.put(SOCPlayDevCardRequest.toCmd(ga.getName(), dc));
    }

    public void discoveryPick(SOCGame ga, SOCResourceSet rscs) {
        this.put(SOCDiscoveryPick.toCmd(ga.getName(), rscs));
    }

    public void monopolyPick(SOCGame ga, int res) {
        this.put(SOCMonopolyPick.toCmd(ga.getName(), res));
    }

    public void changeFace(SOCGame ga, int id) {
        this.put(SOCChangeFace.toCmd(ga.getName(), ga.getPlayer(this.nickname).getPlayerNumber(), id));
    }

    public void lockSeat(SOCGame ga, int pn) {
        this.put(SOCSetSeatLock.toCmd(ga.getName(), pn, true));
    }

    public void unlockSeat(SOCGame ga, int pn) {
        this.put(SOCSetSeatLock.toCmd(ga.getName(), pn, false));
    }

    public void destroy() {
        SOCLeaveAll leaveAllMes = new SOCLeaveAll();
        this.put(leaveAllMes.toCmd());
        this.disconnect();
    }

    public boolean isSmartSettlersAgent() {
        return false;
    }

    public static void main(String[] args) {
        SOCDisplaylessPlayerClient ex1 = new SOCDisplaylessPlayerClient(args[0], Integer.parseInt(args[1]), true);
    }
}

