/*
 * Decompiled with CFR 0.152.
 */
package soc.client;

import java.awt.Canvas;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import soc.client.SOCPlayerClient;
import soc.client.SOCPlayerInterface;
import soc.game.SOCGame;

public class SOCFaceButton
extends Canvas {
    public static final int DEFAULT_FACE = 1;
    private static final String IMAGEDIR = "/soc/client/images";
    public static final int NUM_FACES = 74;
    private static Image[] images;
    private int currentImageNum = 1;
    private int panelx;
    private int panely;
    private int pNumber;
    private SOCGame game;
    private SOCPlayerClient client;
    private Image buffer;

    private static synchronized void loadImages(Component c) {
        if (images == null) {
            MediaTracker tracker = new MediaTracker(c);
            Toolkit tk = c.getToolkit();
            Class<?> clazz = c.getClass();
            images = new Image[74];
            SOCFaceButton.images[0] = tk.getImage(clazz.getResource("/soc/client/images/robot.gif"));
            tracker.addImage(images[0], 0);
            for (int i = 1; i < 74; ++i) {
                SOCFaceButton.images[i] = tk.getImage(clazz.getResource("/soc/client/images/face" + i + ".gif"));
                tracker.addImage(images[i], 0);
            }
            try {
                tracker.waitForID(0);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            if (tracker.isErrorID(0)) {
                System.out.println("Error loading Face images");
            }
        }
    }

    public SOCFaceButton(SOCPlayerInterface pi, int pn) {
        this.client = pi.getClient();
        this.game = pi.getGame();
        this.pNumber = pn;
        this.setBackground(pi.getPlayerColor(pn));
        this.panelx = 40;
        this.panely = 40;
        SOCFaceButton.loadImages(this);
        this.addMouseListener(new MyMouseAdapter());
    }

    public void setFace(int id) {
        this.currentImageNum = id;
        this.repaint();
    }

    public void setDefaultFace() {
        this.setFace(1);
    }

    public Dimension getPreferedSize() {
        return new Dimension(this.panelx, this.panely);
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(this.panelx, this.panely);
    }

    @Override
    public void paint(Graphics g) {
        if (this.buffer == null) {
            this.buffer = this.createImage(this.panelx, this.panely);
        }
        this.drawFace(this.buffer.getGraphics());
        this.buffer.flush();
        g.drawImage(this.buffer, 0, 0, this);
    }

    @Override
    public void update(Graphics g) {
        this.paint(g);
    }

    private void drawFace(Graphics g) {
        g.clearRect(0, 0, 1, 2);
        g.drawImage(images[this.currentImageNum], 0, 0, this.getBackground(), this);
    }

    private class MyMouseAdapter
    extends MouseAdapter {
        private MyMouseAdapter() {
        }

        @Override
        public void mousePressed(MouseEvent evt) {
            if (SOCFaceButton.this.game.getPlayer(SOCFaceButton.this.pNumber).getName().equals(SOCFaceButton.this.client.getNickname())) {
                if (evt.getX() < 20) {
                    SOCFaceButton.this.currentImageNum--;
                    if (SOCFaceButton.this.currentImageNum <= 0) {
                        SOCFaceButton.this.currentImageNum = 73;
                    }
                } else {
                    SOCFaceButton.this.currentImageNum++;
                    if (SOCFaceButton.this.currentImageNum == 74) {
                        SOCFaceButton.this.currentImageNum = 1;
                    }
                }
                SOCFaceButton.this.client.changeFace(SOCFaceButton.this.game, SOCFaceButton.this.currentImageNum);
                SOCFaceButton.this.repaint();
            }
        }
    }
}

