/*
 * Decompiled with CFR 0.152.
 */
package soc.client;

import java.awt.Button;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import soc.client.ColorSquare;
import soc.client.SOCFaceButton;
import soc.client.SOCPlayerClient;
import soc.client.SOCPlayerInterface;
import soc.client.SquaresPanel;
import soc.client.TradeOfferPanel;
import soc.disableDebug.D;
import soc.game.SOCDevCardSet;
import soc.game.SOCGame;
import soc.game.SOCPlayer;
import soc.game.SOCResourceSet;
import soc.game.SOCTradeOffer;

public class SOCHandPanel
extends Panel
implements ActionListener {
    public static final int ROADS = 0;
    public static final int SETTLEMENTS = 1;
    public static final int CITIES = 2;
    public static final int NUMRESOURCES = 3;
    public static final int NUMDEVCARDS = 4;
    public static final int NUMKNIGHTS = 5;
    public static final int VICTORYPOINTS = 6;
    public static final int LONGESTROAD = 7;
    public static final int LARGESTARMY = 8;
    public static final int CLAY = 9;
    public static final int ORE = 10;
    public static final int SHEEP = 11;
    public static final int WHEAT = 12;
    public static final int WOOD = 13;
    protected static final int[] zero = new int[]{0, 0, 0, 0, 0};
    protected static final String SIT = "Sit Here";
    protected static final String START = "Start Game";
    protected static final String ROBOT = "Robot";
    protected static final String TAKEOVER = "Take Over";
    protected static final String LOCKSEAT = "Lock";
    protected static final String UNLOCKSEAT = "Unlock";
    protected static final String ROLL = "Roll";
    protected static final String QUIT = "Quit";
    protected static final String DONE = "Done";
    protected static final String CLEAR = "Clear";
    protected static final String SEND = "Send";
    protected static final String BANK = "Bank/Port";
    protected static final String CARD = "  Play Card  ";
    protected static final String GIVE = "I Give: ";
    protected static final String GET = "I Get: ";
    protected Button sitBut;
    protected Button robotBut;
    protected Button startBut;
    protected Button takeOverBut;
    protected Button seatLockBut;
    protected SOCFaceButton faceImg;
    protected Label pname;
    protected Label vpLab;
    protected ColorSquare vpSq;
    protected Label larmyLab;
    protected Label lroadLab;
    protected ColorSquare claySq;
    protected ColorSquare oreSq;
    protected ColorSquare sheepSq;
    protected ColorSquare wheatSq;
    protected ColorSquare woodSq;
    protected Label clayLab;
    protected Label oreLab;
    protected Label sheepLab;
    protected Label wheatLab;
    protected Label woodLab;
    protected ColorSquare settlementSq;
    protected ColorSquare citySq;
    protected ColorSquare roadSq;
    protected Label settlementLab;
    protected Label cityLab;
    protected Label roadLab;
    protected ColorSquare resourceSq;
    protected Label resourceLab;
    protected ColorSquare developmentSq;
    protected Label developmentLab;
    protected ColorSquare knightsSq;
    protected Label knightsLab;
    protected List cardList;
    protected Button playCardBut;
    protected SquaresPanel sqPanel;
    protected Label giveLab;
    protected Label getLab;
    protected Button sendBut;
    protected Button clearBut;
    protected Button bankBut;
    protected ColorSquare[] playerSend;
    protected Button rollBut;
    protected Button doneBut;
    protected Button quitBut;
    protected SOCPlayerInterface playerInterface;
    protected SOCPlayerClient client;
    protected SOCGame game;
    protected SOCPlayer player;
    protected boolean inPlay;
    protected int[] playerSendMap;
    protected TradeOfferPanel offer;
    protected boolean interactive;

    public SOCHandPanel(SOCPlayerInterface pi, SOCPlayer pl, boolean in) {
        super(null);
        this.creation(pi, pl, in);
    }

    public SOCHandPanel(SOCPlayerInterface pi, SOCPlayer pl) {
        this(pi, pl, true);
    }

    protected void creation(SOCPlayerInterface pi, SOCPlayer pl, boolean in) {
        this.playerInterface = pi;
        this.client = pi.getClient();
        this.game = pi.getGame();
        this.player = pl;
        this.interactive = in;
        this.setBackground(this.playerInterface.getPlayerColor(this.player.getPlayerNumber()));
        this.setForeground(Color.black);
        this.setFont(new Font("Helvetica", 0, 10));
        this.faceImg = new SOCFaceButton(this.playerInterface, this.player.getPlayerNumber());
        this.add(this.faceImg);
        this.pname = new Label();
        this.pname.setFont(new Font("Serif", 0, 14));
        this.add(this.pname);
        this.startBut = new Button(START);
        this.startBut.addActionListener(this);
        this.add(this.startBut);
        this.vpLab = new Label("Points: ");
        this.add(this.vpLab);
        this.vpSq = new ColorSquare(ColorSquare.GREY, 0);
        this.add(this.vpSq);
        this.larmyLab = new Label("", 1);
        this.larmyLab.setForeground(new Color(142, 45, 10));
        this.add(this.larmyLab);
        this.lroadLab = new Label("", 1);
        this.lroadLab.setForeground(new Color(142, 45, 10));
        this.add(this.lroadLab);
        this.clayLab = new Label("Clay:");
        this.add(this.clayLab);
        this.claySq = new ColorSquare(ColorSquare.CLAY, 0);
        this.add(this.claySq);
        this.oreLab = new Label("Ore:");
        this.add(this.oreLab);
        this.oreSq = new ColorSquare(ColorSquare.ORE, 0);
        this.add(this.oreSq);
        this.sheepLab = new Label("Sheep:");
        this.add(this.sheepLab);
        this.sheepSq = new ColorSquare(ColorSquare.SHEEP, 0);
        this.add(this.sheepSq);
        this.wheatLab = new Label("Wheat:");
        this.add(this.wheatLab);
        this.wheatSq = new ColorSquare(ColorSquare.WHEAT, 0);
        this.add(this.wheatSq);
        this.woodLab = new Label("Wood:");
        this.add(this.woodLab);
        this.woodSq = new ColorSquare(ColorSquare.WOOD, 0);
        this.add(this.woodSq);
        this.cardList = new List(0, false);
        this.add(this.cardList);
        this.roadSq = new ColorSquare(ColorSquare.GREY, 0);
        this.add(this.roadSq);
        this.roadLab = new Label("Roads:");
        this.add(this.roadLab);
        this.settlementSq = new ColorSquare(ColorSquare.GREY, 0);
        this.add(this.settlementSq);
        this.settlementLab = new Label("Stlmts:");
        this.add(this.settlementLab);
        this.citySq = new ColorSquare(ColorSquare.GREY, 0);
        this.add(this.citySq);
        this.cityLab = new Label("Cities:");
        this.add(this.cityLab);
        this.knightsLab = new Label("Knights: ");
        this.add(this.knightsLab);
        this.knightsSq = new ColorSquare(ColorSquare.GREY, 0);
        this.add(this.knightsSq);
        this.resourceLab = new Label("Resources: ");
        this.add(this.resourceLab);
        this.resourceSq = new ColorSquare(ColorSquare.GREY, 0);
        this.add(this.resourceSq);
        this.developmentLab = new Label("Dev. Cards: ");
        this.add(this.developmentLab);
        this.developmentSq = new ColorSquare(ColorSquare.GREY, 0);
        this.add(this.developmentSq);
        this.seatLockBut = new Button(UNLOCKSEAT);
        this.seatLockBut.addActionListener(this);
        this.seatLockBut.setEnabled(this.interactive);
        this.add(this.seatLockBut);
        this.takeOverBut = new Button(TAKEOVER);
        this.takeOverBut.addActionListener(this);
        this.takeOverBut.setEnabled(this.interactive);
        this.add(this.takeOverBut);
        this.sitBut = new Button(SIT);
        this.sitBut.addActionListener(this);
        this.sitBut.setEnabled(this.interactive);
        this.add(this.sitBut);
        this.robotBut = new Button(ROBOT);
        this.robotBut.addActionListener(this);
        this.robotBut.setEnabled(this.interactive);
        this.add(this.robotBut);
        this.playCardBut = new Button(CARD);
        this.playCardBut.addActionListener(this);
        this.playCardBut.setEnabled(this.interactive);
        this.add(this.playCardBut);
        this.giveLab = new Label(GIVE);
        this.add(this.giveLab);
        this.getLab = new Label(GET);
        this.add(this.getLab);
        this.sqPanel = new SquaresPanel(this.interactive);
        this.add(this.sqPanel);
        this.sqPanel.setVisible(false);
        this.sendBut = new Button(SEND);
        this.sendBut.addActionListener(this);
        this.sendBut.setEnabled(this.interactive);
        this.add(this.sendBut);
        this.clearBut = new Button(CLEAR);
        this.clearBut.addActionListener(this);
        this.clearBut.setEnabled(this.interactive);
        this.add(this.clearBut);
        this.bankBut = new Button(BANK);
        this.bankBut.addActionListener(this);
        this.bankBut.setEnabled(this.interactive);
        this.add(this.bankBut);
        this.playerSend = new ColorSquare[3];
        this.playerSendMap = new int[3];
        int cnt = 0;
        for (int pn = 0; pn < 4; ++pn) {
            if (pn == this.player.getPlayerNumber()) continue;
            Color color = this.playerInterface.getPlayerColor(pn);
            this.playerSendMap[cnt] = pn;
            this.playerSend[cnt] = new ColorSquare(2, true, color);
            this.playerSend[cnt].setColor(this.playerInterface.getPlayerColor(pn));
            this.playerSend[cnt].setBoolValue(true);
            this.add(this.playerSend[cnt]);
            ++cnt;
        }
        this.rollBut = new Button(ROLL);
        this.rollBut.addActionListener(this);
        this.rollBut.setEnabled(this.interactive);
        this.add(this.rollBut);
        this.doneBut = new Button(DONE);
        this.doneBut.addActionListener(this);
        this.doneBut.setEnabled(this.interactive);
        this.add(this.doneBut);
        this.quitBut = new Button(QUIT);
        this.quitBut.addActionListener(this);
        this.quitBut.setEnabled(this.interactive);
        this.add(this.quitBut);
        this.offer = new TradeOfferPanel(this, this.player.getPlayerNumber());
        this.offer.setVisible(false);
        this.add(this.offer);
        this.removePlayer();
    }

    public SOCPlayerInterface getPlayerInterface() {
        return this.playerInterface;
    }

    public SOCPlayer getPlayer() {
        return this.player;
    }

    public SOCPlayerClient getClient() {
        return this.client;
    }

    public SOCGame getGame() {
        return this.game;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String target = e.getActionCommand();
        SOCPlayerClient client = this.playerInterface.getClient();
        SOCGame game = this.playerInterface.getGame();
        if (target == LOCKSEAT) {
            client.lockSeat(game, this.player.getPlayerNumber());
        } else if (target == UNLOCKSEAT) {
            client.unlockSeat(game, this.player.getPlayerNumber());
        } else if (target == TAKEOVER) {
            client.sitDown(game, this.player.getPlayerNumber());
        } else if (target == SIT) {
            client.sitDown(game, this.player.getPlayerNumber());
        } else if (target == START) {
            client.startGame(game);
        } else if (target != ROBOT) {
            if (target == ROLL) {
                client.rollDice(game);
            } else if (target == QUIT) {
                this.playerInterface.leaveGame();
            } else if (target == DONE) {
                client.endTurn(game);
            } else if (target == CLEAR) {
                this.sqPanel.setValues(zero, zero);
                if (game.getGameState() == 20) {
                    client.clearOffer(game);
                }
            } else if (target == BANK) {
                if (game.getGameState() == 20) {
                    int[] give = new int[5];
                    int[] get = new int[5];
                    this.sqPanel.getValues(give, get);
                    client.clearOffer(game);
                    SOCResourceSet giveSet = new SOCResourceSet(give[0], give[1], give[2], give[3], give[4], 0);
                    SOCResourceSet getSet = new SOCResourceSet(get[0], get[1], get[2], get[3], get[4], 0);
                    client.bankTrade(game, giveSet, getSet);
                }
            } else if (target == SEND) {
                if (game.getGameState() == 20) {
                    int[] give = new int[5];
                    int[] get = new int[5];
                    int giveSum = 0;
                    int getSum = 0;
                    this.sqPanel.getValues(give, get);
                    for (int i = 0; i < 5; ++i) {
                        giveSum += give[i];
                        getSum += get[i];
                    }
                    SOCResourceSet giveSet = new SOCResourceSet(give[0], give[1], give[2], give[3], give[4], 0);
                    SOCResourceSet getSet = new SOCResourceSet(get[0], get[1], get[2], get[3], get[4], 0);
                    if (!this.player.getResources().contains(giveSet)) {
                        this.playerInterface.print("*** You can't offer what you don't have.");
                    } else if (giveSum == 0 || getSum == 0) {
                        this.playerInterface.print("*** A trade must contain at least one resource card from each player.");
                    } else {
                        boolean[] to = new boolean[4];
                        if (game.getCurrentPlayerNumber() == this.player.getPlayerNumber()) {
                            for (int i = 0; i < 3; ++i) {
                                if (!this.playerSend[i].getBoolValue()) continue;
                                to[this.playerSendMap[i]] = true;
                            }
                        } else {
                            to[game.getCurrentPlayerNumber()] = true;
                        }
                        SOCTradeOffer tradeOffer = new SOCTradeOffer(game.getName(), this.player.getPlayerNumber(), to, giveSet, getSet);
                        client.offerTrade(game, tradeOffer);
                    }
                }
            } else if (e.getSource() == this.cardList || target == CARD) {
                String item = this.cardList.getSelectedItem();
                int itemNum = this.cardList.getSelectedIndex();
                if (item == null || item.length() == 0) {
                    return;
                }
                if (game.getCurrentPlayerNumber() == this.player.getPlayerNumber()) {
                    if (item.equals("Knight")) {
                        if (game.canPlayKnight(this.player.getPlayerNumber())) {
                            client.playDevCard(game, 0);
                        }
                    } else if (item.equals("Road Building")) {
                        if (game.canPlayRoadBuilding(this.player.getPlayerNumber())) {
                            client.playDevCard(game, 1);
                        }
                    } else if (item.equals("Discovery")) {
                        if (game.canPlayDiscovery(this.player.getPlayerNumber())) {
                            client.playDevCard(game, 2);
                        }
                    } else if (item.equals("Monopoly") && game.canPlayMonopoly(this.player.getPlayerNumber())) {
                        client.playDevCard(game, 3);
                    }
                }
            }
        }
    }

    public void addSeatLockBut() {
        D.ebugPrintln("*** addSeatLockBut() ***");
        D.ebugPrintln("seatLockBut = " + this.seatLockBut);
        if (this.game.isSeatLocked(this.player.getPlayerNumber())) {
            this.seatLockBut.setLabel(UNLOCKSEAT);
        } else {
            this.seatLockBut.setLabel(UNLOCKSEAT);
        }
        this.seatLockBut.setVisible(true);
    }

    public void addTakeOverBut() {
        this.takeOverBut.setVisible(true);
    }

    public void addSitButton() {
        if (this.player.getName() == null) {
            this.sitBut.setVisible(true);
        }
    }

    public void addRobotButton() {
        this.robotBut.setVisible(true);
    }

    public void changeFace(int id) {
        this.faceImg.setFace(id);
    }

    public void removePlayer() {
        this.vpLab.setVisible(false);
        this.vpSq.setVisible(false);
        this.faceImg.setVisible(false);
        this.pname.setVisible(false);
        this.roadSq.setVisible(false);
        this.roadLab.setVisible(false);
        this.settlementLab.setVisible(false);
        this.settlementSq.setVisible(false);
        this.cityLab.setVisible(false);
        this.citySq.setVisible(false);
        this.knightsSq.setVisible(false);
        this.knightsLab.setVisible(false);
        this.offer.setVisible(false);
        this.larmyLab.setVisible(false);
        this.lroadLab.setVisible(false);
        if (this.game.getPlayer(this.client.getNickname()) == null) {
            if (this.game.getGameState() == 0) {
                this.sitBut.setVisible(true);
            }
        }
        this.claySq.setVisible(false);
        this.clayLab.setVisible(false);
        this.oreSq.setVisible(false);
        this.oreLab.setVisible(false);
        this.sheepSq.setVisible(false);
        this.sheepLab.setVisible(false);
        this.wheatSq.setVisible(false);
        this.wheatLab.setVisible(false);
        this.woodSq.setVisible(false);
        this.woodLab.setVisible(false);
        this.cardList.setVisible(false);
        this.playCardBut.setVisible(false);
        this.giveLab.setVisible(false);
        this.getLab.setVisible(false);
        this.sqPanel.setVisible(false);
        this.sendBut.setVisible(false);
        this.clearBut.setVisible(false);
        this.bankBut.setVisible(false);
        for (int i = 0; i < 3; ++i) {
            this.playerSend[i].setVisible(false);
        }
        this.rollBut.setVisible(false);
        this.doneBut.setVisible(false);
        this.quitBut.setVisible(false);
        this.resourceLab.setVisible(false);
        this.resourceSq.setVisible(false);
        this.developmentLab.setVisible(false);
        this.developmentSq.setVisible(false);
        this.removeTakeOverBut();
        this.removeSeatLockBut();
        this.inPlay = false;
        this.validate();
        this.repaint();
    }

    public void addPlayer(String name) {
        this.faceImg.setDefaultFace();
        this.faceImg.setVisible(true);
        this.pname.setText(name);
        this.pname.setVisible(true);
        this.larmyLab.setVisible(true);
        this.lroadLab.setVisible(true);
        this.roadSq.setVisible(true);
        this.roadLab.setVisible(true);
        this.settlementSq.setVisible(true);
        this.settlementLab.setVisible(true);
        this.citySq.setVisible(true);
        this.cityLab.setVisible(true);
        this.knightsLab.setVisible(true);
        this.knightsSq.setVisible(true);
        if (this.player.getName().equals(this.client.getNickname())) {
            int i;
            D.ebugPrintln("SOCHandPanel.addPlayer: This is our hand");
            if (this.game.getGameState() == 0) {
                this.startBut.setVisible(true);
            } else {
                this.vpLab.setVisible(true);
                this.vpSq.setVisible(true);
            }
            this.claySq.setVisible(true);
            this.clayLab.setVisible(true);
            this.oreSq.setVisible(true);
            this.oreLab.setVisible(true);
            this.sheepSq.setVisible(true);
            this.sheepLab.setVisible(true);
            this.wheatSq.setVisible(true);
            this.wheatLab.setVisible(true);
            this.woodSq.setVisible(true);
            this.woodLab.setVisible(true);
            this.cardList.setVisible(true);
            this.playCardBut.setVisible(true);
            this.giveLab.setVisible(true);
            this.getLab.setVisible(true);
            this.sqPanel.setVisible(true);
            this.sendBut.setVisible(true);
            this.clearBut.setVisible(true);
            this.bankBut.setVisible(true);
            for (i = 0; i < 3; ++i) {
                this.playerSend[i].setBoolValue(true);
                this.playerSend[i].setVisible(true);
            }
            this.rollBut.setVisible(true);
            this.doneBut.setVisible(true);
            this.quitBut.setVisible(true);
            for (i = 0; i < 4; ++i) {
                this.playerInterface.getPlayerHandPanel(i).removeSitBut();
                this.playerInterface.getPlayerHandPanel(i).removeTakeOverBut();
            }
        } else {
            D.ebugPrintln("**** SOCHandPanel.addPlayer(name) ****");
            D.ebugPrintln("player.getPlayerNumber() = " + this.player.getPlayerNumber());
            D.ebugPrintln("player.isRobot() = " + this.player.isRobot());
            D.ebugPrintln("game.isSeatLocked(" + this.player.getPlayerNumber() + ") = " + this.game.isSeatLocked(this.player.getPlayerNumber()));
            D.ebugPrintln("game.getPlayer(client.getNickname()) = " + this.game.getPlayer(this.client.getNickname()));
            if (this.player.isRobot() && this.game.getPlayer(this.client.getNickname()) == null && !this.game.isSeatLocked(this.player.getPlayerNumber())) {
                this.addTakeOverBut();
            }
            if (this.player.isRobot() && this.game.getPlayer(this.client.getNickname()) != null) {
                this.addSeatLockBut();
            } else {
                this.removeSeatLockBut();
            }
            this.vpLab.setVisible(true);
            this.vpSq.setVisible(true);
            this.resourceLab.setVisible(true);
            this.resourceSq.setVisible(true);
            this.developmentLab.setVisible(true);
            this.developmentSq.setVisible(true);
            this.removeSitBut();
            this.removeRobotBut();
        }
        this.inPlay = true;
        this.validate();
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateDevCards() {
        SOCDevCardSet cards = this.player.getDevCards();
        int[] cardTypes = new int[]{2, 0, 3, 1, 4, 5, 7, 8, 6};
        String[] cardNames = new String[]{"Discovery", "Knight", "Monopoly", "Road Building", "Capitol (1VP)", "Library (1VP)", "Temple (1VP)", "Tower (1VP)", "University (1VP)"};
        Object object = this.cardList.getTreeLock();
        synchronized (object) {
            this.cardList.removeAll();
            for (int i = 0; i < cardTypes.length; ++i) {
                int j;
                int numOld = cards.getAmount(0, cardTypes[i]);
                int numNew = cards.getAmount(1, cardTypes[i]);
                for (j = 0; j < numOld; ++j) {
                    this.cardList.add(cardNames[i]);
                }
                for (j = 0; j < numNew; ++j) {
                    String prefix = i < 4 ? "*NEW* " : "";
                    this.cardList.add(prefix + cardNames[i]);
                }
            }
        }
    }

    public void removeSeatLockBut() {
        this.seatLockBut.setVisible(false);
    }

    public void removeTakeOverBut() {
        this.takeOverBut.setVisible(false);
    }

    public void removeSitBut() {
        this.sitBut.setVisible(false);
    }

    public void removeRobotBut() {
        this.robotBut.setVisible(false);
    }

    public void removeStartBut() {
        this.vpLab.setVisible(true);
        this.vpSq.setVisible(true);
        this.startBut.setVisible(false);
    }

    public void updateCurrentOffer() {
        if (this.inPlay) {
            SOCTradeOffer currentOffer = this.player.getCurrentOffer();
            if (currentOffer != null) {
                this.offer.setOffer(currentOffer);
                this.offer.setVisible(true);
                this.offer.repaint();
            } else {
                this.clearOffer();
            }
        }
    }

    public void rejectOffer() {
        this.offer.setMessage("No thanks.");
        this.offer.setVisible(true);
        this.repaint();
    }

    public void clearTradeMsg() {
        if (this.offer.getMode() == "message") {
            this.offer.setVisible(false);
            this.repaint();
        }
    }

    public void clearOffer() {
        this.offer.setVisible(false);
        if (this.player.getName().equals(this.client.getNickname())) {
            this.sqPanel.setValues(zero, zero);
            for (int i = 0; i < 3; ++i) {
                this.playerSend[i].setBoolValue(true);
            }
        }
        this.validate();
        this.repaint();
    }

    public void updateTakeOverButton() {
        if (!this.game.isSeatLocked(this.player.getPlayerNumber()) && this.game.getCurrentPlayerNumber() != this.player.getPlayerNumber()) {
            this.takeOverBut.setLabel(TAKEOVER);
        } else {
            this.takeOverBut.setLabel("* Seat Locked *");
        }
    }

    public void updateSeatLockButton() {
        if (this.game.isSeatLocked(this.player.getPlayerNumber())) {
            this.seatLockBut.setLabel(UNLOCKSEAT);
        } else {
            this.seatLockBut.setLabel(LOCKSEAT);
        }
    }

    protected void setLArmy(boolean haveIt) {
        this.larmyLab.setText(haveIt ? "L. Army" : "");
    }

    protected void setLRoad(boolean haveIt) {
        this.lroadLab.setText(haveIt ? "L. Road" : "");
    }

    public void updateValue(int vt) {
        switch (vt) {
            case 6: {
                this.vpSq.setIntValue(this.player.getTotalVP());
                break;
            }
            case 7: {
                this.setLRoad(this.player.hasLongestRoad());
                break;
            }
            case 8: {
                this.setLArmy(this.player.hasLargestArmy());
                break;
            }
            case 9: {
                this.claySq.setIntValue(this.player.getResources().getAmount(1));
                break;
            }
            case 10: {
                this.oreSq.setIntValue(this.player.getResources().getAmount(2));
                break;
            }
            case 11: {
                this.sheepSq.setIntValue(this.player.getResources().getAmount(3));
                break;
            }
            case 12: {
                this.wheatSq.setIntValue(this.player.getResources().getAmount(4));
                break;
            }
            case 13: {
                this.woodSq.setIntValue(this.player.getResources().getAmount(5));
                break;
            }
            case 3: {
                this.resourceSq.setIntValue(this.player.getResources().getTotal());
                break;
            }
            case 0: {
                this.roadSq.setIntValue(this.player.getNumPieces(0));
                break;
            }
            case 1: {
                this.settlementSq.setIntValue(this.player.getNumPieces(1));
                break;
            }
            case 2: {
                this.citySq.setIntValue(this.player.getNumPieces(2));
                break;
            }
            case 4: {
                this.developmentSq.setIntValue(this.player.getDevCards().getTotal());
                break;
            }
            case 5: {
                this.knightsSq.setIntValue(this.player.getNumKnights());
            }
        }
    }

    @Override
    public void doLayout() {
        Dimension dim = this.getSize();
        int inset = 8;
        int space = 2;
        if (!this.inPlay) {
            this.sitBut.setBounds((dim.width - 60) / 2, (dim.height - 82) / 2, 60, 40);
        } else {
            FontMetrics fm = this.getFontMetrics(this.getFont());
            int lineH = 16;
            int stlmtsW = fm.stringWidth("Stlmts: ");
            int knightsW = fm.stringWidth("Knights: ");
            int faceW = 40;
            int pnameW = dim.width - (inset + faceW + inset + inset);
            this.faceImg.setBounds(inset, inset, faceW, faceW);
            this.pname.setBounds(inset + faceW + inset, inset, pnameW, lineH);
            if (this.player.getName().equals(this.client.getNickname())) {
                Dimension sqpDim = this.sqPanel.getSize();
                int sheepW = fm.stringWidth("Sheep: ");
                int pcW = fm.stringWidth(CARD);
                int giveW = fm.stringWidth(GIVE);
                int clearW = fm.stringWidth(CLEAR);
                int bankW = fm.stringWidth(BANK);
                int cardsH = 5 * (lineH + space);
                int tradeH = sqpDim.height + space + 2 * (lineH + space);
                int sectionSpace = (dim.height - (inset + faceW + cardsH + tradeH + lineH + inset)) / 3;
                int tradeY = inset + faceW + sectionSpace;
                int cardsY = tradeY + tradeH + sectionSpace;
                this.startBut.setBounds(inset + faceW + inset, inset + lineH + space, dim.width - (inset + faceW + inset + inset), lineH);
                int vpW = fm.stringWidth(this.vpLab.getText());
                this.vpLab.setBounds(inset + faceW + inset, inset + faceW - lineH, vpW, lineH);
                this.vpSq.setBounds(inset + faceW + inset + vpW + space, inset + faceW - lineH, 16, 16);
                int topStuffW = inset + faceW + inset + vpW + space + 16 + space;
                this.larmyLab.setBounds(topStuffW, inset + faceW - lineH, (dim.width - (topStuffW + inset + space)) / 2, lineH);
                this.lroadLab.setBounds(topStuffW + (dim.width - (topStuffW + inset + space)) / 2 + space, inset + faceW - lineH, (dim.width - (topStuffW + inset + space)) / 2, lineH);
                this.giveLab.setBounds(inset, tradeY, giveW, lineH);
                this.getLab.setBounds(inset, tradeY + lineH, giveW, lineH);
                this.sqPanel.setLocation(inset + giveW + space, tradeY);
                int tbW = (giveW + sqpDim.width) / 2;
                int tbX = inset;
                int tbY = tradeY + sqpDim.height + space;
                this.sendBut.setBounds(tbX, tbY, tbW, lineH);
                this.clearBut.setBounds(tbX, tbY + lineH + space, tbW, lineH);
                this.bankBut.setBounds(tbX + tbW + space, tbY + lineH + space, tbW, lineH);
                this.playerSend[0].setBounds(tbX + tbW + space, tbY, 16, 16);
                this.playerSend[1].setBounds(tbX + tbW + space + (tbW - 16) / 2, tbY, 16, 16);
                this.playerSend[2].setBounds(tbX + tbW + space + tbW - 16, tbY, 16, 16);
                this.knightsLab.setBounds(dim.width - inset - knightsW - 16 - space, tradeY, knightsW, lineH);
                this.knightsSq.setBounds(dim.width - inset - 16, tradeY, 16, 16);
                this.roadLab.setBounds(dim.width - inset - knightsW - 16 - space, tradeY + lineH + space, knightsW, lineH);
                this.roadSq.setBounds(dim.width - inset - 16, tradeY + lineH + space, 16, 16);
                this.settlementLab.setBounds(dim.width - inset - knightsW - 16 - space, tradeY + 2 * (lineH + space), knightsW, lineH);
                this.settlementSq.setBounds(dim.width - inset - 16, tradeY + 2 * (lineH + space), 16, 16);
                this.cityLab.setBounds(dim.width - inset - knightsW - 16 - space, tradeY + 3 * (lineH + space), knightsW, lineH);
                this.citySq.setBounds(dim.width - inset - 16, tradeY + 3 * (lineH + space), 16, 16);
                this.clayLab.setBounds(inset, cardsY, sheepW, lineH);
                this.claySq.setBounds(inset + sheepW + space, cardsY, 16, 16);
                this.oreLab.setBounds(inset, cardsY + (lineH + space), sheepW, lineH);
                this.oreSq.setBounds(inset + sheepW + space, cardsY + (lineH + space), 16, 16);
                this.sheepLab.setBounds(inset, cardsY + 2 * (lineH + space), sheepW, lineH);
                this.sheepSq.setBounds(inset + sheepW + space, cardsY + 2 * (lineH + space), 16, 16);
                this.wheatLab.setBounds(inset, cardsY + 3 * (lineH + space), sheepW, lineH);
                this.wheatSq.setBounds(inset + sheepW + space, cardsY + 3 * (lineH + space), 16, 16);
                this.woodLab.setBounds(inset, cardsY + 4 * (lineH + space), sheepW, lineH);
                this.woodSq.setBounds(inset + sheepW + space, cardsY + 4 * (lineH + space), 16, 16);
                int clW = dim.width - (inset + sheepW + space + 16 + 4 * space + inset);
                int clX = inset + sheepW + space + 16 + 4 * space;
                this.cardList.setBounds(clX, cardsY, clW, 4 * (lineH + space) - 2);
                this.playCardBut.setBounds((clW - pcW) / 2 + clX, cardsY + 4 * (lineH + space), pcW, lineH);
                int bbW = 50;
                this.quitBut.setBounds(inset, dim.height - lineH - inset, bbW, lineH);
                this.rollBut.setBounds(dim.width - (bbW + space + bbW + inset), dim.height - lineH - inset, bbW, lineH);
                this.doneBut.setBounds(dim.width - inset - bbW, dim.height - lineH - inset, bbW, lineH);
            } else {
                int balloonH = dim.height - (inset + 4 * (lineH + space) + inset);
                int dcardsW = fm.stringWidth("Dev. Cards: ");
                int vpW = fm.stringWidth(this.vpLab.getText());
                if (this.player.isRobot()) {
                    if (this.game.getPlayer(this.client.getNickname()) == null) {
                        this.takeOverBut.setBounds(10, inset + balloonH - 10, dim.width - 20, 20);
                    } else if (this.seatLockBut.isVisible()) {
                        this.seatLockBut.setBounds(inset + dcardsW + space + 16 + space, inset + balloonH + (lineH + space) + lineH / 2, dim.width - 2 * (inset + 16 + 2 * space) - stlmtsW - dcardsW, 2 * (lineH + space));
                    }
                }
                this.offer.setBounds(inset, inset + faceW + space, dim.width - 2 * inset, balloonH);
                this.offer.doLayout();
                this.vpLab.setBounds(inset + faceW + inset, inset + faceW - lineH, vpW, lineH);
                this.vpSq.setBounds(inset + faceW + inset + vpW + space, inset + faceW - lineH, 16, 16);
                int topStuffW = inset + faceW + inset + vpW + space + 16 + space;
                this.larmyLab.setBounds(topStuffW, inset + faceW - lineH, (dim.width - (topStuffW + inset + space)) / 2, lineH);
                this.lroadLab.setBounds(topStuffW + (dim.width - (topStuffW + inset + space)) / 2 + space, inset + faceW - lineH, (dim.width - (topStuffW + inset + space)) / 2, lineH);
                this.resourceLab.setBounds(inset, inset + balloonH + 2 * (lineH + space), dcardsW, lineH);
                this.resourceSq.setBounds(inset + dcardsW + space, inset + balloonH + 2 * (lineH + space), 16, 16);
                this.developmentLab.setBounds(inset, inset + balloonH + 3 * (lineH + space), dcardsW, lineH);
                this.developmentSq.setBounds(inset + dcardsW + space, inset + balloonH + 3 * (lineH + space), 16, 16);
                this.knightsLab.setBounds(inset, inset + balloonH + (lineH + space), dcardsW, lineH);
                this.knightsSq.setBounds(inset + dcardsW + space, inset + balloonH + (lineH + space), 16, 16);
                this.roadLab.setBounds(dim.width - inset - stlmtsW - 16 - space, inset + balloonH + (lineH + space), stlmtsW, lineH);
                this.roadSq.setBounds(dim.width - inset - 16, inset + balloonH + (lineH + space), 16, 16);
                this.settlementLab.setBounds(dim.width - inset - stlmtsW - 16 - space, inset + balloonH + 2 * (lineH + space), stlmtsW, lineH);
                this.settlementSq.setBounds(dim.width - inset - 16, inset + balloonH + 2 * (lineH + space), 16, 16);
                this.cityLab.setBounds(dim.width - inset - stlmtsW - 16 - space, inset + balloonH + 3 * (lineH + space), stlmtsW, lineH);
                this.citySq.setBounds(dim.width - inset - 16, inset + balloonH + 3 * (lineH + space), 16, 16);
            }
        }
    }
}

