/*
 * Decompiled with CFR 0.152.
 */
package soc.client;

import java.applet.Applet;
import java.applet.AppletContext;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import soc.client.ChannelFrame;
import soc.client.SOCHandPanel;
import soc.client.SOCPlayerInterface;
import soc.disableDebug.D;
import soc.game.SOCBoard;
import soc.game.SOCCity;
import soc.game.SOCGame;
import soc.game.SOCPlayer;
import soc.game.SOCPlayingPiece;
import soc.game.SOCResourceSet;
import soc.game.SOCRoad;
import soc.game.SOCSettlement;
import soc.game.SOCTradeOffer;
import soc.message.SOCAcceptOffer;
import soc.message.SOCBCastTextMsg;
import soc.message.SOCBankTrade;
import soc.message.SOCBoardLayout;
import soc.message.SOCBuildRequest;
import soc.message.SOCBuyCardRequest;
import soc.message.SOCCancelBuildRequest;
import soc.message.SOCChangeFace;
import soc.message.SOCChannels;
import soc.message.SOCChoosePlayer;
import soc.message.SOCChoosePlayerRequest;
import soc.message.SOCClearOffer;
import soc.message.SOCClearTradeMsg;
import soc.message.SOCDeleteChannel;
import soc.message.SOCDeleteGame;
import soc.message.SOCDevCard;
import soc.message.SOCDevCardCount;
import soc.message.SOCDiceResult;
import soc.message.SOCDiscard;
import soc.message.SOCDiscardRequest;
import soc.message.SOCDiscoveryPick;
import soc.message.SOCEndTurn;
import soc.message.SOCFirstPlayer;
import soc.message.SOCGameMembers;
import soc.message.SOCGameState;
import soc.message.SOCGameStats;
import soc.message.SOCGameTextMsg;
import soc.message.SOCGames;
import soc.message.SOCJoin;
import soc.message.SOCJoinAuth;
import soc.message.SOCJoinGame;
import soc.message.SOCJoinGameAuth;
import soc.message.SOCLargestArmy;
import soc.message.SOCLeave;
import soc.message.SOCLeaveAll;
import soc.message.SOCLeaveGame;
import soc.message.SOCLongestRoad;
import soc.message.SOCMakeOffer;
import soc.message.SOCMembers;
import soc.message.SOCMessage;
import soc.message.SOCMonopolyPick;
import soc.message.SOCMoveRobber;
import soc.message.SOCNewChannel;
import soc.message.SOCNewGame;
import soc.message.SOCPlayDevCardRequest;
import soc.message.SOCPlayerElement;
import soc.message.SOCPotentialSettlements;
import soc.message.SOCPutPiece;
import soc.message.SOCRejectConnection;
import soc.message.SOCRejectOffer;
import soc.message.SOCResourceCount;
import soc.message.SOCRollDice;
import soc.message.SOCSetPlayedDevCard;
import soc.message.SOCSetSeatLock;
import soc.message.SOCSetTurn;
import soc.message.SOCSitDown;
import soc.message.SOCStartGame;
import soc.message.SOCStatusMessage;
import soc.message.SOCTextMsg;
import soc.message.SOCTurn;
import soc.util.Version;

public class SOCPlayerClient
extends Applet
implements Runnable,
ActionListener {
    private static final String MAIN_PANEL = "main";
    private static final String MESSAGE_PANEL = "message";
    protected static String STATSPREFEX = "  [";
    protected TextField nick;
    protected TextField pass;
    protected TextField status;
    protected TextField channel;
    protected TextField game;
    protected List chlist;
    protected List gmlist;
    protected Button jc;
    protected Button jg;
    protected Label messageLabel;
    protected AppletContext ac;
    protected String lastMessage;
    protected CardLayout cardLayout;
    public String host;
    public int port;
    public Socket s;
    protected DataInputStream in;
    protected DataOutputStream out;
    protected Thread reader = null;
    protected Exception ex = null;
    protected boolean connected = false;
    public String nickname = null;
    protected String password = null;
    protected boolean gotPassword = false;
    protected Hashtable channels = new Hashtable();
    public Hashtable games = new Hashtable();
    public Hashtable playerInterfaces = new Hashtable();
    protected Vector ignoreList = new Vector();

    public SOCPlayerClient() {
        this(null, 8880);
    }

    public SOCPlayerClient(String h, int p) {
        this.host = h;
        this.port = p;
    }

    public void initVisualElements() {
        this.setFont(new Font("Monaco", 0, 12));
        this.nick = new TextField(20);
        this.pass = new TextField(20);
        this.pass.setEchoChar('*');
        this.status = new TextField(20);
        this.status.setEditable(false);
        this.channel = new TextField(20);
        this.game = new TextField(20);
        this.chlist = new List(10, false);
        this.chlist.add(" ");
        this.gmlist = new List(10, false);
        this.gmlist.add(" ");
        this.jc = new Button("Join Channel");
        this.jg = new Button("Join Game");
        this.nick.addActionListener(this);
        this.pass.addActionListener(this);
        this.channel.addActionListener(this);
        this.game.addActionListener(this);
        this.chlist.addActionListener(this);
        this.gmlist.addActionListener(this);
        this.jc.addActionListener(this);
        this.jg.addActionListener(this);
        this.ac = null;
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        Panel mainPane = new Panel(gbl);
        c.fill = 1;
        c.gridwidth = 0;
        gbl.setConstraints(this.status, c);
        mainPane.add(this.status);
        Label l = new Label();
        c.gridwidth = 0;
        gbl.setConstraints(l, c);
        mainPane.add(l);
        l = new Label("Your Nickname:");
        c.gridwidth = 1;
        gbl.setConstraints(l, c);
        mainPane.add(l);
        c.gridwidth = 1;
        gbl.setConstraints(this.nick, c);
        mainPane.add(this.nick);
        l = new Label();
        c.gridwidth = 1;
        gbl.setConstraints(l, c);
        mainPane.add(l);
        l = new Label("Optional Password:");
        c.gridwidth = 1;
        gbl.setConstraints(l, c);
        mainPane.add(l);
        c.gridwidth = 1;
        gbl.setConstraints(this.pass, c);
        mainPane.add(this.pass);
        l = new Label();
        c.gridwidth = 0;
        gbl.setConstraints(l, c);
        mainPane.add(l);
        l = new Label();
        c.gridwidth = 0;
        gbl.setConstraints(l, c);
        mainPane.add(l);
        l = new Label("New Channel:");
        c.gridwidth = 1;
        gbl.setConstraints(l, c);
        mainPane.add(l);
        c.gridwidth = 1;
        gbl.setConstraints(this.channel, c);
        mainPane.add(this.channel);
        l = new Label();
        c.gridwidth = 1;
        gbl.setConstraints(l, c);
        mainPane.add(l);
        l = new Label("New Game:");
        c.gridwidth = 1;
        gbl.setConstraints(l, c);
        mainPane.add(l);
        c.gridwidth = 1;
        gbl.setConstraints(this.game, c);
        mainPane.add(this.game);
        l = new Label();
        c.gridwidth = 0;
        gbl.setConstraints(l, c);
        mainPane.add(l);
        l = new Label();
        c.gridwidth = 0;
        gbl.setConstraints(l, c);
        mainPane.add(l);
        l = new Label();
        c.gridwidth = 1;
        gbl.setConstraints(l, c);
        mainPane.add(l);
        c.gridwidth = 1;
        gbl.setConstraints(this.jc, c);
        mainPane.add(this.jc);
        l = new Label();
        c.gridwidth = 1;
        gbl.setConstraints(l, c);
        mainPane.add(l);
        l = new Label();
        c.gridwidth = 1;
        gbl.setConstraints(l, c);
        mainPane.add(l);
        c.gridwidth = 1;
        gbl.setConstraints(this.jg, c);
        mainPane.add(this.jg);
        l = new Label();
        c.gridwidth = 0;
        gbl.setConstraints(l, c);
        mainPane.add(l);
        l = new Label("Channels");
        c.gridwidth = 2;
        gbl.setConstraints(l, c);
        mainPane.add(l);
        l = new Label();
        c.gridwidth = 1;
        gbl.setConstraints(l, c);
        mainPane.add(l);
        l = new Label("Games");
        c.gridwidth = 0;
        gbl.setConstraints(l, c);
        mainPane.add(l);
        c.gridwidth = 2;
        c.gridheight = 0;
        gbl.setConstraints(this.chlist, c);
        mainPane.add(this.chlist);
        l = new Label();
        c.gridwidth = 1;
        gbl.setConstraints(l, c);
        mainPane.add(l);
        c.gridwidth = 0;
        gbl.setConstraints(this.gmlist, c);
        mainPane.add(this.gmlist);
        this.messageLabel = new Label("", 1);
        Panel messagePane = new Panel(new BorderLayout());
        messagePane.add((Component)this.messageLabel, "Center");
        this.cardLayout = new CardLayout();
        this.setLayout(this.cardLayout);
        this.add((Component)messagePane, MESSAGE_PANEL);
        this.add((Component)mainPane, MAIN_PANEL);
        this.messageLabel.setText("Waiting to connect.");
        this.validate();
    }

    public int getHexParameter(String name) {
        String value = null;
        int iValue = -1;
        try {
            value = this.getParameter(name);
            if (value != null) {
                iValue = Integer.parseInt(value, 16);
            }
        }
        catch (Exception e) {
            System.err.println("Invalid " + name + ": " + value);
        }
        return iValue;
    }

    @Override
    public void start() {
        this.nick.requestFocus();
    }

    @Override
    public synchronized void init() {
        System.out.println("Java Settlers Client " + Version.version() + ", " + Version.copyright());
        System.out.println("Network layer based on code by Cristian Bogdan.");
        String param = null;
        int intValue = this.getHexParameter("background");
        if (intValue != -1) {
            this.setBackground(new Color(intValue));
        }
        if ((intValue = this.getHexParameter("foreground")) != -1) {
            this.setForeground(new Color(intValue));
        }
        this.initVisualElements();
        param = this.getParameter("suggestion");
        if (param != null) {
            this.channel.setText(param);
        }
        System.out.println("Getting host...");
        this.host = this.getCodeBase().getHost();
        if (this.host.equals("")) {
            this.host = null;
        }
        try {
            param = this.getParameter("PORT");
            if (param != null) {
                this.port = Integer.parseInt(param);
            }
        }
        catch (Exception e) {
            System.err.println("Invalid port: " + param);
        }
        this.connect();
    }

    public synchronized void connect() {
        String hostString = (this.host != null ? this.host : "localhost") + ":" + this.port;
        if (this.connected) {
            throw new IllegalStateException("Already connected to " + hostString);
        }
        System.out.println("Connecting to " + hostString);
        try {
            this.s = new Socket(this.host, this.port);
            this.in = new DataInputStream(this.s.getInputStream());
            this.out = new DataOutputStream(this.s.getOutputStream());
            this.connected = true;
            this.reader = new Thread(this);
            this.reader.start();
        }
        catch (Exception e) {
            this.ex = e;
            String msg = "Could not connect to the server: " + this.ex;
            System.err.println(msg);
        }
    }

    public String getNickname() {
        return this.nickname;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object target = e.getSource();
        if (target == this.jc || target == this.channel || target == this.chlist) {
            String ch;
            if (target == this.jc) {
                ch = this.channel.getText().trim();
                if (ch.length() == 0) {
                    try {
                        ch = this.chlist.getSelectedItem().trim();
                    }
                    catch (NullPointerException ex) {
                        return;
                    }
                }
            } else if (target == this.channel) {
                ch = this.channel.getText().trim();
            } else {
                try {
                    ch = this.chlist.getSelectedItem().trim();
                }
                catch (NullPointerException ex) {
                    return;
                }
            }
            if (ch.length() == 0) {
                return;
            }
            ChannelFrame cf = (ChannelFrame)this.channels.get(ch);
            if (cf == null) {
                if (this.channels.isEmpty()) {
                    String n = this.nick.getText().trim();
                    if (n.length() == 0) {
                        return;
                    }
                    this.nickname = n.length() > 20 ? n.substring(1, 20) : n;
                    if (!this.gotPassword) {
                        String p = this.pass.getText().trim();
                        this.password = p.length() > 20 ? p.substring(1, 20) : p;
                    }
                }
                this.status.setText("Talking to server...");
                this.put(SOCJoin.toCmd(this.nickname, this.password, this.host, ch));
            } else {
                cf.show();
            }
            this.channel.setText("");
            return;
        }
        if (target == this.jg || target == this.game || target == this.gmlist) {
            String gm;
            if (target == this.jg) {
                gm = this.game.getText().trim();
                if (gm.length() == 0) {
                    try {
                        gm = this.gmlist.getSelectedItem().trim();
                    }
                    catch (NullPointerException ex) {
                        return;
                    }
                }
            } else if (target == this.game) {
                gm = this.game.getText().trim();
            } else {
                try {
                    gm = this.gmlist.getSelectedItem().trim();
                }
                catch (NullPointerException ex) {
                    return;
                }
            }
            if (gm.length() == 0) {
                return;
            }
            SOCPlayerInterface pi = (SOCPlayerInterface)this.playerInterfaces.get(gm);
            if (pi == null) {
                int endOfName;
                if (this.games.isEmpty()) {
                    String n = this.nick.getText().trim();
                    if (n.length() == 0) {
                        return;
                    }
                    this.nickname = n.length() > 20 ? n.substring(1, 20) : n;
                    if (!this.gotPassword) {
                        String p = this.pass.getText().trim();
                        this.password = p.length() > 20 ? p.substring(1, 20) : p;
                    }
                }
                if ((endOfName = gm.indexOf(STATSPREFEX)) > 0) {
                    gm = gm.substring(0, endOfName);
                }
                this.status.setText("Talking to server...");
                this.put(SOCJoinGame.toCmd(this.nickname, this.password, this.host, gm));
            } else {
                pi.show();
            }
            this.game.setText("");
            return;
        }
        if (target == this.nick) {
            this.nick.transferFocus();
        }
    }

    @Override
    public void run() {
        block3: {
            try {
                while (this.connected) {
                    String s = this.in.readUTF();
                    this.treat(SOCMessage.toMsg(s));
                }
            }
            catch (IOException e) {
                if (!this.connected) break block3;
                this.ex = e;
                System.out.println("could not read from the net: " + this.ex);
                this.destroy();
            }
        }
    }

    public void resend() {
        this.put(this.lastMessage);
    }

    public synchronized boolean put(String s) {
        this.lastMessage = s;
        D.ebugPrintln("OUT - " + SOCMessage.toMsg(s));
        if (this.ex != null || !this.connected) {
            return false;
        }
        try {
            this.out.writeUTF(s);
        }
        catch (IOException e) {
            this.ex = e;
            System.err.println("could not write to the net: " + this.ex);
            this.destroy();
            return false;
        }
        return true;
    }

    public void treat(SOCMessage mes) {
        D.ebugPrintln(mes.toString());
        try {
            switch (mes.getType()) {
                case 1069: {
                    this.handleSTATUSMESSAGE((SOCStatusMessage)mes);
                    break;
                }
                case 1020: {
                    this.handleJOINAUTH((SOCJoinAuth)mes);
                    break;
                }
                case 1004: {
                    this.handleJOIN((SOCJoin)mes);
                    break;
                }
                case 1002: {
                    this.handleMEMBERS((SOCMembers)mes);
                    break;
                }
                case 1001: {
                    this.handleNEWCHANNEL((SOCNewChannel)mes);
                    break;
                }
                case 1003: {
                    this.handleCHANNELS((SOCChannels)mes);
                    break;
                }
                case 1005: {
                    this.handleTEXTMSG((SOCTextMsg)mes);
                    break;
                }
                case 1006: {
                    this.handleLEAVE((SOCLeave)mes);
                    break;
                }
                case 1007: {
                    this.handleDELETECHANNEL((SOCDeleteChannel)mes);
                    break;
                }
                case 1019: {
                    this.handleGAMES((SOCGames)mes);
                    break;
                }
                case 1021: {
                    this.handleJOINGAMEAUTH((SOCJoinGameAuth)mes);
                    break;
                }
                case 1013: {
                    this.handleJOINGAME((SOCJoinGame)mes);
                    break;
                }
                case 1011: {
                    this.handleLEAVEGAME((SOCLeaveGame)mes);
                    break;
                }
                case 1016: {
                    this.handleNEWGAME((SOCNewGame)mes);
                    break;
                }
                case 1015: {
                    this.handleDELETEGAME((SOCDeleteGame)mes);
                    break;
                }
                case 1017: {
                    this.handleGAMEMEMBERS((SOCGameMembers)mes);
                    break;
                }
                case 1061: {
                    this.handleGAMESTATS((SOCGameStats)mes);
                    break;
                }
                case 1010: {
                    this.handleGAMETEXTMSG((SOCGameTextMsg)mes);
                    break;
                }
                case 1062: {
                    this.handleBCASTTEXTMSG((SOCBCastTextMsg)mes);
                    break;
                }
                case 1012: {
                    this.handleSITDOWN((SOCSitDown)mes);
                    break;
                }
                case 1014: {
                    this.handleBOARDLAYOUT((SOCBoardLayout)mes);
                    break;
                }
                case 1018: {
                    this.handleSTARTGAME((SOCStartGame)mes);
                    break;
                }
                case 1025: {
                    this.handleGAMESTATE((SOCGameState)mes);
                    break;
                }
                case 1055: {
                    this.handleSETTURN((SOCSetTurn)mes);
                    break;
                }
                case 1054: {
                    this.handleFIRSTPLAYER((SOCFirstPlayer)mes);
                    break;
                }
                case 1026: {
                    this.handleTURN((SOCTurn)mes);
                    break;
                }
                case 1024: {
                    this.handlePLAYERELEMENT((SOCPlayerElement)mes);
                    break;
                }
                case 1063: {
                    this.handleRESOURCECOUNT((SOCResourceCount)mes);
                    break;
                }
                case 1028: {
                    this.handleDICERESULT((SOCDiceResult)mes);
                    break;
                }
                case 1009: {
                    this.handlePUTPIECE((SOCPutPiece)mes);
                    break;
                }
                case 1034: {
                    this.handleMOVEROBBER((SOCMoveRobber)mes);
                    break;
                }
                case 1029: {
                    this.handleDISCARDREQUEST((SOCDiscardRequest)mes);
                    break;
                }
                case 1036: {
                    this.handleCHOOSEPLAYERREQUEST((SOCChoosePlayerRequest)mes);
                    break;
                }
                case 1041: {
                    this.handleMAKEOFFER((SOCMakeOffer)mes);
                    break;
                }
                case 1038: {
                    this.handleCLEAROFFER((SOCClearOffer)mes);
                    break;
                }
                case 1037: {
                    this.handleREJECTOFFER((SOCRejectOffer)mes);
                    break;
                }
                case 1042: {
                    this.handleCLEARTRADEMSG((SOCClearTradeMsg)mes);
                    break;
                }
                case 1047: {
                    this.handleDEVCARDCOUNT((SOCDevCardCount)mes);
                    break;
                }
                case 1046: {
                    this.handleDEVCARD((SOCDevCard)mes);
                    break;
                }
                case 1048: {
                    this.handleSETPLAYEDDEVCARD((SOCSetPlayedDevCard)mes);
                    break;
                }
                case 1057: {
                    this.handlePOTENTIALSETTLEMENTS((SOCPotentialSettlements)mes);
                    break;
                }
                case 1058: {
                    this.handleCHANGEFACE((SOCChangeFace)mes);
                    break;
                }
                case 1059: {
                    this.handleREJECTCONNECTION((SOCRejectConnection)mes);
                    break;
                }
                case 1066: {
                    this.handleLONGESTROAD((SOCLongestRoad)mes);
                    break;
                }
                case 1067: {
                    this.handleLARGESTARMY((SOCLargestArmy)mes);
                    break;
                }
                case 1068: {
                    this.handleSETSEATLOCK((SOCSetSeatLock)mes);
                }
            }
        }
        catch (Exception e) {
            System.out.println("SOCPlayerClient treat ERROR - " + e.getMessage());
            e.printStackTrace();
        }
    }

    protected void handleSTATUSMESSAGE(SOCStatusMessage mes) {
        this.status.setText(mes.getStatus());
    }

    protected void handleJOINAUTH(SOCJoinAuth mes) {
        this.nick.setEditable(false);
        this.pass.setText("");
        this.pass.setEditable(false);
        this.gotPassword = true;
        ChannelFrame cf = new ChannelFrame(mes.getChannel(), this);
        cf.setVisible(true);
        this.channels.put(mes.getChannel(), cf);
    }

    protected void handleJOIN(SOCJoin mes) {
        ChannelFrame fr = (ChannelFrame)this.channels.get(mes.getChannel());
        fr.print("*** " + mes.getNickname() + " has joined this channel.\n");
        fr.addMember(mes.getNickname());
    }

    protected void handleMEMBERS(SOCMembers mes) {
        ChannelFrame fr = (ChannelFrame)this.channels.get(mes.getChannel());
        Enumeration membersEnum = mes.getMembers().elements();
        while (membersEnum.hasMoreElements()) {
            fr.addMember((String)membersEnum.nextElement());
        }
        fr.began();
    }

    protected void handleNEWCHANNEL(SOCNewChannel mes) {
        this.addToList(mes.getChannel(), this.chlist);
    }

    protected void handleCHANNELS(SOCChannels mes) {
        this.cardLayout.show(this, MAIN_PANEL);
        this.validate();
        this.status.setText("Login by entering nickname and then joining a channel or game.");
        Enumeration channelsEnum = mes.getChannels().elements();
        while (channelsEnum.hasMoreElements()) {
            this.addToList((String)channelsEnum.nextElement(), this.chlist);
        }
    }

    protected void handleBCASTTEXTMSG(SOCBCastTextMsg mes) {
        Enumeration channelKeysEnum = this.channels.keys();
        while (channelKeysEnum.hasMoreElements()) {
            ChannelFrame fr = (ChannelFrame)this.channels.get(channelKeysEnum.nextElement());
            fr.print("::: " + mes.getText() + " :::");
        }
        Enumeration playerInterfaceKeysEnum = this.playerInterfaces.keys();
        while (playerInterfaceKeysEnum.hasMoreElements()) {
            SOCPlayerInterface pi = (SOCPlayerInterface)this.playerInterfaces.get(playerInterfaceKeysEnum.nextElement());
            pi.chatPrint("::: " + mes.getText() + " :::");
        }
    }

    protected void handleTEXTMSG(SOCTextMsg mes) {
        ChannelFrame fr = (ChannelFrame)this.channels.get(mes.getChannel());
        if (fr != null && !this.onIgnoreList(mes.getNickname())) {
            fr.print(mes.getNickname() + ": " + mes.getText());
        }
    }

    protected void handleLEAVE(SOCLeave mes) {
        ChannelFrame fr = (ChannelFrame)this.channels.get(mes.getChannel());
        fr.print("*** " + mes.getNickname() + " left.\n");
        fr.deleteMember(mes.getNickname());
    }

    protected void handleDELETECHANNEL(SOCDeleteChannel mes) {
        this.deleteFromList(mes.getChannel(), this.chlist);
    }

    protected void handleGAMES(SOCGames mes) {
        Enumeration gamesEnum = mes.getGames().elements();
        while (gamesEnum.hasMoreElements()) {
            this.addToGameList((String)gamesEnum.nextElement());
        }
    }

    protected void handleJOINGAMEAUTH(SOCJoinGameAuth mes) {
        this.nick.setEditable(false);
        this.pass.setEditable(false);
        this.pass.setText("");
        this.gotPassword = true;
        SOCGame ga = new SOCGame(mes.getGame());
        if (ga != null) {
            SOCPlayerInterface pi = new SOCPlayerInterface(mes.getGame(), this, ga);
            pi.setVisible(true);
            this.playerInterfaces.put(mes.getGame(), pi);
            this.games.put(mes.getGame(), ga);
        }
    }

    protected void handleJOINGAME(SOCJoinGame mes) {
        SOCPlayerInterface pi = (SOCPlayerInterface)this.playerInterfaces.get(mes.getGame());
        pi.print("*** " + mes.getNickname() + " has joined this game.\n");
    }

    protected void handleLEAVEGAME(SOCLeaveGame mes) {
        String gn = mes.getGame();
        SOCGame ga = (SOCGame)this.games.get(gn);
        if (ga != null) {
            SOCPlayerInterface pi = (SOCPlayerInterface)this.playerInterfaces.get(gn);
            SOCPlayer player = ga.getPlayer(mes.getNickname());
            if (player != null) {
                pi.removePlayer(player.getPlayerNumber());
                ga.removePlayer(mes.getNickname());
            }
        }
    }

    protected void handleNEWGAME(SOCNewGame mes) {
        this.addToGameList(mes.getGame());
    }

    protected void handleDELETEGAME(SOCDeleteGame mes) {
        this.deleteFromGameList(mes.getGame());
    }

    protected void handleGAMEMEMBERS(SOCGameMembers mes) {
        SOCPlayerInterface pi = (SOCPlayerInterface)this.playerInterfaces.get(mes.getGame());
        pi.began();
    }

    protected void handleGAMESTATS(SOCGameStats mes) {
        this.updateGameStats(mes.getGame(), mes.getScores(), mes.getRobotSeats());
    }

    protected void handleGAMETEXTMSG(SOCGameTextMsg mes) {
        SOCPlayerInterface pi = (SOCPlayerInterface)this.playerInterfaces.get(mes.getGame());
        if (pi != null) {
            if (mes.getNickname().equals("Server")) {
                pi.print("* " + mes.getText());
            } else if (!this.onIgnoreList(mes.getNickname())) {
                pi.chatPrint(mes.getNickname() + ": " + mes.getText());
            }
        }
    }

    protected void handleSITDOWN(SOCSitDown mes) {
        SOCGame ga = (SOCGame)this.games.get(mes.getGame());
        if (ga != null) {
            ga.takeMonitor();
            try {
                ga.addPlayer(mes.getNickname(), mes.getPlayerNumber());
                ga.getPlayer(mes.getPlayerNumber()).setRobotFlag(mes.isRobot());
            }
            catch (Exception e) {
                ga.releaseMonitor();
                System.out.println("Exception caught - " + e);
                e.printStackTrace();
            }
            ga.releaseMonitor();
            SOCPlayerInterface pi = (SOCPlayerInterface)this.playerInterfaces.get(mes.getGame());
            pi.addPlayer(mes.getNickname(), mes.getPlayerNumber());
            if (this.nickname.equals(mes.getNickname())) {
                pi.getBoardPanel().setPlayer();
                ga.getPlayer(mes.getPlayerNumber()).setFaceId(1);
                this.changeFace(ga, 1);
            }
            SOCHandPanel hp = pi.getPlayerHandPanel(mes.getPlayerNumber());
            hp.updateValue(0);
            hp.updateValue(1);
            hp.updateValue(2);
            hp.updateValue(5);
            hp.updateValue(6);
            hp.updateValue(7);
            hp.updateValue(8);
            if (this.nickname.equals(mes.getNickname())) {
                hp.updateValue(9);
                hp.updateValue(10);
                hp.updateValue(11);
                hp.updateValue(12);
                hp.updateValue(13);
                hp.updateDevCards();
            } else {
                hp.updateValue(3);
                hp.updateValue(4);
            }
        }
    }

    protected void handleBOARDLAYOUT(SOCBoardLayout mes) {
        SOCGame ga = (SOCGame)this.games.get(mes.getGame());
        if (ga != null) {
            SOCBoard bd = ga.getBoard();
            bd.setHexLayout(mes.getHexLayout());
            bd.setNumberLayout(mes.getNumberLayout());
            bd.setRobberHex(mes.getRobberHex());
            SOCPlayerInterface pi = (SOCPlayerInterface)this.playerInterfaces.get(mes.getGame());
            pi.getBoardPanel().repaint();
        }
    }

    protected void handleSTARTGAME(SOCStartGame mes) {
        SOCPlayerInterface pi = (SOCPlayerInterface)this.playerInterfaces.get(mes.getGame());
        pi.startGame();
    }

    protected void handleGAMESTATE(SOCGameState mes) {
        SOCGame ga = (SOCGame)this.games.get(mes.getGame());
        if (ga != null) {
            SOCPlayerInterface pi = (SOCPlayerInterface)this.playerInterfaces.get(mes.getGame());
            if (ga.getGameState() == 0) {
                if (mes.getState() != 0) {
                    pi.startGame();
                }
            }
            ga.setGameState(mes.getState());
            pi.getBoardPanel().updateMode();
            pi.getBuildingPanel().updateButtonStatus();
            pi.getBoardPanel().repaint();
            SOCPlayer ourPlayerData = ga.getPlayer(this.nickname);
            if (ourPlayerData != null && ourPlayerData.getPlayerNumber() == ga.getCurrentPlayerNumber()) {
                if (mes.getState() == 52) {
                    pi.showDiscoveryDialog();
                }
                if (mes.getState() == 53) {
                    pi.showMonopolyDialog();
                }
            }
        }
    }

    protected void handleSETTURN(SOCSetTurn mes) {
        SOCGame ga = (SOCGame)this.games.get(mes.getGame());
        if (ga != null) {
            ga.setCurrentPlayerNumber(mes.getPlayerNumber());
            SOCPlayerInterface pi = (SOCPlayerInterface)this.playerInterfaces.get(mes.getGame());
            pi.getBoardPanel().repaint();
            for (int i = 0; i < 4; ++i) {
                pi.getPlayerHandPanel(i).updateTakeOverButton();
            }
        }
    }

    protected void handleFIRSTPLAYER(SOCFirstPlayer mes) {
        SOCGame ga = (SOCGame)this.games.get(mes.getGame());
        if (ga != null) {
            ga.setFirstPlayer(mes.getPlayerNumber());
        }
    }

    protected void handleTURN(SOCTurn mes) {
        SOCGame ga = (SOCGame)this.games.get(mes.getGame());
        if (ga != null) {
            if (ga.getFirstPlayer() == -1) {
                ga.setFirstPlayer(mes.getPlayerNumber());
            }
            ga.setCurrentDice(0);
            ga.setCurrentPlayerNumber(mes.getPlayerNumber());
            ga.getPlayer(mes.getPlayerNumber()).getDevCards().newToOld();
            SOCPlayerInterface pi = (SOCPlayerInterface)this.playerInterfaces.get(mes.getGame());
            pi.getPlayerHandPanel(mes.getPlayerNumber()).updateDevCards();
            for (int i = 0; i < 4; ++i) {
                pi.getPlayerHandPanel(i).updateTakeOverButton();
            }
            pi.getBoardPanel().updateMode();
            pi.getBoardPanel().repaint();
        }
    }

    protected void handlePLAYERELEMENT(SOCPlayerElement mes) {
        SOCGame ga = (SOCGame)this.games.get(mes.getGame());
        if (ga != null) {
            SOCPlayer pl = ga.getPlayer(mes.getPlayerNumber());
            SOCPlayerInterface pi = (SOCPlayerInterface)this.playerInterfaces.get(mes.getGame());
            switch (mes.getElementType()) {
                case 10: {
                    switch (mes.getAction()) {
                        case 100: {
                            pl.setNumPieces(0, mes.getValue());
                            break;
                        }
                        case 101: {
                            pl.setNumPieces(0, pl.getNumPieces(0) + mes.getValue());
                            break;
                        }
                        case 102: {
                            pl.setNumPieces(0, pl.getNumPieces(0) - mes.getValue());
                        }
                    }
                    pi.getPlayerHandPanel(mes.getPlayerNumber()).updateValue(0);
                    break;
                }
                case 11: {
                    switch (mes.getAction()) {
                        case 100: {
                            pl.setNumPieces(1, mes.getValue());
                            break;
                        }
                        case 101: {
                            pl.setNumPieces(1, pl.getNumPieces(1) + mes.getValue());
                            break;
                        }
                        case 102: {
                            pl.setNumPieces(1, pl.getNumPieces(1) - mes.getValue());
                        }
                    }
                    pi.getPlayerHandPanel(mes.getPlayerNumber()).updateValue(1);
                    break;
                }
                case 12: {
                    switch (mes.getAction()) {
                        case 100: {
                            pl.setNumPieces(2, mes.getValue());
                            break;
                        }
                        case 101: {
                            pl.setNumPieces(2, pl.getNumPieces(2) + mes.getValue());
                            break;
                        }
                        case 102: {
                            pl.setNumPieces(2, pl.getNumPieces(2) - mes.getValue());
                        }
                    }
                    pi.getPlayerHandPanel(mes.getPlayerNumber()).updateValue(2);
                    break;
                }
                case 15: {
                    switch (mes.getAction()) {
                        case 100: {
                            pl.setNumKnights(mes.getValue());
                            break;
                        }
                        case 101: {
                            pl.setNumKnights(pl.getNumKnights() + mes.getValue());
                            break;
                        }
                        case 102: {
                            pl.setNumKnights(pl.getNumKnights() - mes.getValue());
                        }
                    }
                    ga.updateLargestArmy();
                    pi.getPlayerHandPanel(mes.getPlayerNumber()).updateValue(5);
                    for (int i = 0; i < 4; ++i) {
                        pi.getPlayerHandPanel(i).updateValue(8);
                        pi.getPlayerHandPanel(i).updateValue(6);
                    }
                    break;
                }
                case 1: {
                    switch (mes.getAction()) {
                        case 100: {
                            pl.getResources().setAmount(mes.getValue(), 1);
                            break;
                        }
                        case 101: {
                            pl.getResources().add(mes.getValue(), 1);
                            break;
                        }
                        case 102: {
                            if (pl.getResources().getAmount(1) >= mes.getValue()) {
                                pl.getResources().subtract(mes.getValue(), 1);
                                break;
                            }
                            pl.getResources().subtract(mes.getValue() - pl.getResources().getAmount(1), 6);
                            pl.getResources().setAmount(0, 1);
                        }
                    }
                    if (this.nickname.equals(pl.getName())) {
                        pi.getPlayerHandPanel(mes.getPlayerNumber()).updateValue(9);
                        break;
                    }
                    pi.getPlayerHandPanel(mes.getPlayerNumber()).updateValue(3);
                    break;
                }
                case 2: {
                    switch (mes.getAction()) {
                        case 100: {
                            pl.getResources().setAmount(mes.getValue(), 2);
                            break;
                        }
                        case 101: {
                            pl.getResources().add(mes.getValue(), 2);
                            break;
                        }
                        case 102: {
                            if (pl.getResources().getAmount(2) >= mes.getValue()) {
                                pl.getResources().subtract(mes.getValue(), 2);
                                break;
                            }
                            pl.getResources().subtract(mes.getValue() - pl.getResources().getAmount(2), 6);
                            pl.getResources().setAmount(0, 2);
                        }
                    }
                    if (this.nickname.equals(pl.getName())) {
                        pi.getPlayerHandPanel(mes.getPlayerNumber()).updateValue(10);
                        break;
                    }
                    pi.getPlayerHandPanel(mes.getPlayerNumber()).updateValue(3);
                    break;
                }
                case 3: {
                    switch (mes.getAction()) {
                        case 100: {
                            pl.getResources().setAmount(mes.getValue(), 3);
                            break;
                        }
                        case 101: {
                            pl.getResources().add(mes.getValue(), 3);
                            break;
                        }
                        case 102: {
                            if (pl.getResources().getAmount(3) >= mes.getValue()) {
                                pl.getResources().subtract(mes.getValue(), 3);
                                break;
                            }
                            pl.getResources().subtract(mes.getValue() - pl.getResources().getAmount(3), 6);
                            pl.getResources().setAmount(0, 3);
                        }
                    }
                    if (this.nickname.equals(pl.getName())) {
                        pi.getPlayerHandPanel(mes.getPlayerNumber()).updateValue(11);
                        break;
                    }
                    pi.getPlayerHandPanel(mes.getPlayerNumber()).updateValue(3);
                    break;
                }
                case 4: {
                    switch (mes.getAction()) {
                        case 100: {
                            pl.getResources().setAmount(mes.getValue(), 4);
                            break;
                        }
                        case 101: {
                            pl.getResources().add(mes.getValue(), 4);
                            break;
                        }
                        case 102: {
                            if (pl.getResources().getAmount(4) >= mes.getValue()) {
                                pl.getResources().subtract(mes.getValue(), 4);
                                break;
                            }
                            pl.getResources().subtract(mes.getValue() - pl.getResources().getAmount(4), 6);
                            pl.getResources().setAmount(0, 4);
                        }
                    }
                    if (this.nickname.equals(pl.getName())) {
                        pi.getPlayerHandPanel(mes.getPlayerNumber()).updateValue(12);
                        break;
                    }
                    pi.getPlayerHandPanel(mes.getPlayerNumber()).updateValue(3);
                    break;
                }
                case 5: {
                    switch (mes.getAction()) {
                        case 100: {
                            pl.getResources().setAmount(mes.getValue(), 5);
                            break;
                        }
                        case 101: {
                            pl.getResources().add(mes.getValue(), 5);
                            break;
                        }
                        case 102: {
                            if (pl.getResources().getAmount(5) >= mes.getValue()) {
                                pl.getResources().subtract(mes.getValue(), 5);
                                break;
                            }
                            pl.getResources().subtract(mes.getValue() - pl.getResources().getAmount(5), 6);
                            pl.getResources().setAmount(0, 5);
                        }
                    }
                    if (this.nickname.equals(pl.getName())) {
                        pi.getPlayerHandPanel(mes.getPlayerNumber()).updateValue(13);
                        break;
                    }
                    pi.getPlayerHandPanel(mes.getPlayerNumber()).updateValue(3);
                    break;
                }
                case 6: {
                    switch (mes.getAction()) {
                        case 100: {
                            pl.getResources().setAmount(mes.getValue(), 6);
                            break;
                        }
                        case 101: {
                            pl.getResources().add(mes.getValue(), 6);
                            break;
                        }
                        case 102: {
                            SOCResourceSet rs = pl.getResources();
                            rs.add(rs.getAmount(1), 6);
                            rs.setAmount(0, 1);
                            rs.add(rs.getAmount(2), 6);
                            rs.setAmount(0, 2);
                            rs.add(rs.getAmount(3), 6);
                            rs.setAmount(0, 3);
                            rs.add(rs.getAmount(4), 6);
                            rs.setAmount(0, 4);
                            rs.add(rs.getAmount(5), 6);
                            rs.setAmount(0, 5);
                            pl.getResources().subtract(mes.getValue(), 6);
                        }
                    }
                    pi.getPlayerHandPanel(mes.getPlayerNumber()).updateValue(3);
                }
            }
            if (this.nickname.equals(pl.getName()) && ga.getGameState() != 0) {
                pi.getBuildingPanel().updateButtonStatus();
            }
        }
    }

    protected void handleRESOURCECOUNT(SOCResourceCount mes) {
        SOCGame ga = (SOCGame)this.games.get(mes.getGame());
        if (ga != null) {
            SOCPlayer pl = ga.getPlayer(mes.getPlayerNumber());
            SOCPlayerInterface pi = (SOCPlayerInterface)this.playerInterfaces.get(mes.getGame());
            if (mes.getCount() != pl.getResources().getTotal()) {
                SOCResourceSet rsrcs = pl.getResources();
                if (!pl.getName().equals(this.nickname)) {
                    rsrcs.clear();
                    rsrcs.setAmount(mes.getCount(), 6);
                    pi.getPlayerHandPanel(mes.getPlayerNumber()).updateValue(3);
                }
            }
        }
    }

    protected void handleDICERESULT(SOCDiceResult mes) {
        SOCGame ga = (SOCGame)this.games.get(mes.getGame());
        if (ga != null) {
            SOCPlayerInterface pi = (SOCPlayerInterface)this.playerInterfaces.get(mes.getGame());
            ga.setCurrentDice(mes.getResult());
            pi.getBoardPanel().repaint();
        }
    }

    protected void handlePUTPIECE(SOCPutPiece mes) {
        SOCGame ga = (SOCGame)this.games.get(mes.getGame());
        if (ga != null) {
            SOCPlayer pl = ga.getPlayer(mes.getPlayerNumber());
            SOCPlayerInterface pi = (SOCPlayerInterface)this.playerInterfaces.get(mes.getGame());
            switch (mes.getPieceType()) {
                case 0: {
                    SOCRoad rd = new SOCRoad(pl, mes.getCoordinates());
                    ga.putPiece(rd);
                    pi.getPlayerHandPanel(mes.getPlayerNumber()).updateValue(0);
                    for (int i = 0; i < 4; ++i) {
                        pi.getPlayerHandPanel(i).updateValue(7);
                        pi.getPlayerHandPanel(i).updateValue(6);
                    }
                    break;
                }
                case 1: {
                    SOCSettlement se = new SOCSettlement(pl, mes.getCoordinates());
                    ga.putPiece(se);
                    pi.getPlayerHandPanel(mes.getPlayerNumber()).updateValue(1);
                    for (int i = 0; i < 4; ++i) {
                        pi.getPlayerHandPanel(i).updateValue(7);
                        pi.getPlayerHandPanel(i).updateValue(6);
                    }
                    if (this.nickname.equals(pl.getName())) {
                        pi.getPlayerHandPanel(mes.getPlayerNumber()).updateValue(9);
                        pi.getPlayerHandPanel(mes.getPlayerNumber()).updateValue(10);
                        pi.getPlayerHandPanel(mes.getPlayerNumber()).updateValue(11);
                        pi.getPlayerHandPanel(mes.getPlayerNumber()).updateValue(12);
                        pi.getPlayerHandPanel(mes.getPlayerNumber()).updateValue(13);
                        break;
                    }
                    pi.getPlayerHandPanel(mes.getPlayerNumber()).updateValue(3);
                    break;
                }
                case 2: {
                    SOCCity ci = new SOCCity(pl, mes.getCoordinates());
                    ga.putPiece(ci);
                    pi.getPlayerHandPanel(mes.getPlayerNumber()).updateValue(1);
                    pi.getPlayerHandPanel(mes.getPlayerNumber()).updateValue(2);
                }
            }
            pi.getPlayerHandPanel(mes.getPlayerNumber()).updateValue(6);
            pi.getBoardPanel().repaint();
            pi.getBuildingPanel().updateButtonStatus();
        }
    }

    protected void handleMOVEROBBER(SOCMoveRobber mes) {
        SOCGame ga = (SOCGame)this.games.get(mes.getGame());
        if (ga != null) {
            SOCPlayerInterface pi = (SOCPlayerInterface)this.playerInterfaces.get(mes.getGame());
            ga.getBoard().setRobberHex(mes.getCoordinates());
            pi.getBoardPanel().repaint();
        }
    }

    protected void handleDISCARDREQUEST(SOCDiscardRequest mes) {
        SOCPlayerInterface pi = (SOCPlayerInterface)this.playerInterfaces.get(mes.getGame());
        pi.showDiscardDialog(mes.getNumberOfDiscards());
    }

    protected void handleCHOOSEPLAYERREQUEST(SOCChoosePlayerRequest mes) {
        SOCPlayerInterface pi = (SOCPlayerInterface)this.playerInterfaces.get(mes.getGame());
        int[] choices = new int[4];
        boolean[] ch = mes.getChoices();
        int count = 0;
        for (int i = 0; i < 4; ++i) {
            if (!ch[i]) continue;
            choices[count] = i;
            ++count;
        }
        pi.choosePlayer(count, choices);
    }

    protected void handleMAKEOFFER(SOCMakeOffer mes) {
        SOCGame ga = (SOCGame)this.games.get(mes.getGame());
        if (ga != null) {
            SOCPlayerInterface pi = (SOCPlayerInterface)this.playerInterfaces.get(mes.getGame());
            SOCTradeOffer offer = mes.getOffer();
            ga.getPlayer(offer.getFrom()).setCurrentOffer(offer);
            pi.getPlayerHandPanel(offer.getFrom()).updateCurrentOffer();
        }
    }

    protected void handleCLEAROFFER(SOCClearOffer mes) {
        SOCGame ga = (SOCGame)this.games.get(mes.getGame());
        if (ga != null) {
            SOCPlayerInterface pi = (SOCPlayerInterface)this.playerInterfaces.get(mes.getGame());
            ga.getPlayer(mes.getPlayerNumber()).setCurrentOffer(null);
            pi.getPlayerHandPanel(mes.getPlayerNumber()).updateCurrentOffer();
        }
    }

    protected void handleREJECTOFFER(SOCRejectOffer mes) {
        SOCPlayerInterface pi = (SOCPlayerInterface)this.playerInterfaces.get(mes.getGame());
        pi.getPlayerHandPanel(mes.getPlayerNumber()).rejectOffer();
    }

    protected void handleCLEARTRADEMSG(SOCClearTradeMsg mes) {
        SOCPlayerInterface pi = (SOCPlayerInterface)this.playerInterfaces.get(mes.getGame());
        pi.getPlayerHandPanel(mes.getPlayerNumber()).clearTradeMsg();
    }

    protected void handleDEVCARDCOUNT(SOCDevCardCount mes) {
        SOCGame ga = (SOCGame)this.games.get(mes.getGame());
        if (ga != null) {
            ga.setNumDevCards(mes.getNumDevCards());
        }
    }

    protected void handleDEVCARD(SOCDevCard mes) {
        SOCGame ga = (SOCGame)this.games.get(mes.getGame());
        if (ga != null) {
            SOCPlayer player = ga.getPlayer(mes.getPlayerNumber());
            SOCPlayerInterface pi = (SOCPlayerInterface)this.playerInterfaces.get(mes.getGame());
            switch (mes.getAction()) {
                case 0: {
                    player.getDevCards().add(1, 1, mes.getCardType());
                    break;
                }
                case 1: {
                    player.getDevCards().subtract(1, 0, mes.getCardType());
                    break;
                }
                case 3: {
                    player.getDevCards().add(1, 0, mes.getCardType());
                    break;
                }
                case 2: {
                    player.getDevCards().add(1, 1, mes.getCardType());
                }
            }
            SOCPlayer ourPlayerData = ga.getPlayer(this.nickname);
            if (ourPlayerData != null) {
                if (mes.getPlayerNumber() == ourPlayerData.getPlayerNumber()) {
                    pi.getPlayerHandPanel(mes.getPlayerNumber()).updateDevCards();
                    pi.getPlayerHandPanel(mes.getPlayerNumber()).updateValue(6);
                } else {
                    pi.getPlayerHandPanel(mes.getPlayerNumber()).updateValue(4);
                }
            } else {
                pi.getPlayerHandPanel(mes.getPlayerNumber()).updateValue(4);
            }
        }
    }

    protected void handleSETPLAYEDDEVCARD(SOCSetPlayedDevCard mes) {
        SOCGame ga = (SOCGame)this.games.get(mes.getGame());
        if (ga != null) {
            SOCPlayer player = ga.getPlayer(mes.getPlayerNumber());
            player.setPlayedDevCard(mes.hasPlayedDevCard());
        }
    }

    protected void handlePOTENTIALSETTLEMENTS(SOCPotentialSettlements mes) {
        SOCGame ga = (SOCGame)this.games.get(mes.getGame());
        if (ga != null) {
            SOCPlayer player = ga.getPlayer(mes.getPlayerNumber());
            player.setPotentialSettlements(mes.getPotentialSettlements());
        }
    }

    protected void handleCHANGEFACE(SOCChangeFace mes) {
        SOCGame ga = (SOCGame)this.games.get(mes.getGame());
        if (ga != null) {
            SOCPlayer player = ga.getPlayer(mes.getPlayerNumber());
            SOCPlayerInterface pi = (SOCPlayerInterface)this.playerInterfaces.get(mes.getGame());
            player.setFaceId(mes.getFaceId());
            pi.changeFace(mes.getPlayerNumber(), mes.getFaceId());
        }
    }

    protected void handleREJECTCONNECTION(SOCRejectConnection mes) {
        this.disconnect();
        this.messageLabel.setText(mes.getText());
        this.cardLayout.show(this, MESSAGE_PANEL);
        this.validate();
    }

    protected void handleLONGESTROAD(SOCLongestRoad mes) {
        SOCGame ga = (SOCGame)this.games.get(mes.getGame());
        if (ga != null) {
            if (mes.getPlayerNumber() == -1) {
                ga.setPlayerWithLongestRoad(null);
            } else {
                ga.setPlayerWithLongestRoad(ga.getPlayer(mes.getPlayerNumber()));
            }
            SOCPlayerInterface pi = (SOCPlayerInterface)this.playerInterfaces.get(mes.getGame());
            for (int i = 0; i < 4; ++i) {
                pi.getPlayerHandPanel(i).updateValue(7);
                pi.getPlayerHandPanel(i).updateValue(6);
            }
        }
    }

    protected void handleLARGESTARMY(SOCLargestArmy mes) {
        SOCGame ga = (SOCGame)this.games.get(mes.getGame());
        if (ga != null) {
            if (mes.getPlayerNumber() == -1) {
                ga.setPlayerWithLargestArmy(null);
            } else {
                ga.setPlayerWithLargestArmy(ga.getPlayer(mes.getPlayerNumber()));
            }
            SOCPlayerInterface pi = (SOCPlayerInterface)this.playerInterfaces.get(mes.getGame());
            for (int i = 0; i < 4; ++i) {
                pi.getPlayerHandPanel(i).updateValue(8);
                pi.getPlayerHandPanel(i).updateValue(6);
            }
        }
    }

    protected void handleSETSEATLOCK(SOCSetSeatLock mes) {
        SOCGame ga = (SOCGame)this.games.get(mes.getGame());
        if (ga != null) {
            if (mes.getLockState()) {
                ga.lockSeat(mes.getPlayerNumber());
            } else {
                ga.unlockSeat(mes.getPlayerNumber());
            }
            SOCPlayerInterface pi = (SOCPlayerInterface)this.playerInterfaces.get(mes.getGame());
            for (int i = 0; i < 4; ++i) {
                pi.getPlayerHandPanel(i).updateSeatLockButton();
                pi.getPlayerHandPanel(i).updateTakeOverButton();
            }
        }
    }

    public void addToGameList(String thing) {
        String gameName = thing;
        if (this.gmlist.getItem(0).equals(" ")) {
            this.gmlist.replaceItem(gameName, 0);
            this.gmlist.select(0);
        } else {
            this.gmlist.add(gameName, 0);
        }
    }

    public void addToList(String thing, List lst) {
        if (lst.getItem(0).equals(" ")) {
            lst.replaceItem(thing, 0);
            lst.select(0);
        } else {
            lst.add(thing, 0);
        }
    }

    public void updateGameStats(String gameName, int[] scores, boolean[] robots) {
        String testString = gameName + STATSPREFEX;
        for (int i = 0; i < this.gmlist.getItemCount(); ++i) {
            if (!this.gmlist.getItem(i).startsWith(testString)) continue;
            String updatedString = gameName + STATSPREFEX;
            for (int pn = 0; pn < 3; ++pn) {
                if (scores[pn] != -1) {
                    updatedString = robots[pn] ? updatedString + "#" : updatedString + "o";
                    updatedString = updatedString + scores[pn] + " ";
                    continue;
                }
                updatedString = updatedString + "-- ";
            }
            if (scores[3] != -1) {
                updatedString = robots[3] ? updatedString + "#" : updatedString + "o";
                updatedString = updatedString + scores[3] + "]";
            } else {
                updatedString = updatedString + "--]";
            }
            this.gmlist.replaceItem(updatedString, i);
            break;
        }
    }

    public void deleteFromGameList(String gameName) {
        String testString = gameName;
        if (this.gmlist.getItemCount() == 1) {
            if (this.gmlist.getItem(0).startsWith(testString)) {
                this.gmlist.replaceItem(" ", 0);
                this.gmlist.deselect(0);
            }
            return;
        }
        for (int i = this.gmlist.getItemCount() - 1; i >= 0; --i) {
            if (!this.gmlist.getItem(i).startsWith(testString)) continue;
            this.gmlist.remove(i);
        }
        if (this.gmlist.getSelectedIndex() == -1) {
            this.gmlist.select(this.gmlist.getItemCount() - 1);
        }
    }

    public void deleteFromList(String thing, List lst) {
        if (lst.getItemCount() == 1) {
            if (lst.getItem(0).equals(thing)) {
                lst.replaceItem(" ", 0);
                lst.deselect(0);
            }
            return;
        }
        for (int i = lst.getItemCount() - 1; i >= 0; --i) {
            if (!lst.getItem(i).equals(thing)) continue;
            lst.remove(i);
        }
        if (lst.getSelectedIndex() == -1) {
            lst.select(lst.getItemCount() - 1);
        }
    }

    public void chSend(String ch, String mes) {
        if (!this.doLocalCommand(ch, mes)) {
            this.put(SOCTextMsg.toCmd(ch, this.nickname, mes));
        }
    }

    public void leaveChannel(String ch) {
        this.channels.remove(ch);
        this.put(SOCLeave.toCmd(this.nickname, this.host, ch));
    }

    protected synchronized void disconnect() {
        this.connected = false;
        try {
            this.s.close();
        }
        catch (Exception e) {
            this.ex = e;
        }
    }

    public void buyDevCard(SOCGame ga) {
        this.put(SOCBuyCardRequest.toCmd(ga.getName()));
    }

    public void buildRequest(SOCGame ga, int piece) {
        this.put(SOCBuildRequest.toCmd(ga.getName(), piece));
    }

    public void cancelBuildRequest(SOCGame ga, int piece) {
        this.put(SOCCancelBuildRequest.toCmd(ga.getName(), piece));
    }

    public void putPiece(SOCGame ga, SOCPlayingPiece pp) {
        this.put(SOCPutPiece.toCmd(ga.getName(), pp.getPlayer().getPlayerNumber(), pp.getType(), pp.getCoordinates()));
    }

    public void moveRobber(SOCGame ga, SOCPlayer pl, int coord) {
        this.put(SOCMoveRobber.toCmd(ga.getName(), pl.getPlayerNumber(), coord));
    }

    public void sendText(SOCGame ga, String me) {
        if (!this.doLocalCommand(ga, me)) {
            this.put(SOCGameTextMsg.toCmd(ga.getName(), this.nickname, me));
        }
    }

    public void leaveGame(SOCGame ga) {
        this.playerInterfaces.remove(ga.getName());
        this.games.remove(ga.getName());
        this.put(SOCLeaveGame.toCmd(this.nickname, this.host, ga.getName()));
    }

    public void sitDown(SOCGame ga, int pn) {
        this.put(SOCSitDown.toCmd(ga.getName(), "dummy", pn, false));
    }

    public void startGame(SOCGame ga) {
        this.put(SOCStartGame.toCmd(ga.getName()));
    }

    public void rollDice(SOCGame ga) {
        this.put(SOCRollDice.toCmd(ga.getName()));
    }

    public void endTurn(SOCGame ga) {
        this.put(SOCEndTurn.toCmd(ga.getName()));
    }

    public void discard(SOCGame ga, SOCResourceSet rs) {
        this.put(SOCDiscard.toCmd(ga.getName(), rs));
    }

    public void choosePlayer(SOCGame ga, int pn) {
        this.put(SOCChoosePlayer.toCmd(ga.getName(), pn));
    }

    public void rejectOffer(SOCGame ga) {
        this.put(SOCRejectOffer.toCmd(ga.getName(), ga.getPlayer(this.nickname).getPlayerNumber()));
    }

    public void acceptOffer(SOCGame ga, int from) {
        this.put(SOCAcceptOffer.toCmd(ga.getName(), ga.getPlayer(this.nickname).getPlayerNumber(), from));
    }

    public void clearOffer(SOCGame ga) {
        this.put(SOCClearOffer.toCmd(ga.getName(), ga.getPlayer(this.nickname).getPlayerNumber()));
    }

    public void bankTrade(SOCGame ga, SOCResourceSet give, SOCResourceSet get) {
        this.put(SOCBankTrade.toCmd(ga.getName(), give, get));
    }

    public void offerTrade(SOCGame ga, SOCTradeOffer offer) {
        this.put(SOCMakeOffer.toCmd(ga.getName(), offer));
    }

    public void playDevCard(SOCGame ga, int dc) {
        this.put(SOCPlayDevCardRequest.toCmd(ga.getName(), dc));
    }

    public void discoveryPick(SOCGame ga, SOCResourceSet rscs) {
        this.put(SOCDiscoveryPick.toCmd(ga.getName(), rscs));
    }

    public void monopolyPick(SOCGame ga, int res) {
        this.put(SOCMonopolyPick.toCmd(ga.getName(), res));
    }

    public void changeFace(SOCGame ga, int id) {
        this.put(SOCChangeFace.toCmd(ga.getName(), ga.getPlayer(this.nickname).getPlayerNumber(), id));
    }

    public void lockSeat(SOCGame ga, int pn) {
        this.put(SOCSetSeatLock.toCmd(ga.getName(), pn, true));
    }

    public void unlockSeat(SOCGame ga, int pn) {
        this.put(SOCSetSeatLock.toCmd(ga.getName(), pn, false));
    }

    public boolean doLocalCommand(String ch, String cmd) {
        ChannelFrame fr = (ChannelFrame)this.channels.get(ch);
        if (cmd.startsWith("\\ignore ")) {
            String name = cmd.substring(8);
            this.addToIgnoreList(name);
            fr.print("* Ignoring " + name);
            fr.print("* Ignore list:");
            Enumeration enum1 = this.ignoreList.elements();
            while (enum1.hasMoreElements()) {
                String s = (String)enum1.nextElement();
                fr.print("* " + s);
            }
            return true;
        }
        if (cmd.startsWith("\\unignore ")) {
            String name = cmd.substring(10);
            this.removeFromIgnoreList(name);
            fr.print("* Unignoring " + name);
            fr.print("* Ignore list:");
            Enumeration enum1 = this.ignoreList.elements();
            while (enum1.hasMoreElements()) {
                String s = (String)enum1.nextElement();
                fr.print("* " + s);
            }
            return true;
        }
        return false;
    }

    public boolean doLocalCommand(SOCGame ga, String cmd) {
        SOCPlayerInterface pi = (SOCPlayerInterface)this.playerInterfaces.get(ga.getName());
        if (cmd.startsWith("\\ignore ")) {
            String name = cmd.substring(8);
            this.addToIgnoreList(name);
            pi.print("* Ignoring " + name);
            pi.print("* Ignore list:");
            Enumeration enum1 = this.ignoreList.elements();
            while (enum1.hasMoreElements()) {
                String s = (String)enum1.nextElement();
                pi.print("* " + s);
            }
            return true;
        }
        if (cmd.startsWith("\\unignore ")) {
            String name = cmd.substring(10);
            this.removeFromIgnoreList(name);
            pi.print("* Unignoring " + name);
            pi.print("* Ignore list:");
            Enumeration enum1 = this.ignoreList.elements();
            while (enum1.hasMoreElements()) {
                String s = (String)enum1.nextElement();
                pi.print("* " + s);
            }
            return true;
        }
        if (cmd.startsWith("\\clm-set ")) {
            String name = cmd.substring(9).trim();
            pi.getBoardPanel().setOtherPlayer(ga.getPlayer(name));
            pi.getBoardPanel().setMode(7);
            return true;
        }
        if (cmd.startsWith("\\clm-road ")) {
            String name = cmd.substring(10).trim();
            pi.getBoardPanel().setOtherPlayer(ga.getPlayer(name));
            pi.getBoardPanel().setMode(8);
            return true;
        }
        if (cmd.startsWith("\\clm-city ")) {
            String name = cmd.substring(10).trim();
            pi.getBoardPanel().setOtherPlayer(ga.getPlayer(name));
            pi.getBoardPanel().setMode(9);
            return true;
        }
        if (cmd.startsWith("\\clt-set ")) {
            String name = cmd.substring(9).trim();
            pi.getBoardPanel().setOtherPlayer(ga.getPlayer(name));
            pi.getBoardPanel().setMode(10);
            return true;
        }
        if (cmd.startsWith("\\clt-road ")) {
            String name = cmd.substring(10).trim();
            pi.getBoardPanel().setOtherPlayer(ga.getPlayer(name));
            pi.getBoardPanel().setMode(11);
            return true;
        }
        if (cmd.startsWith("\\clt-city ")) {
            String name = cmd.substring(10).trim();
            pi.getBoardPanel().setOtherPlayer(ga.getPlayer(name));
            pi.getBoardPanel().setMode(12);
            return true;
        }
        return false;
    }

    protected boolean onIgnoreList(String name) {
        D.ebugPrintln("onIgnoreList |" + name + "|");
        boolean result = false;
        Enumeration enum1 = this.ignoreList.elements();
        while (enum1.hasMoreElements()) {
            String s = (String)enum1.nextElement();
            D.ebugPrintln("comparing |" + s + "| to |" + name + "|");
            if (!s.equals(name)) continue;
            result = true;
            D.ebugPrintln("match");
            break;
        }
        return result;
    }

    protected void addToIgnoreList(String name) {
        if (!this.onIgnoreList(name = name.trim())) {
            this.ignoreList.addElement(name);
        }
    }

    protected void removeFromIgnoreList(String name) {
        name = name.trim();
        this.ignoreList.removeElement(name);
    }

    public void considerMove(SOCGame ga, String pname, SOCPlayingPiece piece) {
        String msg = pname + ":consider-move ";
        switch (piece.getType()) {
            case 1: {
                msg = msg + "settlement";
                break;
            }
            case 0: {
                msg = msg + "road";
                break;
            }
            case 2: {
                msg = msg + "city";
            }
        }
        msg = msg + " " + piece.getCoordinates();
        this.put(SOCGameTextMsg.toCmd(ga.getName(), this.nickname, msg));
    }

    public void considerTarget(SOCGame ga, String pname, SOCPlayingPiece piece) {
        String msg = pname + ":consider-target ";
        switch (piece.getType()) {
            case 1: {
                msg = msg + "settlement";
                break;
            }
            case 0: {
                msg = msg + "road";
                break;
            }
            case 2: {
                msg = msg + "city";
            }
        }
        msg = msg + " " + piece.getCoordinates();
        this.put(SOCGameTextMsg.toCmd(ga.getName(), this.nickname, msg));
    }

    @Override
    public String getAppletInfo() {
        return "SOCPlayerClient 0.9 by Robert S. Thomas.";
    }

    @Override
    public void destroy() {
        SOCLeaveAll leaveAllMes = new SOCLeaveAll();
        this.put(leaveAllMes.toCmd());
        String err = "Sorry, the applet has been destroyed. " + (this.ex == null ? "Load the page again." : this.ex.toString());
        Enumeration e = this.channels.elements();
        while (e.hasMoreElements()) {
            ((ChannelFrame)e.nextElement()).over(err);
        }
        e = this.playerInterfaces.elements();
        while (e.hasMoreElements()) {
            ((SOCPlayerInterface)e.nextElement()).over(err);
        }
        this.disconnect();
        this.messageLabel.setText(err);
        this.cardLayout.show(this, MESSAGE_PANEL);
        this.validate();
    }

    public static void usage() {
        System.err.println("usage: java soc.client.SOCPlayerClient <host> <port>");
    }

    public static void main(String[] args) {
        SOCPlayerClient client = new SOCPlayerClient();
        if (args.length != 2) {
            SOCPlayerClient.usage();
            System.exit(1);
        }
        try {
            client.host = args[0];
            client.port = Integer.parseInt(args[1]);
        }
        catch (NumberFormatException x) {
            SOCPlayerClient.usage();
            System.err.println("Invalid port: " + args[1]);
            System.exit(1);
        }
        Frame frame = new Frame("SOCPlayerClient");
        frame.setBackground(new Color(Integer.parseInt("61AF71", 16)));
        frame.setForeground(Color.black);
        frame.addWindowListener(client.createWindowAdapter());
        client.initVisualElements();
        frame.add((Component)client, "Center");
        frame.setSize(620, 400);
        frame.setVisible(true);
        client.connect();
    }

    private WindowAdapter createWindowAdapter() {
        return new MyWindowAdapter();
    }

    private class MyWindowAdapter
    extends WindowAdapter {
        private MyWindowAdapter() {
        }

        @Override
        public void windowClosing(WindowEvent evt) {
            System.exit(0);
        }

        @Override
        public void windowOpened(WindowEvent evt) {
            SOCPlayerClient.this.nick.requestFocus();
        }
    }
}

