/*
 * Decompiled with CFR 0.152.
 */
package soc.client;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.StringTokenizer;
import soc.client.SOCBoardPanel;
import soc.client.SOCBuildingPanel;
import soc.client.SOCChoosePlayerDialog;
import soc.client.SOCDiscardDialog;
import soc.client.SOCDiscoveryDialog;
import soc.client.SOCHandPanel;
import soc.client.SOCMonopolyDialog;
import soc.client.SOCPlayerClient;
import soc.client.SnippingTextArea;
import soc.disableDebug.D;
import soc.game.SOCGame;

public class SOCPlayerInterface
extends Frame
implements ActionListener {
    protected SOCBoardPanel boardPanel;
    protected TextField textInput;
    protected SnippingTextArea textDisplay;
    protected SnippingTextArea chatDisplay;
    protected SOCBuildingPanel buildingPanel;
    protected SOCHandPanel[] hands;
    protected Color[] playerColors;
    protected SOCPlayerClient client;
    protected SOCGame game;
    protected int ncols;
    protected int npix;
    protected SOCDiscardDialog discardDialog;
    protected SOCChoosePlayerDialog choosePlayerDialog;
    protected SOCDiscoveryDialog discoveryDialog;
    protected SOCMonopolyDialog monopolyDialog;

    public SOCPlayerInterface(String title, SOCPlayerClient cl, SOCGame ga) {
        super("Settlers of Catan Game: " + title);
        this.setResizable(true);
        this.client = cl;
        this.game = ga;
        this.playerColors = new Color[4];
        this.playerColors[0] = new Color(153, 204, 255);
        this.playerColors[1] = new Color(255, 153, 255);
        this.playerColors[2] = new Color(153, 255, 153);
        this.playerColors[3] = new Color(255, 255, 102);
        this.setBackground(Color.black);
        this.setForeground(Color.black);
        this.setFont(new Font("Geneva", 0, 10));
        this.initInterfaceElements();
        this.setLayout(null);
        this.setLocation(50, 50);
        this.setSize(660, 600);
        this.validate();
    }

    protected void initInterfaceElements() {
        this.hands = new SOCHandPanel[4];
        for (int i = 0; i < 4; ++i) {
            this.hands[i] = new SOCHandPanel(this, this.game.getPlayer(i));
            this.hands[i].setSize(180, 180);
            this.add(this.hands[i]);
        }
        this.buildingPanel = new SOCBuildingPanel(this);
        this.buildingPanel.setSize(200, 160);
        this.add(this.buildingPanel);
        this.boardPanel = new SOCBoardPanel(this);
        this.boardPanel.setBackground(new Color(112, 45, 10));
        this.boardPanel.setForeground(Color.black);
        this.boardPanel.setSize(SOCBoardPanel.getPanelX(), SOCBoardPanel.getPanelY());
        this.add(this.boardPanel);
        this.textDisplay = new SnippingTextArea("", 40, 80, 1, 80);
        this.textDisplay.setFont(new Font("Monoco", 0, 10));
        this.textDisplay.setBackground(new Color(255, 230, 162));
        this.textDisplay.setForeground(Color.black);
        this.textDisplay.setEditable(false);
        this.add(this.textDisplay);
        this.chatDisplay = new SnippingTextArea("", 40, 80, 1, 100);
        this.chatDisplay.setFont(new Font("Monoco", 0, 10));
        this.chatDisplay.setBackground(new Color(255, 230, 162));
        this.chatDisplay.setForeground(Color.black);
        this.chatDisplay.setEditable(false);
        this.add(this.chatDisplay);
        this.textInput = new TextField();
        this.textInput.setFont(new Font("Monoco", 0, 10));
        FontMetrics fm = this.getFontMetrics(this.textInput.getFont());
        this.textInput.setSize(SOCBoardPanel.getPanelX(), fm.getHeight() + 4);
        this.textInput.setBackground(new Color(255, 230, 162));
        this.textInput.setForeground(Color.black);
        this.textInput.setEditable(false);
        this.textInput.setText("Please wait...");
        this.add(this.textInput);
        this.textInput.addActionListener(this);
        this.addWindowListener(new MyWindowAdapter());
    }

    @Override
    public void update(Graphics g) {
        this.paint(g);
    }

    public SOCPlayerClient getClient() {
        return this.client;
    }

    public SOCGame getGame() {
        return this.game;
    }

    public Color getPlayerColor(int pn) {
        return this.playerColors[pn];
    }

    public SOCHandPanel getPlayerHandPanel(int pn) {
        return this.hands[pn];
    }

    public SOCBoardPanel getBoardPanel() {
        return this.boardPanel;
    }

    public SOCBuildingPanel getBuildingPanel() {
        return this.buildingPanel;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.textInput) {
            String s = this.textInput.getText().trim();
            if (s.length() > 100) {
                s = s.substring(0, 100);
            } else if (s.length() == 0) {
                return;
            }
            this.textInput.setText("");
            this.client.sendText(this.game, s + "\n");
        }
    }

    public void leaveGame() {
        this.client.leaveGame(this.game);
        this.dispose();
    }

    public void print(String s) {
        StringTokenizer st = new StringTokenizer(s, " \n", true);
        String row = "";
        while (st.hasMoreElements()) {
            String tk = st.nextToken();
            if (tk.equals("\n")) continue;
            if (row.length() + tk.length() > this.ncols) {
                this.textDisplay.append(row + "\n");
                row = tk;
                continue;
            }
            row = row + tk;
        }
        if (row.trim().length() > 0) {
            this.textDisplay.append(row + "\n");
        }
    }

    public void chatPrint(String s) {
        StringTokenizer st = new StringTokenizer(s, " \n", true);
        String row = "";
        while (st.hasMoreElements()) {
            String tk = st.nextToken();
            if (tk.equals("\n")) continue;
            if (row.length() + tk.length() > this.ncols) {
                this.chatDisplay.append(row + "\n");
                row = tk;
                continue;
            }
            row = row + tk;
        }
        if (row.trim().length() > 0) {
            this.chatDisplay.append(row + "\n");
        }
    }

    public void over(String s) {
        this.textInput.setEditable(false);
        this.textInput.setText(s);
    }

    public void began() {
        this.textInput.setEditable(true);
        this.textInput.setText("");
        this.textInput.requestFocus();
        if (this.game.getGameState() == 0 || this.game.getGameState() == 1) {
            for (int i = 0; i < 4; ++i) {
                this.hands[i].addSitButton();
            }
        }
    }

    public void addPlayer(String n, int pn) {
        this.hands[pn].addPlayer(n);
        if (n.equals(this.client.getNickname())) {
            for (int i = 0; i < 4; ++i) {
                D.ebugPrintln("game.getPlayer(" + i + ").isRobot() = " + this.game.getPlayer(i).isRobot());
                if (!this.game.getPlayer(i).isRobot()) continue;
                this.hands[i].addSeatLockBut();
            }
        }
    }

    public void removePlayer(int pn) {
        this.hands[pn].removePlayer();
        if (this.game.getGameState() <= 1) {
            boolean match = false;
            for (int i = 0; i < 4; ++i) {
                if (this.game.getPlayer(i).getName() == null || this.game.isSeatVacant(i) || !this.game.getPlayer(i).getName().equals(this.client.getNickname())) continue;
                match = true;
                break;
            }
            if (!match) {
                this.hands[pn].addSitButton();
            }
        }
    }

    public void startGame() {
        for (int i = 0; i < 4; ++i) {
            this.hands[i].removeStartBut();
        }
    }

    public void showDiscardDialog(int nd) {
        this.discardDialog = new SOCDiscardDialog(this, nd);
        this.discardDialog.setVisible(true);
    }

    public void choosePlayer(int count, int[] pnums) {
        this.choosePlayerDialog = new SOCChoosePlayerDialog(this, count, pnums);
        this.choosePlayerDialog.setVisible(true);
    }

    public void showDiscoveryDialog() {
        this.discoveryDialog = new SOCDiscoveryDialog(this);
        this.discoveryDialog.setVisible(true);
    }

    public void showMonopolyDialog() {
        this.monopolyDialog = new SOCMonopolyDialog(this);
        this.monopolyDialog.setVisible(true);
    }

    public void changeFace(int pn, int id) {
        this.hands[pn].changeFace(id);
    }

    @Override
    public void doLayout() {
        Insets i = this.getInsets();
        Dimension dim = this.getSize();
        dim.width -= i.left + i.right;
        dim.height -= i.top + i.bottom;
        int bw = SOCBoardPanel.getPanelX();
        int bh = SOCBoardPanel.getPanelY();
        int hw = (dim.width - bw - 16) / 2;
        int hh = (dim.height - 12) / 2;
        int kw = bw;
        int kh = this.buildingPanel.getSize().height;
        int tfh = this.textInput.getSize().height;
        int tah = dim.height - bh - kh - tfh - 16;
        this.boardPanel.setBounds(i.left + hw + 8, i.top + tfh + tah + 8, SOCBoardPanel.getPanelX(), SOCBoardPanel.getPanelY());
        this.buildingPanel.setBounds(i.left + hw + 8, i.top + tah + tfh + bh + 12, kw, kh);
        this.hands[0].setBounds(i.left + 4, i.top + 4, hw, hh);
        this.hands[1].setBounds(i.left + hw + bw + 12, i.top + 4, hw, hh);
        this.hands[2].setBounds(i.left + hw + bw + 12, i.top + hh + 8, hw, hh);
        this.hands[3].setBounds(i.left + 4, i.top + hh + 8, hw, hh);
        int tdh = tah / 2;
        int cdh = tah - tdh;
        this.textDisplay.setBounds(i.left + hw + 8, i.top + 4, bw, tdh);
        this.chatDisplay.setBounds(i.left + hw + 8, i.top + 4 + tdh, bw, cdh);
        this.textInput.setBounds(i.left + hw + 8, i.top + 4 + tah, bw, tfh);
        this.npix = this.textDisplay.getPreferredSize().width;
        this.ncols = (int)((double)bw * 100.0 / (double)this.npix) - 2;
        FontMetrics fm = this.getFontMetrics(this.textDisplay.getFont());
        int nrows = tdh / fm.getHeight() - 1;
        nrows = cdh / fm.getHeight() - 1;
        this.boardPanel.doLayout();
    }

    private class MyWindowAdapter
    extends WindowAdapter {
        private MyWindowAdapter() {
        }

        @Override
        public void windowClosing(WindowEvent e) {
            SOCPlayerInterface.this.leaveGame();
        }
    }
}

