/*
 * Decompiled with CFR 0.152.
 */
package soc.client;

import java.awt.TextArea;

public class SnippingTextArea
extends TextArea {
    int maximumLines = 100;
    int lines = 0;

    public SnippingTextArea(int height, int width, int maxLines) {
        super(height, width);
        this.maximumLines = maxLines;
    }

    public SnippingTextArea(String contents, int maxLines) {
        super(contents);
        this.maximumLines = maxLines;
        this.lines = this.countLines(contents);
    }

    public SnippingTextArea(String contents, int height, int width, int maxLines) {
        super(contents, height, width);
        this.maximumLines = maxLines;
        this.lines = this.countLines(contents);
    }

    public SnippingTextArea(String contents, int height, int width, int scrollType, int maxLines) {
        super(contents, height, width, scrollType);
        this.maximumLines = maxLines;
        this.lines = this.countLines(contents);
    }

    public int getMaximumLines() {
        return this.maximumLines;
    }

    public void setMaximumLines(int newMax) {
        this.maximumLines = newMax;
        this.snipText();
    }

    @Override
    public void setText(String newString) {
        super.setText(newString);
    }

    @Override
    public synchronized void replaceRange(String newString, int x, int y) {
        super.replaceRange(newString, x, y);
    }

    @Override
    public synchronized void insert(String newString, int x) {
        super.insert(newString, x);
    }

    @Override
    public synchronized void append(String newString) {
        super.append(newString);
        this.lines += this.countLines(newString);
        this.snipText();
    }

    protected int countLines(String s) {
        int lines = 0;
        int end = s.length();
        for (int idx = 0; idx < end; ++idx) {
            if (s.charAt(idx) != '\n') continue;
            ++lines;
        }
        return lines;
    }

    public void snipText() {
        while (this.lines > this.maximumLines) {
            String s = this.getText();
            super.replaceRange("", 0, s.indexOf(10) + 1);
            --this.lines;
        }
        super.setCaretPosition(this.getText().length());
    }
}

