/*
 * Decompiled with CFR 0.152.
 */
package soc.client;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Polygon;

public class SpeechBalloon
extends Canvas {
    private static Color balloonColor = new Color(255, 230, 162);
    int height = 50;
    int width = 50;

    public SpeechBalloon(Color bg) {
        this.setBackground(bg);
        this.setForeground(Color.black);
    }

    public Dimension getPreferedSize() {
        return new Dimension(this.width, this.height);
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(this.width, this.height);
    }

    @Override
    public void paint(Graphics g) {
        int i;
        Dimension dim = this.getSize();
        int h = dim.height;
        int w = dim.width;
        int xm = 5;
        int ym = 5;
        int[] xPoints = new int[]{0, w / 8, w / 8, w / 8 + w / 16, w - xm, w - xm, 0, 0};
        int[] yPoints = new int[]{h / 8, h / 8, 0, h / 8, h / 8, h - ym, h - ym, h / 8};
        Polygon balloon = new Polygon(xPoints, yPoints, 8);
        g.setPaintMode();
        g.setColor(balloonColor);
        g.fillPolygon(balloon);
        g.setColor(Color.black);
        g.drawPolygon(balloon);
        for (i = xm; i > 0; --i) {
            g.drawLine(ym, h - i, w, h - i);
        }
        for (i = ym; i > 0; --i) {
            g.drawLine(w - i, h / 6 + xm, w - i, h);
        }
    }
}

