/*
 * Decompiled with CFR 0.152.
 */
package soc.client;

import java.awt.Button;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import soc.client.SOCHandPanel;
import soc.client.SOCPlayerInterface;
import soc.client.ShadowedBox;
import soc.client.SpeechBalloon;
import soc.client.SquaresPanel;
import soc.game.SOCGame;
import soc.game.SOCPlayer;
import soc.game.SOCResourceSet;
import soc.game.SOCTradeOffer;

public class TradeOfferPanel
extends Panel {
    public static final String OFFER_MODE = "offer";
    public static final String MESSAGE_MODE = "message";
    protected static final int[] zero = new int[]{0, 0, 0, 0, 0};
    static final String OFFER = "counter";
    static final String ACCEPT = "accept";
    static final String REJECT = "reject";
    static final String SEND = "send";
    static final String CLEAR = "clear";
    static final String CANCEL = "cancel";
    static final Color insideBGColor = new Color(255, 230, 162);
    int from;
    SOCHandPanel hp;
    SOCPlayerInterface pi;
    String mode;
    CardLayout cardLayout;
    MessagePanel messagePanel;
    OfferPanel offerPanel;

    public TradeOfferPanel(SOCHandPanel hp, int from) {
        this.hp = hp;
        this.from = from;
        this.pi = hp.getPlayerInterface();
        this.setBackground(this.pi.getPlayerColor(from));
        this.setForeground(Color.black);
        this.messagePanel = new MessagePanel();
        this.offerPanel = new OfferPanel();
        this.cardLayout = new CardLayout();
        this.setLayout(this.cardLayout);
        this.add((Component)this.messagePanel, MESSAGE_MODE);
        this.add((Component)this.offerPanel, OFFER_MODE);
        this.mode = MESSAGE_MODE;
    }

    public void setMessage(String message) {
        this.messagePanel.update(message);
        this.mode = MESSAGE_MODE;
        this.cardLayout.show(this, MESSAGE_MODE);
        this.validate();
    }

    public void setOffer(SOCTradeOffer currentOffer) {
        this.offerPanel.update(currentOffer);
        this.mode = OFFER_MODE;
        this.cardLayout.show(this, OFFER_MODE);
        this.validate();
    }

    public String getMode() {
        return this.mode;
    }

    private class OfferPanel
    extends Panel
    implements ActionListener {
        SpeechBalloon balloon;
        Label toWhom1;
        Label toWhom2;
        Label giveLab;
        Label getLab;
        SquaresPanel squares;
        Button offerBut;
        Button acceptBut;
        Button rejectBut;
        ShadowedBox offerBox;
        SquaresPanel offerSquares;
        Label giveLab2;
        Label getLab2;
        Button sendBut;
        Button clearBut;
        Button cancelBut;
        boolean offered;
        SOCResourceSet give;
        SOCResourceSet get;
        int[] giveInt = new int[5];
        int[] getInt = new int[5];
        boolean counterOfferMode = false;

        public OfferPanel() {
            this.setLayout(null);
            this.setFont(new Font("Helvetica", 0, 10));
            this.toWhom1 = new Label();
            this.toWhom1.setBackground(insideBGColor);
            this.add(this.toWhom1);
            this.toWhom2 = new Label();
            this.toWhom2.setBackground(insideBGColor);
            this.add(this.toWhom2);
            this.squares = new SquaresPanel(false);
            this.add(this.squares);
            this.giveLab = new Label("I Give: ");
            this.giveLab.setBackground(insideBGColor);
            this.add(this.giveLab);
            this.getLab = new Label("I Get: ");
            this.getLab.setBackground(insideBGColor);
            this.add(this.getLab);
            this.giveInt = new int[5];
            this.getInt = new int[5];
            this.acceptBut = new Button("Accept");
            this.acceptBut.setActionCommand(TradeOfferPanel.ACCEPT);
            this.acceptBut.addActionListener(this);
            this.add(this.acceptBut);
            this.rejectBut = new Button("Reject");
            this.rejectBut.setActionCommand(TradeOfferPanel.REJECT);
            this.rejectBut.addActionListener(this);
            this.add(this.rejectBut);
            this.offerBut = new Button("Counter");
            this.offerBut.setActionCommand(TradeOfferPanel.OFFER);
            this.offerBut.addActionListener(this);
            this.add(this.offerBut);
            this.sendBut = new Button("Send");
            this.sendBut.setActionCommand(TradeOfferPanel.SEND);
            this.sendBut.addActionListener(this);
            this.sendBut.setVisible(false);
            this.add(this.sendBut);
            this.clearBut = new Button("Clear");
            this.clearBut.setActionCommand(TradeOfferPanel.CLEAR);
            this.clearBut.addActionListener(this);
            this.clearBut.setVisible(false);
            this.add(this.clearBut);
            this.cancelBut = new Button("Cancel");
            this.cancelBut.setActionCommand(TradeOfferPanel.CANCEL);
            this.cancelBut.addActionListener(this);
            this.cancelBut.setVisible(false);
            this.add(this.cancelBut);
            this.offerSquares = new SquaresPanel(true);
            this.offerSquares.setVisible(false);
            this.add(this.offerSquares);
            this.giveLab2 = new Label("I Give: ");
            this.giveLab2.setVisible(false);
            this.add(this.giveLab2);
            this.getLab2 = new Label("I Get: ");
            this.getLab2.setVisible(false);
            this.add(this.getLab2);
            this.offerBox = new ShadowedBox(TradeOfferPanel.this.pi.getPlayerColor(TradeOfferPanel.this.from), Color.white);
            this.offerBox.setVisible(false);
            this.add(this.offerBox);
            this.balloon = new SpeechBalloon(TradeOfferPanel.this.pi.getPlayerColor(TradeOfferPanel.this.from));
            this.add(this.balloon);
        }

        public void update(SOCTradeOffer offer) {
            int cnt;
            this.give = offer.getGiveSet();
            this.get = offer.getGetSet();
            boolean[] offerList = offer.getTo();
            SOCPlayer player = TradeOfferPanel.this.hp.getGame().getPlayer(TradeOfferPanel.this.hp.getClient().getNickname());
            if (player != null) {
                Color ourPlayerColor = TradeOfferPanel.this.pi.getPlayerColor(player.getPlayerNumber());
                this.giveLab2.setBackground(ourPlayerColor);
                this.getLab2.setBackground(ourPlayerColor);
                this.offerBox.setInterior(ourPlayerColor);
                this.offered = offerList[player.getPlayerNumber()];
            } else {
                this.offered = false;
            }
            SOCGame ga = TradeOfferPanel.this.hp.getGame();
            String names1 = "Offered to: ";
            String names2 = null;
            for (cnt = 0; cnt < 4; ++cnt) {
                if (!offerList[cnt]) continue;
                names1 = names1 + ga.getPlayer(cnt).getName();
                break;
            }
            ++cnt;
            int len = names1.length();
            while (cnt < 4) {
                if (offerList[cnt]) {
                    String name = ga.getPlayer(cnt).getName();
                    if ((len += name.length()) < 25) {
                        names1 = names1 + ", ";
                        names1 = names1 + name;
                    } else if (names2 == null) {
                        names1 = names1 + ",";
                        names2 = new String(name);
                    } else {
                        names2 = names2 + ", ";
                        names2 = names2 + name;
                    }
                }
                ++cnt;
            }
            this.toWhom1.setText(names1);
            this.toWhom2.setText(names2);
            for (int i = 0; i < 5; ++i) {
                this.giveInt[i] = this.give.getAmount(i + 1);
                this.getInt[i] = this.get.getAmount(i + 1);
            }
            this.squares.setValues(this.giveInt, this.getInt);
            this.setCounterOfferVisible(false);
            this.validate();
        }

        @Override
        public void doLayout() {
            FontMetrics fm = this.getFontMetrics(this.getFont());
            Dimension dim = this.getSize();
            int w = Math.min(175, dim.width);
            int h = Math.min(124, dim.height);
            int inset = 10;
            int top = h / 8 + 5;
            if (this.counterOfferMode) {
                h = Math.min(92, h);
                top = h / 8 + 5;
                int lineH = 16;
                int giveW = fm.stringWidth("I Give: ") + 2;
                int buttonW = 48;
                int buttonH = 18;
                this.toWhom1.setBounds(inset, top, w - 20, 14);
                this.toWhom2.setBounds(inset, top + 14, w - 20, 14);
                this.giveLab.setBounds(inset, top + 32, giveW, lineH);
                this.getLab.setBounds(inset, top + 32 + lineH, giveW, lineH);
                this.squares.setLocation(inset + giveW, top + 32);
                int squaresHeight = this.squares.getBounds().height + 24;
                this.giveLab2.setBounds(inset, top + 32 + squaresHeight, giveW, lineH);
                this.getLab2.setBounds(inset, top + 32 + lineH + squaresHeight, giveW, lineH);
                this.offerSquares.setLocation(inset + giveW, top + 32 + squaresHeight);
                this.offerSquares.doLayout();
                this.sendBut.setBounds(inset, top + 12 + 2 * squaresHeight, buttonW, buttonH);
                this.clearBut.setBounds(inset + 5 + buttonW, top + 12 + 2 * squaresHeight, buttonW, buttonH);
                this.cancelBut.setBounds(inset + 2 * (5 + buttonW), top + 12 + 2 * squaresHeight, buttonW, buttonH);
                this.balloon.setBounds(0, 0, w, h);
                this.offerBox.setBounds(0, top + 22 + squaresHeight, w, squaresHeight + 15);
            } else {
                int lineH = 16;
                int giveW = fm.stringWidth("I Give: ") + 2;
                int buttonW = 48;
                int buttonH = 18;
                this.toWhom1.setBounds(inset, top, w - 20, 14);
                this.toWhom2.setBounds(inset, top + 14, w - 20, 14);
                this.giveLab.setBounds(inset, top + 32, giveW, lineH);
                this.getLab.setBounds(inset, top + 32 + lineH, giveW, lineH);
                this.squares.setLocation(inset + giveW, top + 32);
                this.squares.doLayout();
                if (this.offered) {
                    int squaresHeight = this.squares.getBounds().height + 8;
                    this.acceptBut.setBounds(inset, top + 32 + squaresHeight, buttonW, buttonH);
                    this.rejectBut.setBounds(inset + 5 + buttonW, top + 32 + squaresHeight, buttonW, buttonH);
                    this.offerBut.setBounds(inset + 2 * (5 + buttonW), top + 32 + squaresHeight, buttonW, buttonH);
                }
                this.balloon.setBounds(0, 0, w, h);
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String target = e.getActionCommand();
            if (target == TradeOfferPanel.OFFER) {
                this.setCounterOfferVisible(true);
            } else if (target == TradeOfferPanel.CLEAR) {
                this.offerSquares.setValues(zero, zero);
            } else if (target == TradeOfferPanel.SEND) {
                SOCGame game = TradeOfferPanel.this.hp.getGame();
                SOCPlayer player = game.getPlayer(TradeOfferPanel.this.pi.getClient().getNickname());
                if (game.getGameState() == 20) {
                    int[] give = new int[5];
                    int[] get = new int[5];
                    int giveSum = 0;
                    int getSum = 0;
                    this.offerSquares.getValues(give, get);
                    for (int i = 0; i < 5; ++i) {
                        giveSum += give[i];
                        getSum += get[i];
                    }
                    SOCResourceSet giveSet = new SOCResourceSet(give[0], give[1], give[2], give[3], give[4], 0);
                    SOCResourceSet getSet = new SOCResourceSet(get[0], get[1], get[2], get[3], get[4], 0);
                    if (!player.getResources().contains(giveSet)) {
                        TradeOfferPanel.this.pi.print("*** You can't offer what you don't have.");
                    } else if (giveSum == 0 || getSum == 0) {
                        TradeOfferPanel.this.pi.print("*** A trade must contain at least one resource card from each player.");
                    } else {
                        boolean[] to = new boolean[4];
                        to[TradeOfferPanel.this.from] = true;
                        SOCTradeOffer tradeOffer = new SOCTradeOffer(game.getName(), player.getPlayerNumber(), to, giveSet, getSet);
                        TradeOfferPanel.this.hp.getClient().offerTrade(game, tradeOffer);
                        this.setCounterOfferVisible(true);
                    }
                }
            }
            if (target == TradeOfferPanel.CANCEL) {
                this.setCounterOfferVisible(false);
            }
            if (target == TradeOfferPanel.REJECT) {
                TradeOfferPanel.this.hp.getClient().rejectOffer(TradeOfferPanel.this.hp.getGame());
                this.rejectBut.setVisible(false);
            }
            if (target == TradeOfferPanel.ACCEPT) {
                TradeOfferPanel.this.hp.getClient().acceptOffer(TradeOfferPanel.this.hp.getGame(), TradeOfferPanel.this.from);
            }
        }

        private void setCounterOfferVisible(boolean visible) {
            this.giveLab2.setVisible(visible);
            this.getLab2.setVisible(visible);
            this.offerSquares.setVisible(visible);
            this.sendBut.setVisible(visible);
            this.clearBut.setVisible(visible);
            this.cancelBut.setVisible(visible);
            this.offerBox.setVisible(visible);
            this.acceptBut.setVisible(this.offered && !visible);
            this.rejectBut.setVisible(this.offered && !visible);
            this.offerBut.setVisible(this.offered && !visible);
            this.counterOfferMode = visible;
            this.validate();
        }
    }

    private class MessagePanel
    extends Panel {
        SpeechBalloon balloon;
        Label msg;

        public MessagePanel() {
            this.setLayout(null);
            this.setFont(new Font("Helvetica", 0, 18));
            this.msg = new Label(" ", 1);
            this.msg.setBackground(insideBGColor);
            this.add(this.msg);
            this.balloon = new SpeechBalloon(TradeOfferPanel.this.pi.getPlayerColor(TradeOfferPanel.this.from));
            this.add(this.balloon);
        }

        public void update(String message) {
            this.msg.setText(message);
        }

        @Override
        public void doLayout() {
            Dimension dim = this.getSize();
            int w = Math.min(175, dim.width);
            int h = Math.min(124, dim.height);
            int inset = 10;
            this.msg.setBounds(inset, (h - 18) / 2, w - 2 * inset, 18);
            this.balloon.setBounds(0, 0, w, h);
        }
    }
}

