/*
 * Decompiled with CFR 0.152.
 */
package soc.game;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Random;
import java.util.Vector;
import soc.game.SOCPlayingPiece;

public class SOCBoard
implements Serializable,
Cloneable {
    public static final int DESERT_HEX = 0;
    public static final int CLAY_HEX = 1;
    public static final int ORE_HEX = 2;
    public static final int SHEEP_HEX = 3;
    public static final int WHEAT_HEX = 4;
    public static final int WOOD_HEX = 5;
    public static final int WATER_HEX = 6;
    public static final int MISC_PORT_HEX = 7;
    public static final int CLAY_PORT_HEX = 8;
    public static final int ORE_PORT_HEX = 9;
    public static final int SHEEP_PORT_HEX = 10;
    public static final int WHEAT_PORT_HEX = 11;
    public static final int WOOD_PORT_HEX = 12;
    public static final int MISC_PORT = 0;
    public static final int CLAY_PORT = 1;
    public static final int ORE_PORT = 2;
    public static final int SHEEP_PORT = 3;
    public static final int WHEAT_PORT = 4;
    public static final int WOOD_PORT = 5;
    public static final int MAXHEX = 221;
    public static final int MINHEX = 17;
    public static final int MAXEDGE = 204;
    public static final int MINEDGE = 34;
    public static final int MAXNODE = 220;
    public static final int MINNODE = 35;
    public static final int MAXNODEPLUSONE = 221;
    private int[] hexLayout = new int[]{6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6};
    private int[] boardNum2Num = new int[]{-1, -1, 0, 1, 2, 3, 4, -1, 5, 6, 7, 8, 9};
    private int[] num2BoardNum = new int[]{2, 3, 4, 5, 6, 8, 9, 10, 11, 12};
    private int[] numberLayout = new int[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
    private int[] numToHexID = new int[]{23, 57, 91, 125, 21, 55, 89, 123, 157, 19, 53, 87, 121, 155, 189, 17, 51, 85, 119, 153, 187, 221, 49, 83, 117, 151, 185, 219, 81, 115, 149, 183, 217, 113, 147, 181, 215};
    public int[] hexIDtoNum;
    private int[] hexNodes = new int[]{1, 18, 33, 16, -1, -16};
    private int[] nodeToHex = new int[]{-33, 1, -1, -16, 16, -18};
    private int robberHex = -1;
    private Vector[] ports;
    private Vector pieces;
    private Vector roads;
    private Vector settlements;
    private Vector cities;
    private Random rand = new Random();
    protected Hashtable nodesOnBoard;

    public SOCBoard() {
        int i;
        this.pieces = new Vector(96);
        this.roads = new Vector(60);
        this.settlements = new Vector(20);
        this.cities = new Vector(16);
        this.ports = new Vector[6];
        this.ports[0] = new Vector(8);
        for (i = 1; i <= 5; ++i) {
            this.ports[i] = new Vector(2);
        }
        this.hexIDtoNum = new int[238];
        for (i = 0; i < 238; ++i) {
            this.hexIDtoNum[i] = 0;
        }
        this.initHexIDtoNumAux(23, 125, 0);
        this.initHexIDtoNumAux(21, 157, 4);
        this.initHexIDtoNumAux(19, 189, 9);
        this.initHexIDtoNumAux(17, 221, 15);
        this.initHexIDtoNumAux(49, 219, 22);
        this.initHexIDtoNumAux(81, 217, 28);
        this.initHexIDtoNumAux(113, 215, 33);
        this.nodesOnBoard = new Hashtable();
        Boolean t = new Boolean(true);
        for (i = 39; i <= 141; i += 17) {
            this.nodesOnBoard.put(new Integer(i), t);
        }
        for (i = 37; i <= 173; i += 17) {
            this.nodesOnBoard.put(new Integer(i), t);
        }
        for (i = 35; i <= 205; i += 17) {
            this.nodesOnBoard.put(new Integer(i), t);
        }
        for (i = 50; i <= 220; i += 17) {
            this.nodesOnBoard.put(new Integer(i), t);
        }
        for (i = 82; i <= 218; i += 17) {
            this.nodesOnBoard.put(new Integer(i), t);
        }
        for (i = 114; i <= 216; i += 17) {
            this.nodesOnBoard.put(new Integer(i), t);
        }
    }

    private final void initHexIDtoNumAux(int begin, int end, int num) {
        for (int i = begin; i <= end; i += 34) {
            this.hexIDtoNum[i] = num++;
        }
    }

    public void makeNewBoard() {
        int tmp;
        int idx;
        int i;
        int j;
        int[] landHex = new int[]{0, 1, 1, 1, 2, 2, 2, 3, 3, 3, 3, 4, 4, 4, 4, 5, 5, 5, 5};
        int[] portHex = new int[]{0, 0, 0, 0, 1, 2, 3, 4, 5};
        int[] number = new int[]{3, 0, 4, 1, 5, 7, 6, 9, 8, 2, 5, 7, 6, 2, 3, 4, 1, 8};
        int[] numPath = new int[]{29, 30, 31, 26, 20, 13, 7, 6, 5, 10, 16, 23, 24, 25, 19, 12, 11, 17, 18};
        for (j = 0; j < 10; ++j) {
            for (i = 0; i < landHex.length; ++i) {
                idx = Math.abs(this.rand.nextInt() % (landHex.length - i));
                tmp = landHex[idx];
                landHex[idx] = landHex[i];
                landHex[i] = tmp;
            }
        }
        int cnt = 0;
        for (i = 0; i < landHex.length; ++i) {
            this.hexLayout[numPath[i]] = landHex[i];
            if (landHex[i] == 0) {
                this.robberHex = this.numToHexID[numPath[i]];
                this.numberLayout[numPath[i]] = -1;
                continue;
            }
            this.numberLayout[numPath[i]] = number[cnt];
            ++cnt;
        }
        for (j = 0; j < 10; ++j) {
            for (i = 1; i < portHex.length; ++i) {
                idx = Math.abs(this.rand.nextInt() % (portHex.length - i));
                tmp = portHex[idx];
                portHex[idx] = portHex[i];
                portHex[i] = tmp;
            }
        }
        this.placePort(portHex[0], 0, 3);
        this.placePort(portHex[1], 2, 4);
        this.placePort(portHex[2], 8, 4);
        this.placePort(portHex[3], 9, 2);
        this.placePort(portHex[4], 21, 5);
        this.placePort(portHex[5], 22, 2);
        this.placePort(portHex[6], 32, 6);
        this.placePort(portHex[7], 33, 1);
        this.placePort(portHex[8], 35, 6);
        this.ports[portHex[0]].addElement(new Integer(39));
        this.ports[portHex[0]].addElement(new Integer(56));
        this.ports[portHex[1]].addElement(new Integer(90));
        this.ports[portHex[1]].addElement(new Integer(107));
        this.ports[portHex[2]].addElement(new Integer(156));
        this.ports[portHex[2]].addElement(new Integer(173));
        this.ports[portHex[3]].addElement(new Integer(37));
        this.ports[portHex[3]].addElement(new Integer(52));
        this.ports[portHex[4]].addElement(new Integer(205));
        this.ports[portHex[4]].addElement(new Integer(220));
        this.ports[portHex[5]].addElement(new Integer(67));
        this.ports[portHex[5]].addElement(new Integer(82));
        this.ports[portHex[6]].addElement(new Integer(201));
        this.ports[portHex[6]].addElement(new Integer(218));
        this.ports[portHex[7]].addElement(new Integer(114));
        this.ports[portHex[7]].addElement(new Integer(131));
        this.ports[portHex[8]].addElement(new Integer(165));
        this.ports[portHex[8]].addElement(new Integer(182));
    }

    private final void placePort(int port, int hex, int face) {
        this.hexLayout[hex] = port == 0 ? face + 6 : (face << 4) + port;
    }

    public int[] getHexLayout() {
        return this.hexLayout;
    }

    public int[] getNumberLayout() {
        return this.numberLayout;
    }

    public int getRobberHex() {
        return this.robberHex;
    }

    public void setHexLayout(int[] hl) {
        this.hexLayout = hl;
        if (hl[0] == 6) {
            return;
        }
        this.ports[this.getPortTypeFromHex(this.hexLayout[0])].addElement(new Integer(39));
        this.ports[this.getPortTypeFromHex(this.hexLayout[0])].addElement(new Integer(56));
        this.ports[this.getPortTypeFromHex(this.hexLayout[2])].addElement(new Integer(90));
        this.ports[this.getPortTypeFromHex(this.hexLayout[2])].addElement(new Integer(107));
        this.ports[this.getPortTypeFromHex(this.hexLayout[8])].addElement(new Integer(156));
        this.ports[this.getPortTypeFromHex(this.hexLayout[8])].addElement(new Integer(173));
        this.ports[this.getPortTypeFromHex(this.hexLayout[9])].addElement(new Integer(37));
        this.ports[this.getPortTypeFromHex(this.hexLayout[9])].addElement(new Integer(52));
        this.ports[this.getPortTypeFromHex(this.hexLayout[21])].addElement(new Integer(205));
        this.ports[this.getPortTypeFromHex(this.hexLayout[21])].addElement(new Integer(220));
        this.ports[this.getPortTypeFromHex(this.hexLayout[22])].addElement(new Integer(67));
        this.ports[this.getPortTypeFromHex(this.hexLayout[22])].addElement(new Integer(82));
        this.ports[this.getPortTypeFromHex(this.hexLayout[32])].addElement(new Integer(201));
        this.ports[this.getPortTypeFromHex(this.hexLayout[32])].addElement(new Integer(218));
        this.ports[this.getPortTypeFromHex(this.hexLayout[33])].addElement(new Integer(114));
        this.ports[this.getPortTypeFromHex(this.hexLayout[33])].addElement(new Integer(131));
        this.ports[this.getPortTypeFromHex(this.hexLayout[35])].addElement(new Integer(165));
        this.ports[this.getPortTypeFromHex(this.hexLayout[35])].addElement(new Integer(182));
    }

    public int getPortTypeFromHex(int hex) {
        int portType = 0;
        portType = hex >= 7 && hex <= 12 ? 0 : hex & 0xF;
        return portType;
    }

    public void setNumberLayout(int[] nl) {
        this.numberLayout = nl;
    }

    public void setRobberHex(int rh) {
        this.robberHex = rh;
    }

    public Vector getPortCoordinates(int portType) {
        return this.ports[portType];
    }

    public int getNumberOnHexFromCoord(int hex) {
        return this.getNumberOnHexFromNumber(this.hexIDtoNum[hex]);
    }

    public int getNumberOnHexFromNumber(int hex) {
        int num = this.numberLayout[hex];
        if (num < 0) {
            return 0;
        }
        return this.num2BoardNum[num];
    }

    public int getHexTypeFromCoord(int hex) {
        return this.getHexTypeFromNumber(this.hexIDtoNum[hex]);
    }

    public int getHexTypeFromNumber(int hex) {
        int hexType = this.hexLayout[hex];
        if (hexType < 7) {
            return hexType;
        }
        if (hexType >= 7 && hexType <= 12) {
            return 7;
        }
        switch (hexType & 7) {
            case 1: {
                return 8;
            }
            case 2: {
                return 9;
            }
            case 3: {
                return 10;
            }
            case 4: {
                return 11;
            }
            case 5: {
                return 12;
            }
        }
        return -1;
    }

    public void putPiece(SOCPlayingPiece pp) {
        this.pieces.addElement(pp);
        switch (pp.getType()) {
            case 0: {
                this.roads.addElement(pp);
                break;
            }
            case 1: {
                this.settlements.addElement(pp);
                break;
            }
            case 2: {
                this.cities.addElement(pp);
            }
        }
    }

    public void removePiece(SOCPlayingPiece piece) {
        Enumeration pEnum = this.pieces.elements();
        while (pEnum.hasMoreElements()) {
            SOCPlayingPiece p = (SOCPlayingPiece)pEnum.nextElement();
            if (piece.getType() != p.getType() || piece.getCoordinates() != p.getCoordinates()) continue;
            this.pieces.removeElement(p);
            switch (piece.getType()) {
                case 0: {
                    this.roads.removeElement(p);
                    break;
                }
                case 1: {
                    this.settlements.removeElement(p);
                    break;
                }
                case 2: {
                    this.cities.removeElement(p);
                }
            }
            break;
        }
    }

    public Vector getPieces() {
        return this.pieces;
    }

    public Vector getRoads() {
        return this.roads;
    }

    public Vector getSettlements() {
        return this.settlements;
    }

    public Vector getCities() {
        return this.cities;
    }

    public static Vector getAdjacentNodesToEdge(int coord) {
        Vector<Integer> nodes = new Vector<Integer>(2);
        if (((coord & 0xF) + (coord >> 4)) % 2 == 0) {
            int tmp = coord + 1;
            if (tmp >= 35 && tmp <= 220) {
                nodes.addElement(new Integer(tmp));
            }
            if ((tmp = coord + 16) >= 35 && tmp <= 220) {
                nodes.addElement(new Integer(tmp));
            }
        } else {
            int tmp = coord;
            if (tmp >= 35 && tmp <= 220) {
                nodes.addElement(new Integer(tmp));
            }
            if ((tmp = coord + 17) >= 35 && tmp <= 220) {
                nodes.addElement(new Integer(tmp));
            }
        }
        return nodes;
    }

    public static Vector getAdjacentEdgesToEdge(int coord) {
        Vector<Integer> edges = new Vector<Integer>(4);
        if (((coord & 0xF) + (coord >> 4)) % 2 == 0) {
            int tmp = coord - 16;
            if (tmp >= 34 && tmp <= 204) {
                edges.addElement(new Integer(tmp));
            }
            if ((tmp = coord + 1) >= 34 && tmp <= 204) {
                edges.addElement(new Integer(tmp));
            }
            if ((tmp = coord + 16) >= 34 && tmp <= 204) {
                edges.addElement(new Integer(tmp));
            }
            if ((tmp = coord - 1) >= 34 && tmp <= 204) {
                edges.addElement(new Integer(tmp));
            }
        } else if ((coord >> 4) % 2 == 0) {
            int tmp = coord - 17;
            if (tmp >= 34 && tmp <= 204) {
                edges.addElement(new Integer(tmp));
            }
            if ((tmp = coord + 1) >= 34 && tmp <= 204) {
                edges.addElement(new Integer(tmp));
            }
            if ((tmp = coord + 17) >= 34 && tmp <= 204) {
                edges.addElement(new Integer(tmp));
            }
            if ((tmp = coord - 1) >= 34 && tmp <= 204) {
                edges.addElement(new Integer(tmp));
            }
        } else {
            int tmp = coord - 16;
            if (tmp >= 34 && tmp <= 204) {
                edges.addElement(new Integer(tmp));
            }
            if ((tmp = coord + 17) >= 34 && tmp <= 204) {
                edges.addElement(new Integer(tmp));
            }
            if ((tmp = coord + 16) >= 34 && tmp <= 204) {
                edges.addElement(new Integer(tmp));
            }
            if ((tmp = coord - 17) >= 34 && tmp <= 204) {
                edges.addElement(new Integer(tmp));
            }
        }
        return edges;
    }

    public static Vector getAdjacentHexesToNode(int coord) {
        Vector<Integer> hexes = new Vector<Integer>(3);
        if ((coord >> 4) % 2 == 0) {
            int tmp = coord - 16;
            if (tmp >= 17 && tmp <= 221) {
                hexes.addElement(new Integer(tmp));
            }
            if ((tmp = coord + 16) >= 17 && tmp <= 221) {
                hexes.addElement(new Integer(tmp));
            }
            if ((tmp = coord - 18) >= 17 && tmp <= 221) {
                hexes.addElement(new Integer(tmp));
            }
        } else {
            int tmp = coord - 33;
            if (tmp >= 17 && tmp <= 221) {
                hexes.addElement(new Integer(tmp));
            }
            if ((tmp = coord + 1) >= 17 && tmp <= 221) {
                hexes.addElement(new Integer(tmp));
            }
            if ((tmp = coord - 1) >= 17 && tmp <= 221) {
                hexes.addElement(new Integer(coord - 1));
            }
        }
        return hexes;
    }

    public static Vector getAdjacentEdgesToNode(int coord) {
        Vector<Integer> edges = new Vector<Integer>(3);
        if ((coord >> 4) % 2 == 0) {
            int tmp = coord - 17;
            if (tmp >= 34 && tmp <= 204) {
                edges.addElement(new Integer(tmp));
            }
            if ((tmp = coord) >= 34 && tmp <= 204) {
                edges.addElement(new Integer(tmp));
            }
            if ((tmp = coord - 1) >= 34 && tmp <= 204) {
                edges.addElement(new Integer(tmp));
            }
        } else {
            int tmp = coord - 16;
            if (tmp >= 34 && tmp <= 204) {
                edges.addElement(new Integer(tmp));
            }
            if ((tmp = coord) >= 34 && tmp <= 204) {
                edges.addElement(new Integer(tmp));
            }
            if ((tmp = coord - 17) >= 34 && tmp <= 204) {
                edges.addElement(new Integer(tmp));
            }
        }
        return edges;
    }

    public static Vector getAdjacentNodesToNode(int coord) {
        Vector<Integer> nodes = new Vector<Integer>(3);
        int tmp = coord - 17;
        if (tmp >= 35 && tmp <= 220) {
            nodes.addElement(new Integer(tmp));
        }
        if ((tmp = coord + 17) >= 35 && tmp <= 220) {
            nodes.addElement(new Integer(tmp));
        }
        if ((coord >> 4) % 2 == 0) {
            tmp = coord + 16 - 1;
            if (tmp >= 35 && tmp <= 220) {
                nodes.addElement(new Integer(coord + 16 - 1));
            }
        } else {
            tmp = coord - 16 + 1;
            if (tmp >= 35 && tmp <= 220) {
                nodes.addElement(new Integer(coord - 16 + 1));
            }
        }
        return nodes;
    }

    public static Vector getAdjacentNodesToHex(int coord) {
        Vector<Integer> nodes = new Vector<Integer>(6);
        int tmp = coord + 18;
        if (tmp >= 35 && tmp <= 220) {
            nodes.addElement(new Integer(tmp));
        }
        if ((tmp = coord + 1) >= 35 && tmp <= 220) {
            nodes.addElement(new Integer(tmp));
        }
        if ((tmp = coord - 16) >= 35 && tmp <= 220) {
            nodes.addElement(new Integer(tmp));
        }
        if ((tmp = coord - 1) >= 35 && tmp <= 220) {
            nodes.addElement(new Integer(tmp));
        }
        if ((tmp = coord + 16) >= 35 && tmp <= 220) {
            nodes.addElement(new Integer(tmp));
        }
        if ((tmp = coord + 33) >= 35 && tmp <= 220) {
            nodes.addElement(new Integer(tmp));
        }
        return nodes;
    }

    public static Vector getAdjacentEdgesToHex(int coord) {
        Vector<Integer> edges = new Vector<Integer>(6);
        int tmp = coord + 17;
        if (tmp >= 34 && tmp <= 204) {
            edges.addElement(new Integer(tmp));
        }
        if ((tmp = coord + 1) >= 34 && tmp <= 204) {
            edges.addElement(new Integer(tmp));
        }
        if ((tmp = coord - 16) >= 34 && tmp <= 204) {
            edges.addElement(new Integer(tmp));
        }
        if ((tmp = coord - 17) >= 34 && tmp <= 204) {
            edges.addElement(new Integer(tmp));
        }
        if ((tmp = coord - 1) >= 34 && tmp <= 204) {
            edges.addElement(new Integer(tmp));
        }
        if ((tmp = coord + 16) >= 34 && tmp <= 204) {
            edges.addElement(new Integer(tmp));
        }
        return edges;
    }

    public boolean isNodeOnBoard(int node) {
        return this.nodesOnBoard.containsKey(new Integer(node));
    }

    public String nodeCoordToString(int node) {
        Enumeration hexes = SOCBoard.getAdjacentHexesToNode(node).elements();
        Integer hex = (Integer)hexes.nextElement();
        int number = this.getNumberOnHexFromCoord(hex);
        String str = number == 0 ? "-" : "" + number;
        while (hexes.hasMoreElements()) {
            hex = (Integer)hexes.nextElement();
            number = this.getNumberOnHexFromCoord(hex);
            if (number == 0) {
                str = str + "/-";
                continue;
            }
            str = str + "/" + number;
        }
        return str;
    }

    public String edgeCoordToString(int edge) {
        int number2;
        int number1;
        if (((edge & 0xF) + (edge >> 4)) % 2 == 0) {
            number1 = this.getNumberOnHexFromCoord(edge - 17);
            number2 = this.getNumberOnHexFromCoord(edge + 17);
        } else if ((edge >> 4) % 2 == 0) {
            number1 = this.getNumberOnHexFromCoord(edge - 16);
            number2 = this.getNumberOnHexFromCoord(edge + 16);
        } else {
            number1 = this.getNumberOnHexFromCoord(edge - 1);
            number2 = this.getNumberOnHexFromCoord(edge + 1);
        }
        String str = number1 + "/" + number2;
        return str;
    }
}

