/*
 * Decompiled with CFR 0.152.
 */
package soc.game;

import java.io.Serializable;
import java.util.Date;
import java.util.Enumeration;
import java.util.Random;
import java.util.Stack;
import java.util.Vector;
import soc.debug.D;
import soc.game.SOCBoard;
import soc.game.SOCCity;
import soc.game.SOCMoveRobberResult;
import soc.game.SOCOldLRStats;
import soc.game.SOCPlayer;
import soc.game.SOCPlayingPiece;
import soc.game.SOCResourceSet;
import soc.game.SOCRoad;
import soc.game.SOCSettlement;
import soc.game.SOCTradeOffer;
import soc.util.IntPair;

public class SOCGame
implements Serializable,
Cloneable {
    public static final int NEW = 0;
    public static final int READY = 1;
    public static final int START1A = 5;
    public static final int START1B = 6;
    public static final int START2A = 10;
    public static final int START2B = 11;
    public static final int PLAY = 15;
    public static final int PLAY1 = 20;
    public static final int PLACING_ROAD = 30;
    public static final int PLACING_SETTLEMENT = 31;
    public static final int PLACING_CITY = 32;
    public static final int PLACING_ROBBER = 33;
    public static final int PLACING_FREE_ROAD1 = 40;
    public static final int PLACING_FREE_ROAD2 = 41;
    public static final int WAITING_FOR_DISCARDS = 50;
    public static final int WAITING_FOR_CHOICE = 51;
    public static final int WAITING_FOR_DISCOVERY = 52;
    public static final int WAITING_FOR_MONOPOLY = 53;
    public static final int OVER = 1000;
    public static final int VACANT = 0;
    public static final int OCCUPIED = 1;
    public static final boolean LOCKED = true;
    public static final boolean UNLOCKED = false;
    public static final int MAXPLAYERS = 4;
    public static final SOCResourceSet EMPTY_RESOURCES = new SOCResourceSet();
    public static final SOCResourceSet SETTLEMENT_SET = new SOCResourceSet(1, 0, 1, 1, 1, 0);
    public static final SOCResourceSet ROAD_SET = new SOCResourceSet(1, 0, 0, 0, 1, 0);
    public static final SOCResourceSet CITY_SET = new SOCResourceSet(0, 3, 0, 2, 0, 0);
    public static final SOCResourceSet CARD_SET = new SOCResourceSet(0, 1, 1, 1, 0, 0);
    boolean inUse;
    private String name;
    private boolean active;
    private SOCBoard board;
    private SOCPlayer[] players;
    private int[] seats;
    private boolean[] seatLocks;
    private int currentPlayerNumber;
    private int firstPlayerNumber;
    private int lastPlayerNumber;
    private int currentDice;
    private int gameState;
    private int oldGameState;
    private int playerWithLargestArmy;
    private int oldPlayerWithLargestArmy;
    private int playerWithLongestRoad;
    private int numDevCards;
    private int[] devCardDeck;
    private Random rand = new Random();
    boolean allOriginalPlayers;
    Stack oldPlayerWithLongestRoad;
    Date startTime;
    long expiration;

    public SOCGame(String n) {
        this.active = true;
        this.inUse = false;
        this.name = n;
        this.board = new SOCBoard();
        this.players = new SOCPlayer[4];
        this.seats = new int[4];
        this.seatLocks = new boolean[4];
        for (int i = 0; i < 4; ++i) {
            this.players[i] = new SOCPlayer(i, this);
            this.seats[i] = 0;
            this.seatLocks[i] = false;
        }
        this.currentPlayerNumber = -1;
        this.firstPlayerNumber = -1;
        this.currentDice = -1;
        this.playerWithLargestArmy = -1;
        this.playerWithLongestRoad = -1;
        this.numDevCards = 25;
        this.gameState = 0;
        this.oldPlayerWithLongestRoad = new Stack();
        this.startTime = new Date();
    }

    public SOCGame(String n, boolean a) {
        this.active = a;
        this.inUse = false;
        this.name = n;
        this.board = new SOCBoard();
        this.players = new SOCPlayer[4];
        this.seats = new int[4];
        for (int i = 0; i < 4; ++i) {
            this.players[i] = new SOCPlayer(i, this);
            this.seats[i] = 0;
        }
        this.currentPlayerNumber = -1;
        this.firstPlayerNumber = -1;
        this.currentDice = -1;
        this.playerWithLargestArmy = -1;
        this.playerWithLongestRoad = -1;
        this.numDevCards = 25;
        this.gameState = 0;
        this.oldPlayerWithLongestRoad = new Stack();
    }

    public synchronized void takeMonitor() {
        D.ebugPrintln("TAKE MONITOR");
        while (this.inUse) {
            try {
                this.wait(1000L);
            }
            catch (InterruptedException e) {
                System.out.println("EXCEPTION IN takeMonitor() -- " + e);
            }
        }
        this.inUse = true;
    }

    public synchronized void releaseMonitor() {
        D.ebugPrintln("RELEASE MONITOR");
        this.inUse = false;
        this.notify();
    }

    public boolean allOriginalPlayers() {
        return this.allOriginalPlayers;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public long getExpiration() {
        return this.expiration;
    }

    public void setExpiration(long ex) {
        this.expiration = ex;
    }

    public void addPlayer(String name, int pn) {
        this.players[pn].setName(name);
        this.seats[pn] = 1;
        if (this.gameState > 0 && this.gameState < 1000) {
            this.allOriginalPlayers = false;
        }
    }

    public void removePlayer(String name) {
        SOCPlayer pl = this.getPlayer(name);
        pl.setName(null);
        this.seats[pl.getPlayerNumber()] = 0;
        D.ebugPrintln("seats[" + pl.getPlayerNumber() + "] = VACANT");
    }

    public boolean isSeatVacant(int pn) {
        return this.seats[pn] == 0;
    }

    public void lockSeat(int pn) {
        this.seatLocks[pn] = true;
    }

    public void unlockSeat(int pn) {
        this.seatLocks[pn] = false;
    }

    public boolean isSeatLocked(int pn) {
        return this.seatLocks[pn];
    }

    public SOCPlayer getPlayer(int pn) {
        return this.players[pn];
    }

    public SOCPlayer getPlayer(String nn) {
        if (nn != null) {
            for (int i = 0; i < 4; ++i) {
                if (!nn.equals(this.players[i].getName())) continue;
                return this.players[i];
            }
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public SOCBoard getBoard() {
        return this.board;
    }

    protected void setBoard(SOCBoard gb) {
        this.board = gb;
    }

    public SOCPlayer[] getPlayers() {
        return this.players;
    }

    protected void setPlayer(int pn, SOCPlayer pl) {
        this.players[pn] = pl;
    }

    public int getCurrentPlayerNumber() {
        return this.currentPlayerNumber;
    }

    public void setCurrentPlayerNumber(int pn) {
        D.ebugPrintln("SETTING CURRENT PLAYER NUMBER TO " + pn);
        this.currentPlayerNumber = pn;
    }

    public int getCurrentDice() {
        return this.currentDice;
    }

    public void setCurrentDice(int dr) {
        this.currentDice = dr;
    }

    public int getGameState() {
        return this.gameState;
    }

    public void setGameState(int gs) {
        this.gameState = gs;
    }

    public int getNumDevCards() {
        return this.numDevCards;
    }

    public void setNumDevCards(int nd) {
        this.numDevCards = nd;
    }

    public SOCPlayer getPlayerWithLargestArmy() {
        if (this.playerWithLargestArmy != -1) {
            return this.players[this.playerWithLargestArmy];
        }
        return null;
    }

    public void setPlayerWithLargestArmy(SOCPlayer pl) {
        this.playerWithLargestArmy = pl == null ? -1 : pl.getPlayerNumber();
    }

    public SOCPlayer getPlayerWithLongestRoad() {
        if (this.playerWithLongestRoad != -1) {
            return this.players[this.playerWithLongestRoad];
        }
        return null;
    }

    public void setPlayerWithLongestRoad(SOCPlayer pl) {
        this.playerWithLongestRoad = pl == null ? -1 : pl.getPlayerNumber();
    }

    protected void advanceTurnBackwards() {
        D.ebugPrintln("ADVANCE TURN BACKWARDS");
        --this.currentPlayerNumber;
        if (this.currentPlayerNumber < 0) {
            this.currentPlayerNumber = 3;
        }
    }

    protected void advanceTurn() {
        D.ebugPrintln("ADVANCE TURN FORWARDS");
        ++this.currentPlayerNumber;
        if (this.currentPlayerNumber == 4) {
            this.currentPlayerNumber = 0;
        }
    }

    public void putPiece(SOCPlayingPiece pp) {
        int i;
        for (int i2 = 0; i2 < 4; ++i2) {
            this.players[i2].putPiece(pp);
        }
        this.board.putPiece(pp);
        if (pp.getType() == 2) {
            SOCSettlement se = new SOCSettlement(pp.getPlayer(), pp.getCoordinates());
            for (i = 0; i < 4; ++i) {
                this.players[i].removePiece(se);
            }
            this.board.removePiece(se);
        }
        if (this.gameState == 10 && pp.getType() == 1) {
            SOCResourceSet resources = new SOCResourceSet();
            Enumeration hexes = SOCBoard.getAdjacentHexesToNode(pp.getCoordinates()).elements();
            while (hexes.hasMoreElements()) {
                Integer hex = (Integer)hexes.nextElement();
                switch (this.board.getHexTypeFromCoord(hex)) {
                    case 1: {
                        resources.add(1, 1);
                        break;
                    }
                    case 2: {
                        resources.add(1, 2);
                        break;
                    }
                    case 3: {
                        resources.add(1, 3);
                        break;
                    }
                    case 4: {
                        resources.add(1, 4);
                        break;
                    }
                    case 5: {
                        resources.add(1, 5);
                    }
                }
            }
            pp.getPlayer().getResources().add(resources);
        }
        if (this.gameState == 11 && pp.getType() == 0) {
            pp.getPlayer().clearPotentialSettlements();
        }
        if (pp.getType() != 2) {
            if (pp.getType() == 0) {
                this.updateLongestRoad(pp.getPlayer().getPlayerNumber());
            } else {
                int[] roads = new int[4];
                for (i = 0; i < 4; ++i) {
                    roads[i] = 0;
                }
                Enumeration adjEdgeEnum = SOCBoard.getAdjacentEdgesToNode(pp.getCoordinates()).elements();
                while (adjEdgeEnum.hasMoreElements()) {
                    Integer adjEdge = (Integer)adjEdgeEnum.nextElement();
                    Enumeration allRoadsEnum = this.board.getRoads().elements();
                    while (allRoadsEnum.hasMoreElements()) {
                        SOCRoad road = (SOCRoad)allRoadsEnum.nextElement();
                        if (adjEdge.intValue() != road.getCoordinates()) continue;
                        int n = road.getPlayer().getPlayerNumber();
                        roads[n] = roads[n] + 1;
                    }
                }
                for (int i3 = 0; i3 < 4; ++i3) {
                    if (i3 == pp.getPlayer().getPlayerNumber() || roads[i3] != 2) continue;
                    this.updateLongestRoad(i3);
                    break;
                }
            }
        }
        this.checkForWinner();
        if (this.active) {
            D.ebugPrintln("CHANGING GAME STATE FROM " + this.gameState);
            switch (this.gameState) {
                case 5: {
                    this.gameState = 6;
                    break;
                }
                case 6: {
                    int tmpCPN = this.currentPlayerNumber + 1;
                    if (tmpCPN >= 4) {
                        tmpCPN = 0;
                    }
                    if (tmpCPN == this.firstPlayerNumber) {
                        this.gameState = 10;
                        break;
                    }
                    this.advanceTurn();
                    this.gameState = 5;
                    break;
                }
                case 10: {
                    this.gameState = 11;
                    break;
                }
                case 11: {
                    int tmpCPN = this.currentPlayerNumber - 1;
                    if (tmpCPN < 0) {
                        tmpCPN = 3;
                    }
                    if (tmpCPN == this.lastPlayerNumber) {
                        this.gameState = 15;
                        break;
                    }
                    this.advanceTurnBackwards();
                    this.gameState = 10;
                    break;
                }
                case 30: 
                case 31: 
                case 32: {
                    this.gameState = 20;
                    break;
                }
                case 40: {
                    this.gameState = 41;
                    break;
                }
                case 41: {
                    this.gameState = this.oldGameState;
                }
            }
            D.ebugPrintln("  TO " + this.gameState);
        }
    }

    public void putTempPiece(SOCPlayingPiece pp) {
        int i;
        D.ebugPrintln("@@@ putTempPiece " + pp);
        this.oldPlayerWithLongestRoad.push(new SOCOldLRStats(this));
        for (int i2 = 0; i2 < 4; ++i2) {
            this.players[i2].putPiece(pp);
        }
        this.board.putPiece(pp);
        if (pp.getType() == 2) {
            SOCSettlement se = new SOCSettlement(pp.getPlayer(), pp.getCoordinates());
            for (i = 0; i < 4; ++i) {
                this.players[i].removePiece(se);
            }
            this.board.removePiece(se);
        }
        if (pp.getType() != 2) {
            if (pp.getType() == 0) {
                this.updateLongestRoad(pp.getPlayer().getPlayerNumber());
            } else {
                int[] roads = new int[4];
                for (i = 0; i < 4; ++i) {
                    roads[i] = 0;
                }
                Enumeration adjEdgeEnum = SOCBoard.getAdjacentEdgesToNode(pp.getCoordinates()).elements();
                while (adjEdgeEnum.hasMoreElements()) {
                    Integer adjEdge = (Integer)adjEdgeEnum.nextElement();
                    Enumeration allRoadsEnum = this.board.getRoads().elements();
                    while (allRoadsEnum.hasMoreElements()) {
                        SOCRoad road = (SOCRoad)allRoadsEnum.nextElement();
                        if (adjEdge.intValue() != road.getCoordinates()) continue;
                        int n = road.getPlayer().getPlayerNumber();
                        roads[n] = roads[n] + 1;
                    }
                }
                for (int i3 = 0; i3 < 4; ++i3) {
                    if (i3 == pp.getPlayer().getPlayerNumber() || roads[i3] != 2) continue;
                    this.updateLongestRoad(i3);
                    break;
                }
            }
        }
    }

    public void undoPutTempPiece(SOCPlayingPiece pp) {
        D.ebugPrintln("@@@ undoPutTempPiece " + pp);
        this.board.removePiece(pp);
        for (int i = 0; i < 4; ++i) {
            this.players[i].undoPutPiece(pp);
        }
        if (pp.getType() == 2) {
            SOCSettlement se = new SOCSettlement(pp.getPlayer(), pp.getCoordinates());
            for (int i = 0; i < 4; ++i) {
                this.players[i].putPiece(se);
            }
            this.board.putPiece(se);
        }
        SOCOldLRStats oldLRStats = (SOCOldLRStats)this.oldPlayerWithLongestRoad.pop();
        oldLRStats.restoreOldStats(this);
    }

    public void startGame() {
        int i;
        this.board.makeNewBoard();
        this.devCardDeck = new int[25];
        for (i = 0; i < 14; ++i) {
            this.devCardDeck[i] = 0;
        }
        for (i = 14; i < 16; ++i) {
            this.devCardDeck[i] = 1;
        }
        for (i = 16; i < 18; ++i) {
            this.devCardDeck[i] = 3;
        }
        for (i = 18; i < 20; ++i) {
            this.devCardDeck[i] = 2;
        }
        this.devCardDeck[20] = 4;
        this.devCardDeck[21] = 5;
        this.devCardDeck[22] = 6;
        this.devCardDeck[23] = 7;
        this.devCardDeck[24] = 8;
        for (int j = 0; j < 10; ++j) {
            for (i = 1; i < this.devCardDeck.length; ++i) {
                int idx = Math.abs(this.rand.nextInt() % (this.devCardDeck.length - 1));
                int tmp = this.devCardDeck[idx];
                this.devCardDeck[idx] = this.devCardDeck[i];
                this.devCardDeck[i] = tmp;
            }
        }
        this.allOriginalPlayers = true;
        this.gameState = 5;
        this.currentPlayerNumber = Math.abs(this.rand.nextInt() % 4);
        this.setFirstPlayer(this.currentPlayerNumber);
    }

    public void setFirstPlayer(int pn) {
        this.firstPlayerNumber = pn;
        this.lastPlayerNumber = pn - 1;
        if (this.lastPlayerNumber < 0) {
            this.lastPlayerNumber = 3;
        }
    }

    public int getFirstPlayer() {
        return this.firstPlayerNumber;
    }

    public boolean canEndTurn(int pn) {
        if (this.currentPlayerNumber != pn) {
            return false;
        }
        return this.gameState == 20;
    }

    public void endTurn() {
        this.gameState = 15;
        this.currentDice = 0;
        this.advanceTurn();
        this.players[this.currentPlayerNumber].setPlayedDevCard(false);
        this.players[this.currentPlayerNumber].getDevCards().newToOld();
    }

    public boolean canRollDice(int pn) {
        if (this.currentPlayerNumber != pn) {
            return false;
        }
        return this.gameState == 15;
    }

    public IntPair rollDice() {
        int die1 = Math.abs(this.rand.nextInt() % 6) + 1;
        int die2 = Math.abs(this.rand.nextInt() % 6) + 1;
        this.currentDice = die1 + die2;
        if (this.currentDice == 7) {
            for (int i = 0; i < 4; ++i) {
                if (this.players[i].getResources().getTotal() <= 7) continue;
                this.players[i].setNeedToDiscard(true);
                this.gameState = 50;
            }
            if (this.gameState != 50) {
                this.oldGameState = 20;
                this.gameState = 33;
            }
        } else {
            for (int i = 0; i < 4; ++i) {
                SOCResourceSet newResources = this.getResourcesGainedFromRoll(this.players[i], this.currentDice);
                this.players[i].getResources().add(newResources);
            }
            this.gameState = 20;
        }
        return new IntPair(die1, die2);
    }

    public SOCResourceSet getResourcesGainedFromRoll(SOCPlayer player, int roll) {
        SOCResourceSet resources = new SOCResourceSet();
        Enumeration sEnum = player.getSettlements().elements();
        while (sEnum.hasMoreElements()) {
            SOCSettlement se = (SOCSettlement)sEnum.nextElement();
            Enumeration hexes = SOCBoard.getAdjacentHexesToNode(se.getCoordinates()).elements();
            while (hexes.hasMoreElements()) {
                Integer hex = (Integer)hexes.nextElement();
                if (this.board.getNumberOnHexFromCoord(hex) != roll || hex.intValue() == this.board.getRobberHex()) continue;
                switch (this.board.getHexTypeFromCoord(hex)) {
                    case 1: {
                        resources.add(1, 1);
                        break;
                    }
                    case 2: {
                        resources.add(1, 2);
                        break;
                    }
                    case 3: {
                        resources.add(1, 3);
                        break;
                    }
                    case 4: {
                        resources.add(1, 4);
                        break;
                    }
                    case 5: {
                        resources.add(1, 5);
                    }
                }
            }
        }
        Enumeration cEnum = player.getCities().elements();
        while (cEnum.hasMoreElements()) {
            SOCCity ci = (SOCCity)cEnum.nextElement();
            Enumeration hexes = SOCBoard.getAdjacentHexesToNode(ci.getCoordinates()).elements();
            while (hexes.hasMoreElements()) {
                Integer hex = (Integer)hexes.nextElement();
                if (this.board.getNumberOnHexFromCoord(hex) != roll || hex.intValue() == this.board.getRobberHex()) continue;
                switch (this.board.getHexTypeFromCoord(hex)) {
                    case 1: {
                        resources.add(2, 1);
                        break;
                    }
                    case 2: {
                        resources.add(2, 2);
                        break;
                    }
                    case 3: {
                        resources.add(2, 3);
                        break;
                    }
                    case 4: {
                        resources.add(2, 4);
                        break;
                    }
                    case 5: {
                        resources.add(2, 5);
                    }
                }
            }
        }
        return resources;
    }

    public boolean canDiscard(int pn, SOCResourceSet rs) {
        if (this.gameState != 50) {
            return false;
        }
        SOCResourceSet resources = this.players[pn].getResources();
        if (!this.players[pn].getNeedToDiscard()) {
            return false;
        }
        if (rs.getTotal() != resources.getTotal() / 2) {
            return false;
        }
        return resources.contains(rs);
    }

    public void discard(int pn, SOCResourceSet rs) {
        this.players[pn].getResources().subtract(rs);
        this.players[pn].setNeedToDiscard(false);
        this.gameState = 33;
        for (int i = 0; i < 4; ++i) {
            if (!this.players[i].getNeedToDiscard()) continue;
            this.gameState = 50;
            break;
        }
        if (this.gameState != 50) {
            this.oldGameState = 20;
            this.gameState = 33;
        }
    }

    public boolean canMoveRobber(int pn, int co) {
        if (this.gameState != 33) {
            return false;
        }
        if (this.currentPlayerNumber != pn) {
            return false;
        }
        if (this.board.getRobberHex() == co) {
            return false;
        }
        int hexType = this.board.getHexTypeFromCoord(co);
        return hexType == 1 || hexType == 2 || hexType == 3 || hexType == 4 || hexType == 5 || hexType == 0;
    }

    public SOCMoveRobberResult moveRobber(int pn, int co) {
        SOCMoveRobberResult result = new SOCMoveRobberResult();
        this.board.setRobberHex(co);
        Vector victims = this.getPossibleVictims();
        if (victims.isEmpty()) {
            this.gameState = this.oldGameState;
        } else if (victims.size() == 1) {
            SOCPlayer victim = (SOCPlayer)victims.firstElement();
            int loot = this.stealFromPlayer(victim.getPlayerNumber());
            result.setLoot(loot);
        } else {
            this.gameState = 51;
        }
        result.setVictims(victims);
        return result;
    }

    public boolean canChoosePlayer(int pn) {
        if (this.gameState != 51) {
            return false;
        }
        Enumeration plEnum = this.getPossibleVictims().elements();
        while (plEnum.hasMoreElements()) {
            SOCPlayer pl = (SOCPlayer)plEnum.nextElement();
            if (pl.getPlayerNumber() != pn) continue;
            return true;
        }
        return false;
    }

    public Vector getPlayersOnHex(int hex) {
        Vector<SOCPlayer> playerList = new Vector<SOCPlayer>(4);
        for (int i = 0; i < 4; ++i) {
            SOCSettlement se;
            Vector settlements = this.players[i].getSettlements();
            Vector cities = this.players[i].getCities();
            boolean touching = false;
            int node = hex + 1;
            Enumeration seEnum = settlements.elements();
            while (seEnum.hasMoreElements()) {
                se = (SOCSettlement)seEnum.nextElement();
                if (se.getCoordinates() != node) continue;
                touching = true;
                break;
            }
            if (!touching) {
                SOCCity ci;
                Enumeration ciEnum = cities.elements();
                while (ciEnum.hasMoreElements()) {
                    ci = (SOCCity)ciEnum.nextElement();
                    if (ci.getCoordinates() != node) continue;
                    touching = true;
                    break;
                }
                if (!touching) {
                    node = hex + 18;
                    seEnum = settlements.elements();
                    while (seEnum.hasMoreElements()) {
                        se = (SOCSettlement)seEnum.nextElement();
                        if (se.getCoordinates() != node) continue;
                        touching = true;
                        break;
                    }
                    if (!touching) {
                        ciEnum = cities.elements();
                        while (ciEnum.hasMoreElements()) {
                            ci = (SOCCity)ciEnum.nextElement();
                            if (ci.getCoordinates() != node) continue;
                            touching = true;
                            break;
                        }
                        if (!touching) {
                            node = hex + 33;
                            seEnum = settlements.elements();
                            while (seEnum.hasMoreElements()) {
                                se = (SOCSettlement)seEnum.nextElement();
                                if (se.getCoordinates() != node) continue;
                                touching = true;
                                break;
                            }
                            if (!touching) {
                                ciEnum = cities.elements();
                                while (ciEnum.hasMoreElements()) {
                                    ci = (SOCCity)ciEnum.nextElement();
                                    if (ci.getCoordinates() != node) continue;
                                    touching = true;
                                    break;
                                }
                                node = hex + 16;
                                seEnum = settlements.elements();
                                while (seEnum.hasMoreElements()) {
                                    se = (SOCSettlement)seEnum.nextElement();
                                    if (se.getCoordinates() != node) continue;
                                    touching = true;
                                    break;
                                }
                                if (!touching) {
                                    ciEnum = cities.elements();
                                    while (ciEnum.hasMoreElements()) {
                                        ci = (SOCCity)ciEnum.nextElement();
                                        if (ci.getCoordinates() != node) continue;
                                        touching = true;
                                        break;
                                    }
                                    node = hex - 1;
                                    seEnum = settlements.elements();
                                    while (seEnum.hasMoreElements()) {
                                        se = (SOCSettlement)seEnum.nextElement();
                                        if (se.getCoordinates() != node) continue;
                                        touching = true;
                                        break;
                                    }
                                    if (!touching) {
                                        ciEnum = cities.elements();
                                        while (ciEnum.hasMoreElements()) {
                                            ci = (SOCCity)ciEnum.nextElement();
                                            if (ci.getCoordinates() != node) continue;
                                            touching = true;
                                            break;
                                        }
                                        node = hex - 16;
                                        seEnum = settlements.elements();
                                        while (seEnum.hasMoreElements()) {
                                            se = (SOCSettlement)seEnum.nextElement();
                                            if (se.getCoordinates() != node) continue;
                                            touching = true;
                                            break;
                                        }
                                        if (!touching) {
                                            ciEnum = cities.elements();
                                            while (ciEnum.hasMoreElements()) {
                                                ci = (SOCCity)ciEnum.nextElement();
                                                if (ci.getCoordinates() != node) continue;
                                                touching = true;
                                                break;
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
            if (!touching) continue;
            playerList.addElement(this.players[i]);
        }
        return playerList;
    }

    public Vector getPossibleVictims() {
        Vector<SOCPlayer> victims = new Vector<SOCPlayer>();
        Enumeration plEnum = this.getPlayersOnHex(this.getBoard().getRobberHex()).elements();
        while (plEnum.hasMoreElements()) {
            SOCPlayer pl = (SOCPlayer)plEnum.nextElement();
            if (pl.getPlayerNumber() == this.currentPlayerNumber || pl.getResources().getTotal() <= 0) continue;
            victims.addElement(pl);
        }
        return victims;
    }

    public int stealFromPlayer(int pn) {
        SOCPlayer victim = this.players[pn];
        int[] rsrcs = new int[victim.getResources().getTotal()];
        int cnt = 0;
        for (int i = 1; i <= 5; ++i) {
            for (int j = 0; j < victim.getResources().getAmount(i); ++j) {
                rsrcs[cnt] = i;
                ++cnt;
            }
        }
        int pick = Math.abs(this.rand.nextInt() % cnt);
        victim.getResources().subtract(1, rsrcs[pick]);
        this.players[this.currentPlayerNumber].getResources().add(1, rsrcs[pick]);
        this.gameState = this.oldGameState;
        return rsrcs[pick];
    }

    public boolean canMakeTrade(int offering, int accepting) {
        D.ebugPrintln("*** canMakeTrade ***");
        D.ebugPrintln("*** offering = " + offering);
        D.ebugPrintln("*** accepting = " + accepting);
        if (this.gameState != 20) {
            return false;
        }
        if (this.players[offering].getCurrentOffer() == null) {
            return false;
        }
        if (this.currentPlayerNumber != offering && this.currentPlayerNumber != accepting) {
            return false;
        }
        SOCPlayer offeringPlayer = this.players[offering];
        SOCPlayer acceptingPlayer = this.players[accepting];
        SOCTradeOffer offer = offeringPlayer.getCurrentOffer();
        D.ebugPrintln("*** offer = " + offer);
        if (offer.getGiveSet().getTotal() == 0 || offer.getGetSet().getTotal() == 0) {
            return false;
        }
        D.ebugPrintln("*** offeringPlayer.getResources() = " + offeringPlayer.getResources());
        if (!offeringPlayer.getResources().contains(offer.getGiveSet())) {
            return false;
        }
        D.ebugPrintln("*** acceptingPlayer.getResources() = " + acceptingPlayer.getResources());
        return acceptingPlayer.getResources().contains(offer.getGetSet());
    }

    public void makeTrade(int offering, int accepting) {
        SOCResourceSet offeringPlayerResources = this.players[offering].getResources();
        SOCResourceSet acceptingPlayerResources = this.players[accepting].getResources();
        SOCTradeOffer offer = this.players[offering].getCurrentOffer();
        offeringPlayerResources.subtract(offer.getGiveSet());
        acceptingPlayerResources.subtract(offer.getGetSet());
        offeringPlayerResources.add(offer.getGetSet());
        acceptingPlayerResources.add(offer.getGiveSet());
    }

    public boolean canMakeBankTrade(SOCResourceSet give, SOCResourceSet get) {
        if (this.gameState != 20) {
            return false;
        }
        if (give.getTotal() < 2 || get.getTotal() == 0) {
            return false;
        }
        if (!this.players[this.currentPlayerNumber].getResources().contains(give)) {
            return false;
        }
        int groupCount = 0;
        int ratio = give.getTotal() / get.getTotal();
        switch (ratio) {
            case 4: {
                for (int i = 1; i <= 5; ++i) {
                    if (give.getAmount(i) % 4 == 0) {
                        groupCount += give.getAmount(i) / 4;
                        continue;
                    }
                    return false;
                }
                break;
            }
            case 3: {
                for (int i = 1; i <= 5; ++i) {
                    if (give.getAmount(i) % 3 == 0) {
                        groupCount += give.getAmount(i) / 3;
                        if (this.players[this.currentPlayerNumber].getPortFlag(0)) continue;
                        return false;
                    }
                    return false;
                }
                break;
            }
            case 2: {
                for (int i = 1; i <= 5; ++i) {
                    if (give.getAmount(i) <= 0) continue;
                    if (give.getAmount(i) % 2 == 0 && this.players[this.currentPlayerNumber].getPortFlag(i)) {
                        groupCount += give.getAmount(i) / 2;
                        continue;
                    }
                    return false;
                }
                break;
            }
        }
        return groupCount == get.getTotal();
    }

    public void makeBankTrade(SOCResourceSet give, SOCResourceSet get) {
        SOCResourceSet playerResources = this.players[this.currentPlayerNumber].getResources();
        playerResources.subtract(give);
        playerResources.add(get);
    }

    public boolean couldBuildRoad(int pn) {
        SOCResourceSet resources = this.players[pn].getResources();
        return resources.getAmount(1) >= 1 && resources.getAmount(5) >= 1 && this.players[pn].getNumPieces(0) >= 1 && this.players[pn].hasPotentialRoad();
    }

    public boolean couldBuildSettlement(int pn) {
        SOCResourceSet resources = this.players[pn].getResources();
        return resources.getAmount(1) >= 1 && resources.getAmount(3) >= 1 && resources.getAmount(4) >= 1 && resources.getAmount(5) >= 1 && this.players[pn].getNumPieces(1) >= 1 && this.players[pn].hasPotentialSettlement();
    }

    public boolean couldBuildCity(int pn) {
        SOCResourceSet resources = this.players[pn].getResources();
        return resources.getAmount(2) >= 3 && resources.getAmount(4) >= 2 && this.players[pn].getNumPieces(2) >= 1 && this.players[pn].hasPotentialCity();
    }

    public boolean couldBuyDevCard(int pn) {
        SOCResourceSet resources = this.players[pn].getResources();
        return resources.getAmount(3) >= 1 && resources.getAmount(2) >= 1 && resources.getAmount(4) >= 1 && this.numDevCards > 0;
    }

    public void buyRoad(int pn) {
        SOCResourceSet resources = this.players[pn].getResources();
        resources.subtract(1, 1);
        resources.subtract(1, 5);
        this.gameState = 30;
    }

    public void buySettlement(int pn) {
        SOCResourceSet resources = this.players[pn].getResources();
        resources.subtract(1, 1);
        resources.subtract(1, 3);
        resources.subtract(1, 4);
        resources.subtract(1, 5);
        this.gameState = 31;
    }

    public void buyCity(int pn) {
        SOCResourceSet resources = this.players[pn].getResources();
        resources.subtract(3, 2);
        resources.subtract(2, 4);
        this.gameState = 32;
    }

    public void cancelBuildRoad(int pn) {
        SOCResourceSet resources = this.players[pn].getResources();
        resources.add(1, 1);
        resources.add(1, 5);
        this.gameState = 20;
    }

    public void cancelBuildSettlement(int pn) {
        SOCResourceSet resources = this.players[pn].getResources();
        resources.add(1, 1);
        resources.add(1, 3);
        resources.add(1, 4);
        resources.add(1, 5);
        this.gameState = 20;
    }

    public void cancelBuildCity(int pn) {
        SOCResourceSet resources = this.players[pn].getResources();
        resources.add(3, 2);
        resources.add(2, 4);
        this.gameState = 20;
    }

    public int buyDevCard() {
        int card = this.devCardDeck[this.numDevCards - 1];
        --this.numDevCards;
        SOCResourceSet resources = this.players[this.currentPlayerNumber].getResources();
        resources.subtract(1, 2);
        resources.subtract(1, 3);
        resources.subtract(1, 4);
        this.players[this.currentPlayerNumber].getDevCards().add(1, 1, card);
        this.checkForWinner();
        return card;
    }

    public boolean canPlayKnight(int pn) {
        if (this.gameState != 15 && this.gameState != 20) {
            D.ebugPrintln("cannot play Knight: Not PLAY or PLAY1 state.");
            return false;
        }
        if (this.players[pn].hasPlayedDevCard()) {
            D.ebugPrintln("cannot play Knight: already played something.");
            return false;
        }
        if (this.players[pn].getDevCards().getAmount(0, 0) == 0) {
            D.ebugPrintln("cannot play Knight: do not have the card.");
            return false;
        }
        return true;
    }

    public boolean canPlayRoadBuilding(int pn) {
        if (this.gameState != 15 && this.gameState != 20) {
            D.ebugPrintln("cannot play RoadBuilding: Not PLAY or PLAY1 state.");
            return false;
        }
        if (this.players[pn].hasPlayedDevCard()) {
            return false;
        }
        if (this.players[pn].getDevCards().getAmount(0, 1) == 0) {
            D.ebugPrintln("cannot play RoadBuilding: already played something.");
            return false;
        }
        if (this.players[pn].getNumPieces(0) < 2) {
            D.ebugPrintln("cannot play RoadBuilding: do not have the card.");
            return false;
        }
        return true;
    }

    public boolean canPlayDiscovery(int pn) {
        if (this.gameState != 15 && this.gameState != 20) {
            D.ebugPrintln("cannot play Discovery: Not PLAY or PLAY1 state.");
            return false;
        }
        if (this.players[pn].hasPlayedDevCard()) {
            D.ebugPrintln("cannot play Discovery: already played something.");
            return false;
        }
        if (this.players[pn].getDevCards().getAmount(0, 2) == 0) {
            D.ebugPrintln("cannot play Discovery: do not have the card.");
            return false;
        }
        return true;
    }

    public boolean canPlayMonopoly(int pn) {
        if (this.gameState != 15 && this.gameState != 20) {
            D.ebugPrintln("cannot play Monopoly: Not PLAY or PLAY1 state.");
            return false;
        }
        if (this.players[pn].hasPlayedDevCard()) {
            D.ebugPrintln("cannot play Monopoly: already played something.");
            return false;
        }
        if (this.players[pn].getDevCards().getAmount(0, 3) == 0) {
            D.ebugPrintln("cannot play Monopoly: do not have the card.");
            return false;
        }
        return true;
    }

    public void playKnight() {
        this.players[this.currentPlayerNumber].setPlayedDevCard(true);
        this.players[this.currentPlayerNumber].getDevCards().subtract(1, 0, 0);
        this.players[this.currentPlayerNumber].incrementNumKnights();
        this.updateLargestArmy();
        this.checkForWinner();
        this.oldGameState = this.gameState;
        this.gameState = 33;
    }

    public void playRoadBuilding() {
        this.players[this.currentPlayerNumber].setPlayedDevCard(true);
        this.players[this.currentPlayerNumber].getDevCards().subtract(1, 0, 1);
        this.oldGameState = this.gameState;
        this.gameState = 40;
    }

    public void playDiscovery() {
        this.players[this.currentPlayerNumber].setPlayedDevCard(true);
        this.players[this.currentPlayerNumber].getDevCards().subtract(1, 0, 2);
        this.oldGameState = this.gameState;
        this.gameState = 52;
    }

    public void playMonopoly() {
        this.players[this.currentPlayerNumber].setPlayedDevCard(true);
        this.players[this.currentPlayerNumber].getDevCards().subtract(1, 0, 3);
        this.oldGameState = this.gameState;
        this.gameState = 53;
    }

    public boolean canDoDiscoveryAction(SOCResourceSet pick) {
        if (this.gameState != 52) {
            return false;
        }
        return pick.getTotal() == 2;
    }

    public boolean canDoMonopolyAction() {
        return this.gameState == 53;
    }

    public void doDiscoveryAction(SOCResourceSet pick) {
        for (int i = 1; i <= 5; ++i) {
            this.players[this.currentPlayerNumber].getResources().add(pick.getAmount(i), i);
        }
        this.gameState = this.oldGameState;
    }

    public void doMonopolyAction(int pick) {
        int sum = 0;
        for (int i = 0; i < 4; ++i) {
            sum += this.players[i].getResources().getAmount(pick);
            this.players[i].getResources().setAmount(0, pick);
        }
        this.players[this.currentPlayerNumber].getResources().setAmount(sum, pick);
        this.gameState = this.oldGameState;
    }

    public void updateLargestArmy() {
        int size = this.playerWithLargestArmy == -1 ? 2 : this.players[this.playerWithLargestArmy].getNumKnights();
        for (int i = 0; i < 4; ++i) {
            if (this.players[i].getNumKnights() <= size) continue;
            this.playerWithLargestArmy = i;
        }
    }

    public void saveLargestArmyState() {
        this.oldPlayerWithLargestArmy = this.playerWithLargestArmy;
    }

    public void restoreLargestArmyState() {
        this.playerWithLargestArmy = this.oldPlayerWithLargestArmy;
    }

    public void updateLongestRoad(int pn) {
        D.ebugPrintln("## updateLongestRoad(" + pn + ")");
        int tmpPlayerWithLR = -1;
        this.players[pn].calcLongestRoad2();
        int longestLength = 4;
        for (int i = 0; i < 4; ++i) {
            int playerLength = this.players[i].getLongestRoadLength();
            D.ebugPrintln("----- LR length for player " + i + " is " + playerLength);
            if (playerLength <= longestLength) continue;
            longestLength = playerLength;
            tmpPlayerWithLR = i;
        }
        if (longestLength == 4) {
            this.playerWithLongestRoad = -1;
        } else {
            int playersWithLR = 0;
            for (int i = 0; i < 4; ++i) {
                if (this.players[i].getLongestRoadLength() != longestLength) continue;
                ++playersWithLR;
            }
            if (playersWithLR == 1) {
                this.playerWithLongestRoad = tmpPlayerWithLR;
            } else if (this.playerWithLongestRoad == -1 || this.players[this.playerWithLongestRoad].getLongestRoadLength() != longestLength) {
                this.playerWithLongestRoad = -1;
            }
        }
        D.ebugPrintln("----- player " + this.playerWithLongestRoad + " has LR");
    }

    public void checkForWinner() {
        for (int i = 0; i < 4; ++i) {
            if (this.players[i].getTotalVP() < 10) continue;
            this.gameState = 1000;
            break;
        }
    }

    public void destroyGame() {
        for (int i = 0; i < 4; ++i) {
            if (this.players[i] == null) continue;
            this.players[i].destroyPlayer();
            this.players[i] = null;
        }
        this.players = null;
        this.board = null;
        this.rand = null;
    }
}

