/*
 * Decompiled with CFR 0.152.
 */
package soc.game;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Stack;
import java.util.Vector;
import soc.disableDebug.D;
import soc.game.SOCBoard;
import soc.game.SOCCity;
import soc.game.SOCDevCardConstants;
import soc.game.SOCDevCardSet;
import soc.game.SOCGame;
import soc.game.SOCLRPathData;
import soc.game.SOCPlayerNumbers;
import soc.game.SOCPlayingPiece;
import soc.game.SOCResourceConstants;
import soc.game.SOCResourceSet;
import soc.game.SOCRoad;
import soc.game.SOCSettlement;
import soc.game.SOCTradeOffer;
import soc.util.IntPair;
import soc.util.NodeLenVis;

public class SOCPlayer
implements SOCResourceConstants,
SOCDevCardConstants,
Serializable,
Cloneable {
    private String name;
    private int playerNumber;
    private SOCGame game;
    private int[] numPieces;
    private Vector pieces;
    private Vector roads;
    private Vector settlements;
    private Vector cities;
    protected int lastSettlementCoord;
    protected int lastRoadCoord;
    private int longestRoadLength;
    private Vector lrPaths;
    private SOCResourceSet resources;
    private SOCDevCardSet devCards;
    private int numKnights;
    private int buildingVP;
    private int devCardVP;
    private boolean needToDiscard;
    private Vector roadNodes;
    private boolean[][] roadNodeGraph;
    private boolean[] legalRoads;
    private boolean[] legalSettlements;
    private boolean[] potentialRoads;
    private boolean[] potentialSettlements;
    private boolean[] potentialCities;
    private boolean[] ports;
    private SOCTradeOffer currentOffer;
    private boolean playedDevCard;
    private boolean robotFlag;
    private int faceId;
    private SOCPlayerNumbers ourNumbers;

    public SOCPlayer(SOCPlayer player) {
        int i;
        this.game = player.game;
        this.playerNumber = player.playerNumber;
        this.numPieces = new int[3];
        this.numPieces[0] = player.numPieces[0];
        this.numPieces[1] = player.numPieces[1];
        this.numPieces[2] = player.numPieces[2];
        this.pieces = (Vector)player.pieces.clone();
        this.roads = (Vector)player.roads.clone();
        this.settlements = (Vector)player.settlements.clone();
        this.cities = (Vector)player.cities.clone();
        this.longestRoadLength = player.longestRoadLength;
        this.lrPaths = (Vector)player.lrPaths.clone();
        this.resources = player.resources.copy();
        this.devCards = new SOCDevCardSet(player.devCards);
        this.numKnights = player.numKnights;
        this.buildingVP = player.buildingVP;
        this.devCardVP = player.devCardVP;
        this.playedDevCard = player.playedDevCard;
        this.needToDiscard = player.needToDiscard;
        this.robotFlag = player.robotFlag;
        this.faceId = player.faceId;
        this.ourNumbers = new SOCPlayerNumbers(player.ourNumbers);
        this.ports = new boolean[6];
        for (i = 0; i <= 5; ++i) {
            this.ports[i] = player.ports[i];
        }
        this.roadNodes = (Vector)player.roadNodes.clone();
        this.roadNodeGraph = new boolean[221][221];
        for (i = 35; i < 221; ++i) {
            for (int j = 35; j < 221; ++j) {
                this.roadNodeGraph[i][j] = player.roadNodeGraph[i][j];
            }
        }
        this.legalRoads = new boolean[239];
        this.legalSettlements = new boolean[255];
        this.potentialRoads = new boolean[239];
        this.potentialSettlements = new boolean[255];
        this.potentialCities = new boolean[255];
        for (i = 0; i < 239; ++i) {
            this.legalRoads[i] = player.legalRoads[i];
            this.potentialRoads[i] = player.potentialRoads[i];
        }
        for (i = 0; i < 255; ++i) {
            this.legalSettlements[i] = player.legalSettlements[i];
            this.potentialSettlements[i] = player.potentialSettlements[i];
            this.potentialCities[i] = player.potentialCities[i];
        }
        this.currentOffer = player.currentOffer != null ? new SOCTradeOffer(player.currentOffer) : null;
    }

    public SOCPlayer(int pn, SOCGame ga) {
        int i;
        this.game = ga;
        this.playerNumber = pn;
        this.numPieces = new int[3];
        this.numPieces[0] = 15;
        this.numPieces[1] = 5;
        this.numPieces[2] = 4;
        this.pieces = new Vector(24);
        this.roads = new Vector(15);
        this.settlements = new Vector(5);
        this.cities = new Vector(4);
        this.longestRoadLength = 0;
        this.lrPaths = new Vector();
        this.resources = new SOCResourceSet();
        this.devCards = new SOCDevCardSet();
        this.numKnights = 0;
        this.buildingVP = 0;
        this.devCardVP = 0;
        this.playedDevCard = false;
        this.needToDiscard = false;
        this.robotFlag = false;
        this.faceId = 1;
        this.ourNumbers = new SOCPlayerNumbers();
        this.ports = new boolean[6];
        for (i = 0; i <= 5; ++i) {
            this.ports[i] = false;
        }
        this.roadNodes = new Vector(20);
        this.roadNodeGraph = new boolean[221][221];
        for (i = 35; i < 221; ++i) {
            for (int j = 35; j < 221; ++j) {
                this.roadNodeGraph[i][j] = false;
            }
        }
        this.legalRoads = new boolean[239];
        this.legalSettlements = new boolean[255];
        this.potentialRoads = new boolean[239];
        this.potentialSettlements = new boolean[255];
        this.potentialCities = new boolean[255];
        for (i = 0; i < 239; ++i) {
            this.legalRoads[i] = false;
            this.potentialRoads[i] = false;
        }
        for (i = 0; i < 255; ++i) {
            this.legalSettlements[i] = false;
            this.potentialSettlements[i] = false;
            this.potentialCities[i] = false;
        }
        this.initLegalRoads();
        this.initLegalAndPotentialSettlements();
        this.currentOffer = null;
    }

    private final void initLegalRoads() {
        int i;
        for (i = 39; i <= 124; i += 17) {
            this.legalRoads[i] = true;
        }
        for (i = 38; i <= 140; i += 34) {
            this.legalRoads[i] = true;
        }
        for (i = 37; i <= 156; i += 17) {
            this.legalRoads[i] = true;
        }
        for (i = 36; i <= 172; i += 34) {
            this.legalRoads[i] = true;
        }
        for (i = 35; i <= 188; i += 17) {
            this.legalRoads[i] = true;
        }
        for (i = 34; i <= 204; i += 34) {
            this.legalRoads[i] = true;
        }
        for (i = 50; i <= 203; i += 17) {
            this.legalRoads[i] = true;
        }
        for (i = 66; i <= 202; i += 34) {
            this.legalRoads[i] = true;
        }
        for (i = 82; i <= 201; i += 17) {
            this.legalRoads[i] = true;
        }
        for (i = 98; i <= 200; i += 34) {
            this.legalRoads[i] = true;
        }
        for (i = 114; i <= 199; i += 17) {
            this.legalRoads[i] = true;
        }
    }

    private final void initLegalAndPotentialSettlements() {
        int i;
        for (i = 39; i <= 141; i += 17) {
            this.potentialSettlements[i] = true;
            this.legalSettlements[i] = true;
        }
        for (i = 37; i <= 173; i += 17) {
            this.potentialSettlements[i] = true;
            this.legalSettlements[i] = true;
        }
        for (i = 35; i <= 205; i += 17) {
            this.potentialSettlements[i] = true;
            this.legalSettlements[i] = true;
        }
        for (i = 50; i <= 220; i += 17) {
            this.potentialSettlements[i] = true;
            this.legalSettlements[i] = true;
        }
        for (i = 82; i <= 218; i += 17) {
            this.potentialSettlements[i] = true;
            this.legalSettlements[i] = true;
        }
        for (i = 114; i <= 216; i += 17) {
            this.potentialSettlements[i] = true;
            this.legalSettlements[i] = true;
        }
    }

    public void clearPotentialSettlements() {
        for (int i = 0; i < 255; ++i) {
            this.potentialSettlements[i] = false;
        }
    }

    public void setName(String na) {
        this.name = na;
    }

    public String getName() {
        return this.name;
    }

    public int getPlayerNumber() {
        return this.playerNumber;
    }

    public SOCGame getGame() {
        return this.game;
    }

    public boolean hasPlayedDevCard() {
        return this.playedDevCard;
    }

    public void setPlayedDevCard(boolean value) {
        this.playedDevCard = value;
    }

    public void setNeedToDiscard(boolean value) {
        this.needToDiscard = value;
    }

    public boolean getNeedToDiscard() {
        return this.needToDiscard;
    }

    public void setRobotFlag(boolean value) {
        this.robotFlag = value;
    }

    public boolean isRobot() {
        return this.robotFlag;
    }

    public void setFaceId(int id) {
        this.faceId = id;
    }

    public int getFaceId() {
        return this.faceId;
    }

    public SOCPlayerNumbers getNumbers() {
        return this.ourNumbers;
    }

    public int getNumPieces(int ptype) {
        return this.numPieces[ptype];
    }

    public void setNumPieces(int ptype, int amt) {
        this.numPieces[ptype] = amt;
    }

    public Vector getPieces() {
        return this.pieces;
    }

    public Vector getRoads() {
        return this.roads;
    }

    public Vector getSettlements() {
        return this.settlements;
    }

    public Vector getCities() {
        return this.cities;
    }

    public int getLastSettlementCoord() {
        return this.lastSettlementCoord;
    }

    public int getLastRoadCoord() {
        return this.lastRoadCoord;
    }

    public int getLongestRoadLength() {
        return this.longestRoadLength;
    }

    public Vector getLRPaths() {
        return this.lrPaths;
    }

    public void setLRPaths(Vector vec) {
        this.lrPaths.removeAllElements();
        Enumeration enum1 = vec.elements();
        while (enum1.hasMoreElements()) {
            SOCLRPathData pd = (SOCLRPathData)enum1.nextElement();
            D.ebugPrintln("restoring pd for player " + this.playerNumber + " :" + pd);
            this.lrPaths.addElement(pd);
        }
    }

    public void setLongestRoadLength(int len) {
        this.longestRoadLength = len;
    }

    public SOCResourceSet getResources() {
        return this.resources;
    }

    public SOCDevCardSet getDevCards() {
        return this.devCards;
    }

    public int getNumKnights() {
        return this.numKnights;
    }

    public void setNumKnights(int nk) {
        this.numKnights = nk;
    }

    public void incrementNumKnights() {
        ++this.numKnights;
    }

    public boolean hasLongestRoad() {
        if (this.game.getPlayerWithLongestRoad() == null) {
            return false;
        }
        return this.game.getPlayerWithLongestRoad().getPlayerNumber() == this.getPlayerNumber();
    }

    public boolean hasLargestArmy() {
        if (this.game.getPlayerWithLargestArmy() == null) {
            return false;
        }
        return this.game.getPlayerWithLargestArmy().getPlayerNumber() == this.getPlayerNumber();
    }

    public int getPublicVP() {
        int vp = this.buildingVP;
        if (this.hasLongestRoad()) {
            vp += 2;
        }
        if (this.hasLargestArmy()) {
            vp += 2;
        }
        return vp;
    }

    public int getTotalVP() {
        int vp = this.getPublicVP();
        return vp += this.devCards.getNumVPCards();
    }

    public Vector getRoadNodes() {
        return this.roadNodes;
    }

    public SOCTradeOffer getCurrentOffer() {
        return this.currentOffer;
    }

    public void setCurrentOffer(SOCTradeOffer of) {
        this.currentOffer = of;
    }

    public boolean isConnectedByRoad(int node1, int node2) {
        return this.roadNodeGraph[node1][node2];
    }

    public void putPiece(SOCPlayingPiece piece) {
        if (piece.getPlayer().getPlayerNumber() == this.getPlayerNumber()) {
            this.pieces.addElement(piece);
            block0 : switch (piece.getType()) {
                case 0: {
                    this.numPieces[0] = this.numPieces[0] - 1;
                    this.roads.addElement(piece);
                    this.lastRoadCoord = piece.getCoordinates();
                    Enumeration nodes = SOCBoard.getAdjacentNodesToEdge(piece.getCoordinates()).elements();
                    int[] nodeCoords = new int[2];
                    int i = 0;
                    while (nodes.hasMoreElements()) {
                        Integer node = (Integer)nodes.nextElement();
                        nodeCoords[i] = node;
                        ++i;
                        if (this.roadNodes.contains(node)) continue;
                        this.roadNodes.addElement(node);
                    }
                    this.roadNodeGraph[nodeCoords[0]][nodeCoords[1]] = true;
                    this.roadNodeGraph[nodeCoords[1]][nodeCoords[0]] = true;
                    break;
                }
                case 1: {
                    this.numPieces[1] = this.numPieces[1] - 1;
                    this.settlements.addElement(piece);
                    this.lastSettlementCoord = piece.getCoordinates();
                    ++this.buildingVP;
                    this.ourNumbers.updateNumbers(piece, this.game.getBoard());
                    Integer coordInteger = new Integer(piece.getCoordinates());
                    for (int portType = 0; portType <= 5; ++portType) {
                        if (!this.game.getBoard().getPortCoordinates(portType).contains(coordInteger)) continue;
                        this.setPortFlag(portType, true);
                        break block0;
                    }
                    break;
                }
                case 2: {
                    this.numPieces[2] = this.numPieces[2] - 1;
                    this.cities.addElement(piece);
                    this.buildingVP += 2;
                    this.ourNumbers.updateNumbers(piece, this.game.getBoard());
                }
            }
        }
        this.updatePotentials(piece);
    }

    public void undoPutPiece(SOCPlayingPiece piece) {
        boolean ours = piece.getPlayer().getPlayerNumber() == this.getPlayerNumber();
        switch (piece.getType()) {
            case 0: {
                if (ours) {
                    this.removePiece(piece);
                    break;
                }
                this.legalRoads[piece.getCoordinates()] = true;
                Vector adjEdges = SOCBoard.getAdjacentEdgesToEdge(piece.getCoordinates());
                Enumeration roadEnum = this.roads.elements();
                while (roadEnum.hasMoreElements()) {
                    SOCRoad road = (SOCRoad)roadEnum.nextElement();
                    Enumeration edgeEnum = adjEdges.elements();
                    while (edgeEnum.hasMoreElements()) {
                        Integer edge = (Integer)edgeEnum.nextElement();
                        if (road.getCoordinates() != edge.intValue()) continue;
                        this.updatePotentials(road);
                    }
                }
                break;
            }
            case 1: {
                if (ours) {
                    this.removePiece(piece);
                    this.ourNumbers.undoUpdateNumbers(piece, this.game.getBoard());
                    Integer coordInteger = new Integer(piece.getCoordinates());
                    for (int portType = 0; portType <= 5; ++portType) {
                        if (!this.game.getBoard().getPortCoordinates(portType).contains(coordInteger)) continue;
                        if (portType != 0) {
                            this.setPortFlag(portType, false);
                            continue;
                        }
                        boolean haveMiscPort = false;
                        Enumeration settlementEnum = this.settlements.elements();
                        while (settlementEnum.hasMoreElements()) {
                            SOCSettlement settlement = (SOCSettlement)settlementEnum.nextElement();
                            if (!this.game.getBoard().getPortCoordinates(0).contains(new Integer(settlement.getCoordinates()))) continue;
                            haveMiscPort = true;
                            break;
                        }
                        if (!haveMiscPort) {
                            Enumeration cityEnum = this.cities.elements();
                            while (cityEnum.hasMoreElements()) {
                                SOCCity city = (SOCCity)cityEnum.nextElement();
                                if (!this.game.getBoard().getPortCoordinates(0).contains(new Integer(city.getCoordinates()))) continue;
                                haveMiscPort = true;
                                break;
                            }
                        }
                        this.setPortFlag(0, haveMiscPort);
                    }
                }
                this.undoPutPieceAuxSettlement(piece.getCoordinates());
                Enumeration adjNodesEnum = SOCBoard.getAdjacentNodesToNode(piece.getCoordinates()).elements();
                while (adjNodesEnum.hasMoreElements()) {
                    Integer adjNode = (Integer)adjNodesEnum.nextElement();
                    this.undoPutPieceAuxSettlement(adjNode);
                }
                break;
            }
            case 2: {
                if (!ours) break;
                this.removePiece(piece);
                this.potentialCities[piece.getCoordinates()] = true;
                this.ourNumbers.undoUpdateNumbers(piece, this.game.getBoard());
                this.ourNumbers.undoUpdateNumbers(piece, this.game.getBoard());
            }
        }
    }

    protected void undoPutPieceAuxSettlement(int settlementNode) {
        boolean haveNeighbor = false;
        Vector adjNodes = SOCBoard.getAdjacentNodesToNode(settlementNode);
        Enumeration settlementsEnum = this.game.getBoard().getSettlements().elements();
        while (settlementsEnum.hasMoreElements()) {
            SOCSettlement settlement = (SOCSettlement)settlementsEnum.nextElement();
            Enumeration adjNodesEnum = adjNodes.elements();
            while (adjNodesEnum.hasMoreElements()) {
                Integer adjNode = (Integer)adjNodesEnum.nextElement();
                if (adjNode.intValue() != settlement.getCoordinates()) continue;
                haveNeighbor = true;
                break;
            }
            if (!haveNeighbor) continue;
            break;
        }
        if (!haveNeighbor) {
            Enumeration citiesEnum = this.game.getBoard().getCities().elements();
            while (citiesEnum.hasMoreElements()) {
                SOCCity city = (SOCCity)citiesEnum.nextElement();
                Enumeration adjNodesEnum = adjNodes.elements();
                while (adjNodesEnum.hasMoreElements()) {
                    Integer adjNode = (Integer)adjNodesEnum.nextElement();
                    if (adjNode.intValue() != city.getCoordinates()) continue;
                    haveNeighbor = true;
                    break;
                }
                if (!haveNeighbor) continue;
                break;
            }
            if (!haveNeighbor && this.game.getBoard().isNodeOnBoard(settlementNode)) {
                this.legalSettlements[settlementNode] = true;
                if (this.game.getGameState() < 15) {
                    this.potentialSettlements[settlementNode] = true;
                } else {
                    boolean adjRoad = false;
                    Vector adjEdges = SOCBoard.getAdjacentEdgesToNode(settlementNode);
                    Enumeration roadsEnum = this.roads.elements();
                    while (roadsEnum.hasMoreElements()) {
                        SOCRoad road = (SOCRoad)roadsEnum.nextElement();
                        Enumeration adjEdgesEnum = adjEdges.elements();
                        while (adjEdgesEnum.hasMoreElements()) {
                            Integer adjEdge = (Integer)adjEdgesEnum.nextElement();
                            if (road.getCoordinates() != adjEdge.intValue()) continue;
                            adjRoad = true;
                            break;
                        }
                        if (!adjRoad) continue;
                        break;
                    }
                    if (adjRoad) {
                        this.potentialSettlements[settlementNode] = true;
                    }
                }
            }
        }
    }

    public void removePiece(SOCPlayingPiece piece) {
        D.ebugPrintln("--- SOCPlayer.removePiece(" + piece + ")");
        Enumeration pEnum = this.pieces.elements();
        while (pEnum.hasMoreElements()) {
            SOCPlayingPiece p = (SOCPlayingPiece)pEnum.nextElement();
            if (piece.getType() != p.getType() || piece.getCoordinates() != p.getCoordinates()) continue;
            this.pieces.removeElement(p);
            switch (piece.getType()) {
                case 0: {
                    this.roads.removeElement(p);
                    this.numPieces[0] = this.numPieces[0] + 1;
                    Enumeration nodes = SOCBoard.getAdjacentNodesToEdge(piece.getCoordinates()).elements();
                    int[] nodeCoords = new int[2];
                    int i = 0;
                    while (nodes.hasMoreElements()) {
                        Integer node = (Integer)nodes.nextElement();
                        nodeCoords[i] = node;
                        ++i;
                        Enumeration roadsEnum = this.roads.elements();
                        Vector adjEdges = SOCBoard.getAdjacentEdgesToNode(node);
                        boolean match = false;
                        while (roadsEnum.hasMoreElements()) {
                            SOCRoad rd = (SOCRoad)roadsEnum.nextElement();
                            Enumeration adjEdgesEnum = adjEdges.elements();
                            while (adjEdgesEnum.hasMoreElements()) {
                                Integer adjEdge = (Integer)adjEdgesEnum.nextElement();
                                if (adjEdge.intValue() != rd.getCoordinates()) continue;
                                match = true;
                                break;
                            }
                            if (!match) continue;
                            break;
                        }
                        if (match) continue;
                        this.roadNodes.removeElement(node);
                        this.potentialSettlements[node.intValue()] = false;
                    }
                    this.roadNodeGraph[nodeCoords[0]][nodeCoords[1]] = false;
                    this.roadNodeGraph[nodeCoords[1]][nodeCoords[0]] = false;
                    this.potentialRoads[piece.getCoordinates()] = true;
                    this.legalRoads[piece.getCoordinates()] = true;
                    Vector allPieces = this.game.getBoard().getPieces();
                    Enumeration adjEdgesEnum = SOCBoard.getAdjacentEdgesToEdge(piece.getCoordinates()).elements();
                    while (adjEdgesEnum.hasMoreElements()) {
                        Integer adjEdge = (Integer)adjEdgesEnum.nextElement();
                        if (!this.potentialRoads[adjEdge]) continue;
                        boolean isPotentialRoad = false;
                        Enumeration adjNodesEnum = SOCBoard.getAdjacentNodesToEdge(adjEdge).elements();
                        while (adjNodesEnum.hasMoreElements() && !isPotentialRoad) {
                            boolean blocked = false;
                            Integer adjNode = (Integer)adjNodesEnum.nextElement();
                            Enumeration allPiecesEnum = allPieces.elements();
                            while (allPiecesEnum.hasMoreElements()) {
                                SOCPlayingPiece aPiece = (SOCPlayingPiece)allPiecesEnum.nextElement();
                                if (aPiece.getPlayer().getPlayerNumber() == this.getPlayerNumber() || aPiece.getType() != 1 && aPiece.getType() != 2 || aPiece.getCoordinates() != adjNode.intValue()) continue;
                                blocked = true;
                                break;
                            }
                            if (blocked) continue;
                            Enumeration adjAdjEdgesEnum = SOCBoard.getAdjacentEdgesToNode(adjNode).elements();
                            block12: while (adjAdjEdgesEnum.hasMoreElements() && !isPotentialRoad) {
                                Integer adjAdjEdge = (Integer)adjAdjEdgesEnum.nextElement();
                                if (adjAdjEdge.intValue() == adjEdge.intValue()) continue;
                                Enumeration ourRoadsEnum = this.roads.elements();
                                while (ourRoadsEnum.hasMoreElements()) {
                                    SOCRoad ourRoad = (SOCRoad)ourRoadsEnum.nextElement();
                                    if (ourRoad.getCoordinates() != adjAdjEdge.intValue()) continue;
                                    isPotentialRoad = true;
                                    continue block12;
                                }
                            }
                        }
                        this.potentialRoads[adjEdge.intValue()] = isPotentialRoad;
                    }
                    break;
                }
                case 1: {
                    this.settlements.removeElement(p);
                    this.numPieces[1] = this.numPieces[1] + 1;
                    --this.buildingVP;
                    break;
                }
                case 2: {
                    this.cities.removeElement(p);
                    this.numPieces[2] = this.numPieces[2] + 1;
                    this.buildingVP -= 2;
                }
            }
            break;
        }
    }

    public void updatePotentials(SOCPlayingPiece piece) {
        int id = piece.getCoordinates();
        Vector allPieces = this.game.getBoard().getPieces();
        boolean ours = piece.getPlayer().getPlayerNumber() == this.getPlayerNumber();
        switch (piece.getType()) {
            case 0: {
                this.potentialRoads[id] = false;
                this.legalRoads[id] = false;
                if (!ours) break;
                Enumeration nodes = SOCBoard.getAdjacentNodesToEdge(id).elements();
                while (nodes.hasMoreElements()) {
                    Integer node = (Integer)nodes.nextElement();
                    boolean blocked = false;
                    Enumeration pEnum = allPieces.elements();
                    while (pEnum.hasMoreElements()) {
                        SOCPlayingPiece p = (SOCPlayingPiece)pEnum.nextElement();
                        if (p.getPlayer().getPlayerNumber() == this.getPlayerNumber() || p.getType() != 1 && p.getType() != 2 || p.getCoordinates() != node.intValue()) continue;
                        blocked = true;
                        break;
                    }
                    if (blocked) continue;
                    Enumeration edges = SOCBoard.getAdjacentEdgesToNode(node).elements();
                    while (edges.hasMoreElements()) {
                        Integer edge = (Integer)edges.nextElement();
                        if (!this.legalRoads[edge]) continue;
                        this.potentialRoads[edge.intValue()] = true;
                    }
                    if (!this.legalSettlements[node]) continue;
                    this.potentialSettlements[node.intValue()] = true;
                }
                break;
            }
            case 1: {
                this.potentialSettlements[id] = false;
                this.potentialSettlements[id - 17] = false;
                this.potentialSettlements[id + 17] = false;
                this.legalSettlements[id] = false;
                this.legalSettlements[id - 17] = false;
                this.legalSettlements[id + 17] = false;
                if ((id >> 4) % 2 == 0) {
                    this.potentialSettlements[id + 16 - 1] = false;
                    this.legalSettlements[id + 16 - 1] = false;
                    if (ours) {
                        int tmp = id - 17;
                        if (this.legalRoads[tmp]) {
                            this.potentialRoads[tmp] = true;
                        }
                        if (this.legalRoads[id]) {
                            this.potentialRoads[id] = true;
                        }
                        if (this.legalRoads[tmp = id - 1]) {
                            this.potentialRoads[tmp] = true;
                        }
                    } else {
                        Vector<Integer> ourRoads = new Vector<Integer>();
                        Enumeration pEnum = this.pieces.elements();
                        while (pEnum.hasMoreElements()) {
                            SOCPlayingPiece p = (SOCPlayingPiece)pEnum.nextElement();
                            if (p.getType() != 0) continue;
                            ourRoads.addElement(new Integer(p.getCoordinates()));
                        }
                        int tmp = id - 17;
                        if (this.potentialRoads[tmp] && !ourRoads.contains(new Integer(tmp - 16)) && !ourRoads.contains(new Integer(tmp - 17))) {
                            this.potentialRoads[tmp] = false;
                        }
                        if (this.potentialRoads[tmp = id] && !ourRoads.contains(new Integer(tmp + 1)) && !ourRoads.contains(new Integer(tmp + 17))) {
                            this.potentialRoads[tmp] = false;
                        }
                        if (this.potentialRoads[tmp = id - 1] && !ourRoads.contains(new Integer(tmp - 1)) && !ourRoads.contains(new Integer(tmp + 16))) {
                            this.potentialRoads[tmp] = false;
                        }
                    }
                } else {
                    this.potentialSettlements[id - 16 + 1] = false;
                    this.legalSettlements[id - 16 + 1] = false;
                    if (ours) {
                        int tmp = id - 17;
                        if (this.legalRoads[tmp]) {
                            this.potentialRoads[tmp] = true;
                        }
                        if (this.legalRoads[id]) {
                            this.potentialRoads[id] = true;
                        }
                        if (this.legalRoads[tmp = id - 16]) {
                            this.potentialRoads[tmp] = true;
                        }
                    } else {
                        Vector<Integer> ourRoads = new Vector<Integer>();
                        Enumeration pEnum = this.pieces.elements();
                        while (pEnum.hasMoreElements()) {
                            SOCPlayingPiece p = (SOCPlayingPiece)pEnum.nextElement();
                            if (p.getType() != 0) continue;
                            ourRoads.addElement(new Integer(p.getCoordinates()));
                        }
                        int tmp = id - 17;
                        if (this.potentialRoads[tmp] && !ourRoads.contains(new Integer(tmp - 17)) && !ourRoads.contains(new Integer(tmp - 1))) {
                            this.potentialRoads[tmp] = false;
                        }
                        if (this.potentialRoads[tmp = id] && !ourRoads.contains(new Integer(tmp + 17)) && !ourRoads.contains(new Integer(tmp + 16))) {
                            this.potentialRoads[tmp] = false;
                        }
                        if (this.potentialRoads[tmp = id - 16] && !ourRoads.contains(new Integer(tmp - 16)) && !ourRoads.contains(new Integer(tmp + 1))) {
                            this.potentialRoads[tmp] = false;
                        }
                    }
                }
                if (!ours) break;
                this.potentialCities[id] = true;
                break;
            }
            case 2: {
                this.potentialCities[id] = false;
            }
        }
    }

    public void setPotentialSettlements(Vector psList) {
        this.clearPotentialSettlements();
        Enumeration enum1 = psList.elements();
        while (enum1.hasMoreElements()) {
            Integer number = (Integer)enum1.nextElement();
            this.potentialSettlements[number.intValue()] = true;
        }
    }

    public boolean isPotentialSettlement(int node) {
        return this.potentialSettlements[node];
    }

    public boolean isPotentialCity(int node) {
        return this.potentialCities[node];
    }

    public boolean isPotentialRoad(int edge) {
        return this.potentialRoads[edge];
    }

    public boolean isLegalRoad(int edge) {
        return this.legalRoads[edge];
    }

    public boolean hasPotentialRoad() {
        for (int i = 34; i <= 204; ++i) {
            if (!this.potentialRoads[i]) continue;
            return true;
        }
        return false;
    }

    public boolean hasPotentialSettlement() {
        for (int i = 35; i <= 220; ++i) {
            if (!this.potentialSettlements[i]) continue;
            return true;
        }
        return false;
    }

    public boolean hasPotentialCity() {
        for (int i = 35; i <= 220; ++i) {
            if (!this.potentialCities[i]) continue;
            return true;
        }
        return false;
    }

    public int calcLongestRoad2() {
        D.ebugPrintln("CLEARING PATH DATA");
        this.lrPaths.removeAllElements();
        Stack<NodeLenVis> pending = new Stack<NodeLenVis>();
        int longest = 0;
        Enumeration e = this.roadNodes.elements();
        while (e.hasMoreElements()) {
            Integer roadNode = (Integer)e.nextElement();
            int pathStartCoord = roadNode;
            boolean pathLength = false;
            pending.push(new NodeLenVis(pathStartCoord, 0, new Vector()));
            while (!pending.isEmpty()) {
                SOCLRPathData oldPathData;
                NodeLenVis curNode = (NodeLenVis)pending.pop();
                int coord = curNode.node;
                int len = curNode.len;
                Vector visited = curNode.vis;
                boolean pathEnd = false;
                Enumeration pEnum = this.game.getBoard().getPieces().elements();
                while (pEnum.hasMoreElements()) {
                    SOCPlayingPiece p = (SOCPlayingPiece)pEnum.nextElement();
                    if (len <= 0 || p.getPlayer().getPlayerNumber() == this.getPlayerNumber() || p.getType() != 1 && p.getType() != 2 || p.getCoordinates() != coord) continue;
                    pathEnd = true;
                    break;
                }
                if (!pathEnd) {
                    Vector newVis;
                    IntPair vis;
                    Enumeration ev;
                    pathEnd = true;
                    int j = coord - 17;
                    IntPair pair = new IntPair(coord, j);
                    boolean match = false;
                    if (j >= 35 && j < 221 && this.isConnectedByRoad(coord, j)) {
                        ev = visited.elements();
                        while (ev.hasMoreElements()) {
                            vis = (IntPair)ev.nextElement();
                            if (!vis.equals(pair)) continue;
                            match = true;
                            break;
                        }
                        if (!match) {
                            newVis = (Vector)visited.clone();
                            newVis.addElement(pair);
                            pending.push(new NodeLenVis(j, len + 1, newVis));
                            pathEnd = false;
                        }
                    }
                    j = coord + 17;
                    pair = new IntPair(coord, j);
                    match = false;
                    if (j >= 35 && j < 221 && this.isConnectedByRoad(coord, j)) {
                        ev = visited.elements();
                        while (ev.hasMoreElements()) {
                            vis = (IntPair)ev.nextElement();
                            if (!vis.equals(pair)) continue;
                            match = true;
                            break;
                        }
                        if (!match) {
                            newVis = (Vector)visited.clone();
                            newVis.addElement(pair);
                            pending.push(new NodeLenVis(j, len + 1, newVis));
                            pathEnd = false;
                        }
                    }
                    j = coord + 16 - 1;
                    pair = new IntPair(coord, j);
                    match = false;
                    if (j >= 35 && j < 221 && this.isConnectedByRoad(coord, j)) {
                        ev = visited.elements();
                        while (ev.hasMoreElements()) {
                            vis = (IntPair)ev.nextElement();
                            if (!vis.equals(pair)) continue;
                            match = true;
                            break;
                        }
                        if (!match) {
                            newVis = (Vector)visited.clone();
                            newVis.addElement(pair);
                            pending.push(new NodeLenVis(j, len + 1, newVis));
                            pathEnd = false;
                        }
                    }
                    j = coord - 16 + 1;
                    pair = new IntPair(coord, j);
                    match = false;
                    if (j >= 35 && j < 221 && this.isConnectedByRoad(coord, j)) {
                        ev = visited.elements();
                        while (ev.hasMoreElements()) {
                            vis = (IntPair)ev.nextElement();
                            if (!vis.equals(pair)) continue;
                            match = true;
                            break;
                        }
                        if (!match) {
                            newVis = (Vector)visited.clone();
                            newVis.addElement(pair);
                            pending.push(new NodeLenVis(j, len + 1, newVis));
                            pathEnd = false;
                        }
                    }
                }
                if (!pathEnd) continue;
                if (len > longest) {
                    longest = len;
                }
                boolean addNewPath = true;
                Vector<SOCLRPathData> trash = new Vector<SOCLRPathData>();
                Enumeration pdEnum = this.lrPaths.elements();
                while (pdEnum.hasMoreElements()) {
                    oldPathData = (SOCLRPathData)pdEnum.nextElement();
                    D.ebugPrintln("oldPathData = " + oldPathData);
                    Vector nodePairs = oldPathData.getNodePairs();
                    boolean intersection = false;
                    Enumeration ev = visited.elements();
                    while (ev.hasMoreElements()) {
                        IntPair vis = (IntPair)ev.nextElement();
                        D.ebugPrintln("vis = " + vis);
                        Enumeration npev = nodePairs.elements();
                        while (npev.hasMoreElements()) {
                            IntPair np = (IntPair)npev.nextElement();
                            D.ebugPrintln("np = " + np);
                            if (!np.equals(vis)) continue;
                            D.ebugPrintln("oldPathData.nodePairs.contains(vis)");
                            intersection = true;
                            break;
                        }
                        if (!intersection) continue;
                        break;
                    }
                    if (!intersection) continue;
                    if (oldPathData.getLength() < len) {
                        D.ebugPrintln("REMOVING OLDPATHDATA");
                        trash.addElement(oldPathData);
                        continue;
                    }
                    addNewPath = false;
                    D.ebugPrintln("NOT ADDING NEW PATH");
                }
                if (!trash.isEmpty()) {
                    Enumeration trashEnum = trash.elements();
                    while (trashEnum.hasMoreElements()) {
                        oldPathData = (SOCLRPathData)trashEnum.nextElement();
                        this.lrPaths.removeElement(oldPathData);
                    }
                }
                if (!addNewPath) continue;
                SOCLRPathData newPathData = new SOCLRPathData(pathStartCoord, coord, len, visited);
                D.ebugPrintln("ADDING PATH: " + newPathData);
                this.lrPaths.addElement(newPathData);
            }
        }
        this.longestRoadLength = longest;
        return longest;
    }

    public void setPortFlag(int portType, boolean value) {
        this.ports[portType] = value;
    }

    public boolean getPortFlag(int portType) {
        return this.ports[portType];
    }

    public boolean[] getPortFlags() {
        return this.ports;
    }

    public SOCPlayer copy() {
        SOCPlayer copy = new SOCPlayer(this.getPlayerNumber(), this.game);
        if (this.game.getGameState() >= 11) {
            copy.clearPotentialSettlements();
        }
        for (int pnum = 0; pnum < 4; ++pnum) {
            SOCSettlement temp;
            SOCPlayer owner;
            SOCPlayingPiece piece;
            Enumeration piecesEnum;
            if (pnum != this.getPlayerNumber()) {
                piecesEnum = this.game.getPlayer(pnum).getPieces().elements();
                while (piecesEnum.hasMoreElements()) {
                    piece = (SOCPlayingPiece)piecesEnum.nextElement();
                    owner = this.game.getPlayer(pnum);
                    switch (piece.getType()) {
                        case 0: {
                            copy.putPiece(new SOCRoad(owner, piece.getCoordinates()));
                            break;
                        }
                        case 1: {
                            copy.putPiece(new SOCSettlement(owner, piece.getCoordinates()));
                            break;
                        }
                        case 2: {
                            if (piece.getType() == 2) {
                                temp = new SOCSettlement(owner, piece.getCoordinates());
                                copy.putPiece(temp);
                                copy.removePiece(temp);
                            }
                            copy.putPiece(new SOCCity(owner, piece.getCoordinates()));
                        }
                    }
                }
                continue;
            }
            piecesEnum = this.getPieces().elements();
            while (piecesEnum.hasMoreElements()) {
                piece = (SOCPlayingPiece)piecesEnum.nextElement();
                owner = copy;
                switch (piece.getType()) {
                    case 0: {
                        copy.putPiece(new SOCRoad(owner, piece.getCoordinates()));
                        break;
                    }
                    case 1: {
                        copy.putPiece(new SOCSettlement(owner, piece.getCoordinates()));
                        break;
                    }
                    case 2: {
                        if (piece.getType() == 2) {
                            temp = new SOCSettlement(owner, piece.getCoordinates());
                            copy.putPiece(temp);
                            copy.removePiece(temp);
                        }
                        copy.putPiece(new SOCCity(owner, piece.getCoordinates()));
                    }
                }
            }
        }
        SOCResourceSet copyResources = copy.getResources();
        for (int rType = 1; rType <= 6; ++rType) {
            copyResources.setAmount(this.resources.getAmount(rType), rType);
        }
        SOCDevCardSet copyDevCards = this.getDevCards();
        for (int dcType = 0; dcType <= 9; ++dcType) {
            copyDevCards.setAmount(this.devCards.getAmount(0, dcType), 0, dcType);
            copyDevCards.setAmount(this.devCards.getAmount(1, dcType), 1, dcType);
        }
        copy.setNumKnights(this.numKnights);
        for (int port = 0; port <= 5; ++port) {
            copy.setPortFlag(port, this.ports[port]);
        }
        return copy;
    }

    public void destroyPlayer() {
        this.game = null;
        this.numPieces = null;
        this.pieces.removeAllElements();
        this.pieces = null;
        this.roads.removeAllElements();
        this.roads = null;
        this.settlements.removeAllElements();
        this.settlements = null;
        this.cities.removeAllElements();
        this.cities = null;
        this.resources = null;
        this.devCards = null;
        this.ourNumbers = null;
        this.ports = null;
        this.roadNodes.removeAllElements();
        this.roadNodes = null;
        this.roadNodeGraph = null;
        this.legalRoads = null;
        this.legalSettlements = null;
        this.potentialRoads = null;
        this.potentialSettlements = null;
        this.potentialCities = null;
        this.currentOffer = null;
    }
}

