/*
 * Decompiled with CFR 0.152.
 */
package soc.game;

import java.util.Enumeration;
import java.util.Vector;
import soc.game.SOCBoard;
import soc.game.SOCPlayingPiece;
import soc.util.IntPair;

public class SOCPlayerNumbers {
    static int[] hexCoords = new int[]{51, 53, 55, 83, 85, 87, 89, 115, 117, 119, 121, 123, 149, 151, 153, 155, 183, 185, 187};
    Vector[] numbersForResource = new Vector[6];
    Vector[] resourcesForNumber;
    Vector[] numberAndResourceForHex;

    public SOCPlayerNumbers(SOCPlayerNumbers numbers) {
        int i;
        for (i = 1; i <= 5; ++i) {
            this.numbersForResource[i] = (Vector)numbers.numbersForResource[i].clone();
        }
        this.resourcesForNumber = new Vector[13];
        for (i = 0; i < 13; ++i) {
            this.resourcesForNumber[i] = (Vector)numbers.resourcesForNumber[i].clone();
        }
        this.numberAndResourceForHex = new Vector[188];
        for (i = 0; i < 19; ++i) {
            this.numberAndResourceForHex[SOCPlayerNumbers.hexCoords[i]] = (Vector)numbers.numberAndResourceForHex[hexCoords[i]].clone();
        }
    }

    public SOCPlayerNumbers() {
        int i;
        for (i = 1; i <= 5; ++i) {
            this.numbersForResource[i] = new Vector();
        }
        this.resourcesForNumber = new Vector[13];
        for (i = 0; i < 13; ++i) {
            this.resourcesForNumber[i] = new Vector();
        }
        this.numberAndResourceForHex = new Vector[188];
        for (i = 0; i < 19; ++i) {
            this.numberAndResourceForHex[SOCPlayerNumbers.hexCoords[i]] = new Vector();
        }
    }

    public void clear() {
        int i;
        for (i = 1; i <= 5; ++i) {
            this.numbersForResource[i].removeAllElements();
        }
        for (i = 0; i < 13; ++i) {
            this.resourcesForNumber[i].removeAllElements();
        }
        for (i = 0; i < 19; ++i) {
            this.numberAndResourceForHex[hexCoords[i]].removeAllElements();
        }
    }

    public void updateNumbers(SOCPlayingPiece piece, SOCBoard board) {
        Enumeration hexes = SOCBoard.getAdjacentHexesToNode(piece.getCoordinates()).elements();
        while (hexes.hasMoreElements()) {
            Integer hex = (Integer)hexes.nextElement();
            int number = board.getNumberOnHexFromCoord(hex);
            int resource = board.getHexTypeFromCoord(hex);
            this.addNumberForResource(number, resource, hex);
        }
    }

    public void updateNumbers(int coord, SOCBoard board) {
        Enumeration hexes = SOCBoard.getAdjacentHexesToNode(coord).elements();
        while (hexes.hasMoreElements()) {
            Integer hex = (Integer)hexes.nextElement();
            int number = board.getNumberOnHexFromCoord(hex);
            int resource = board.getHexTypeFromCoord(hex);
            this.addNumberForResource(number, resource, hex);
        }
    }

    public Vector getResourcesForNumber(int num) {
        return this.resourcesForNumber[num];
    }

    public Vector getNumbersForResource(int resource) {
        return this.numbersForResource[resource];
    }

    public Vector getNumberResourcePairsForHex(int hex) {
        return this.numberAndResourceForHex[hex];
    }

    public Vector getNumbersForResource(int resource, int robberHex) {
        Vector<Integer> numbers = new Vector<Integer>();
        for (int i = 0; i < 19; ++i) {
            if (hexCoords[i] == robberHex) continue;
            Enumeration pairsEnum = this.numberAndResourceForHex[hexCoords[i]].elements();
            while (pairsEnum.hasMoreElements()) {
                IntPair pair = (IntPair)pairsEnum.nextElement();
                if (pair.getB() != resource) continue;
                numbers.addElement(new Integer(pair.getA()));
            }
        }
        return numbers;
    }

    public Vector getResourcesForNumber(int number, int robberHex) {
        Vector<Integer> resources = new Vector<Integer>();
        for (int i = 0; i < 19; ++i) {
            if (hexCoords[i] == robberHex) continue;
            Enumeration pairsEnum = this.numberAndResourceForHex[hexCoords[i]].elements();
            while (pairsEnum.hasMoreElements()) {
                IntPair pair = (IntPair)pairsEnum.nextElement();
                if (pair.getA() != number) continue;
                resources.addElement(new Integer(pair.getB()));
            }
        }
        return resources;
    }

    public void addNumberForResource(int number, int resource, int hex) {
        if (resource >= 1 && resource <= 5) {
            this.numbersForResource[resource].addElement(new Integer(number));
            Integer resourceInt = new Integer(resource);
            this.resourcesForNumber[number].addElement(resourceInt);
            this.numberAndResourceForHex[hex].addElement(new IntPair(number, resource));
        }
    }

    public void undoUpdateNumbers(SOCPlayingPiece piece, SOCBoard board) {
        Enumeration hexes = SOCBoard.getAdjacentHexesToNode(piece.getCoordinates()).elements();
        while (hexes.hasMoreElements()) {
            Integer hex = (Integer)hexes.nextElement();
            int number = board.getNumberOnHexFromCoord(hex);
            int resource = board.getHexTypeFromCoord(hex);
            this.undoAddNumberForResource(number, resource, hex);
        }
    }

    public void undoUpdateNumbers(int coord, SOCBoard board) {
        Enumeration hexes = SOCBoard.getAdjacentHexesToNode(coord).elements();
        while (hexes.hasMoreElements()) {
            Integer hex = (Integer)hexes.nextElement();
            int number = board.getNumberOnHexFromCoord(hex);
            int resource = board.getHexTypeFromCoord(hex);
            this.undoAddNumberForResource(number, resource, hex);
        }
    }

    public void undoAddNumberForResource(int number, int resource, int hex) {
        if (resource >= 1 && resource <= 5) {
            Enumeration numEnum = this.numbersForResource[resource].elements();
            while (numEnum.hasMoreElements()) {
                Integer num = (Integer)numEnum.nextElement();
                if (num != number) continue;
                this.numbersForResource[resource].removeElement(num);
                break;
            }
            Enumeration resourceEnum = this.resourcesForNumber[number].elements();
            while (resourceEnum.hasMoreElements()) {
                Integer resourceInt = (Integer)resourceEnum.nextElement();
                if (resourceInt != resource) continue;
                this.resourcesForNumber[number].removeElement(resourceInt);
                break;
            }
            Enumeration numAndResourceEnum = this.numberAndResourceForHex[hex].elements();
            while (numAndResourceEnum.hasMoreElements()) {
                IntPair numAndResource = (IntPair)numAndResourceEnum.nextElement();
                if (numAndResource.getA() != number || numAndResource.getB() != resource) continue;
                this.numberAndResourceForHex[hex].removeElement(numAndResource);
                break;
            }
        }
    }

    public boolean hasNumber(int number) {
        return !this.resourcesForNumber[number].isEmpty();
    }

    public SOCPlayerNumbers copy() {
        SOCPlayerNumbers copy = new SOCPlayerNumbers();
        for (int i = 0; i < 19; ++i) {
            Enumeration pairsEnum = this.numberAndResourceForHex[hexCoords[i]].elements();
            while (pairsEnum.hasMoreElements()) {
                IntPair pair = (IntPair)pairsEnum.nextElement();
                copy.addNumberForResource(pair.getA(), pair.getB(), hexCoords[i]);
            }
        }
        return copy;
    }

    public String toString() {
        String str = "SOCPN:";
        for (int i = 1; i <= 5; ++i) {
            str = str + i + ":";
            Enumeration nums = this.numbersForResource[i].elements();
            while (nums.hasMoreElements()) {
                Integer num = (Integer)nums.nextElement();
                str = str + num + ",";
            }
            str = str + "|";
        }
        return str;
    }
}

