/*
 * Decompiled with CFR 0.152.
 */
package soc.game;

import java.io.Serializable;

public class SOCResourceSet
implements Serializable,
Cloneable {
    public static final SOCResourceSet EMPTY_SET = new SOCResourceSet();
    private int[] resources = new int[7];

    public SOCResourceSet() {
        this.clear();
    }

    public SOCResourceSet(int cl, int or, int sh, int wh, int wo, int uk) {
        this.resources[1] = cl;
        this.resources[2] = or;
        this.resources[3] = sh;
        this.resources[4] = wh;
        this.resources[5] = wo;
        this.resources[6] = uk;
    }

    public int pickResource() {
        if (this.resources[1] > 0) {
            return 1;
        }
        if (this.resources[2] > 0) {
            return 2;
        }
        if (this.resources[3] > 0) {
            return 3;
        }
        if (this.resources[4] > 0) {
            return 4;
        }
        if (this.resources[5] > 0) {
            return 5;
        }
        return -1;
    }

    public void clear() {
        for (int i = 1; i < 7; ++i) {
            this.resources[i] = 0;
        }
    }

    public int getAmount(int rtype) {
        return this.resources[rtype];
    }

    public int getTotal() {
        int sum = 0;
        for (int i = 1; i < 7; ++i) {
            sum += this.resources[i];
        }
        return sum;
    }

    public void setAmount(int amt, int rtype) {
        this.resources[rtype] = amt;
    }

    public void add(int amt, int rtype) {
        int n = rtype;
        this.resources[n] = this.resources[n] + amt;
    }

    public void subtract(int amt, int rtype) {
        if (amt > this.resources[rtype]) {
            this.resources[6] = this.resources[6] - (amt - this.resources[rtype]);
            this.resources[rtype] = 0;
        } else {
            int n = rtype;
            this.resources[n] = this.resources[n] - amt;
        }
        if (this.resources[6] < 0) {
            System.err.println("RESOURCE < 0 : RESOURCE TYPE=" + rtype);
        }
    }

    public void add(SOCResourceSet rs) {
        this.resources[1] = this.resources[1] + rs.getAmount(1);
        this.resources[2] = this.resources[2] + rs.getAmount(2);
        this.resources[3] = this.resources[3] + rs.getAmount(3);
        this.resources[4] = this.resources[4] + rs.getAmount(4);
        this.resources[5] = this.resources[5] + rs.getAmount(5);
        this.resources[6] = this.resources[6] + rs.getAmount(6);
    }

    public void subtract(SOCResourceSet rs) {
        this.resources[1] = this.resources[1] - rs.getAmount(1);
        if (this.resources[1] < 0) {
            this.resources[1] = 0;
        }
        this.resources[2] = this.resources[2] - rs.getAmount(2);
        if (this.resources[2] < 0) {
            this.resources[2] = 0;
        }
        this.resources[3] = this.resources[3] - rs.getAmount(3);
        if (this.resources[3] < 0) {
            this.resources[3] = 0;
        }
        this.resources[4] = this.resources[4] - rs.getAmount(4);
        if (this.resources[4] < 0) {
            this.resources[4] = 0;
        }
        this.resources[5] = this.resources[5] - rs.getAmount(5);
        if (this.resources[5] < 0) {
            this.resources[5] = 0;
        }
        this.resources[6] = this.resources[6] - rs.getAmount(6);
        if (this.resources[6] < 0) {
            this.resources[6] = 0;
        }
    }

    public static boolean gte(SOCResourceSet a, SOCResourceSet b) {
        return a.getAmount(1) >= b.getAmount(1) && a.getAmount(2) >= b.getAmount(2) && a.getAmount(3) >= b.getAmount(3) && a.getAmount(4) >= b.getAmount(4) && a.getAmount(5) >= b.getAmount(5) && a.getAmount(6) >= b.getAmount(6);
    }

    public static boolean lte(SOCResourceSet a, SOCResourceSet b) {
        return a.getAmount(1) <= b.getAmount(1) && a.getAmount(2) <= b.getAmount(2) && a.getAmount(3) <= b.getAmount(3) && a.getAmount(4) <= b.getAmount(4) && a.getAmount(5) <= b.getAmount(5) && a.getAmount(6) <= b.getAmount(6);
    }

    public String toString() {
        String s = "clay=" + this.resources[1] + "|ore=" + this.resources[2] + "|sheep=" + this.resources[3] + "|wheat=" + this.resources[4] + "|wood=" + this.resources[5] + "|unknown=" + this.resources[6];
        return s;
    }

    public String toShortString() {
        String s = "Resources: " + this.resources[1] + " " + this.resources[2] + " " + this.resources[3] + " " + this.resources[4] + " " + this.resources[5] + " " + this.resources[6];
        return s;
    }

    public boolean contains(SOCResourceSet sub) {
        return SOCResourceSet.gte(this, sub);
    }

    public boolean equals(Object anObject) {
        return anObject instanceof SOCResourceSet && ((SOCResourceSet)anObject).getAmount(1) == this.resources[1] && ((SOCResourceSet)anObject).getAmount(2) == this.resources[2] && ((SOCResourceSet)anObject).getAmount(3) == this.resources[3] && ((SOCResourceSet)anObject).getAmount(4) == this.resources[4] && ((SOCResourceSet)anObject).getAmount(5) == this.resources[5] && ((SOCResourceSet)anObject).getAmount(6) == this.resources[6];
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public SOCResourceSet copy() {
        SOCResourceSet copy = new SOCResourceSet();
        copy.add(this);
        return copy;
    }

    public void setAmounts(SOCResourceSet set) {
        this.resources[1] = set.getAmount(1);
        this.resources[2] = set.getAmount(2);
        this.resources[3] = set.getAmount(3);
        this.resources[4] = set.getAmount(4);
        this.resources[5] = set.getAmount(5);
        this.resources[6] = set.getAmount(6);
    }
}

