/*
 * Decompiled with CFR 0.152.
 */
package soc.game;

import java.io.Serializable;
import soc.game.SOCResourceSet;

public class SOCTradeOffer
implements Serializable,
Cloneable {
    String game;
    SOCResourceSet give;
    SOCResourceSet get;
    int from;
    boolean[] to;

    public SOCTradeOffer(String game, int from, boolean[] to, SOCResourceSet give, SOCResourceSet get) {
        this.game = game;
        this.from = from;
        this.to = to;
        this.give = give;
        this.get = get;
    }

    public SOCTradeOffer(SOCTradeOffer offer) {
        this.game = offer.game;
        this.from = offer.from;
        this.to = new boolean[4];
        for (int i = 0; i < 4; ++i) {
            this.to[i] = offer.to[i];
        }
        this.give = offer.give.copy();
        this.get = offer.get.copy();
    }

    public String getGame() {
        return this.game;
    }

    public int getFrom() {
        return this.from;
    }

    public boolean[] getTo() {
        return this.to;
    }

    public SOCResourceSet getGiveSet() {
        return this.give;
    }

    public SOCResourceSet getGetSet() {
        return this.get;
    }

    public String toString() {
        String str = "game=" + this.game + "|from=" + this.from + "|to=" + this.to[0];
        for (int i = 1; i < 4; ++i) {
            str = str + "," + this.to[i];
        }
        str = str + "|give=" + this.give + "|get=" + this.get;
        return str;
    }
}

