/*
 * Decompiled with CFR 0.152.
 */
package soc.message;

import java.util.StringTokenizer;
import soc.message.SOCMessage;

public class SOCAcceptOffer
extends SOCMessage {
    private String game;
    private int accepting;
    private int offering;

    public SOCAcceptOffer(String ga, int ac, int of) {
        this.messageType = 1039;
        this.game = ga;
        this.accepting = ac;
        this.offering = of;
    }

    @Override
    public String getGame() {
        return this.game;
    }

    public int getAcceptingNumber() {
        return this.accepting;
    }

    public int getOfferingNumber() {
        return this.offering;
    }

    @Override
    public String toCmd() {
        return SOCAcceptOffer.toCmd(this.game, this.accepting, this.offering);
    }

    public static String toCmd(String ga, int ac, int of) {
        return "1039|" + ga + sep2 + ac + sep2 + of;
    }

    public static SOCAcceptOffer parseDataStr(String s) {
        int of;
        int ac;
        String ga;
        StringTokenizer st = new StringTokenizer(s, sep2);
        try {
            ga = st.nextToken();
            ac = Integer.parseInt(st.nextToken());
            of = Integer.parseInt(st.nextToken());
        }
        catch (Exception e) {
            return null;
        }
        return new SOCAcceptOffer(ga, ac, of);
    }

    public String toString() {
        return "SOCAcceptOffer:game=" + this.game + "|accepting=" + this.accepting + "|offering=" + this.offering;
    }
}

