/*
 * Decompiled with CFR 0.152.
 */
package soc.message;

import java.util.StringTokenizer;
import soc.game.SOCResourceSet;
import soc.message.SOCMessage;

public class SOCBankTrade
extends SOCMessage {
    private String game;
    private SOCResourceSet give;
    private SOCResourceSet get;

    public SOCBankTrade(String ga, SOCResourceSet give, SOCResourceSet get) {
        this.messageType = 1040;
        this.game = ga;
        this.give = give;
        this.get = get;
    }

    @Override
    public String getGame() {
        return this.game;
    }

    public SOCResourceSet getGiveSet() {
        return this.give;
    }

    public SOCResourceSet getGetSet() {
        return this.get;
    }

    @Override
    public String toCmd() {
        return SOCBankTrade.toCmd(this.game, this.give, this.get);
    }

    public static String toCmd(String ga, SOCResourceSet give, SOCResourceSet get) {
        int i;
        String cmd = "1040|" + ga;
        for (i = 1; i <= 5; ++i) {
            cmd = cmd + sep2 + give.getAmount(i);
        }
        for (i = 1; i <= 5; ++i) {
            cmd = cmd + sep2 + get.getAmount(i);
        }
        return cmd;
    }

    public static SOCBankTrade parseDataStr(String s) {
        String ga;
        SOCResourceSet give = new SOCResourceSet();
        SOCResourceSet get = new SOCResourceSet();
        StringTokenizer st = new StringTokenizer(s, sep2);
        try {
            int i;
            ga = st.nextToken();
            for (i = 1; i <= 5; ++i) {
                give.setAmount(Integer.parseInt(st.nextToken()), i);
            }
            for (i = 1; i <= 5; ++i) {
                get.setAmount(Integer.parseInt(st.nextToken()), i);
            }
        }
        catch (Exception e) {
            return null;
        }
        return new SOCBankTrade(ga, give, get);
    }

    public String toString() {
        return "SOCBankTrade:game=" + this.game + "|give=" + this.give + "|get=" + this.get;
    }
}

