/*
 * Decompiled with CFR 0.152.
 */
package soc.message;

import java.util.StringTokenizer;
import soc.message.SOCMessage;

public class SOCBoardLayout
extends SOCMessage {
    private String game;
    private int[] hexLayout;
    private int[] numberLayout;
    private int robberHex;

    public SOCBoardLayout(String ga, int[] hl, int[] nl, int rh) {
        this.messageType = 1014;
        this.game = ga;
        this.hexLayout = hl;
        this.numberLayout = nl;
        this.robberHex = rh;
    }

    @Override
    public String getGame() {
        return this.game;
    }

    public int[] getHexLayout() {
        return this.hexLayout;
    }

    public int[] getNumberLayout() {
        return this.numberLayout;
    }

    public int getRobberHex() {
        return this.robberHex;
    }

    @Override
    public String toCmd() {
        return SOCBoardLayout.toCmd(this.game, this.hexLayout, this.numberLayout, this.robberHex);
    }

    public static String toCmd(String ga, int[] hl, int[] nl, int rh) {
        int i;
        String cmd = "1014|" + ga;
        for (i = 0; i < 37; ++i) {
            cmd = cmd + sep2 + hl[i];
        }
        for (i = 0; i < 37; ++i) {
            cmd = cmd + sep2 + nl[i];
        }
        cmd = cmd + sep2 + rh;
        return cmd;
    }

    public static SOCBoardLayout parseDataStr(String s) {
        int rh;
        String ga;
        int[] hl = new int[37];
        int[] nl = new int[37];
        StringTokenizer st = new StringTokenizer(s, sep2);
        try {
            int i;
            ga = st.nextToken();
            for (i = 0; i < 37; ++i) {
                hl[i] = Integer.parseInt(st.nextToken());
            }
            for (i = 0; i < 37; ++i) {
                nl[i] = Integer.parseInt(st.nextToken());
            }
            rh = Integer.parseInt(st.nextToken());
        }
        catch (Exception e) {
            return null;
        }
        return new SOCBoardLayout(ga, hl, nl, rh);
    }

    public String toString() {
        String s = "SOCBoardLayout:game=" + this.game + "|hexLayout=" + this.hexLayout + "|numberLayout=" + this.numberLayout + "|robberHex=" + this.robberHex;
        return s;
    }
}

