/*
 * Decompiled with CFR 0.152.
 */
package soc.message;

import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import soc.message.SOCMessage;

public class SOCChannels
extends SOCMessage {
    private Vector channels;

    public SOCChannels(Vector cl) {
        this.messageType = 1003;
        this.channels = cl;
    }

    public Vector getChannels() {
        return this.channels;
    }

    @Override
    public String toCmd() {
        return SOCChannels.toCmd(this.channels);
    }

    public static String toCmd(Vector cl) {
        String cmd = "1003|";
        try {
            Enumeration clEnum = cl.elements();
            cmd = cmd + (String)clEnum.nextElement();
            while (clEnum.hasMoreElements()) {
                cmd = cmd + sep2 + (String)clEnum.nextElement();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return cmd;
    }

    public static SOCChannels parseDataStr(String s) {
        Vector<String> cl = new Vector<String>();
        StringTokenizer st = new StringTokenizer(s, sep2);
        try {
            while (st.hasMoreTokens()) {
                cl.addElement(st.nextToken());
            }
        }
        catch (Exception e) {
            System.err.println("SOCChannels parseDataStr ERROR - " + e);
            return null;
        }
        return new SOCChannels(cl);
    }

    public String toString() {
        String s = "SOCChannels:channels=";
        try {
            Enumeration clEnum = this.channels.elements();
            s = s + (String)clEnum.nextElement();
            while (clEnum.hasMoreElements()) {
                s = s + "," + (String)clEnum.nextElement();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return s;
    }
}

