/*
 * Decompiled with CFR 0.152.
 */
package soc.message;

import java.util.StringTokenizer;
import soc.message.SOCMessage;

public class SOCCreateAccount
extends SOCMessage {
    private static String NULLEMAIL = "\t";
    private String nickname;
    private String password;
    private String host;
    private String email;

    public SOCCreateAccount(String nn, String pw, String hn, String em) {
        this.messageType = 1070;
        this.nickname = nn;
        this.password = pw;
        this.email = em;
        this.host = hn;
    }

    public String getNickname() {
        return this.nickname;
    }

    public String getPassword() {
        return this.password;
    }

    public String getHost() {
        return this.host;
    }

    public String getEmail() {
        return this.email;
    }

    @Override
    public String toCmd() {
        return SOCCreateAccount.toCmd(this.nickname, this.password, this.host, this.email);
    }

    public static String toCmd(String nn, String pw, String hn, String em) {
        String tempem;
        if (em == null) {
            tempem = NULLEMAIL;
        } else {
            tempem = new String(em);
            if (tempem.equals("")) {
                tempem = NULLEMAIL;
            }
        }
        return "1070|" + nn + sep2 + pw + sep2 + hn + sep2 + tempem;
    }

    public static SOCCreateAccount parseDataStr(String s) {
        String em;
        String hn;
        String pw;
        String nn;
        StringTokenizer st = new StringTokenizer(s, sep2);
        try {
            nn = st.nextToken();
            pw = st.nextToken();
            hn = st.nextToken();
            em = st.nextToken();
            if (em.equals(NULLEMAIL)) {
                em = "";
            }
        }
        catch (Exception e) {
            return null;
        }
        return new SOCCreateAccount(nn, pw, hn, em);
    }

    public String toString() {
        String s = "SOCCreateAccount:nickname=" + this.nickname + "|password=" + this.password + "|host=" + this.host + "|email=" + this.email;
        return s;
    }
}

