/*
 * Decompiled with CFR 0.152.
 */
package soc.message;

import java.util.StringTokenizer;
import soc.message.SOCMessage;

public class SOCDevCard
extends SOCMessage {
    public static final int DRAW = 0;
    public static final int PLAY = 1;
    public static final int ADDNEW = 2;
    public static final int ADDOLD = 3;
    private String game;
    private int playerNumber;
    private int cardType;
    private int actionType;

    public SOCDevCard(String ga, int pn, int ac, int ct) {
        this.messageType = 1046;
        this.game = ga;
        this.playerNumber = pn;
        this.actionType = ac;
        this.cardType = ct;
    }

    @Override
    public String getGame() {
        return this.game;
    }

    public int getPlayerNumber() {
        return this.playerNumber;
    }

    public int getAction() {
        return this.actionType;
    }

    public int getCardType() {
        return this.cardType;
    }

    @Override
    public String toCmd() {
        return SOCDevCard.toCmd(this.game, this.playerNumber, this.actionType, this.cardType);
    }

    public static String toCmd(String ga, int pn, int ac, int ct) {
        return "1046|" + ga + sep2 + pn + sep2 + ac + sep2 + ct;
    }

    public static SOCDevCard parseDataStr(String s) {
        int ct;
        int ac;
        int pn;
        String ga;
        StringTokenizer st = new StringTokenizer(s, sep2);
        try {
            ga = st.nextToken();
            pn = Integer.parseInt(st.nextToken());
            ac = Integer.parseInt(st.nextToken());
            ct = Integer.parseInt(st.nextToken());
        }
        catch (Exception e) {
            return null;
        }
        return new SOCDevCard(ga, pn, ac, ct);
    }

    public String toString() {
        String s = "SOCDevCard:game=" + this.game + "|playerNum=" + this.playerNumber + "|actionType=" + this.actionType + "|cardType=" + this.cardType;
        return s;
    }
}

