/*
 * Decompiled with CFR 0.152.
 */
package soc.message;

import java.util.StringTokenizer;
import soc.game.SOCResourceSet;
import soc.message.SOCMessage;

public class SOCDiscard
extends SOCMessage {
    private String game;
    private SOCResourceSet resources;

    public SOCDiscard(String ga, int cl, int or, int sh, int wh, int wo, int uk) {
        this.messageType = 1033;
        this.game = ga;
        this.resources = new SOCResourceSet(cl, or, sh, wh, wo, uk);
    }

    public SOCDiscard(String ga, int pn, SOCResourceSet rs) {
        this.messageType = 1033;
        this.game = ga;
        this.resources = rs;
    }

    @Override
    public String getGame() {
        return this.game;
    }

    public SOCResourceSet getResources() {
        return this.resources;
    }

    @Override
    public String toCmd() {
        return SOCDiscard.toCmd(this.game, this.resources.getAmount(1), this.resources.getAmount(2), this.resources.getAmount(3), this.resources.getAmount(4), this.resources.getAmount(5), this.resources.getAmount(6));
    }

    public static String toCmd(String ga, SOCResourceSet rs) {
        return SOCDiscard.toCmd(ga, rs.getAmount(1), rs.getAmount(2), rs.getAmount(3), rs.getAmount(4), rs.getAmount(5), rs.getAmount(6));
    }

    public static String toCmd(String ga, int cl, int or, int sh, int wh, int wo, int uk) {
        return "1033|" + ga + sep2 + cl + sep2 + or + sep2 + sh + sep2 + wh + sep2 + wo + sep2 + uk;
    }

    public static SOCDiscard parseDataStr(String s) {
        int uk;
        int wo;
        int wh;
        int sh;
        int or;
        int cl;
        String ga;
        StringTokenizer st = new StringTokenizer(s, sep2);
        try {
            ga = st.nextToken();
            cl = Integer.parseInt(st.nextToken());
            or = Integer.parseInt(st.nextToken());
            sh = Integer.parseInt(st.nextToken());
            wh = Integer.parseInt(st.nextToken());
            wo = Integer.parseInt(st.nextToken());
            uk = Integer.parseInt(st.nextToken());
        }
        catch (Exception e) {
            return null;
        }
        return new SOCDiscard(ga, cl, or, sh, wh, wo, uk);
    }

    public String toString() {
        return "SOCDiscard:game=" + this.game + "|resources=" + this.resources;
    }
}

