/*
 * Decompiled with CFR 0.152.
 */
package soc.message;

import java.util.StringTokenizer;
import soc.game.SOCResourceSet;
import soc.message.SOCMessage;

public class SOCDiscoveryPick
extends SOCMessage {
    private String game;
    private SOCResourceSet resources;

    public SOCDiscoveryPick(String ga, SOCResourceSet rs) {
        this.messageType = 1052;
        this.game = ga;
        this.resources = rs;
    }

    @Override
    public String getGame() {
        return this.game;
    }

    public SOCResourceSet getResources() {
        return this.resources;
    }

    @Override
    public String toCmd() {
        return SOCDiscoveryPick.toCmd(this.game, this.resources);
    }

    public static String toCmd(String ga, SOCResourceSet rs) {
        String cmd = "1052|" + ga;
        for (int i = 1; i <= 5; ++i) {
            cmd = cmd + sep2 + rs.getAmount(i);
        }
        return cmd;
    }

    public static SOCDiscoveryPick parseDataStr(String s) {
        String ga;
        SOCResourceSet rs = new SOCResourceSet();
        StringTokenizer st = new StringTokenizer(s, sep2);
        try {
            ga = st.nextToken();
            for (int i = 1; i <= 5; ++i) {
                rs.setAmount(Integer.parseInt(st.nextToken()), i);
            }
        }
        catch (Exception e) {
            return null;
        }
        return new SOCDiscoveryPick(ga, rs);
    }

    public String toString() {
        return "SOCDiscoveryPick:game=" + this.game + "|resources=" + this.resources;
    }
}

