/*
 * Decompiled with CFR 0.152.
 */
package soc.message;

import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import soc.message.SOCMessage;
import soc.server.genericServer.Connection;

public class SOCGameMembers
extends SOCMessage {
    private Vector members;
    private String game;

    public SOCGameMembers(String ga, Vector ml) {
        this.messageType = 1017;
        this.members = ml;
        this.game = ga;
    }

    public Vector getMembers() {
        return this.members;
    }

    @Override
    public String getGame() {
        return this.game;
    }

    @Override
    public String toCmd() {
        return SOCGameMembers.toCmd(this.game, this.members);
    }

    public static String toCmd(String ga, Vector ml) {
        String cmd = "1017|" + ga;
        try {
            Enumeration mlEnum = ml.elements();
            while (mlEnum.hasMoreElements()) {
                Connection con = (Connection)mlEnum.nextElement();
                cmd = cmd + sep2 + (String)con.data;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return cmd;
    }

    public static SOCGameMembers parseDataStr(String s) {
        String ga;
        Vector<String> ml = new Vector<String>();
        StringTokenizer st = new StringTokenizer(s, sep2);
        try {
            ga = st.nextToken();
            while (st.hasMoreTokens()) {
                ml.addElement(st.nextToken());
            }
        }
        catch (Exception e) {
            return null;
        }
        return new SOCGameMembers(ga, ml);
    }

    public String toString() {
        String s = "SOCGameMembers:game=" + this.game + "|members=";
        try {
            Enumeration mlEnum = this.members.elements();
            s = s + (String)mlEnum.nextElement();
            while (mlEnum.hasMoreElements()) {
                s = s + "," + (String)mlEnum.nextElement();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return s;
    }
}

