/*
 * Decompiled with CFR 0.152.
 */
package soc.message;

import java.util.StringTokenizer;
import soc.message.SOCMessage;

public class SOCGameStats
extends SOCMessage {
    private String game;
    private int[] scores;
    private boolean[] robots;

    public SOCGameStats(String ga, int[] sc, boolean[] rb) {
        this.messageType = 1061;
        this.game = ga;
        this.scores = sc;
        this.robots = rb;
    }

    @Override
    public String getGame() {
        return this.game;
    }

    public int[] getScores() {
        return this.scores;
    }

    public boolean[] getRobotSeats() {
        return this.robots;
    }

    @Override
    public String toCmd() {
        return SOCGameStats.toCmd(this.game, this.scores, this.robots);
    }

    public static String toCmd(String ga, int[] sc, boolean[] rb) {
        int i;
        String cmd = "1061|" + ga;
        for (i = 0; i < 4; ++i) {
            cmd = cmd + sep2 + sc[i];
        }
        for (i = 0; i < 4; ++i) {
            cmd = cmd + sep2 + rb[i];
        }
        return cmd;
    }

    public static SOCGameStats parseDataStr(String s) {
        String ga;
        int[] sc = new int[4];
        boolean[] rb = new boolean[4];
        StringTokenizer st = new StringTokenizer(s, sep2);
        try {
            int i;
            ga = st.nextToken();
            for (i = 0; i < 4; ++i) {
                sc[i] = Integer.parseInt(st.nextToken());
            }
            for (i = 0; i < 4; ++i) {
                rb[i] = Boolean.valueOf(st.nextToken());
            }
        }
        catch (Exception e) {
            return null;
        }
        return new SOCGameStats(ga, sc, rb);
    }

    public String toString() {
        int i;
        String text = "SOCGameStats:game=" + this.game;
        for (i = 0; i < 4; ++i) {
            text = text + "|" + this.scores[i];
        }
        for (i = 0; i < 4; ++i) {
            text = text + "|" + this.robots[i];
        }
        return text;
    }
}

