/*
 * Decompiled with CFR 0.152.
 */
package soc.message;

import java.util.StringTokenizer;
import soc.message.SOCMessage;

public class SOCGameTextMsg
extends SOCMessage {
    private static String sep2 = "\u0000";
    private String game;
    private String nickname;
    private String text;

    public SOCGameTextMsg(String ga, String nn, String tm) {
        this.messageType = 1010;
        this.game = ga;
        this.nickname = nn;
        this.text = tm;
    }

    @Override
    public String getGame() {
        return this.game;
    }

    public String getNickname() {
        return this.nickname;
    }

    public String getText() {
        return this.text;
    }

    @Override
    public String toCmd() {
        return SOCGameTextMsg.toCmd(this.game, this.nickname, this.text);
    }

    public static String toCmd(String ga, String nn, String tm) {
        return "1010|" + ga + sep2 + nn + sep2 + tm;
    }

    public static SOCGameTextMsg parseDataStr(String s) {
        String tm;
        String nn;
        String ga;
        StringTokenizer st = new StringTokenizer(s, sep2);
        try {
            ga = st.nextToken();
            nn = st.nextToken();
            tm = st.nextToken();
        }
        catch (Exception e) {
            return null;
        }
        return new SOCGameTextMsg(ga, nn, tm);
    }

    public String toString() {
        String s = "SOCGameTextMsg:game=" + this.game + "|nickname=" + this.nickname + "|text=" + this.text;
        return s;
    }
}

