/*
 * Decompiled with CFR 0.152.
 */
package soc.message;

import java.util.StringTokenizer;
import soc.message.SOCMessage;

public class SOCJoin
extends SOCMessage {
    private static String NULLPASS = "\t";
    private String nickname;
    private String password;
    private String channel;
    private String host;

    public SOCJoin(String nn, String pw, String hn, String ch) {
        this.messageType = 1004;
        this.nickname = nn;
        this.password = pw;
        this.channel = ch;
        this.host = hn;
    }

    public String getNickname() {
        return this.nickname;
    }

    public String getPassword() {
        return this.password;
    }

    public String getHost() {
        return this.host;
    }

    public String getChannel() {
        return this.channel;
    }

    @Override
    public String toCmd() {
        return SOCJoin.toCmd(this.nickname, this.password, this.host, this.channel);
    }

    public static String toCmd(String nn, String pw, String hn, String ch) {
        String temppw = new String(pw);
        if (temppw.equals("")) {
            temppw = NULLPASS;
        }
        return "1004|" + nn + sep2 + temppw + sep2 + hn + sep2 + ch;
    }

    public static SOCJoin parseDataStr(String s) {
        String ch;
        String hn;
        String pw;
        String nn;
        StringTokenizer st = new StringTokenizer(s, sep2);
        try {
            nn = st.nextToken();
            pw = st.nextToken();
            hn = st.nextToken();
            ch = st.nextToken();
            if (pw.equals(NULLPASS)) {
                pw = "";
            }
        }
        catch (Exception e) {
            return null;
        }
        return new SOCJoin(nn, pw, hn, ch);
    }

    public String toString() {
        String s = "SOCJoin:nickname=" + this.nickname + "|password=" + this.password + "|host=" + this.host + "|channel=" + this.channel;
        return s;
    }
}

