/*
 * Decompiled with CFR 0.152.
 */
package soc.message;

import java.util.StringTokenizer;
import soc.message.SOCMessage;

public class SOCJoinAuth
extends SOCMessage {
    private String nickname;
    private String channel;

    public SOCJoinAuth(String nn, String ch) {
        this.messageType = 1020;
        this.nickname = nn;
        this.channel = ch;
    }

    public String getNickname() {
        return this.nickname;
    }

    public String getChannel() {
        return this.channel;
    }

    @Override
    public String toCmd() {
        return SOCJoinAuth.toCmd(this.nickname, this.channel);
    }

    public static String toCmd(String nn, String ch) {
        return "1020|" + nn + sep2 + ch;
    }

    public static SOCJoinAuth parseDataStr(String s) {
        String ch;
        String nn;
        StringTokenizer st = new StringTokenizer(s, sep2);
        try {
            nn = st.nextToken();
            ch = st.nextToken();
        }
        catch (Exception e) {
            return null;
        }
        return new SOCJoinAuth(nn, ch);
    }

    public String toString() {
        String s = "SOCJoinAuth:nickname=" + this.nickname + "|channel=" + this.channel;
        return s;
    }
}

