/*
 * Decompiled with CFR 0.152.
 */
package soc.message;

import java.util.StringTokenizer;
import soc.message.SOCMessage;

public class SOCJoinGame
extends SOCMessage {
    private static String NULLPASS = "\t";
    private String nickname;
    private String password;
    private String game;
    private String host;

    public SOCJoinGame(String nn, String pw, String hn, String ga) {
        this.messageType = 1013;
        this.nickname = nn;
        this.password = pw;
        this.game = ga;
        this.host = hn;
    }

    public String getNickname() {
        return this.nickname;
    }

    public String getPassword() {
        return this.password;
    }

    public String getHost() {
        return this.host;
    }

    @Override
    public String getGame() {
        return this.game;
    }

    @Override
    public String toCmd() {
        return SOCJoinGame.toCmd(this.nickname, this.password, this.host, this.game);
    }

    public static String toCmd(String nn, String pw, String hn, String ga) {
        String temppw = new String(pw);
        if (temppw.equals("")) {
            temppw = NULLPASS;
        }
        return "1013|" + nn + sep2 + temppw + sep2 + hn + sep2 + ga;
    }

    public static SOCJoinGame parseDataStr(String s) {
        String ga;
        String hn;
        String pw;
        String nn;
        StringTokenizer st = new StringTokenizer(s, sep2);
        try {
            nn = st.nextToken();
            pw = st.nextToken();
            hn = st.nextToken();
            ga = st.nextToken();
            if (pw.equals(NULLPASS)) {
                pw = "";
            }
        }
        catch (Exception e) {
            return null;
        }
        return new SOCJoinGame(nn, pw, hn, ga);
    }

    public String toString() {
        String s = "SOCJoinGame:nickname=" + this.nickname + "|password=" + this.password + "|host=" + this.host + "|game=" + this.game;
        return s;
    }
}

