/*
 * Decompiled with CFR 0.152.
 */
package soc.message;

import java.util.StringTokenizer;
import soc.message.SOCMessage;

public class SOCLeave
extends SOCMessage {
    private String nickname;
    private String channel;
    private String host;

    public SOCLeave(String nn, String hn, String ch) {
        this.messageType = 1006;
        this.nickname = nn;
        this.channel = ch;
        this.host = hn;
    }

    public String getNickname() {
        return this.nickname;
    }

    public String getHost() {
        return this.host;
    }

    public String getChannel() {
        return this.channel;
    }

    @Override
    public String toCmd() {
        return SOCLeave.toCmd(this.nickname, this.host, this.channel);
    }

    public static String toCmd(String nn, String hn, String ch) {
        return "1006|" + nn + sep2 + hn + sep2 + ch;
    }

    public static SOCLeave parseDataStr(String s) {
        String ch;
        String hn;
        String nn;
        StringTokenizer st = new StringTokenizer(s, sep2);
        try {
            nn = st.nextToken();
            hn = st.nextToken();
            ch = st.nextToken();
        }
        catch (Exception e) {
            return null;
        }
        return new SOCLeave(nn, hn, ch);
    }

    public String toString() {
        String s = "SOCLeave:nickname=" + this.nickname + "|host=" + this.host + "|channel=" + this.channel;
        return s;
    }
}

