/*
 * Decompiled with CFR 0.152.
 */
package soc.message;

import java.util.StringTokenizer;
import soc.game.SOCResourceSet;
import soc.game.SOCTradeOffer;
import soc.message.SOCMessage;

public class SOCMakeOffer
extends SOCMessage {
    private String game;
    private SOCTradeOffer offer;

    public SOCMakeOffer(String ga, SOCTradeOffer of) {
        this.messageType = 1041;
        this.game = ga;
        this.offer = of;
    }

    @Override
    public String getGame() {
        return this.game;
    }

    public SOCTradeOffer getOffer() {
        return this.offer;
    }

    @Override
    public String toCmd() {
        return SOCMakeOffer.toCmd(this.game, this.offer);
    }

    public static String toCmd(String ga, SOCTradeOffer of) {
        String cmd = "1041|" + ga;
        cmd = cmd + sep2 + of.getFrom();
        boolean[] to = of.getTo();
        for (int i = 0; i < 4; ++i) {
            cmd = cmd + sep2 + to[i];
        }
        SOCResourceSet give = of.getGiveSet();
        for (int i = 1; i <= 5; ++i) {
            cmd = cmd + sep2 + give.getAmount(i);
        }
        SOCResourceSet get = of.getGetSet();
        for (int i = 1; i <= 5; ++i) {
            cmd = cmd + sep2 + get.getAmount(i);
        }
        return cmd;
    }

    public static SOCMakeOffer parseDataStr(String s) {
        int from;
        String ga;
        boolean[] to = new boolean[4];
        SOCResourceSet give = new SOCResourceSet();
        SOCResourceSet get = new SOCResourceSet();
        StringTokenizer st = new StringTokenizer(s, sep2);
        try {
            int i;
            ga = st.nextToken();
            from = Integer.parseInt(st.nextToken());
            for (i = 0; i < 4; ++i) {
                to[i] = Boolean.valueOf(st.nextToken());
            }
            for (i = 1; i <= 5; ++i) {
                give.setAmount(Integer.parseInt(st.nextToken()), i);
            }
            for (i = 1; i <= 5; ++i) {
                get.setAmount(Integer.parseInt(st.nextToken()), i);
            }
        }
        catch (Exception e) {
            return null;
        }
        return new SOCMakeOffer(ga, new SOCTradeOffer(ga, from, to, give, get));
    }

    public String toString() {
        return "SOCMakeOffer:game=" + this.game + "|offer=" + this.offer;
    }
}

