/*
 * Decompiled with CFR 0.152.
 */
package soc.message;

import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import soc.message.SOCMessage;
import soc.server.genericServer.Connection;

public class SOCMembers
extends SOCMessage {
    private Vector members;
    private String channel;

    public SOCMembers(String ch, Vector ml) {
        this.messageType = 1002;
        this.members = ml;
        this.channel = ch;
    }

    public Vector getMembers() {
        return this.members;
    }

    public String getChannel() {
        return this.channel;
    }

    @Override
    public String toCmd() {
        return SOCMembers.toCmd(this.channel, this.members);
    }

    public static String toCmd(String ch, Vector ml) {
        String cmd = "1002|" + ch;
        try {
            Enumeration mlEnum = ml.elements();
            while (mlEnum.hasMoreElements()) {
                Connection con = (Connection)mlEnum.nextElement();
                cmd = cmd + sep2 + (String)con.data;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return cmd;
    }

    public static SOCMembers parseDataStr(String s) {
        String ch;
        Vector<String> ml = new Vector<String>();
        StringTokenizer st = new StringTokenizer(s, sep2);
        try {
            ch = st.nextToken();
            while (st.hasMoreTokens()) {
                ml.addElement(st.nextToken());
            }
        }
        catch (Exception e) {
            return null;
        }
        return new SOCMembers(ch, ml);
    }

    public String toString() {
        String s = "SOCMembers:channel=" + this.channel + "|members=";
        try {
            Enumeration mlEnum = this.members.elements();
            s = s + (String)mlEnum.nextElement();
            while (mlEnum.hasMoreElements()) {
                s = s + "," + (String)mlEnum.nextElement();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return s;
    }
}

