/*
 * Decompiled with CFR 0.152.
 */
package soc.message;

import java.io.Serializable;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import soc.message.SOCAcceptOffer;
import soc.message.SOCAdminPing;
import soc.message.SOCAdminReset;
import soc.message.SOCBCastTextMsg;
import soc.message.SOCBankTrade;
import soc.message.SOCBoardLayout;
import soc.message.SOCBuildRequest;
import soc.message.SOCBuyCardRequest;
import soc.message.SOCCancelBuildRequest;
import soc.message.SOCChangeFace;
import soc.message.SOCChannels;
import soc.message.SOCChoosePlayer;
import soc.message.SOCChoosePlayerRequest;
import soc.message.SOCClearOffer;
import soc.message.SOCClearTradeMsg;
import soc.message.SOCCreateAccount;
import soc.message.SOCDeleteChannel;
import soc.message.SOCDeleteGame;
import soc.message.SOCDevCard;
import soc.message.SOCDevCardCount;
import soc.message.SOCDiceResult;
import soc.message.SOCDiscard;
import soc.message.SOCDiscardRequest;
import soc.message.SOCDiscoveryPick;
import soc.message.SOCEndTurn;
import soc.message.SOCFirstPlayer;
import soc.message.SOCGameMembers;
import soc.message.SOCGameState;
import soc.message.SOCGameStats;
import soc.message.SOCGameTextMsg;
import soc.message.SOCGames;
import soc.message.SOCImARobot;
import soc.message.SOCJoin;
import soc.message.SOCJoinAuth;
import soc.message.SOCJoinGame;
import soc.message.SOCJoinGameAuth;
import soc.message.SOCJoinGameRequest;
import soc.message.SOCLargestArmy;
import soc.message.SOCLastSettlement;
import soc.message.SOCLeave;
import soc.message.SOCLeaveAll;
import soc.message.SOCLeaveGame;
import soc.message.SOCLongestRoad;
import soc.message.SOCMakeOffer;
import soc.message.SOCMembers;
import soc.message.SOCMonopolyPick;
import soc.message.SOCMoveRobber;
import soc.message.SOCNewChannel;
import soc.message.SOCNewGame;
import soc.message.SOCPlayDevCardRequest;
import soc.message.SOCPlayerElement;
import soc.message.SOCPotentialSettlements;
import soc.message.SOCPutPiece;
import soc.message.SOCRejectConnection;
import soc.message.SOCRejectOffer;
import soc.message.SOCResourceCount;
import soc.message.SOCRobotDismiss;
import soc.message.SOCRollDice;
import soc.message.SOCRollDiceRequest;
import soc.message.SOCServerPing;
import soc.message.SOCSetPlayedDevCard;
import soc.message.SOCSetSeatLock;
import soc.message.SOCSetTurn;
import soc.message.SOCSetupDone;
import soc.message.SOCSitDown;
import soc.message.SOCStartGame;
import soc.message.SOCStatusMessage;
import soc.message.SOCTextMsg;
import soc.message.SOCTurn;
import soc.message.SOCUpdateRobotParams;

public abstract class SOCMessage
implements Serializable,
Cloneable {
    public static final int NULLMESSAGE = 1000;
    public static final int NEWCHANNEL = 1001;
    public static final int MEMBERS = 1002;
    public static final int CHANNELS = 1003;
    public static final int JOIN = 1004;
    public static final int TEXTMSG = 1005;
    public static final int LEAVE = 1006;
    public static final int DELETECHANNEL = 1007;
    public static final int LEAVEALL = 1008;
    public static final int PUTPIECE = 1009;
    public static final int GAMETEXTMSG = 1010;
    public static final int LEAVEGAME = 1011;
    public static final int SITDOWN = 1012;
    public static final int JOINGAME = 1013;
    public static final int BOARDLAYOUT = 1014;
    public static final int DELETEGAME = 1015;
    public static final int NEWGAME = 1016;
    public static final int GAMEMEMBERS = 1017;
    public static final int STARTGAME = 1018;
    public static final int GAMES = 1019;
    public static final int JOINAUTH = 1020;
    public static final int JOINGAMEAUTH = 1021;
    public static final int IMAROBOT = 1022;
    public static final int JOINGAMEREQUEST = 1023;
    public static final int PLAYERELEMENT = 1024;
    public static final int GAMESTATE = 1025;
    public static final int TURN = 1026;
    public static final int SETUPDONE = 1027;
    public static final int DICERESULT = 1028;
    public static final int DISCARDREQUEST = 1029;
    public static final int ROLLDICEREQUEST = 1030;
    public static final int ROLLDICE = 1031;
    public static final int ENDTURN = 1032;
    public static final int DISCARD = 1033;
    public static final int MOVEROBBER = 1034;
    public static final int CHOOSEPLAYER = 1035;
    public static final int CHOOSEPLAYERREQUEST = 1036;
    public static final int REJECTOFFER = 1037;
    public static final int CLEAROFFER = 1038;
    public static final int ACCEPTOFFER = 1039;
    public static final int BANKTRADE = 1040;
    public static final int MAKEOFFER = 1041;
    public static final int CLEARTRADEMSG = 1042;
    public static final int BUILDREQUEST = 1043;
    public static final int CANCELBUILDREQUEST = 1044;
    public static final int BUYCARDREQUEST = 1045;
    public static final int DEVCARD = 1046;
    public static final int DEVCARDCOUNT = 1047;
    public static final int SETPLAYEDDEVCARD = 1048;
    public static final int PLAYDEVCARDREQUEST = 1049;
    public static final int DISCOVERYPICK = 1052;
    public static final int MONOPOLYPICK = 1053;
    public static final int FIRSTPLAYER = 1054;
    public static final int SETTURN = 1055;
    public static final int ROBOTDISMISS = 1056;
    public static final int POTENTIALSETTLEMENTS = 1057;
    public static final int CHANGEFACE = 1058;
    public static final int REJECTCONNECTION = 1059;
    public static final int LASTSETTLEMENT = 1060;
    public static final int GAMESTATS = 1061;
    public static final int BCASTTEXTMSG = 1062;
    public static final int RESOURCECOUNT = 1063;
    public static final int ADMINPING = 1064;
    public static final int ADMINRESET = 1065;
    public static final int LONGESTROAD = 1066;
    public static final int LARGESTARMY = 1067;
    public static final int SETSEATLOCK = 1068;
    public static final int STATUSMESSAGE = 1069;
    public static final int CREATEACCOUNT = 1070;
    public static final int UPDATEROBOTPARAMS = 1071;
    public static final int SERVERPING = 9999;
    public static final int IMSMARTSETTLERS = 1072;
    protected static final String sep = "|";
    protected static String sep2 = ",";
    protected int messageType;

    public int getType() {
        return this.messageType;
    }

    public abstract String toCmd();

    public static SOCMessage toMsg(String s) {
        try {
            String data;
            StringTokenizer st = new StringTokenizer(s, sep);
            int msgId = Integer.parseInt(st.nextToken());
            try {
                data = st.nextToken();
            }
            catch (NoSuchElementException e) {
                data = "";
            }
            switch (msgId) {
                case 1000: {
                    return null;
                }
                case 1001: {
                    return SOCNewChannel.parseDataStr(data);
                }
                case 1002: {
                    return SOCMembers.parseDataStr(data);
                }
                case 1003: {
                    return SOCChannels.parseDataStr(data);
                }
                case 1004: {
                    return SOCJoin.parseDataStr(data);
                }
                case 1005: {
                    return SOCTextMsg.parseDataStr(data);
                }
                case 1006: {
                    return SOCLeave.parseDataStr(data);
                }
                case 1007: {
                    return SOCDeleteChannel.parseDataStr(data);
                }
                case 1008: {
                    return SOCLeaveAll.parseDataStr(data);
                }
                case 1009: {
                    return SOCPutPiece.parseDataStr(data);
                }
                case 1010: {
                    return SOCGameTextMsg.parseDataStr(data);
                }
                case 1011: {
                    return SOCLeaveGame.parseDataStr(data);
                }
                case 1012: {
                    return SOCSitDown.parseDataStr(data);
                }
                case 1013: {
                    return SOCJoinGame.parseDataStr(data);
                }
                case 1014: {
                    return SOCBoardLayout.parseDataStr(data);
                }
                case 1019: {
                    return SOCGames.parseDataStr(data);
                }
                case 1015: {
                    return SOCDeleteGame.parseDataStr(data);
                }
                case 1016: {
                    return SOCNewGame.parseDataStr(data);
                }
                case 1017: {
                    return SOCGameMembers.parseDataStr(data);
                }
                case 1018: {
                    return SOCStartGame.parseDataStr(data);
                }
                case 1020: {
                    return SOCJoinAuth.parseDataStr(data);
                }
                case 1021: {
                    return SOCJoinGameAuth.parseDataStr(data);
                }
                case 1022: {
                    return SOCImARobot.parseDataStr(data);
                }
                case 1023: {
                    return SOCJoinGameRequest.parseDataStr(data);
                }
                case 1024: {
                    return SOCPlayerElement.parseDataStr(data);
                }
                case 1025: {
                    return SOCGameState.parseDataStr(data);
                }
                case 1026: {
                    return SOCTurn.parseDataStr(data);
                }
                case 1027: {
                    return SOCSetupDone.parseDataStr(data);
                }
                case 1028: {
                    return SOCDiceResult.parseDataStr(data);
                }
                case 1029: {
                    return SOCDiscardRequest.parseDataStr(data);
                }
                case 1030: {
                    return SOCRollDiceRequest.parseDataStr(data);
                }
                case 1031: {
                    return SOCRollDice.parseDataStr(data);
                }
                case 1032: {
                    return SOCEndTurn.parseDataStr(data);
                }
                case 1033: {
                    return SOCDiscard.parseDataStr(data);
                }
                case 1034: {
                    return SOCMoveRobber.parseDataStr(data);
                }
                case 1035: {
                    return SOCChoosePlayer.parseDataStr(data);
                }
                case 1036: {
                    return SOCChoosePlayerRequest.parseDataStr(data);
                }
                case 1037: {
                    return SOCRejectOffer.parseDataStr(data);
                }
                case 1038: {
                    return SOCClearOffer.parseDataStr(data);
                }
                case 1039: {
                    return SOCAcceptOffer.parseDataStr(data);
                }
                case 1040: {
                    return SOCBankTrade.parseDataStr(data);
                }
                case 1041: {
                    return SOCMakeOffer.parseDataStr(data);
                }
                case 1042: {
                    return SOCClearTradeMsg.parseDataStr(data);
                }
                case 1043: {
                    return SOCBuildRequest.parseDataStr(data);
                }
                case 1044: {
                    return SOCCancelBuildRequest.parseDataStr(data);
                }
                case 1045: {
                    return SOCBuyCardRequest.parseDataStr(data);
                }
                case 1046: {
                    return SOCDevCard.parseDataStr(data);
                }
                case 1047: {
                    return SOCDevCardCount.parseDataStr(data);
                }
                case 1048: {
                    return SOCSetPlayedDevCard.parseDataStr(data);
                }
                case 1049: {
                    return SOCPlayDevCardRequest.parseDataStr(data);
                }
                case 1052: {
                    return SOCDiscoveryPick.parseDataStr(data);
                }
                case 1053: {
                    return SOCMonopolyPick.parseDataStr(data);
                }
                case 1054: {
                    return SOCFirstPlayer.parseDataStr(data);
                }
                case 1055: {
                    return SOCSetTurn.parseDataStr(data);
                }
                case 1056: {
                    return SOCRobotDismiss.parseDataStr(data);
                }
                case 1057: {
                    return SOCPotentialSettlements.parseDataStr(data);
                }
                case 1058: {
                    return SOCChangeFace.parseDataStr(data);
                }
                case 1059: {
                    return SOCRejectConnection.parseDataStr(data);
                }
                case 1060: {
                    return SOCLastSettlement.parseDataStr(data);
                }
                case 1061: {
                    return SOCGameStats.parseDataStr(data);
                }
                case 1062: {
                    return SOCBCastTextMsg.parseDataStr(data);
                }
                case 1063: {
                    return SOCResourceCount.parseDataStr(data);
                }
                case 1064: {
                    return SOCAdminPing.parseDataStr(data);
                }
                case 1065: {
                    return SOCAdminReset.parseDataStr(data);
                }
                case 1066: {
                    return SOCLongestRoad.parseDataStr(data);
                }
                case 1067: {
                    return SOCLargestArmy.parseDataStr(data);
                }
                case 1068: {
                    return SOCSetSeatLock.parseDataStr(data);
                }
                case 1069: {
                    return SOCStatusMessage.parseDataStr(data);
                }
                case 1070: {
                    return SOCCreateAccount.parseDataStr(data);
                }
                case 1071: {
                    return SOCUpdateRobotParams.parseDataStr(data);
                }
                case 9999: {
                    return SOCServerPing.parseDataStr(data);
                }
            }
            return null;
        }
        catch (Exception e) {
            System.err.println("toMsg ERROR - " + e);
            e.printStackTrace();
            return null;
        }
    }

    public String getGame() {
        return null;
    }
}

