/*
 * Decompiled with CFR 0.152.
 */
package soc.message;

import java.util.StringTokenizer;
import soc.message.SOCMessage;

public class SOCPlayerElement
extends SOCMessage {
    public static final int CLAY = 1;
    public static final int ORE = 2;
    public static final int SHEEP = 3;
    public static final int WHEAT = 4;
    public static final int WOOD = 5;
    public static final int UNKNOWN = 6;
    public static final int ROADS = 10;
    public static final int SETTLEMENTS = 11;
    public static final int CITIES = 12;
    public static final int NUMKNIGHTS = 15;
    public static final int SET = 100;
    public static final int GAIN = 101;
    public static final int LOSE = 102;
    private String game;
    private int playerNumber;
    private int elementType;
    private int actionType;
    private int value;

    public SOCPlayerElement(String ga, int pn, int ac, int et, int va) {
        this.messageType = 1024;
        this.game = ga;
        this.playerNumber = pn;
        this.actionType = ac;
        this.elementType = et;
        this.value = va;
    }

    @Override
    public String getGame() {
        return this.game;
    }

    public int getPlayerNumber() {
        return this.playerNumber;
    }

    public int getAction() {
        return this.actionType;
    }

    public int getElementType() {
        return this.elementType;
    }

    public int getValue() {
        return this.value;
    }

    @Override
    public String toCmd() {
        return SOCPlayerElement.toCmd(this.game, this.playerNumber, this.actionType, this.elementType, this.value);
    }

    public static String toCmd(String ga, int pn, int ac, int et, int va) {
        return "1024|" + ga + sep2 + pn + sep2 + ac + sep2 + et + sep2 + va;
    }

    public static SOCPlayerElement parseDataStr(String s) {
        int va;
        int et;
        int ac;
        int pn;
        String ga;
        StringTokenizer st = new StringTokenizer(s, sep2);
        try {
            ga = st.nextToken();
            pn = Integer.parseInt(st.nextToken());
            ac = Integer.parseInt(st.nextToken());
            et = Integer.parseInt(st.nextToken());
            va = Integer.parseInt(st.nextToken());
        }
        catch (Exception e) {
            return null;
        }
        return new SOCPlayerElement(ga, pn, ac, et, va);
    }

    public String toString() {
        String s = "SOCPlayerElement:game=" + this.game + "|playerNum=" + this.playerNumber + "|actionType=" + this.actionType + "|elementType=" + this.elementType + "|value=" + this.value;
        return s;
    }
}

