/*
 * Decompiled with CFR 0.152.
 */
package soc.message;

import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import soc.message.SOCMessage;

public class SOCPotentialSettlements
extends SOCMessage {
    private String game;
    private int playerNumber;
    private Vector psList;

    public SOCPotentialSettlements(String ga, int pn, Vector ps) {
        this.messageType = 1057;
        this.game = ga;
        this.playerNumber = pn;
        this.psList = ps;
    }

    @Override
    public String getGame() {
        return this.game;
    }

    public int getPlayerNumber() {
        return this.playerNumber;
    }

    public Vector getPotentialSettlements() {
        return this.psList;
    }

    @Override
    public String toCmd() {
        return SOCPotentialSettlements.toCmd(this.game, this.playerNumber, this.psList);
    }

    public static String toCmd(String ga, int pn, Vector ps) {
        String cmd = "1057|" + ga + sep2 + pn;
        Enumeration enum1 = ps.elements();
        while (enum1.hasMoreElements()) {
            Integer number = (Integer)enum1.nextElement();
            cmd = cmd + sep2 + number;
        }
        return cmd;
    }

    public static SOCPotentialSettlements parseDataStr(String s) {
        int pn;
        String ga;
        Vector<Integer> ps = new Vector<Integer>();
        StringTokenizer st = new StringTokenizer(s, sep2);
        try {
            ga = st.nextToken();
            pn = Integer.parseInt(st.nextToken());
            while (st.hasMoreTokens()) {
                ps.addElement(new Integer(Integer.parseInt(st.nextToken())));
            }
        }
        catch (Exception e) {
            return null;
        }
        return new SOCPotentialSettlements(ga, pn, ps);
    }

    public String toString() {
        String s = "SOCPotentialSettlements:game=" + this.game + "|playerNum=" + this.playerNumber + "|list=";
        Enumeration enum1 = this.psList.elements();
        while (enum1.hasMoreElements()) {
            Integer number = (Integer)enum1.nextElement();
            s = s + Integer.toHexString(number) + " ";
        }
        return s;
    }
}

